/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Streams;
import com.google.gct.login.common.OAuthData;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\r\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fJ\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u0012\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\u0007J\b\u0010\u0014\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0019\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/google/gct/login/GoogleLoginPrefs;", "", "userPrefs", "Ljava/util/prefs/Preferences;", "<init>", "(Ljava/util/prefs/Preferences;)V", "saveOAuthData", "", "credentials", "Lcom/google/gct/login/common/OAuthData;", "loadOAuthData", "userEmail", "", "clearStoredOAuthData", "getStoredUsers", "", "saveActiveUser", "user", "removeActiveUser", "removeAllUsers", "getActiveUser", "flushPrefs", "prefs", "getCustomUserKey", "key", "addUser", "removeUser", "Companion", "google-login-as"})
@SourceDebugExtension(value={"SMAP\nGoogleLoginPrefs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLoginPrefs.kt\ncom/google/gct/login/GoogleLoginPrefs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,174:1\n774#2:175\n865#2,2:176\n774#2:179\n865#2,2:180\n24#3:178\n*S KotlinDebug\n*F\n+ 1 GoogleLoginPrefs.kt\ncom/google/gct/login/GoogleLoginPrefs\n*L\n97#1:175\n97#1:176,2\n163#1:179\n163#1:180,2\n139#1:178\n*E\n"})
public final class GoogleLoginPrefs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Preferences userPrefs;
    @NotNull
    private static final GoogleLoginPrefs INSTANCE;

    public GoogleLoginPrefs(@NotNull Preferences userPrefs) {
        Intrinsics.checkNotNullParameter((Object)userPrefs, (String)"userPrefs");
        this.userPrefs = userPrefs;
    }

    public final void saveOAuthData(@NotNull OAuthData credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        String string = credentials.getStoredEmail();
        if (string == null) {
            return;
        }
        String userEmail = string;
        this.userPrefs.put(this.getCustomUserKey("credentials_refresh_token", userEmail), credentials.getRefreshToken());
        this.userPrefs.put(this.getCustomUserKey("oauth_scopes", userEmail), Joiner.on((String)" ").join((Iterable)credentials.getStoredScopes()));
        this.userPrefs.put(this.getCustomUserKey("credentials_email", userEmail), userEmail);
        this.addUser(credentials.getStoredEmail());
        this.flushPrefs(this.userPrefs);
    }

    @NotNull
    public final OAuthData loadOAuthData(@NotNull String userEmail) {
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        String refreshToken = this.userPrefs.get(this.getCustomUserKey("credentials_refresh_token", userEmail), null);
        String storedEmail = this.userPrefs.get(this.getCustomUserKey("credentials_email", userEmail), null);
        String storedScopesString = this.userPrefs.get(this.getCustomUserKey("oauth_scopes", userEmail), "");
        Intrinsics.checkNotNull((Object)storedScopesString);
        String[] stringArray = new String[]{" "};
        SortedSet storedScopes = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)storedScopesString, (String[])stringArray, (boolean)false, (int)0, (int)6, null)), GoogleLoginPrefs::loadOAuthData$lambda$0));
        return new OAuthData(null, refreshToken, storedEmail, storedScopes, 0L);
    }

    public final void clearStoredOAuthData(@NotNull String userEmail) {
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        this.userPrefs.remove(this.getCustomUserKey("credentials_refresh_token", userEmail));
        this.userPrefs.remove(this.getCustomUserKey("credentials_email", userEmail));
        this.userPrefs.remove(this.getCustomUserKey("oauth_scopes", userEmail));
        this.removeUser(userEmail);
        this.flushPrefs(this.userPrefs);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getStoredUsers() {
        void $this$filterTo$iv$iv;
        String string = this.userPrefs.get("all_users", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String[] stringArray = new String[]{" "};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public final void saveActiveUser(@NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.userPrefs.put("active_user", user);
        this.flushPrefs(this.userPrefs);
    }

    public final void removeActiveUser() {
        this.userPrefs.remove("active_user");
        this.flushPrefs(this.userPrefs);
    }

    public final void removeAllUsers() {
        this.userPrefs.remove("all_users");
        this.userPrefs.remove("active_user");
        this.flushPrefs(this.userPrefs);
    }

    @Nullable
    public final String getActiveUser() {
        String activeUser = this.userPrefs.get("active_user", null);
        return activeUser == null || ((CharSequence)activeUser).length() == 0 ? null : activeUser;
    }

    private final void flushPrefs(Preferences prefs) {
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            GoogleLoginPrefs $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GoogleLoginPrefs.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Could not flush preferences while saving login credentials", (Throwable)e);
        }
    }

    private final String getCustomUserKey(String key, String userEmail) {
        return key + "_" + userEmail;
    }

    private final void addUser(String user) {
        String currentUsers = this.userPrefs.get("all_users", null);
        if (currentUsers == null) {
            this.userPrefs.put("all_users", user);
            return;
        }
        Iterable users = Splitter.on((String)" ").omitEmptyStrings().split((CharSequence)currentUsers);
        if (Streams.stream((Iterable)users).anyMatch(arg_0 -> GoogleLoginPrefs.addUser$lambda$3(arg_0 -> GoogleLoginPrefs.addUser$lambda$2(user, arg_0), arg_0))) {
            return;
        }
        this.userPrefs.put("all_users", Joiner.on((String)" ").join((Object)currentUsers, (Object)user, new Object[0]));
        this.flushPrefs(this.userPrefs);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeUser(String user) {
        void $this$filterTo$iv$iv;
        String string = this.userPrefs.get("all_users", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String[] stringArray = new String[]{" "};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List currentUsers = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        currentUsers.remove(user);
        this.userPrefs.put("all_users", Joiner.on((String)" ").join((Iterable)currentUsers));
    }

    private static final boolean loadOAuthData$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it);
    }

    private static final boolean addUser$lambda$2(String $user, String anObject) {
        return StringsKt.equals$default((String)$user, (String)anObject, (boolean)false, (int)2, null);
    }

    private static final boolean addUser$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Preferences preferences = Preferences.userRoot().node("/com/google/gct/login");
        Intrinsics.checkNotNullExpressionValue((Object)preferences, (String)"node(...)");
        INSTANCE = new GoogleLoginPrefs(preferences);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/gct/login/GoogleLoginPrefs$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/google/gct/login/GoogleLoginPrefs;", "getINSTANCE", "()Lcom/google/gct/login/GoogleLoginPrefs;", "google-login-as"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GoogleLoginPrefs getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

