/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.android.tools.analytics.UsageTracker;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleRefreshTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.IGoogleLoginCompletedCallback;
import com.google.gct.login.OAuthScopeRegistry;
import com.google.gct.login.OAuthServer;
import com.google.gct.login.common.OAuthData;
import com.google.gct.login.common.OAuthDataStore;
import com.google.gct.login.common.UiFacade;
import com.google.gct.login.common.VerificationCodeHolder;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GoogleLoginPluginEvent;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleLoginState {
    private static final String EXPIRED_OR_REVOKED_MESSAGE = "Token has been expired or revoked.";
    @NotNull
    private static final NotificationGroup notificationGroup = NotificationGroup.findRegisteredGroup((String)"Google Login");
    private static boolean isNotificationShowing = false;
    private static final JsonFactory jsonFactory = new GsonFactory();
    private static final HttpTransport transport = new NetHttpTransport();
    private final GoogleClientSecrets clientSecrets;
    private final SortedSet<String> oAuthScopes;
    private final OAuthDataStore authDataStore;
    private final UiFacade uiFacade;
    private final OAuthServer oAuthServer;
    private Credential oAuth2Credential;
    private String accessToken;
    private long accessTokenExpiryTime;
    private String refreshToken;
    private boolean isLoggedIn;
    private String email;
    private boolean connected;

    static void trackEvent(GoogleLoginPluginEvent.EventKind eventKind) {
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.GOOGLE_LOGIN_EVENT).setGoogleLoginEvent(GoogleLoginPluginEvent.newBuilder().setEvent(eventKind).build()));
    }

    @NotNull
    static GoogleLoginState create(GoogleClientSecrets clientSecrets, SortedSet<String> oAuthScopes, OAuthDataStore authDataStore, UiFacade uiFacade, OAuthServer oAuthServer) {
        return new GoogleLoginState(clientSecrets, oAuthScopes, authDataStore, uiFacade, oAuthServer);
    }

    private GoogleLoginState(GoogleClientSecrets clientSecrets, SortedSet<String> oAuthScopes, OAuthDataStore authDataStore, UiFacade uiFacade, OAuthServer oAuthServer) {
        this.clientSecrets = clientSecrets;
        this.oAuthScopes = oAuthScopes;
        this.authDataStore = authDataStore;
        this.uiFacade = uiFacade;
        this.oAuthServer = oAuthServer;
        this.isLoggedIn = false;
        this.email = "";
        this.connected = true;
        this.retrieveSavedCredentials();
    }

    public HttpRequestFactory createRequestFactory(@Nullable String message) {
        if (!this.checkLoggedIn(message)) {
            return null;
        }
        return transport.createRequestFactory((HttpRequestInitializer)this.oAuth2Credential);
    }

    public synchronized String fetchAccessToken() throws IOException {
        if (!this.isLoggedIn) {
            return null;
        }
        if (GoogleLoginState.isAccessTokenExpired(this.accessTokenExpiryTime)) {
            this.fetchOAuth2Token();
        }
        return this.accessToken;
    }

    private static boolean isAccessTokenExpired(long expirationTimeInSeconds) {
        if (expirationTimeInSeconds == 0L) {
            return true;
        }
        long currentTimeInSeconds = new GregorianCalendar().getTimeInMillis() / 1000L;
        return currentTimeInSeconds >= expirationTimeInSeconds;
    }

    public String fetchOAuth2ClientId() {
        return this.clientSecrets.getDetails().getClientId();
    }

    public String fetchOAuth2ClientSecret() {
        return this.clientSecrets.getDetails().getClientSecret();
    }

    public String fetchOAuth2RefreshToken() {
        if (!this.checkLoggedIn(null)) {
            return null;
        }
        return this.refreshToken;
    }

    private void fetchOAuth2Token() throws IOException {
        GoogleTokenResponse authResponse;
        if (!this.checkLoggedIn(null)) {
            return;
        }
        try {
            GoogleRefreshTokenRequest request = new GoogleRefreshTokenRequest(transport, jsonFactory, this.refreshToken, this.clientSecrets.getDetails().getClientId(), this.clientSecrets.getDetails().getClientSecret());
            authResponse = request.execute();
        }
        catch (TokenResponseException e) {
            TokenErrorResponse details = e.getDetails();
            if (details != null && details.getErrorDescription().equals(EXPIRED_OR_REVOKED_MESSAGE)) {
                GoogleLoginState.getLogger().warn(EXPIRED_OR_REVOKED_MESSAGE, (Throwable)e);
            } else {
                GoogleLoginState.getLogger().warn("Could not refresh token", (Throwable)e);
            }
            GoogleLogin.getInstance().logOut(false, true);
            GoogleLoginState.showSessionExpiredNotification();
            throw e;
        }
        catch (IOException e) {
            GoogleLoginState.getLogger().warn("Could not obtain an OAuth2 access token.", (Throwable)e);
            throw e;
        }
        this.accessToken = authResponse.getAccessToken();
        this.oAuth2Credential.setAccessToken(this.accessToken);
        this.accessTokenExpiryTime = new GregorianCalendar().getTimeInMillis() / 1000L + authResponse.getExpiresInSeconds();
        this.saveCredentials();
    }

    private static void showSessionExpiredNotification() {
        if (isNotificationShowing) {
            return;
        }
        isNotificationShowing = true;
        notificationGroup.createNotification("Authentication error", "Your session has expired. Please login again", NotificationType.WARNING).addAction((AnAction)NotificationAction.createExpiring((String)"Login...", (action, notification) -> GoogleLogin.getInstance().logIn(null, (IGoogleLoginCompletedCallback)null))).whenExpired(() -> {
            isNotificationShowing = false;
        }).notify(null);
    }

    public Credential getCredential() {
        if (this.oAuth2Credential == null) {
            this.oAuth2Credential = this.makeCredential();
        }
        return this.oAuth2Credential;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public boolean logIn(@Nullable String title) {
        GoogleTokenResponse authResponse;
        if (this.isLoggedIn) {
            return true;
        }
        this.connected = true;
        VerificationCodeHolder verificationCodeHolder = this.uiFacade.obtainVerificationCodeFromExternalUserInteraction(title, OAuthScopeRegistry.getScopes());
        if (verificationCodeHolder == null) {
            return false;
        }
        try {
            authResponse = this.oAuthServer.getToken(transport, jsonFactory, this.clientSecrets, verificationCodeHolder);
        }
        catch (IOException e) {
            this.uiFacade.showErrorDialog("Error while signing in", "An error occurred while trying to sign in: " + e.getMessage());
            GoogleLoginState.getLogger().warn("Could not sign in", (Throwable)e);
            return false;
        }
        this.isLoggedIn = true;
        GoogleLoginState.trackEvent(GoogleLoginPluginEvent.EventKind.LOGIN_WITH_SUCCESS);
        this.updateUserCredentials(authResponse);
        return true;
    }

    public boolean logOut(boolean showPrompt, boolean isForced) {
        if (!this.isLoggedIn) {
            return true;
        }
        if (showPrompt && !this.uiFacade.askYesOrNo("Sign out?", "Are you sure you want to sign out?")) {
            return false;
        }
        this.email = "";
        this.isLoggedIn = false;
        if (isForced) {
            GoogleLoginState.trackEvent(GoogleLoginPluginEvent.EventKind.FORCE_LOGOUT);
        } else {
            GoogleLoginState.trackEvent(GoogleLoginPluginEvent.EventKind.LOGOUT_WITH_SUCCESS);
        }
        this.authDataStore.clearStoredOAuthData();
        this.uiFacade.notifyStatusIndicator();
        return true;
    }

    public Credential makeCredential() {
        GoogleCredential cred = new GoogleCredential.Builder().setJsonFactory(jsonFactory).setTransport(transport).setClientSecrets(this.clientSecrets).build();
        cred.setAccessToken(this.accessToken);
        cred.setRefreshToken(this.refreshToken);
        return cred;
    }

    private void updateUserCredentials(GoogleTokenResponse tokenResponse) {
        this.refreshToken = tokenResponse.getRefreshToken();
        this.accessToken = tokenResponse.getAccessToken();
        this.oAuth2Credential = this.makeCredential();
        this.accessTokenExpiryTime = System.currentTimeMillis() / 1000L + tokenResponse.getExpiresInSeconds();
        this.email = this.oAuthServer.retrieveUserInfo(transport, jsonFactory, (HttpRequestInitializer)this.oAuth2Credential).getEmail();
        this.saveCredentials();
        this.uiFacade.notifyStatusIndicator();
    }

    private void retrieveSavedCredentials() {
        OAuthData savedAuthState = this.authDataStore.loadOAuthData();
        if (savedAuthState.getRefreshToken() == null) {
            this.authDataStore.clearStoredOAuthData();
            return;
        }
        this.accessToken = savedAuthState.getAccessToken();
        this.refreshToken = savedAuthState.getRefreshToken();
        this.accessTokenExpiryTime = savedAuthState.getAccessTokenExpiryTime();
        this.email = savedAuthState.getStoredEmail();
        this.isLoggedIn = true;
        if (!this.oAuthScopes.equals(savedAuthState.getStoredScopes())) {
            GoogleLoginState.getLogger().warn("OAuth scope set for stored credentials no longer valid, logging out.");
            GoogleLoginState.getLogger().warn(this.oAuthScopes + " vs. " + savedAuthState.getStoredScopes());
            this.logOut(false, true);
        }
        this.oAuth2Credential = this.makeCredential();
    }

    private boolean checkLoggedIn(String msg) {
        if (!this.isLoggedIn) {
            boolean rc = this.logIn(msg);
            if (!rc) {
                return false;
            }
            this.uiFacade.notifyStatusIndicator();
        }
        return true;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GoogleLoginState.class);
    }

    private void saveCredentials() {
        if (!this.isLoggedIn) {
            this.authDataStore.clearStoredOAuthData();
        } else {
            OAuthData creds = new OAuthData(this.accessToken, this.refreshToken, this.email, this.oAuthScopes, this.accessTokenExpiryTime);
            this.authDataStore.saveOAuthData(creds);
        }
    }
}

