/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfo;
import com.google.gct.login.OAuthServer;
import com.google.gct.login.common.VerificationCodeHolder;
import com.intellij.openapi.application.ApplicationNamesInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/google/gct/login/GoogleOAuthServer;", "Lcom/google/gct/login/OAuthServer;", "<init>", "()V", "getToken", "Lcom/google/api/client/googleapis/auth/oauth2/GoogleTokenResponse;", "transport", "Lcom/google/api/client/http/HttpTransport;", "jsonFactory", "Lcom/google/api/client/json/JsonFactory;", "clientSecrets", "Lcom/google/api/client/googleapis/auth/oauth2/GoogleClientSecrets;", "verificationCodeHolder", "Lcom/google/gct/login/common/VerificationCodeHolder;", "retrieveUserInfo", "Lcom/google/api/services/oauth2/model/Userinfo;", "credential", "Lcom/google/api/client/http/HttpRequestInitializer;", "google-login-as"})
public final class GoogleOAuthServer
implements OAuthServer {
    @NotNull
    public static final GoogleOAuthServer INSTANCE = new GoogleOAuthServer();

    private GoogleOAuthServer() {
    }

    @Override
    @NotNull
    public GoogleTokenResponse getToken(@NotNull HttpTransport transport, @NotNull JsonFactory jsonFactory, @NotNull GoogleClientSecrets clientSecrets, @NotNull VerificationCodeHolder verificationCodeHolder) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)jsonFactory, (String)"jsonFactory");
        Intrinsics.checkNotNullParameter((Object)clientSecrets, (String)"clientSecrets");
        Intrinsics.checkNotNullParameter((Object)verificationCodeHolder, (String)"verificationCodeHolder");
        GoogleTokenResponse googleTokenResponse = new GoogleAuthorizationCodeTokenRequest(transport, jsonFactory, clientSecrets.getDetails().getClientId(), clientSecrets.getDetails().getClientSecret(), verificationCodeHolder.getVerificationCode(), verificationCodeHolder.getRedirectUrl()).execute();
        Intrinsics.checkNotNullExpressionValue((Object)googleTokenResponse, (String)"execute(...)");
        return googleTokenResponse;
    }

    @Override
    @NotNull
    public Userinfo retrieveUserInfo(@NotNull HttpTransport transport, @NotNull JsonFactory jsonFactory, @NotNull HttpRequestInitializer credential) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)jsonFactory, (String)"jsonFactory");
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        String appName = ApplicationNamesInfo.getInstance().getFullProductName();
        Oauth2 oauth2 = new Oauth2.Builder(transport, jsonFactory, credential).setApplicationName(appName).build();
        Object object = oauth2.userinfo().get().execute();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execute(...)");
        return (Userinfo)object;
    }
}

