/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login.ui;

import com.google.gct.login.ui.GoogleLoginUsersPanel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.RoundedIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.InputEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GoogleLoginAction
extends AnAction
implements RightAlignedToolbarAction {
    private static final String SIGN_IN_MESSAGE = "Sign in to Google...";

    public void actionPerformed(@NotNull AnActionEvent event) {
        GoogleLoginUsersPanel usersPanel = new GoogleLoginUsersPanel();
        ComponentPopupBuilder popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)usersPanel, (JComponent)usersPanel.getList());
        JBPopup popup = popupBuilder.setCancelOnWindowDeactivation(true).createPopup();
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent != null) {
            JComponent source = (JComponent)inputEvent.getSource();
            popup.showUnderneathOf((Component)source);
        } else {
            IdeFrame frame = (IdeFrame)event.getDataContext().getData(IdeFrame.KEY);
            if (frame != null) {
                popup.show(RelativePoint.getCenterOf((JComponent)frame.getComponent()));
            } else {
                Logger.getInstance(GoogleLoginAction.class).warn("Failed to get login popup location");
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(false);
    }

    private static Icon getPictureIcon(Image image, int size, boolean isNewUi) {
        if (image == null) {
            return null;
        }
        int scaledSize = JBUIScale.scale((int)size);
        Image scaledImage = ImageUtil.scaleImage((Image)image, (int)scaledSize, (int)scaledSize);
        JBImageIcon icon = new JBImageIcon(scaledImage);
        return isNewUi ? new RoundedIcon((Icon)icon, 1.0) : icon;
    }
}

