/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login.ui;

import com.google.api.client.util.Maps;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.ui.NoUsersListItem;
import com.google.gct.login.ui.UsersListItem;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import icons.GoogleLoginIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;

public class UsersListCellRenderer
extends JComponent
implements ListCellRenderer {
    private static final String CLOUD_LABEL_TEXT = "Open Google Developers Console";
    private static final String PLAY_LABEL_TEXT = "Open Google Play Console";
    private static final String SIGN_IN_TEXT = "<HTML> Sign in with your Google account to start <br> adding Cloud functionality to your <br> Android applications from Android Studio. </HTML>";
    private static final String LEARN_MORE_TEXT = "Learn more";
    private static final int PLAIN_USER_IMAGE_WIDTH = 48;
    private static final int PLAIN_USER_IMAGE_HEIGHT = 48;
    private static final int ACTIVE_USER_IMAGE_WIDTH = 96;
    private static final int ACTIVE_USER_IMAGE_HEIGHT = 96;
    private static final int GOOGLE_IMAGE_NORTH = 18;
    private static final int GOOGLE_IMAGE_WEST = 18;
    private static final int WELCOME_LABEL_NORTH = 15;
    private static final int WELCOME_LABEL_SOUTH = 25;
    private static final int WELCOME_LABEL_EAST = 38;
    private static final int USER_LABEL_VERTICAL_STRUT = 3;
    private static final int HGAP = 10;
    private static final int VGAP = 10;
    private final Color myActiveColor;
    private final Color myInactiveColor;
    private final int myGeneralFontHeight;
    private final Font myNameFont;
    private final Font myGeneralFont;
    private final Dimension myMainPanelDimension;
    private final Dimension myActiveMainPanelDimension;
    private final Dimension myCloudLabelDimension;
    private final Dimension myPlayLabelDimension;
    private final Dimension myLearnMoreLabelDimension;
    private JLabel myGoogleImageLabel;
    private final Map<String, Image> myUserLargeImageCache = Maps.newHashMap();
    private final Map<String, Image> myUserSmallImageCache = Maps.newHashMap();

    public UsersListCellRenderer() {
        this.myNameFont = new Font("Helvetica", 1, 13);
        this.myGeneralFont = new Font("Helvetica", 0, 13);
        this.myMainPanelDimension = new Dimension(250, 68);
        this.myActiveMainPanelDimension = new Dimension(250, 116);
        this.myActiveColor = !JBColor.isBright() ? UIManager.getColor("TextField.background") : Color.WHITE;
        this.myInactiveColor = !JBColor.isBright() ? UIManager.getColor("darcula.inactiveBackground") : new Color(0xF5F5F5);
        FontMetrics fontMetrics = this.getFontMetrics(this.myGeneralFont);
        this.myGeneralFontHeight = fontMetrics.getHeight();
        this.myCloudLabelDimension = new Dimension(fontMetrics.stringWidth(CLOUD_LABEL_TEXT), this.myGeneralFontHeight);
        this.myPlayLabelDimension = new Dimension(fontMetrics.stringWidth(PLAY_LABEL_TEXT), this.myGeneralFontHeight);
        this.myLearnMoreLabelDimension = new Dimension(fontMetrics.stringWidth(LEARN_MORE_TEXT), this.myGeneralFontHeight);
    }

    @Nullable
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof NoUsersListItem) {
            return this.createNoUserDisplay();
        }
        if (!(value instanceof UsersListItem)) {
            return null;
        }
        UsersListItem usersListItem = (UsersListItem)value;
        CredentialedUser activeUser = GoogleLogin.getInstance().getActiveUser();
        boolean isActiveUserSelected = activeUser != null && usersListItem.getUserEmail().equals(activeUser.email);
        JPanel mainPanel = new JPanel(new FlowLayout(0, 10, 10));
        mainPanel.setMinimumSize(isActiveUserSelected ? this.myActiveMainPanelDimension : this.myMainPanelDimension);
        mainPanel.setAlignmentX(0.0f);
        Color bg = isActiveUserSelected ? this.myActiveColor : this.myInactiveColor;
        Color fg = isActiveUserSelected ? UIUtil.getListSelectionForeground((boolean)true) : UIUtil.getListForeground();
        mainPanel.setBackground(bg);
        mainPanel.setForeground(fg);
        Image profilePicture = usersListItem.getUserPicture();
        Icon scaledIcon = profilePicture != null ? this.getScaledIcon(usersListItem, isActiveUserSelected, profilePicture) : GoogleLoginIcons.LOGGED_IN_FALLBACK_USER_AVATAR;
        JComponent textPanel = isActiveUserSelected ? this.createActiveTextDisplay(usersListItem) : this.createTextDisplay(false, usersListItem);
        mainPanel.add(new JLabel(scaledIcon));
        mainPanel.add(textPanel);
        mainPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JBColor.border()));
        return mainPanel;
    }

    private Icon getScaledIcon(UsersListItem user, boolean isActiveUser, Image profileImage) {
        Image scaledImage;
        Map<String, Image> userImageCache;
        int imageHeight;
        int imageWidth;
        if (isActiveUser) {
            imageWidth = 96;
            imageHeight = 96;
            userImageCache = this.myUserLargeImageCache;
        } else {
            imageWidth = 48;
            imageHeight = 48;
            userImageCache = this.myUserSmallImageCache;
        }
        if (!userImageCache.containsKey(user.getUserEmail())) {
            scaledImage = profileImage.getScaledInstance(imageWidth, imageHeight, 4);
            userImageCache.put(user.getUserEmail(), scaledImage);
        } else {
            scaledImage = userImageCache.get(user.getUserEmail());
        }
        return new ImageIcon(scaledImage);
    }

    public boolean inPlayConsoleUrl(Point point, int activeIndex) {
        double playYStart = 106.0 - this.myPlayLabelDimension.getHeight() - this.myCloudLabelDimension.getHeight() - 2.0 + this.myMainPanelDimension.getHeight() * (double)activeIndex + 3.0;
        double playYEnd = playYStart + this.myPlayLabelDimension.getHeight();
        double playXStart = 116.0;
        double playXEnd = playXStart + this.myPlayLabelDimension.getWidth();
        return point.getX() > playXStart && point.getX() < playXEnd && point.getY() > playYStart && point.getY() < playYEnd;
    }

    public boolean inCloudConsoleUrl(Point point, int activeIndex) {
        double playYStart = 106.0 - this.myCloudLabelDimension.getHeight() - 3.0 + this.myMainPanelDimension.getHeight() * (double)activeIndex + 6.0;
        double playYEnd = playYStart + this.myCloudLabelDimension.getHeight();
        double playXStart = 116.0;
        double playXEnd = playXStart + this.myCloudLabelDimension.getWidth();
        return point.getX() > playXStart && point.getX() < playXEnd && point.getY() > playYStart && point.getY() < playYEnd;
    }

    public boolean inLearnMoreUrl(Point point) {
        double urlYStart = 18 + this.myGoogleImageLabel.getIcon().getIconHeight() + 15 + this.myGeneralFontHeight * 3 + 3;
        double urlYEnd = urlYStart + this.myLearnMoreLabelDimension.getHeight();
        double urlXStart = 18.0;
        double urlXEnd = urlXStart + this.myLearnMoreLabelDimension.getWidth();
        return point.getX() > urlXStart && point.getX() < urlXEnd && point.getY() > urlYStart && point.getY() < urlYEnd;
    }

    public int getMainPanelHeight() {
        return (int)this.myMainPanelDimension.getHeight();
    }

    public int getActivePanelHeight() {
        return (int)this.myActiveMainPanelDimension.getHeight();
    }

    private JComponent createTextDisplay(boolean isSelected, UsersListItem usersListItem) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        Color bg = isSelected ? this.myActiveColor : this.myInactiveColor;
        Color fg = isSelected ? UIUtil.getListSelectionForeground((boolean)true) : UIUtil.getListForeground();
        panel.setBackground(bg);
        panel.setForeground(fg);
        JLabel nameLabel = new JLabel(usersListItem.getUserName());
        nameLabel.setFont(this.myNameFont);
        panel.add(nameLabel);
        panel.add(Box.createVerticalStrut(3));
        JLabel emailLabel = new JLabel(usersListItem.getUserEmail());
        emailLabel.setFont(this.myGeneralFont);
        panel.add(emailLabel);
        return panel;
    }

    private JComponent createActiveTextDisplay(UsersListItem usersListItem) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBackground(this.myActiveColor);
        mainPanel.setForeground(UIUtil.getListSelectionForeground((boolean)true));
        mainPanel.setPreferredSize(new Dimension(220, 96));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 3));
        bottomPanel.setBackground(this.myActiveColor);
        bottomPanel.setForeground(UIUtil.getListSelectionForeground((boolean)true));
        bottomPanel.setPreferredSize(new Dimension(220, this.myGeneralFontHeight * 2 + 3));
        JLabel playLabel = new JLabel(PLAY_LABEL_TEXT);
        playLabel.setFont(this.myGeneralFont);
        playLabel.setForeground((Color)JBColor.BLUE);
        playLabel.setPreferredSize(this.myPlayLabelDimension);
        bottomPanel.add((Component)playLabel, Float.valueOf(1.0f));
        bottomPanel.add(Box.createVerticalStrut(3));
        JLabel cloudLabel = new JLabel(CLOUD_LABEL_TEXT);
        cloudLabel.setFont(this.myGeneralFont);
        cloudLabel.setForeground((Color)JBColor.BLUE);
        cloudLabel.setPreferredSize(this.myCloudLabelDimension);
        bottomPanel.add((Component)cloudLabel, Float.valueOf(1.0f));
        GridBagConstraints topConstraints = new GridBagConstraints();
        topConstraints.gridx = 0;
        topConstraints.gridy = 0;
        topConstraints.anchor = 18;
        GridBagConstraints bottomConstraints = new GridBagConstraints();
        bottomConstraints.gridx = 0;
        bottomConstraints.gridy = 1;
        bottomConstraints.weightx = 1.0;
        bottomConstraints.weighty = 5.0;
        bottomConstraints.anchor = 16;
        JComponent topPanel = this.createTextDisplay(true, usersListItem);
        mainPanel.add((Component)topPanel, topConstraints);
        mainPanel.add((Component)bottomPanel, bottomConstraints);
        return mainPanel;
    }

    private JPanel createNoUserDisplay() {
        JPanel mainPanel = new JPanel();
        BoxLayout layout = new BoxLayout(mainPanel, 1);
        mainPanel.setLayout(layout);
        mainPanel.setBackground((Color)JBColor.WHITE);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 18, 0, 0));
        this.myGoogleImageLabel = new JLabel(GoogleLoginIcons.GOOGLE_LOGO);
        JLabel signInLabel = new JLabel(SIGN_IN_TEXT);
        signInLabel.setFont(this.myGeneralFont);
        Dimension textSize = signInLabel.getPreferredSize();
        signInLabel.setPreferredSize(new Dimension((int)textSize.getWidth() + 38, (int)textSize.getHeight()));
        JLabel urlLabel = new JLabel(LEARN_MORE_TEXT);
        urlLabel.setFont(this.myGeneralFont);
        urlLabel.setForeground((Color)JBColor.BLUE);
        urlLabel.setPreferredSize(this.myLearnMoreLabelDimension);
        mainPanel.add(Box.createVerticalStrut(18));
        mainPanel.add(this.myGoogleImageLabel);
        mainPanel.add(Box.createVerticalStrut(15));
        mainPanel.add(signInLabel);
        mainPanel.add(urlLabel);
        mainPanel.add(Box.createVerticalStrut(25));
        return mainPanel;
    }
}

