/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2;

import com.android.annotations.concurrency.Slow;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.gct.login.GoogleLoginPrefs;
import com.google.gct.login2.AndroidUiFacade;
import com.google.gct.login2.CredentialedUser;
import com.google.gct.login2.CredentialedUsersManager;
import com.google.gct.login2.GoogleAccountClient;
import com.google.gct.login2.GoogleAccountClientImpl;
import com.google.gct.login2.GoogleLoginService;
import com.google.gct.login2.GoogleLoginServiceImpl;
import com.google.gct.login2.GoogleLoginState;
import com.google.gct.login2.GoogleOAuthServer;
import com.google.gct.login2.Interceptor;
import com.google.gct.login2.LoginFeature;
import com.google.gct.login2.LoginLogoutCompletedCallback;
import com.google.gct.login2.OAuthServer;
import com.google.gct.login2.PreferredUser;
import com.google.gct.login2.StudioClientInfoKt;
import com.google.gct.login2.V2MigrationUtilsKt;
import com.google.gct.login2.VetoableLogoutListener;
import com.google.gct.login2.common.OAuthDataStore;
import com.google.gct.login2.common.UiFacade;
import com.google.gct.login2.settings.GoogleLoginApplicationSettings;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GoogleLoginPluginEvent;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.jetbrains.rd.util.CollectionExKt;
import io.grpc.ClientInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BC\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010+\u001a\u00020\u001aH\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010%2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020%H\u0016J:\u00104\u001a\u0002022\f\u00105\u001a\b\u0012\u0004\u0012\u00020-062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\u001a\u0010?\u001a\u0002022\u0006\u0010@\u001a\u00020&2\b\u0010A\u001a\u0004\u0018\u00010<H\u0016J\u0012\u0010B\u001a\u0002022\b\u0010A\u001a\u0004\u0018\u00010<H\u0016J\b\u0010C\u001a\u00020\u001aH\u0002J@\u0010D\u001a\u00020\u001a2\f\u00105\u001a\b\u0012\u0004\u0012\u00020-062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010>H\u0096@\u00a2\u0006\u0002\u0010EJ\u0016\u0010F\u001a\u0002022\u0006\u0010@\u001a\u00020&H\u0096@\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\u000202H\u0096@\u00a2\u0006\u0002\u0010IJ\b\u0010J\u001a\u000202H\u0003J\b\u0010K\u001a\u000202H\u0016J&\u0010L\u001a\u0002022\b\u0010M\u001a\u0004\u0018\u00010N2\b\b\u0002\u00107\u001a\u0002082\b\b\u0002\u0010O\u001a\u00020PH\u0002J\u0016\u0010Q\u001a\u00020P2\f\u00105\u001a\b\u0012\u0004\u0012\u00020-06H\u0002J\b\u0010R\u001a\u00020\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u00020\u00148\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R&\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$0#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001c\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010&0#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010(\u00a8\u0006S"}, d2={"Lcom/google/gct/login2/GoogleLoginServiceImpl;", "Lcom/google/gct/login2/GoogleLoginService;", "Lcom/intellij/openapi/Disposable;", "accountClient", "Lcom/google/gct/login2/GoogleAccountClient;", "transport", "Lcom/google/api/client/http/HttpTransport;", "uiFacade", "Lcom/google/gct/login2/common/UiFacade;", "oAuthServer", "Lcom/google/gct/login2/OAuthServer;", "loginApplicationSettings", "Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings;", "oldLoginApplicationSettings", "Lcom/google/gct/login/GoogleLoginPrefs;", "<init>", "(Lcom/google/gct/login2/GoogleAccountClient;Lcom/google/api/client/http/HttpTransport;Lcom/google/gct/login2/common/UiFacade;Lcom/google/gct/login2/OAuthServer;Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings;Lcom/google/gct/login/GoogleLoginPrefs;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "userManager", "Lcom/google/gct/login2/CredentialedUsersManager;", "getUserManager$google_login_as", "()Lcom/google/gct/login2/CredentialedUsersManager;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "value", "", "isInitialized", "()Z", "vetoableLogoutListeners", "", "Lcom/google/gct/login2/VetoableLogoutListener;", "getVetoableLogoutListeners", "()Ljava/util/List;", "allUsersFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "", "Lcom/google/gct/login2/CredentialedUser;", "getAllUsersFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "activeUserFlow", "getActiveUserFlow", "isLoggedIn", "feature", "Lcom/google/gct/login2/LoginFeature;", "fetchOAuth2Token", "getActiveUserAuthInterceptor", "Lio/grpc/ClientInterceptor;", "setActiveUser", "", "userEmail", "logInAsync", "features", "", "loginType", "Lcom/google/wireless/android/sdk/stats/GoogleLoginPluginEvent$LoginType;", "preferredUser", "Lcom/google/gct/login2/PreferredUser;", "loginCompletedCallback", "Lcom/google/gct/login2/LoginLogoutCompletedCallback;", "parentComponent", "Ljavax/swing/JComponent;", "logOutSingleUserAsync", "user", "logoutCompletedCallback", "logOutAllUsersAsync", "confirmLogOut", "logIn", "(Ljava/util/Set;Lcom/google/wireless/android/sdk/stats/GoogleLoginPluginEvent$LoginType;Lcom/google/gct/login2/PreferredUser;Lcom/google/gct/login2/LoginLogoutCompletedCallback;Ljavax/swing/JComponent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logOutSingleUser", "(Lcom/google/gct/login2/CredentialedUser;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logOutAllUsers", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initializeUsers", "dispose", "trackEvent", "eventKind", "Lcom/google/wireless/android/sdk/stats/GoogleLoginPluginEvent$EventKind;", "loginFeatures", "Lcom/google/wireless/android/sdk/stats/GoogleLoginPluginEvent$LoginFeatures;", "buildLoginFeatures", "shouldLogOut", "google-login-as"})
@SourceDebugExtension(value={"SMAP\nGoogleLoginService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLoginService.kt\ncom/google/gct/login2/GoogleLoginServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,521:1\n24#2:522\n24#2:581\n40#3,3:523\n310#4,11:526\n1#5:537\n1#5:577\n1734#6,3:538\n1734#6,3:541\n1557#6:544\n1628#6,3:545\n1485#6:549\n1510#6,3:550\n1513#6,3:560\n1557#6:573\n1628#6,3:574\n1557#6:582\n1628#6,3:583\n1734#6,3:586\n1863#6,2:589\n216#7:548\n136#7,9:563\n216#7:572\n217#7:578\n145#7:579\n217#7:580\n381#8,7:553\n*S KotlinDebug\n*F\n+ 1 GoogleLoginService.kt\ncom/google/gct/login2/GoogleLoginServiceImpl\n*L\n150#1:522\n458#1:581\n146#1:523,3\n269#1:526,11\n431#1:577\n380#1:538,3\n403#1:541,3\n419#1:544\n419#1:545,3\n430#1:549\n430#1:550,3\n430#1:560,3\n434#1:573\n434#1:574,3\n494#1:582\n494#1:583,3\n499#1:586,3\n501#1:589,2\n427#1:548\n431#1:563,9\n431#1:572\n431#1:578\n431#1:579\n427#1:580\n430#1:553,7\n*E\n"})
public final class GoogleLoginServiceImpl
implements GoogleLoginService,
Disposable {
    @NotNull
    private final HttpTransport transport;
    @NotNull
    private final UiFacade uiFacade;
    @NotNull
    private final OAuthServer oAuthServer;
    @NotNull
    private final GoogleLoginApplicationSettings loginApplicationSettings;
    @NotNull
    private final GoogleLoginPrefs oldLoginApplicationSettings;
    @NotNull
    private final Logger logger;
    @VisibleForTesting
    @NotNull
    private final CredentialedUsersManager userManager;
    @NotNull
    private final CoroutineScope scope;
    private boolean isInitialized;
    @NotNull
    private final List<VetoableLogoutListener> vetoableLogoutListeners;

    public GoogleLoginServiceImpl(@NotNull GoogleAccountClient accountClient, @NotNull HttpTransport transport, @NotNull UiFacade uiFacade, @NotNull OAuthServer oAuthServer, @NotNull GoogleLoginApplicationSettings loginApplicationSettings, @NotNull GoogleLoginPrefs oldLoginApplicationSettings) {
        Intrinsics.checkNotNullParameter((Object)accountClient, (String)"accountClient");
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)uiFacade, (String)"uiFacade");
        Intrinsics.checkNotNullParameter((Object)oAuthServer, (String)"oAuthServer");
        Intrinsics.checkNotNullParameter((Object)loginApplicationSettings, (String)"loginApplicationSettings");
        Intrinsics.checkNotNullParameter((Object)oldLoginApplicationSettings, (String)"oldLoginApplicationSettings");
        this.transport = transport;
        this.uiFacade = uiFacade;
        this.oAuthServer = oAuthServer;
        this.loginApplicationSettings = loginApplicationSettings;
        this.oldLoginApplicationSettings = oldLoginApplicationSettings;
        GoogleLoginServiceImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GoogleLoginServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.userManager = new CredentialedUsersManager(this.loginApplicationSettings, accountClient);
        this.scope = CoroutineUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null);
        this.vetoableLogoutListeners = new ArrayList();
        String testModeUser = System.getenv("GOOGLE_LOGIN_USER");
        if (testModeUser != null) {
            this.logger.info("Added fake Google user: " + testModeUser);
            this.userManager.addOrUpdateUser(new GoogleLoginState(this.transport, this.uiFacade, this.oAuthServer, this.loginApplicationSettings, testModeUser));
            this.setActiveUser(testModeUser);
            this.isInitialized = true;
        } else {
            BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getWorkerThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ GoogleLoginServiceImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            try {
                                this.this$0.initializeUsers();
                                LoginFeature enforcedFeature = LoginFeature.Companion.getExtensionByName("User Info");
                                if (enforcedFeature == null) {
                                    String string = "Required value was null.";
                                    throw new IllegalStateException(string.toString());
                                }
                                if (this.this$0.isLoggedIn(enforcedFeature)) {
                                    GoogleLoginServiceImpl.trackEvent$default(this.this$0, GoogleLoginPluginEvent.EventKind.LOGGED_IN_ON_STUDIO_START, null, null, 6, null);
                                }
                            }
                            catch (Exception e) {
                                boolean $i$f$thisLogger = false;
                                Logger logger = Logger.getInstance(CoroutineScope.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                logger.warn("Error when initializing users: " + e);
                            }
                            finally {
                                this.this$0.isInitialized = true;
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public /* synthetic */ GoogleLoginServiceImpl(GoogleAccountClient googleAccountClient, HttpTransport httpTransport, UiFacade uiFacade, OAuthServer oAuthServer, GoogleLoginApplicationSettings googleLoginApplicationSettings, GoogleLoginPrefs googleLoginPrefs, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            googleAccountClient = new GoogleAccountClientImpl();
        }
        if ((n & 2) != 0) {
            httpTransport = (HttpTransport)new NetHttpTransport();
        }
        if ((n & 4) != 0) {
            String string = StudioClientInfoKt.getStudioClientInfo().getDetails().getClientId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClientId(...)");
            uiFacade = new AndroidUiFacade(string);
        }
        if ((n & 8) != 0) {
            oAuthServer = new GoogleOAuthServer(httpTransport);
        }
        if ((n & 0x10) != 0) {
            boolean $i$f$service = false;
            Class<GoogleLoginApplicationSettings> serviceClass$iv = GoogleLoginApplicationSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            googleLoginApplicationSettings = (GoogleLoginApplicationSettings)object;
        }
        if ((n & 0x20) != 0) {
            googleLoginPrefs = GoogleLoginPrefs.Companion.getINSTANCE();
        }
        this(googleAccountClient, httpTransport, uiFacade, oAuthServer, googleLoginApplicationSettings, googleLoginPrefs);
    }

    @NotNull
    public final CredentialedUsersManager getUserManager$google_login_as() {
        return this.userManager;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    @NotNull
    public List<VetoableLogoutListener> getVetoableLogoutListeners() {
        return this.vetoableLogoutListeners;
    }

    @Override
    @NotNull
    public StateFlow<Map<String, CredentialedUser>> getAllUsersFlow() {
        return this.userManager.getAllUsersFlow();
    }

    @Override
    @NotNull
    public StateFlow<CredentialedUser> getActiveUserFlow() {
        return this.userManager.getActiveUserFlow();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLoggedIn(@NotNull LoginFeature feature) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        CredentialedUser credentialedUser = (CredentialedUser)this.getActiveUserFlow().getValue();
        if (credentialedUser != null) {
            if (credentialedUser.isLoggedIn(feature)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        String string = System.getenv("GOOGLE_LOGIN_USER");
        if (string == null) return false;
        CredentialedUser credentialedUser2 = (CredentialedUser)this.getActiveUserFlow().getValue();
        if (!string.equals(credentialedUser2 != null ? credentialedUser2.getEmail() : null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLoggedIn() {
        if (this.getActiveUserFlow().getValue() != null) return true;
        String string = System.getenv("GOOGLE_LOGIN_USER");
        if (string == null) return false;
        CredentialedUser credentialedUser = (CredentialedUser)this.getActiveUserFlow().getValue();
        if (!string.equals(credentialedUser != null ? credentialedUser.getEmail() : null)) return false;
        return true;
    }

    @Override
    @Nullable
    public String fetchOAuth2Token(@NotNull LoginFeature feature) {
        String string;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        CredentialedUser credentialedUser = (CredentialedUser)this.getActiveUserFlow().getValue();
        if (credentialedUser == null) {
            return null;
        }
        CredentialedUser lastActiveUser = credentialedUser;
        try {
            string = lastActiveUser.fetchAccessToken$google_login_as(feature);
        }
        catch (TokenResponseException e) {
            this.userManager.removeInvalidatedLogins(lastActiveUser.getEmail());
            throw e;
        }
        return string;
    }

    @Override
    @NotNull
    public ClientInterceptor getActiveUserAuthInterceptor(@NotNull LoginFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return new Interceptor((Function0<String>)((Function0)() -> GoogleLoginServiceImpl.getActiveUserAuthInterceptor$lambda$0(this, feature)));
    }

    @Override
    public void setActiveUser(@NotNull String userEmail) {
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        this.userManager.setActiveUser(userEmail);
    }

    @Override
    public void logInAsync(@NotNull Set<? extends LoginFeature> features, @NotNull GoogleLoginPluginEvent.LoginType loginType, @NotNull PreferredUser preferredUser, @Nullable LoginLogoutCompletedCallback loginCompletedCallback, @Nullable JComponent parentComponent) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Intrinsics.checkNotNullParameter((Object)loginType, (String)"loginType");
        Intrinsics.checkNotNullParameter((Object)preferredUser, (String)"preferredUser");
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, features, loginType, preferredUser, loginCompletedCallback, parentComponent, null){
            int label;
            final /* synthetic */ GoogleLoginServiceImpl this$0;
            final /* synthetic */ Set<LoginFeature> $features;
            final /* synthetic */ GoogleLoginPluginEvent.LoginType $loginType;
            final /* synthetic */ PreferredUser $preferredUser;
            final /* synthetic */ LoginLogoutCompletedCallback $loginCompletedCallback;
            final /* synthetic */ JComponent $parentComponent;
            {
                this.this$0 = $receiver;
                this.$features = $features;
                this.$loginType = $loginType;
                this.$preferredUser = $preferredUser;
                this.$loginCompletedCallback = $loginCompletedCallback;
                this.$parentComponent = $parentComponent;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.logIn(this.$features, this.$loginType, this.$preferredUser, this.$loginCompletedCallback, this.$parentComponent, (Continuation<? super Boolean>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void logOutSingleUserAsync(@NotNull CredentialedUser user, @Nullable LoginLogoutCompletedCallback logoutCompletedCallback) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!this.shouldLogOut()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, user, null){
            int label;
            final /* synthetic */ GoogleLoginServiceImpl this$0;
            final /* synthetic */ CredentialedUser $user;
            {
                this.this$0 = $receiver;
                this.$user = $user;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.logOutSingleUser(this.$user, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null).invokeOnCompletion(arg_0 -> GoogleLoginServiceImpl.logOutSingleUserAsync$lambda$1(logoutCompletedCallback, arg_0));
    }

    @Override
    public void logOutAllUsersAsync(@Nullable LoginLogoutCompletedCallback logoutCompletedCallback) {
        if (!this.confirmLogOut() || !this.shouldLogOut()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GoogleLoginServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.logOutAllUsers((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null).invokeOnCompletion(arg_0 -> GoogleLoginServiceImpl.logOutAllUsersAsync$lambda$2(logoutCompletedCallback, arg_0));
    }

    private final boolean confirmLogOut() {
        return this.uiFacade.askYesOrNo("Sign out?", "Are you sure you want to sign out? This will sign out all logged in users.");
    }

    @Override
    @Nullable
    public Object logIn(@NotNull Set<? extends LoginFeature> features, @NotNull GoogleLoginPluginEvent.LoginType loginType, @NotNull PreferredUser preferredUser, @Nullable LoginLogoutCompletedCallback loginCompletedCallback, @Nullable JComponent parentComponent, @NotNull Continuation<? super Boolean> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Boolean> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        Ref.ObjectRef state = new Ref.ObjectRef();
        Task.Modal task2 = new Task.Modal(parentComponent, (Ref.ObjectRef<GoogleLoginState>)state, features, preferredUser, this, loginType, loginCompletedCallback, (CancellableContinuation<? super Boolean>)cont){
            private boolean loggedIn;
            final /* synthetic */ Ref.ObjectRef<GoogleLoginState> $state;
            final /* synthetic */ Set<LoginFeature> $features;
            final /* synthetic */ PreferredUser $preferredUser;
            final /* synthetic */ GoogleLoginServiceImpl this$0;
            final /* synthetic */ GoogleLoginPluginEvent.LoginType $loginType;
            final /* synthetic */ LoginLogoutCompletedCallback $loginCompletedCallback;
            final /* synthetic */ CancellableContinuation<Boolean> $cont;
            {
                this.$state = $state;
                this.$features = $features;
                this.$preferredUser = $preferredUser;
                this.this$0 = $receiver;
                this.$loginType = $loginType;
                this.$loginCompletedCallback = $loginCompletedCallback;
                this.$cont = $cont;
                super(null, $parentComponent, "Please sign in via the opened browser...", true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                if (!(indicator instanceof ProgressIndicatorEx)) {
                    return;
                }
                ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(this.this$0){
                    final /* synthetic */ GoogleLoginServiceImpl this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void cancel() {
                        GoogleLoginServiceImpl.access$getUiFacade$p(this.this$0).stop();
                        super.cancel();
                    }
                });
                this.$state.element = GoogleLoginState.Companion.loginAndCreate(this.$features, this.$preferredUser.getEmail(), GoogleLoginServiceImpl.access$getTransport$p(this.this$0), GoogleLoginServiceImpl.access$getUiFacade$p(this.this$0), GoogleLoginServiceImpl.access$getOAuthServer$p(this.this$0), GoogleLoginServiceImpl.access$getLoginApplicationSettings$p(this.this$0));
                this.loggedIn = this.$state.element != null;
            }

            public void onCancel() {
                this.notifyOnComplete();
            }

            public void onSuccess() {
                this.notifyOnComplete();
            }

            private final void notifyOnComplete() {
                GoogleLoginState currentState = (GoogleLoginState)this.$state.element;
                if (currentState != null) {
                    GoogleLoginServiceImpl.access$trackEvent(this.this$0, GoogleLoginPluginEvent.EventKind.LOGIN_WITH_SUCCESS, this.$loginType, GoogleLoginServiceImpl.access$buildLoginFeatures(this.this$0, this.$features));
                    this.this$0.getUserManager$google_login_as().addOrUpdateUser(currentState);
                    this.maybeSetActiveUser();
                    LoginLogoutCompletedCallback loginLogoutCompletedCallback = this.$loginCompletedCallback;
                    if (loginLogoutCompletedCallback != null) {
                        loginLogoutCompletedCallback.onCompleted();
                    }
                    logIn.2.task.1 $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(logIn.2.task.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info("Login succeeded.");
                    ((Continuation)this.$cont).resumeWith(Result.constructor-impl((Object)true));
                } else {
                    GoogleLoginServiceImpl.access$trackEvent(this.this$0, GoogleLoginPluginEvent.EventKind.LOGIN_WITH_FAILURE, this.$loginType, GoogleLoginServiceImpl.access$buildLoginFeatures(this.this$0, this.$features));
                    logIn.2.task.1 $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(logIn.2.task.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info("Login cancelled or failed.");
                    ((Continuation)this.$cont).resumeWith(Result.constructor-impl((Object)false));
                }
            }

            /*
             * Unable to fully structure code
             */
            private final void maybeSetActiveUser() {
                v0 = (GoogleLoginState)this.$state.element;
                if (v0 == null) {
                    return;
                }
                currentState = v0;
                v1 = userSwitchDuringTheFlow = this.$preferredUser.getEmail() != null && Intrinsics.areEqual((Object)this.$preferredUser.getEmail(), (Object)currentState.getEmail()) == false;
                if (!userSwitchDuringTheFlow) ** GOTO lbl-1000
                v2 = (CredentialedUser)this.this$0.getActiveUserFlow().getValue();
                if (!Intrinsics.areEqual((Object)(v2 != null ? v2.getEmail() : null), (Object)currentState.getEmail())) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = shouldAsk = false;
                }
                if (shouldAsk && !this.askYesOrNoForSwitchAccountIntent()) {
                    return;
                }
                this.this$0.setActiveUser(currentState.getEmail());
            }

            private final boolean askYesOrNoForSwitchAccountIntent() {
                return GoogleLoginServiceImpl.access$getUiFacade$p(this.this$0).askYesOrNo("Confirm to use different Google account", "You selected a different Google account to use in Android Studio, that hasn't been added before. \n\nWould you like to use this account and set it to be the currently active one?");
            }
        };
        ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(task2){
            final /* synthetic */ logIn.2.task.1 $task;
            {
                this.$task = $task;
            }

            public final void invoke() {
                this.$task.queue();
            }
        }));
        cont.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ GoogleLoginServiceImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void invoke(Throwable it) {
                GoogleLoginServiceImpl.access$getUiFacade$p(this.this$0).stop();
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object logOutSingleUser(@NotNull CredentialedUser var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof logOutSingleUser.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GoogleLoginServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.logOutSingleUser(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.userManager.removeUser(user.getEmail());
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Boolean>>, Object>((CredentialedUser)user, null){
                    int label;
                    final /* synthetic */ CredentialedUser $user;
                    {
                        this.$user = $user;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$mapTo$iv$iv;
                                ResultKt.throwOnFailure((Object)object);
                                Iterable $this$map$iv = this.$user.getLoginStates$google_login_as();
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    GoogleLoginState googleLoginState = (GoogleLoginState)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(Boxing.boxBoolean((boolean)it.logOut()));
                                }
                                return (List)destination$iv$iv;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<Boolean>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (GoogleLoginServiceImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                allStatus = (List)v0;
                if (this.getActiveUserFlow().getValue() == null) {
                    v1 = CollectionExKt.firstOrNull((Map)((Map)this.getAllUsersFlow().getValue()));
                    if (v1 != null) {
                        it = v1;
                        $i$a$-let-GoogleLoginServiceImpl$logOutSingleUser$2 = false;
                        this.setActiveUser((String)it.getKey());
                    }
                }
                $this$all$iv = allStatus;
                $i$f$all = false;
                if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) ** GOTO lbl36
                v2 = true;
                ** GOTO lbl43
lbl36:
                // 2 sources

                for (T element$iv : $this$all$iv) {
                    it = (Boolean)element$iv;
                    $i$a$-all-GoogleLoginServiceImpl$logOutSingleUser$3 = false;
                    if (it != false) continue;
                    v2 = false;
                    ** GOTO lbl43
                }
                v2 = true;
lbl43:
                // 3 sources

                if (v2) {
                    GoogleLoginServiceImpl.trackEvent$default(this, GoogleLoginPluginEvent.EventKind.LOGOUT_WITH_SUCCESS, null, null, 6, null);
                } else {
                    GoogleLoginServiceImpl.trackEvent$default(this, GoogleLoginPluginEvent.EventKind.LOGOUT_WITH_FAILURE, null, null, 6, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object logOutAllUsers(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof logOutAllUsers.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GoogleLoginServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.logOutAllUsers((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                lastAllUsers = (Map)this.getAllUsersFlow().getValue();
                this.userManager.removeAllUsers();
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Boolean>>, Object>((Map<String, CredentialedUser>)lastAllUsers, null){
                    int label;
                    final /* synthetic */ Map<String, CredentialedUser> $lastAllUsers;
                    {
                        this.$lastAllUsers = $lastAllUsers;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$mapTo$iv$iv;
                                Object list$iv$iv;
                                CredentialedUser it;
                                Iterable $this$flatMapTo$iv$iv;
                                ResultKt.throwOnFailure((Object)object);
                                Iterable $this$flatMap$iv = this.$lastAllUsers.values();
                                boolean $i$f$flatMap = false;
                                Iterable iterable = $this$flatMap$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$flatMapTo = false;
                                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                    it = (CredentialedUser)element$iv$iv;
                                    boolean bl = false;
                                    list$iv$iv = it.getLoginStates$google_login_as();
                                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                }
                                Iterable $this$map$iv = (List)destination$iv$iv;
                                boolean $i$f$map = false;
                                $this$flatMapTo$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    list$iv$iv = (GoogleLoginState)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(Boxing.boxBoolean((boolean)((GoogleLoginState)((Object)it)).logOut()));
                                }
                                return (List)destination$iv$iv;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<Boolean>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var12_4) {
                    return var12_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                this = (GoogleLoginServiceImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                allStatus = (List)v0;
                $this$all$iv = allStatus;
                $i$f$all = false;
                if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) ** GOTO lbl30
                v1 = true;
                ** GOTO lbl37
lbl30:
                // 2 sources

                for (T element$iv : $this$all$iv) {
                    it = (Boolean)element$iv;
                    $i$a$-all-GoogleLoginServiceImpl$logOutAllUsers$2 = false;
                    if (it != false) continue;
                    v1 = false;
                    ** GOTO lbl37
                }
                v1 = true;
lbl37:
                // 3 sources

                if (v1) {
                    GoogleLoginServiceImpl.trackEvent$default(this, GoogleLoginPluginEvent.EventKind.LOGOUT_WITH_SUCCESS, null, null, 6, null);
                } else {
                    GoogleLoginServiceImpl.trackEvent$default(this, GoogleLoginPluginEvent.EventKind.LOGOUT_WITH_FAILURE, null, null, 6, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    private final void initializeUsers() {
        Map<String, Map<LoginFeature, OAuthDataStore>> user2OAuthDataStoreMap;
        Map oAuthDataStoreMap;
        String string = this.loginApplicationSettings.loadActiveUser();
        if (string == null && (string = this.oldLoginApplicationSettings.getActiveUser()) == null) {
            return;
        }
        String activeUserString = string;
        Map<String, Map<LoginFeature, OAuthDataStore>> map = this.loginApplicationSettings.loadOAuthData();
        Object it = map;
        boolean bl = false;
        Map<String, Map<LoginFeature, OAuthDataStore>> map2 = !it.isEmpty() ? map : null;
        if (map2 == null) {
            void $this$mapTo$iv$iv;
            map = V2MigrationUtilsKt.restoreOAuthDataFromV1(this.oldLoginApplicationSettings);
            it = map;
            boolean bl2 = false;
            Iterable $this$map$iv = it.entrySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                String userEmail = (String)entry.getKey();
                oAuthDataStoreMap = (Map)entry.getValue();
                GoogleLoginApplicationSettings.saveAllOAuthDataByUser$default(this.loginApplicationSettings, userEmail, CollectionsKt.toList((Iterable)oAuthDataStoreMap.values()), false, 4, null);
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            map2 = map;
        }
        Map<String, Map<LoginFeature, OAuthDataStore>> $this$forEach$iv = user2OAuthDataStoreMap = map2;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv.entrySet().iterator();
        while (it.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            Map.Entry element$iv;
            Object item$iv$iv;
            Map.Entry entry = element$iv = (Map.Entry)it.next();
            boolean bl4 = false;
            String user = (String)entry.getKey();
            Map feature2OAuthData = (Map)entry.getValue();
            Iterable $i$f$mapTo = MapsKt.toList((Map)feature2OAuthData);
            boolean $i$f$groupBy = false;
            item$iv$iv = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                oAuthDataStoreMap = (Pair)element$iv$iv;
                boolean bl5 = false;
                OAuthDataStore oAuthDataStore = (OAuthDataStore)oAuthDataStoreMap.component2();
                String key$iv$iv = oAuthDataStore.getRefreshToken();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl6 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$groupByTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Unit unit;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl7 = false;
                Map.Entry entry2 = element$iv$iv;
                boolean bl8 = false;
                String token = (String)entry2.getKey();
                List feature2OAuthData2 = (List)entry2.getValue();
                if (token == null) {
                    unit = null;
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = feature2OAuthData2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                        void it2;
                        Pair pair = (Pair)item$iv$iv2;
                        Collection collection = destination$iv$iv2;
                        boolean bl9 = false;
                        collection.add((LoginFeature)it2.getFirst());
                    }
                    Set features = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                    OAuthDataStore oAuthDataStore = new OAuthDataStore(user, token, features);
                    GoogleLoginState state = GoogleLoginState.Companion.createFromPersistence(oAuthDataStore, this.transport, this.uiFacade, this.oAuthServer, this.loginApplicationSettings);
                    this.userManager.addOrUpdateUser(state);
                    this.setActiveUser(state.getEmail());
                    unit = Unit.INSTANCE;
                }
                if (unit == null) continue;
                Unit it$iv$iv = unit;
                boolean bl10 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List cfr_ignored_1 = (List)destination$iv$iv;
        }
        Map allUsers = (Map)this.userManager.getAllUsersFlow().getValue();
        if (allUsers.containsKey(activeUserString)) {
            this.setActiveUser(activeUserString);
        } else if (!allUsers.isEmpty()) {
            String user = (String)CollectionExKt.first((Map)allUsers).getKey();
            this.setActiveUser(user);
            GoogleLoginServiceImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GoogleLoginServiceImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Can't restore to the last active user, so " + user + " becomes active.");
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private final void trackEvent(GoogleLoginPluginEvent.EventKind eventKind, GoogleLoginPluginEvent.LoginType loginType, GoogleLoginPluginEvent.LoginFeatures loginFeatures) {
        void $this$trackEvent_u24lambda_u2414;
        GoogleLoginPluginEvent.Builder builder;
        GoogleLoginPluginEvent.Builder builder2 = builder = GoogleLoginPluginEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.GOOGLE_LOGIN_EVENT);
        boolean bl = false;
        $this$trackEvent_u24lambda_u2414.setEvent(eventKind);
        $this$trackEvent_u24lambda_u2414.setFeatures(loginFeatures);
        $this$trackEvent_u24lambda_u2414.setLoginType(loginType);
        AndroidStudioEvent.Builder builder4 = builder3.setGoogleLoginEvent(builder.build());
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"setGoogleLoginEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder4);
    }

    static /* synthetic */ void trackEvent$default(GoogleLoginServiceImpl googleLoginServiceImpl, GoogleLoginPluginEvent.EventKind eventKind, GoogleLoginPluginEvent.LoginType loginType, GoogleLoginPluginEvent.LoginFeatures loginFeatures, int n, Object object) {
        if ((n & 2) != 0) {
            loginType = GoogleLoginPluginEvent.LoginType.UNKNOWN_TYPE;
        }
        if ((n & 4) != 0) {
            loginFeatures = GoogleLoginPluginEvent.LoginFeatures.getDefaultInstance();
        }
        googleLoginServiceImpl.trackEvent(eventKind, loginType, loginFeatures);
    }

    /*
     * WARNING - void declaration
     */
    private final GoogleLoginPluginEvent.LoginFeatures buildLoginFeatures(Set<? extends LoginFeature> features) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        GoogleLoginPluginEvent.LoginFeatures.Builder builder;
        GoogleLoginPluginEvent.LoginFeatures.Builder $this$buildLoginFeatures_u24lambda_u2416 = builder = GoogleLoginPluginEvent.LoginFeatures.newBuilder();
        boolean bl = false;
        Iterable iterable = features;
        GoogleLoginPluginEvent.LoginFeatures.Builder builder2 = $this$buildLoginFeatures_u24lambda_u2416;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LoginFeature loginFeature = (LoginFeature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getName());
        }
        builder2.addAllFeatures((Iterable)((List)destination$iv$iv));
        GoogleLoginPluginEvent.LoginFeatures loginFeatures = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)loginFeatures, (String)"build(...)");
        return loginFeatures;
    }

    private final boolean shouldLogOut() {
        boolean shouldLogOut;
        VetoableLogoutListener it;
        block5: {
            Iterable $this$all$iv = this.getVetoableLogoutListeners();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (VetoableLogoutListener)element$iv;
                    boolean bl = false;
                    if (it.canLogout()) continue;
                    v0 = false;
                    break block5;
                }
                v0 = shouldLogOut = true;
            }
        }
        if (shouldLogOut) {
            Iterable $this$forEach$iv = this.getVetoableLogoutListeners();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (VetoableLogoutListener)element$iv;
                boolean bl = false;
                it.isLoggingOut();
            }
        }
        return shouldLogOut;
    }

    private static final String getActiveUserAuthInterceptor$lambda$0(GoogleLoginServiceImpl this$0, LoginFeature $feature) {
        return this$0.fetchOAuth2Token($feature);
    }

    private static final Unit logOutSingleUserAsync$lambda$1(LoginLogoutCompletedCallback $logoutCompletedCallback, Throwable it) {
        block0: {
            LoginLogoutCompletedCallback loginLogoutCompletedCallback = $logoutCompletedCallback;
            if (loginLogoutCompletedCallback == null) break block0;
            loginLogoutCompletedCallback.onCompleted();
        }
        return Unit.INSTANCE;
    }

    private static final Unit logOutAllUsersAsync$lambda$2(LoginLogoutCompletedCallback $logoutCompletedCallback, Throwable it) {
        block0: {
            LoginLogoutCompletedCallback loginLogoutCompletedCallback = $logoutCompletedCallback;
            if (loginLogoutCompletedCallback == null) break block0;
            loginLogoutCompletedCallback.onCompleted();
        }
        return Unit.INSTANCE;
    }

    public GoogleLoginServiceImpl() {
        this(null, null, null, null, null, null, 63, null);
    }

    public static final /* synthetic */ UiFacade access$getUiFacade$p(GoogleLoginServiceImpl $this) {
        return $this.uiFacade;
    }

    public static final /* synthetic */ HttpTransport access$getTransport$p(GoogleLoginServiceImpl $this) {
        return $this.transport;
    }

    public static final /* synthetic */ OAuthServer access$getOAuthServer$p(GoogleLoginServiceImpl $this) {
        return $this.oAuthServer;
    }

    public static final /* synthetic */ GoogleLoginApplicationSettings access$getLoginApplicationSettings$p(GoogleLoginServiceImpl $this) {
        return $this.loginApplicationSettings;
    }

    public static final /* synthetic */ void access$trackEvent(GoogleLoginServiceImpl $this, GoogleLoginPluginEvent.EventKind eventKind, GoogleLoginPluginEvent.LoginType loginType, GoogleLoginPluginEvent.LoginFeatures loginFeatures) {
        $this.trackEvent(eventKind, loginType, loginFeatures);
    }

    public static final /* synthetic */ GoogleLoginPluginEvent.LoginFeatures access$buildLoginFeatures(GoogleLoginServiceImpl $this, Set features) {
        return $this.buildLoginFeatures(features);
    }
}

