/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2.ui;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.flags.StudioFlags;
import com.google.gct.login2.CredentialedUser;
import com.google.gct.login2.GoogleLoginService;
import com.google.gct.login2.LoginFeature;
import com.google.gct.login2.ui.GoogleLoginUI;
import com.google.gct.login2.ui.GoogleLoginUsersPanelKt;
import com.google.gct.login2.ui.RoundRectPanel;
import com.google.gct.login2.ui.UsersListCellRenderer;
import com.google.gct.login2.ui.onboarding.GoogleSignInWizard;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.NewUI;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.GoogleLoginIcons;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0001H\u0002J\b\u0010\r\u001a\u00020\u0001H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/google/gct/login2/ui/GoogleLoginUsersPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "closePopup", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "panel", "layout", "Ljava/awt/LayoutManager;", "createMainPanel", "createLoggedOutPanel", "google-login-as"})
@SourceDebugExtension(value={"SMAP\nGoogleLoginUsersPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLoginUsersPanel.kt\ncom/google/gct/login2/ui/GoogleLoginUsersPanel\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n40#2,3:309\n40#2,3:312\n40#2,3:316\n1#3:315\n827#4:319\n855#4,2:320\n1863#4,2:322\n*S KotlinDebug\n*F\n+ 1 GoogleLoginUsersPanel.kt\ncom/google/gct/login2/ui/GoogleLoginUsersPanel\n*L\n80#1:309,3\n86#1:312,3\n140#1:316,3\n201#1:319\n201#1:320,2\n206#1:322,2\n*E\n"})
public final class GoogleLoginUsersPanel
extends JPanel {
    @Nullable
    private final Project project;
    @NotNull
    private final Function0<Unit> closePopup;

    public GoogleLoginUsersPanel(@Nullable Project project2, @NotNull Function0<Unit> closePopup) {
        Intrinsics.checkNotNullParameter(closePopup, (String)"closePopup");
        this.project = project2;
        this.closePopup = closePopup;
        this.setBackground(GoogleLoginUI.Colors.PopupMenu.INSTANCE.getBackground());
        boolean $i$f$service = false;
        Class<GoogleLoginService> serviceClass$iv = GoogleLoginService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.add(((Map)((GoogleLoginService)object).getAllUsersFlow().getValue()).isEmpty() ? this.createLoggedOutPanel() : this.createMainPanel());
    }

    private final JPanel panel(LayoutManager layout) {
        JPanel jPanel;
        JPanel $this$panel_u24lambda_u240 = jPanel = new JPanel(layout);
        boolean bl = false;
        $this$panel_u24lambda_u240.setOpaque(true);
        $this$panel_u24lambda_u240.setBackground(GoogleLoginUI.Colors.PopupMenu.INSTANCE.getBackground());
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createMainPanel() {
        void $this$createMainPanel_u24lambda_u2419_u24lambda_u2418;
        ActionLink $this$createMainPanel_u24lambda_u2419_u24lambda_u2417;
        ActionLink $this$createMainPanel_u24lambda_u2419_u24lambda_u2415;
        JPanel jPanel;
        Object object;
        void $this$filterNotTo$iv$iv;
        JPanel jPanel2;
        void $this$createMainPanel_u24lambda_u245_u24lambda_u244;
        JPanel jPanel3;
        JLabel jLabel;
        JBList jBList;
        boolean $i$f$service = false;
        Class<GoogleLoginService> serviceClass$iv = GoogleLoginService.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        GoogleLoginService service = (GoogleLoginService)object2;
        DefaultListModel<CredentialedUser> listModel = new DefaultListModel<CredentialedUser>();
        JBList $this$createMainPanel_u24lambda_u241 = jBList = new JBList((ListModel)listModel);
        boolean bl = false;
        $this$createMainPanel_u24lambda_u241.setBackground(GoogleLoginUI.Colors.PopupMenu.INSTANCE.getBackground());
        JBList list = jBList;
        list.setSelectionMode(0);
        list.setCellRenderer((ListCellRenderer)new UsersListCellRenderer((JList)list));
        list.addMouseListener((MouseListener)new MouseAdapter((JBList<CredentialedUser>)list, listModel, service, this){
            final /* synthetic */ JBList<CredentialedUser> $list;
            final /* synthetic */ DefaultListModel<CredentialedUser> $listModel;
            final /* synthetic */ GoogleLoginService $service;
            final /* synthetic */ GoogleLoginUsersPanel this$0;
            {
                this.$list = $list;
                this.$listModel = $listModel;
                this.$service = $service;
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
                int index = this.$list.locationToIndex(mouseEvent.getPoint());
                CredentialedUser credentialedUser = this.$listModel.get(index);
                if (credentialedUser == null) {
                    return;
                }
                CredentialedUser user = credentialedUser;
                this.$service.setActiveUser(user.getEmail());
                GoogleLoginUsersPanel.access$getClosePopup$p(this.this$0).invoke();
            }
        });
        listModel.addAll(CollectionsKt.minus((Iterable)((Map)service.getAllUsersFlow().getValue()).values(), (Object)service.getActiveUserFlow().getValue()));
        CredentialedUser credentialedUser = (CredentialedUser)service.getActiveUserFlow().getValue();
        if (credentialedUser == null) {
            throw new IllegalStateException();
        }
        CredentialedUser activeUser = credentialedUser;
        JLabel avatar = new JLabel(GoogleLoginUsersPanelKt.createAvatar$default(activeUser.getPicture(), 0.0f, true, 2, null));
        String string = activeUser.getName();
        if (string == null) {
            string = activeUser.getEmail();
        }
        JLabel $this$createMainPanel_u24lambda_u242 = jLabel = new JLabel(string);
        boolean bl2 = false;
        $this$createMainPanel_u24lambda_u242.setFont(RelativeFont.LARGE.derive($this$createMainPanel_u24lambda_u242.getFont().deriveFont(1)));
        JLabel activeUserName = jLabel;
        $this$createMainPanel_u24lambda_u242 = new JLabel(activeUser.getEmail());
        JComponent $this$createMainPanel_u24lambda_u243 = $this$createMainPanel_u24lambda_u242;
        boolean bl3 = false;
        $this$createMainPanel_u24lambda_u243.setForeground(GoogleLoginUI.Colors.INSTANCE.getSecondaryForeground());
        JLabel activeUserEmail = $this$createMainPanel_u24lambda_u242;
        JComponent $this$createMainPanel_u24lambda_u245 = $this$createMainPanel_u24lambda_u243 = this.panel(new BorderLayout());
        boolean bl4 = false;
        $this$createMainPanel_u24lambda_u245.setBorder(JBUI.Borders.empty((int)5));
        $this$createMainPanel_u24lambda_u245.add((Component)avatar, "West");
        JPanel jPanel4 = jPanel3 = this.panel((LayoutManager)new VerticalFlowLayout(1));
        JComponent jComponent = $this$createMainPanel_u24lambda_u245;
        boolean bl5 = false;
        $this$createMainPanel_u24lambda_u245_u24lambda_u244.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
        $this$createMainPanel_u24lambda_u245_u24lambda_u244.add(activeUserName);
        $this$createMainPanel_u24lambda_u245_u24lambda_u244.add(activeUserEmail);
        jComponent.add((Component)jPanel3, "Center");
        $this$createMainPanel_u24lambda_u245.setName("ActiveUserPanel");
        JComponent activeUserPanel = $this$createMainPanel_u24lambda_u243;
        JComponent p = $this$createMainPanel_u24lambda_u245 = this.panel(new FlowLayout(0, 0, 0));
        boolean bl6 = false;
        p.setBorder((Border)new JBEmptyBorder(4));
        p.setCursor(Cursor.getPredefinedCursor(12));
        boolean $i$f$service2 = false;
        Class<GoogleLoginService> serviceClass$iv2 = GoogleLoginService.class;
        Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object3 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        String text = ((Map)((GoogleLoginService)object3).getAllUsersFlow().getValue()).keySet().size() > 1 ? "Sign Out All" : "Sign Out";
        JBLabel label = new JBLabel(text, StudioIcons.Common.LOGOUT, 2);
        p.add((Component)label);
        p.addMouseListener(new MouseAdapter(this, service, label, (JPanel)p){
            final /* synthetic */ GoogleLoginUsersPanel this$0;
            final /* synthetic */ GoogleLoginService $service;
            final /* synthetic */ JBLabel $label;
            final /* synthetic */ JPanel $p;
            {
                this.this$0 = $receiver;
                this.$service = $service;
                this.$label = $label;
                this.$p = $p;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                GoogleLoginUsersPanel.access$getClosePopup$p(this.this$0).invoke();
                GoogleLoginService.logOutAllUsersAsync$default(this.$service, null, 1, null);
            }

            public void mouseEntered(MouseEvent e) {
                if (!NewUI.isEnabled()) {
                    Icon icon = StudioIcons.Common.LOGOUT;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LOGOUT");
                    this.$label.setIcon(ColoredIconGenerator.generateWhiteIcon((Icon)icon));
                    this.$label.setForeground(GoogleLoginUI.Colors.PopupMenu.INSTANCE.getHoveredForeground());
                }
                GoogleLoginUI.INSTANCE.showHoverEffect$google_login_as(this.$p);
            }

            public void mouseExited(MouseEvent e) {
                this.$label.setIcon(StudioIcons.Common.LOGOUT);
                this.$label.setForeground(GoogleLoginUI.Colors.INSTANCE.getForeground());
                GoogleLoginUI.INSTANCE.hideHoverEffect$google_login_as(this.$p, GoogleLoginUI.Colors.PopupMenu.INSTANCE.getBackground());
            }
        });
        JComponent signOutPanel2 = $this$createMainPanel_u24lambda_u245;
        JComponent p2 = p = this.panel((LayoutManager)new HorizontalLayout(0, 0, 2, null));
        boolean bl7 = false;
        p2.setBorder((Border)new JBEmptyBorder(4));
        p2.setCursor(Cursor.getPredefinedCursor(12));
        JBLabel label2 = new JBLabel("Manage Accounts...", StudioIcons.Common.SETTINGS, 2);
        p2.add((Component)label2);
        p2.addMouseListener(new MouseAdapter(this, label2, (JPanel)p2){
            final /* synthetic */ GoogleLoginUsersPanel this$0;
            final /* synthetic */ JBLabel $label;
            final /* synthetic */ JPanel $p;
            {
                this.this$0 = $receiver;
                this.$label = $label;
                this.$p = $p;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                GoogleLoginUsersPanel.access$getClosePopup$p(this.this$0).invoke();
                ShowSettingsUtil.getInstance().showSettingsDialog(GoogleLoginUsersPanel.access$getProject$p(this.this$0), "Google Accounts");
            }

            public void mouseEntered(MouseEvent e) {
                if (!NewUI.isEnabled()) {
                    Icon icon = StudioIcons.Common.SETTINGS;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SETTINGS");
                    this.$label.setIcon(ColoredIconGenerator.generateWhiteIcon((Icon)icon));
                    this.$label.setForeground(GoogleLoginUI.Colors.PopupMenu.INSTANCE.getHoveredForeground());
                }
                GoogleLoginUI.INSTANCE.showHoverEffect$google_login_as(this.$p);
            }

            public void mouseExited(MouseEvent e) {
                this.$label.setIcon(StudioIcons.Common.SETTINGS);
                this.$label.setForeground(GoogleLoginUI.Colors.INSTANCE.getForeground());
                GoogleLoginUI.INSTANCE.hideHoverEffect$google_login_as(this.$p, GoogleLoginUI.Colors.PopupMenu.INSTANCE.getBackground());
            }
        });
        JComponent managePanel2 = p;
        JPanel $this$createMainPanel_u24lambda_u2419 = jPanel2 = this.panel((LayoutManager)new VerticalFlowLayout());
        boolean bl8 = false;
        $this$createMainPanel_u24lambda_u2419.add(activeUserPanel);
        Iterable $this$filterNot$iv = activeUser.getAllowedFeatures$google_login_as();
        boolean $i$f$filterNot2 = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            LoginFeature it = (LoginFeature)element$iv$iv;
            boolean bl9 = false;
            if (it.isInternal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List features = (List)destination$iv$iv;
        if (!((Collection)features).isEmpty()) {
            JPanel $i$f$filterNot2 = this.panel(new FlowLayout(0));
            JComponent $this$createMainPanel_u24lambda_u2419_u24lambda_u249 = $i$f$filterNot2;
            boolean bl10 = false;
            $this$createMainPanel_u24lambda_u2419_u24lambda_u249.setName("ScopesPanel");
            JPanel scopesPanel = $i$f$filterNot2;
            JComponent $this$createMainPanel_u24lambda_u2419_u24lambda_u2410 = $this$createMainPanel_u24lambda_u2419_u24lambda_u249 = new JLabel("Integrations");
            boolean bl11 = false;
            $this$createMainPanel_u24lambda_u2419_u24lambda_u2410.setForeground(GoogleLoginUI.Colors.INSTANCE.getSecondaryForeground());
            scopesLabel = $this$createMainPanel_u24lambda_u2419_u24lambda_u249;
            Iterable $this$forEach$iv = features;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$createMainPanel_u24lambda_u2419_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411;
                void $this$createMainPanel_u24lambda_u2419_u24lambda_u2413_u24lambda_u2412;
                JBLabel jBLabel;
                RoundRectPanel roundRectPanel;
                LoginFeature it = (LoginFeature)element$iv;
                boolean bl12 = false;
                RoundRectPanel roundRectPanel2 = roundRectPanel = new RoundRectPanel();
                JPanel jPanel5 = scopesPanel;
                boolean bl13 = false;
                JBLabel jBLabel2 = jBLabel = new JBLabel(it.getName());
                void var30_53 = $this$createMainPanel_u24lambda_u2419_u24lambda_u2413_u24lambda_u2412;
                boolean bl14 = false;
                $this$createMainPanel_u24lambda_u2419_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.setBorder((Border)JBUI.Borders.empty((int)3, (int)5));
                var30_53.add((Component)jBLabel);
                jPanel5.add(roundRectPanel);
            }
            $this$createMainPanel_u24lambda_u2419.add((Component)scopesLabel);
            v4 = $this$createMainPanel_u24lambda_u2419.add(scopesPanel);
        } else {
            scopesLabel = object = new ActionLink("Enable integrations...", arg_0 -> GoogleLoginUsersPanel.createMainPanel$lambda$19$lambda$14(this, arg_0));
            jPanel = $this$createMainPanel_u24lambda_u2419;
            boolean bl15 = false;
            $this$createMainPanel_u24lambda_u2419_u24lambda_u2415.setBorder((Border)JBUI.Borders.emptyLeft((int)19));
            v4 = jPanel.add((Component)object);
        }
        if (!listModel.isEmpty()) {
            Object $this$createMainPanel_u24lambda_u2419_u24lambda_u2416;
            $this$createMainPanel_u24lambda_u2419_u24lambda_u2415 = object = new TitledSeparator();
            jPanel = $this$createMainPanel_u24lambda_u2419;
            boolean bl16 = false;
            $this$createMainPanel_u24lambda_u2419_u24lambda_u2416.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
            jPanel.add((Component)object);
            $this$createMainPanel_u24lambda_u2419_u24lambda_u2416 = object = new JLabel("Other accounts");
            jPanel = $this$createMainPanel_u24lambda_u2419;
            boolean bl17 = false;
            $this$createMainPanel_u24lambda_u2419_u24lambda_u2417.setForeground(GoogleLoginUI.Colors.INSTANCE.getSecondaryForeground());
            jPanel.add((Component)object);
            $this$createMainPanel_u24lambda_u2419.add((Component)list);
        }
        $this$createMainPanel_u24lambda_u2419_u24lambda_u2417 = object = new TitledSeparator();
        jPanel = $this$createMainPanel_u24lambda_u2419;
        boolean bl18 = false;
        $this$createMainPanel_u24lambda_u2419_u24lambda_u2418.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
        jPanel.add((Component)object);
        $this$createMainPanel_u24lambda_u2419.add(signOutPanel2);
        $this$createMainPanel_u24lambda_u2419.add(managePanel2);
        JPanel mainPanel = jPanel2;
        return mainPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createLoggedOutPanel() {
        void $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424;
        void $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2425;
        JButton jButton;
        JPanel $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2422;
        JPanel $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2421;
        JPanel $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2420;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel $this$createLoggedOutPanel_u24lambda_u2426 = jPanel2 = this.panel((LayoutManager)new VerticalFlowLayout());
        boolean bl = false;
        $this$createLoggedOutPanel_u24lambda_u2426.setBorder((Border)JBUI.Borders.empty((int)0, (int)3, (int)5, (int)5));
        JPanel jPanel3 = jPanel = this.panel(new FlowLayout(0, 0, 0));
        JPanel jPanel4 = $this$createLoggedOutPanel_u24lambda_u2426;
        boolean bl2 = false;
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2420.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2420.add((Component)new JBLabel(GoogleLoginIcons.GOOGLE_LOGO));
        jPanel4.add(jPanel);
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2420 = jPanel = new JBTextArea("Sign in to access Google services that\naccelerate your daily developer workflow.");
        jPanel4 = $this$createLoggedOutPanel_u24lambda_u2426;
        boolean bl3 = false;
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2421.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2421.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont((float)$this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2421.getFont().getSize()));
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2421.setOpaque(false);
        jPanel4.add(jPanel);
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2421 = jPanel = new BrowserLink("Learn more", "https://d.android.com/r/studio-ui/sign-in/help");
        jPanel4 = $this$createLoggedOutPanel_u24lambda_u2426;
        boolean bl4 = false;
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2422.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        jPanel4.add(jPanel);
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2422 = jPanel = this.panel(new FlowLayout(0, 0, 0));
        jPanel4 = $this$createLoggedOutPanel_u24lambda_u2426;
        boolean bl5 = false;
        JButton jButton2 = jButton = new JButton("Sign In");
        void var10_10 = $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2425;
        boolean bl6 = false;
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424.setOpaque(false);
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424.putClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY, true);
        $this$createLoggedOutPanel_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424.addActionListener(arg_0 -> GoogleLoginUsersPanel.createLoggedOutPanel$lambda$26$lambda$25$lambda$24$lambda$23(this, arg_0));
        var10_10.add(jButton);
        jPanel4.add(jPanel);
        return jPanel2;
    }

    private static final Unit createMainPanel$lambda$19$lambda$14(GoogleLoginUsersPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.closePopup.invoke();
        ShowSettingsUtil.getInstance().showSettingsDialog(this$0.project, "Google Accounts");
        return Unit.INSTANCE;
    }

    private static final void createLoggedOutPanel$lambda$26$lambda$25$lambda$24$lambda$23(GoogleLoginUsersPanel this$0, ActionEvent it) {
        this$0.closePopup.invoke();
        if (((Boolean)StudioFlags.ENABLE_COMBINED_LOGIN_UI.get()).booleanValue()) {
            new GoogleSignInWizard().show();
        } else {
            ShowSettingsUtil.getInstance().showSettingsDialog(this$0.project, "Google Accounts");
        }
    }

    public static final /* synthetic */ Function0 access$getClosePopup$p(GoogleLoginUsersPanel $this) {
        return $this.closePopup;
    }

    public static final /* synthetic */ Project access$getProject$p(GoogleLoginUsersPanel $this) {
        return $this.project;
    }
}

