/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2.ui;

import com.google.gct.login2.CredentialedUser;
import com.google.gct.login2.GoogleLoginService;
import com.google.gct.login2.ui.GoogleLoginUI;
import com.google.gct.login2.ui.GoogleLoginUsersPanelKt;
import com.google.gct.login2.ui.RoundRectPanel;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u001a\u0010\u001c\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\u001aH\u0007R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/google/gct/login2/ui/UsersListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/google/gct/login2/CredentialedUser;", "list", "Ljavax/swing/JList;", "<init>", "(Ljavax/swing/JList;)V", "avatars", "", "Ljava/awt/Image;", "Ljavax/swing/Icon;", "avatarLabel", "Lcom/intellij/ui/components/JBLabel;", "nameComponent", "Lcom/intellij/ui/SimpleColoredComponent;", "emailComponent", "activeLabel", "Ljavax/swing/JPanel;", "renderer", "hoverIdx", "", "getListCellRendererComponent", "Ljava/awt/Component;", "value", "index", "isSelected", "", "cellHasFocus", "getOrCreateAvatar", "picture", "isLoggedIn", "google-login-as"})
@SourceDebugExtension(value={"SMAP\nUsersListCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsersListCellRenderer.kt\ncom/google/gct/login2/ui/UsersListCellRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,145:1\n1#2:146\n40#3,3:147\n*S KotlinDebug\n*F\n+ 1 UsersListCellRenderer.kt\ncom/google/gct/login2/ui/UsersListCellRenderer\n*L\n110#1:147,3\n*E\n"})
public final class UsersListCellRenderer
implements ListCellRenderer<CredentialedUser> {
    @NotNull
    private final Map<Image, Icon> avatars;
    @NotNull
    private final JBLabel avatarLabel;
    @NotNull
    private final SimpleColoredComponent nameComponent;
    @NotNull
    private final SimpleColoredComponent emailComponent;
    @NotNull
    private final JPanel activeLabel;
    @NotNull
    private final JPanel renderer;
    private int hoverIdx;

    /*
     * WARNING - void declaration
     */
    public UsersListCellRenderer(@Nullable JList<CredentialedUser> list) {
        block1: {
            void $this$renderer_u24lambda_u247_u24lambda_u245;
            void $this$renderer_u24lambda_u247;
            void $this$activeLabel_u24lambda_u244_u24lambda_u243_u24lambda_u242;
            SimpleColoredComponent simpleColoredComponent;
            JPanel $this$activeLabel_u24lambda_u244_u24lambda_u243;
            JPanel jPanel;
            Object $this$activeLabel_u24lambda_u244;
            Object $this$emailComponent_u24lambda_u241;
            SimpleColoredComponent $this$nameComponent_u24lambda_u240;
            Object object;
            this.avatars = new LinkedHashMap();
            this.avatarLabel = new JBLabel();
            SimpleColoredComponent simpleColoredComponent2 = object = new SimpleColoredComponent();
            UsersListCellRenderer usersListCellRenderer = this;
            boolean bl = false;
            $this$nameComponent_u24lambda_u240.setOpaque(false);
            usersListCellRenderer.nameComponent = object;
            $this$nameComponent_u24lambda_u240 = object = new SimpleColoredComponent();
            usersListCellRenderer = this;
            boolean bl2 = false;
            $this$emailComponent_u24lambda_u241.setOpaque(false);
            usersListCellRenderer.emailComponent = object;
            $this$emailComponent_u24lambda_u241 = object = new JPanel(new BorderLayout());
            usersListCellRenderer = this;
            boolean bl3 = false;
            $this$activeLabel_u24lambda_u244.setBorder(JBUI.Borders.empty((int)3));
            $this$activeLabel_u24lambda_u244.setOpaque(false);
            RoundRectPanel roundRectPanel = jPanel = new RoundRectPanel();
            void var7_8 = $this$activeLabel_u24lambda_u244;
            boolean bl4 = false;
            $this$activeLabel_u24lambda_u244_u24lambda_u243.setBorder((Border)JBUI.Borders.empty());
            SimpleColoredComponent simpleColoredComponent3 = simpleColoredComponent = new SimpleColoredComponent();
            void var11_12 = $this$activeLabel_u24lambda_u244_u24lambda_u243;
            boolean bl5 = false;
            $this$activeLabel_u24lambda_u244_u24lambda_u243_u24lambda_u242.append("Currently active");
            $this$activeLabel_u24lambda_u244_u24lambda_u243_u24lambda_u242.setOpaque(false);
            $this$activeLabel_u24lambda_u244_u24lambda_u243_u24lambda_u242.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
            var11_12.add((Component)simpleColoredComponent);
            var7_8.add((Component)jPanel, "West");
            usersListCellRenderer.activeLabel = object;
            $this$activeLabel_u24lambda_u244 = object = new JPanel(new BorderLayout());
            usersListCellRenderer = this;
            boolean bl6 = false;
            $this$renderer_u24lambda_u247.add((Component)this.avatarLabel, "West");
            $this$activeLabel_u24lambda_u244_u24lambda_u243 = jPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1, 5, 0, true, false));
            var7_8 = $this$renderer_u24lambda_u247;
            boolean bl7 = false;
            $this$renderer_u24lambda_u247_u24lambda_u245.add((Component)this.nameComponent);
            $this$renderer_u24lambda_u247_u24lambda_u245.add((Component)this.emailComponent);
            $this$renderer_u24lambda_u247_u24lambda_u245.add(this.activeLabel);
            $this$renderer_u24lambda_u247_u24lambda_u245.setOpaque(false);
            var7_8.add((Component)jPanel, "Center");
            $this$renderer_u24lambda_u247.setBorder((Border)new JBEmptyBorder(4));
            JList<CredentialedUser> jList = list;
            if (jList != null) {
                JList<CredentialedUser> it = jList;
                boolean bl8 = false;
                $this$renderer_u24lambda_u247.setBackground(list.getBackground());
            }
            usersListCellRenderer.renderer = object;
            this.hoverIdx = -1;
            JList<CredentialedUser> jList2 = list;
            if (jList2 == null) break block1;
            JList<CredentialedUser> it = jList2;
            boolean bl9 = false;
            MouseAdapter mouseAdapter2 = new MouseAdapter(list, this){
                final /* synthetic */ JList<CredentialedUser> $list;
                final /* synthetic */ UsersListCellRenderer this$0;
                {
                    this.$list = $list;
                    this.this$0 = $receiver;
                }

                public void mouseMoved(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int idx = this.$list.locationToIndex(e.getPoint());
                    if (idx < 0 || !this.$list.getCellBounds(idx, idx).contains(e.getPoint())) {
                        idx = -1;
                    }
                    UsersListCellRenderer.access$setHoverIdx$p(this.this$0, idx);
                    this.$list.repaint();
                }

                public void mouseExited(MouseEvent e) {
                    UsersListCellRenderer.access$setHoverIdx$p(this.this$0, -1);
                    this.$list.repaint();
                }
            };
            list.addMouseListener(mouseAdapter2);
            list.addMouseMotionListener(mouseAdapter2);
        }
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends CredentialedUser> list, @NotNull CredentialedUser value, int index, boolean isSelected, boolean cellHasFocus) {
        SimpleColoredComponent simpleColoredComponent;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.nameComponent.clear();
        String string = value.getName();
        if (string == null) {
            string = value.getEmail();
        }
        this.nameComponent.append(string, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        this.emailComponent.clear();
        SimpleColoredComponent $this$getListCellRendererComponent_u24lambda_u249 = simpleColoredComponent = this.emailComponent.append(value.getEmail());
        boolean bl = false;
        $this$getListCellRendererComponent_u24lambda_u249.setForeground(GoogleLoginUI.Colors.INSTANCE.getSecondaryForeground());
        this.avatarLabel.setIcon(this.getOrCreateAvatar(value.getPicture(), index == 0));
        boolean $i$f$service = false;
        Class<GoogleLoginService> serviceClass$iv = GoogleLoginService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.activeLabel.setVisible(Intrinsics.areEqual((Object)((GoogleLoginService)object).getActiveUserFlow().getValue(), (Object)value));
        if (this.hoverIdx != -1) {
            list.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            list.setCursor(Cursor.getDefaultCursor());
        }
        if (isSelected) {
            this.renderer.setBackground(list.getSelectionBackground());
            this.renderer.setForeground(list.getSelectionForeground());
            this.nameComponent.setForeground(list.getSelectionForeground());
            this.emailComponent.setForeground(list.getSelectionForeground());
        } else if (index == this.hoverIdx) {
            GoogleLoginUI.INSTANCE.showHoverEffect$google_login_as(this.renderer);
            this.nameComponent.setForeground(list.getSelectionForeground());
            this.emailComponent.setForeground(list.getSelectionForeground());
        } else {
            Color color = list.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
            GoogleLoginUI.INSTANCE.hideHoverEffect$google_login_as(this.renderer, color);
            this.renderer.setForeground(list.getForeground());
            this.nameComponent.setForeground(list.getForeground());
            this.emailComponent.setForeground(GoogleLoginUI.Colors.INSTANCE.getSecondaryForeground());
        }
        return this.renderer;
    }

    @VisibleForTesting
    @NotNull
    public final Icon getOrCreateAvatar(@Nullable Image picture, boolean isLoggedIn) {
        Icon icon;
        if (picture == null) {
            Icon icon2 = GoogleLoginUsersPanelKt.createAvatar(null, 0.5f, isLoggedIn);
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"createAvatar(...)");
        } else {
            Icon icon3 = this.avatars.computeIfAbsent(picture, arg_0 -> UsersListCellRenderer.getOrCreateAvatar$lambda$11(arg_0 -> UsersListCellRenderer.getOrCreateAvatar$lambda$10(picture, isLoggedIn, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"computeIfAbsent(...)");
            icon = icon3;
        }
        return icon;
    }

    private static final Icon getOrCreateAvatar$lambda$10(Image $picture, boolean $isLoggedIn, Image it) {
        return GoogleLoginUsersPanelKt.createAvatar($picture, 0.5f, $isLoggedIn);
    }

    private static final Icon getOrCreateAvatar$lambda$11(Function1 $tmp0, Object p0) {
        return (Icon)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$setHoverIdx$p(UsersListCellRenderer $this, int n) {
        $this.hoverIdx = n;
    }
}

