/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.api.ide.stacktrace;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.AndroidExecutors;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.inspectors.common.api.ide.stacktrace.IntelliJCodeElement;
import com.android.tools.inspectors.common.api.ide.stacktrace.IntelliJStackTraceViewKt;
import com.android.tools.inspectors.common.api.stacktrace.CodeElement;
import com.android.tools.inspectors.common.api.stacktrace.StackElement;
import com.android.tools.inspectors.common.api.stacktrace.StackTraceModel;
import com.android.tools.inspectors.common.api.stacktrace.ThreadElement;
import com.android.tools.inspectors.common.api.stacktrace.ThreadId;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.inspectors.common.ui.stacktrace.StackTraceView;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001;B;\b\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010B!\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0011J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020\bH\u0016J\b\u0010*\u001a\u00020\u0017H\u0016J\u000e\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\"J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00106\u001a\u00020\"2\u0006\u00103\u001a\u000204H\u0016J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u001a0\u001a0\u001c8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/android/tools/inspectors/common/api/ide/stacktrace/IntelliJStackTraceView;", "Lcom/android/tools/adtui/model/AspectObserver;", "Lcom/android/tools/inspectors/common/ui/stacktrace/StackTraceView;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/ide/CopyProvider;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/inspectors/common/api/stacktrace/StackTraceModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "generator", "Lkotlin/Function2;", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "Lcom/android/tools/inspectors/common/api/stacktrace/CodeElement;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/inspectors/common/api/stacktrace/StackTraceModel;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function2;)V", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/inspectors/common/api/stacktrace/StackTraceModel;Lcom/intellij/openapi/Disposable;)V", "copyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/ide/CopyPasteManager;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "listModel", "Ljavax/swing/DefaultListModel;", "Lcom/android/tools/inspectors/common/api/stacktrace/StackElement;", "listView", "Lcom/intellij/ui/components/JBList;", "getListView", "()Lcom/intellij/ui/components/JBList;", "renderer", "Lcom/android/tools/inspectors/common/api/ide/stacktrace/IntelliJStackTraceView$StackElementRenderer;", "installNavigationContextMenu", "", "contextMenuInstaller", "Lcom/android/tools/inspectors/common/ui/ContextMenuInstaller;", "installGenericContextMenu", "installer", "contextMenuItem", "Lcom/android/tools/adtui/stdui/ContextMenuItem;", "getModel", "getComponent", "addListSelectionListener", "listener", "Ljavax/swing/event/ListSelectionListener;", "clearSelection", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isCopyEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyVisible", "performCopy", "getData", "", "dataId", "", "StackElementRenderer", "intellij.android.inspectors-common.api-ide"})
public final class IntelliJStackTraceView
extends AspectObserver
implements StackTraceView,
DataProvider,
CopyProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final StackTraceModel model;
    @NotNull
    private final Function2<Project, CodeLocation, CodeElement> generator;
    private final CopyPasteManager copyPasteManager;
    @NotNull
    private final JBScrollPane scrollPane;
    @NotNull
    private final DefaultListModel<StackElement> listModel;
    @NotNull
    private final JBList<StackElement> listView;
    @NotNull
    private final StackElementRenderer renderer;

    @VisibleForTesting
    public IntelliJStackTraceView(@NotNull Project project, @NotNull StackTraceModel model, @NotNull Disposable parentDisposable, @NotNull Function2<? super Project, ? super CodeLocation, ? extends CodeElement> generator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(generator, (String)"generator");
        this.project = project;
        this.model = model;
        this.generator = generator;
        this.copyPasteManager = CopyPasteManager.getInstance();
        this.listModel = new DefaultListModel();
        this.listView = new JBList((ListModel)this.listModel);
        this.listView.setSelectionMode(0);
        this.listView.setBackground(StandardColors.DEFAULT_CONTENT_BACKGROUND_COLOR);
        this.renderer = new StackElementRenderer();
        this.listView.setCellRenderer((ListCellRenderer)((Object)this.renderer));
        this.scrollPane = new JBScrollPane((Component)this.listView);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        DataManager.registerDataProvider((JComponent)((JComponent)this.listView), (DataProvider)this);
        this.listView.addListSelectionListener(arg_0 -> IntelliJStackTraceView._init_$lambda$1(this, arg_0));
        Function0 navigationHandler = () -> IntelliJStackTraceView._init_$lambda$2(this);
        this.listView.addKeyListener((KeyListener)new KeyAdapter((Function0<Boolean>)navigationHandler){
            final /* synthetic */ Function0<Boolean> $navigationHandler;
            {
                this.$navigationHandler = $navigationHandler;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int keyCode = KeyEvent.getExtendedKeyCodeForChar(e.getKeyChar());
                if (keyCode == 10 && ((Boolean)this.$navigationHandler.invoke()).booleanValue()) {
                    e.consume();
                }
            }
        });
        new DoubleClickListener((Function0<Boolean>)navigationHandler){
            final /* synthetic */ Function0<Boolean> $navigationHandler;
            {
                this.$navigationHandler = $navigationHandler;
            }

            protected boolean onDoubleClick(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return (Boolean)this.$navigationHandler.invoke();
            }
        }.installOn((Component)this.listView);
        this.listView.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isRightMouseButton(e) && (row = this.getListView().locationToIndex(e.getPoint())) != -1) {
                    this.getListView().setSelectedIndex(row);
                }
            }
        });
        CoroutineScope scope = CoroutineUtilsKt.AndroidCoroutineScope$default((Disposable)parentDisposable, null, (int)2, null);
        Executor executor = MoreExecutors.newSequentialExecutor((Executor)AndroidExecutors.Companion.getInstance().getWorkerThreadExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"newSequentialExecutor(...)");
        CoroutineDispatcher dispatcher = ExecutorsKt.from((Executor)executor);
        this.model.addDependency(this).onChange((Enum)StackTraceModel.Aspect.STACK_FRAMES, () -> IntelliJStackTraceView._init_$lambda$3(scope, dispatcher, this)).onChange((Enum)StackTraceModel.Aspect.SELECTED_LOCATION, () -> IntelliJStackTraceView._init_$lambda$4(this));
    }

    @VisibleForTesting
    @NotNull
    public final JBList<StackElement> getListView() {
        return this.listView;
    }

    public IntelliJStackTraceView(@NotNull Project project, @NotNull StackTraceModel model, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(project, model, parentDisposable, (Function2<? super Project, ? super CodeLocation, ? extends CodeElement>)((Function2)IntelliJStackTraceView::_init_$lambda$0));
    }

    public final void installNavigationContextMenu(@NotNull ContextMenuInstaller contextMenuInstaller) {
        Intrinsics.checkNotNullParameter((Object)contextMenuInstaller, (String)"contextMenuInstaller");
        contextMenuInstaller.installNavigationContextMenu((JComponent)this.listView, this.model.getCodeNavigator(), () -> IntelliJStackTraceView.installNavigationContextMenu$lambda$5(this));
    }

    public final void installGenericContextMenu(@NotNull ContextMenuInstaller installer, @NotNull ContextMenuItem contextMenuItem) {
        Intrinsics.checkNotNullParameter((Object)installer, (String)"installer");
        Intrinsics.checkNotNullParameter((Object)contextMenuItem, (String)"contextMenuItem");
        installer.installGenericContextMenu((JComponent)this.listView, contextMenuItem);
    }

    @Override
    @NotNull
    public StackTraceModel getModel() {
        return this.model;
    }

    @NotNull
    public JBScrollPane getComponent() {
        return this.scrollPane;
    }

    public final void addListSelectionListener(@NotNull ListSelectionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listView.addListSelectionListener(listener);
    }

    public final void clearSelection() {
        this.listView.clearSelection();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        int selectedIndex = this.listView.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.listView.getItemsCount()) {
            this.renderer.getListCellRendererComponent((JList)this.listView, this.listModel.getElementAt(selectedIndex), selectedIndex, true, false);
            String data = ((Object)this.renderer.getCharSequence(false)).toString();
            this.copyPasteManager.setContents((Transferable)new StringSelection(data));
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return Intrinsics.areEqual((Object)dataId, (Object)PlatformDataKeys.COPY_PROVIDER.getName()) ? this : null;
    }

    private static final CodeElement _init_$lambda$0(Project p, CodeLocation l) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        return new IntelliJCodeElement(p, l);
    }

    private static final void _init_$lambda$1(IntelliJStackTraceView this$0, ListSelectionEvent it) {
        if (this$0.listView.getSelectedValue() == null) {
            this$0.model.clearSelection();
        }
    }

    private static final boolean _init_$lambda$2(IntelliJStackTraceView this$0) {
        boolean bl;
        int index = this$0.listView.getSelectedIndex();
        if (index >= 0 && index < this$0.listView.getItemsCount()) {
            this$0.model.setSelectedIndex(index);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void _init_$lambda$3(CoroutineScope $scope, CoroutineDispatcher $dispatcher, IntelliJStackTraceView this$0) {
        BuildersKt.launch$default((CoroutineScope)$scope, (CoroutineContext)((CoroutineContext)$dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ IntelliJStackTraceView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ResultKt.throwOnFailure((Object)object);
                        List<CodeLocation> list = IntelliJStackTraceView.access$getModel$p(this.this$0).getCodeLocations();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getCodeLocations(...)");
                        Iterable iterable = list;
                        IntelliJStackTraceView intelliJStackTraceView = this.this$0;
                        boolean $i$f$map = false;
                        void var6_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            CodeLocation codeLocation = (CodeLocation)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Function2 function2 = IntelliJStackTraceView.access$getGenerator$p(intelliJStackTraceView);
                            Project project = IntelliJStackTraceView.access$getProject$p(intelliJStackTraceView);
                            Intrinsics.checkNotNull((Object)it);
                            collection.add((CodeElement)function2.invoke((Object)project, (Object)it));
                        }
                        List elements = (List)destination$iv$iv;
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (List<? extends CodeElement>)elements, null){
                            int label;
                            final /* synthetic */ IntelliJStackTraceView this$0;
                            final /* synthetic */ List<CodeElement> $elements;
                            {
                                this.this$0 = $receiver;
                                this.$elements = $elements;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        IntelliJStackTraceView.access$getListModel$p(this.this$0).removeAllElements();
                                        this.this$0.getListView().clearSelection();
                                        IntelliJStackTraceView.access$getListModel$p(this.this$0).addAll((Collection)this.$elements);
                                        ThreadId threadId = IntelliJStackTraceView.access$getModel$p(this.this$0).getThreadId();
                                        Intrinsics.checkNotNullExpressionValue((Object)threadId, (String)"getThreadId(...)");
                                        ThreadId threadId2 = threadId;
                                        if (!Intrinsics.areEqual((Object)threadId2, (Object)ThreadId.INVALID_THREAD_ID)) {
                                            IntelliJStackTraceView.access$getListModel$p(this.this$0).addElement(new ThreadElement(threadId2));
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private static final void _init_$lambda$4(IntelliJStackTraceView this$0) {
        int index = this$0.model.getSelectedIndex();
        if (this$0.model.getSelectedType() == StackTraceModel.Type.INVALID) {
            if (this$0.listView.getSelectedIndex() != -1) {
                this$0.listView.clearSelection();
            }
        } else if (index >= 0 && index < this$0.listView.getItemsCount()) {
            if (this$0.listView.getSelectedIndex() != index) {
                this$0.listView.setSelectedIndex(index);
            }
        } else {
            throw new IndexOutOfBoundsException("View has " + this$0.listView.getItemsCount() + " elements while aspect is changing to index " + index);
        }
    }

    private static final CodeLocation installNavigationContextMenu$lambda$5(IntelliJStackTraceView this$0) {
        int index = this$0.listView.getSelectedIndex();
        if (index >= 0 && index < this$0.listView.getItemsCount()) {
            return this$0.model.getCodeLocations().get(index);
        }
        return null;
    }

    public static final /* synthetic */ StackTraceModel access$getModel$p(IntelliJStackTraceView $this) {
        return $this.model;
    }

    public static final /* synthetic */ DefaultListModel access$getListModel$p(IntelliJStackTraceView $this) {
        return $this.listModel;
    }

    public static final /* synthetic */ Function2 access$getGenerator$p(IntelliJStackTraceView $this) {
        return $this.generator;
    }

    public static final /* synthetic */ Project access$getProject$p(IntelliJStackTraceView $this) {
        return $this.project;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J:\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/inspectors/common/api/ide/stacktrace/IntelliJStackTraceView$StackElementRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/android/tools/inspectors/common/api/stacktrace/StackElement;", "<init>", "()V", "iconManager", "Lcom/intellij/ui/IconManager;", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "renderCodeElement", "element", "Lcom/android/tools/inspectors/common/api/stacktrace/CodeElement;", "renderJavaStackFrame", "codeElement", "renderNativeStackFrame", "renderThreadElement", "threadElement", "Lcom/android/tools/inspectors/common/api/stacktrace/ThreadElement;", "intellij.android.inspectors-common.api-ide"})
    private static final class StackElementRenderer
    extends ColoredListCellRenderer<StackElement> {
        @NotNull
        private final IconManager iconManager = IconManager.Companion.getInstance();

        protected void customizeCellRenderer(@NotNull JList<? extends StackElement> list, @Nullable StackElement value, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (value == null) {
                return;
            }
            this.setIpad(IntelliJStackTraceViewKt.access$getLIST_ROW_INSETS$p());
            StackElement stackElement = value;
            if (stackElement instanceof ThreadElement) {
                this.renderThreadElement((ThreadElement)value, selected);
            } else if (stackElement instanceof CodeElement) {
                this.renderCodeElement((CodeElement)value, selected);
            } else {
                this.append(value.toString(), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        private final void renderCodeElement(CodeElement element, boolean selected) {
            boolean bl = element.getCodeLocation().isNativeCode();
            if (bl) {
                this.renderNativeStackFrame(element, selected);
            } else if (!bl) {
                this.renderJavaStackFrame(element, selected);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }

        private final void renderJavaStackFrame(CodeElement codeElement, boolean selected) {
            this.setIcon(this.iconManager.getPlatformIcon(PlatformIcons.Method));
            SimpleTextAttributes textAttribute = selected || codeElement.isInUserCode() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
            CodeLocation codeLocation = codeElement.getCodeLocation();
            Intrinsics.checkNotNullExpressionValue((Object)codeLocation, (String)"getCodeLocation(...)");
            CodeLocation location = codeLocation;
            StringBuilder methodBuilder = new StringBuilder(codeElement.getMethodName());
            if (location.getLineNumber() != -1) {
                methodBuilder.append(":");
                methodBuilder.append(location.getLineNumber() + 1);
            }
            methodBuilder.append(", ");
            methodBuilder.append(codeElement.getSimpleClassName());
            String string = methodBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String methodName = string;
            this.append(methodName, textAttribute, methodName);
            String packageName = " (" + codeElement.getPackageName() + ")";
            this.append(packageName, selected ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES, packageName);
        }

        private final void renderNativeStackFrame(CodeElement codeElement, boolean selected) {
            String string;
            String fileName;
            StringBuilder stringBuilder;
            this.setIcon(this.iconManager.getPlatformIcon(PlatformIcons.Method));
            CodeLocation codeLocation = codeElement.getCodeLocation();
            Intrinsics.checkNotNullExpressionValue((Object)codeLocation, (String)"getCodeLocation(...)");
            CodeLocation location = codeLocation;
            StringBuilder $this$renderNativeStackFrame_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            CharSequence charSequence = location.getClassName();
            if (!(charSequence == null || charSequence.length() == 0)) {
                $this$renderNativeStackFrame_u24lambda_u241.append(location.getClassName());
                $this$renderNativeStackFrame_u24lambda_u241.append("::");
            }
            $this$renderNativeStackFrame_u24lambda_u241.append(location.getMethodName());
            Object object = location.getMethodParameters();
            if (object == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)",", null, null, (int)0, null, StackElementRenderer::renderNativeStackFrame$lambda$1$lambda$0, (int)30, null)) == null) {
                object = "";
            }
            Object params = object;
            $this$renderNativeStackFrame_u24lambda_u241.append("(" + (String)params + ") ");
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String methodName = string2;
            this.append(methodName, SimpleTextAttributes.REGULAR_ATTRIBUTES, methodName);
            String string3 = location.getFileName();
            if (string3 == null) {
                string3 = "";
            }
            if (((CharSequence)(fileName = string3)).length() > 0) {
                StringBuilder $this$renderNativeStackFrame_u24lambda_u242 = bl = new StringBuilder();
                boolean bl2 = false;
                $this$renderNativeStackFrame_u24lambda_u242.append(((Object)Paths.get(fileName, new String[0]).getFileName()).toString());
                if (location.getLineNumber() != -1) {
                    $this$renderNativeStackFrame_u24lambda_u242.append(":" + (location.getLineNumber() + 1));
                }
                String string4 = bl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                String sourceLocation = string4;
                this.append(sourceLocation, SimpleTextAttributes.REGULAR_ATTRIBUTES, sourceLocation);
            }
            if ((string = location.getNativeModuleName()) == null) {
                string = "unknown";
            }
            String nativeModuleName = string;
            String moduleName = " " + Paths.get(nativeModuleName, new String[0]).getFileName();
            this.append(moduleName, selected ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES, moduleName);
        }

        private final void renderThreadElement(ThreadElement threadElement, boolean selected) {
            this.setIcon(AllIcons.Debugger.ThreadSuspended);
            String string = threadElement.getThreadId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String text = string;
            this.append(text, selected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES, text);
        }

        private static final CharSequence renderNativeStackFrame$lambda$1$lambda$0(String it) {
            Intrinsics.checkNotNull((Object)it);
            return it;
        }
    }
}

