/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.foundation.GenerateDataFunctions;
import org.jetbrains.jewel.foundation.code.MimeType;
import org.jetbrains.jewel.markdown.InlineMarkdown;
import org.jetbrains.jewel.markdown.WithInlineMarkdown;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\t\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u0082\u0001\t\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "", "BlockQuote", "CodeBlock", "CustomBlock", "Heading", "HtmlBlock", "ListBlock", "ListItem", "ThematicBreak", "Paragraph", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$BlockQuote;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CustomBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$Heading;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$HtmlBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListItem;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$Paragraph;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ThematicBreak;", "core"})
public interface MarkdownBlock {

    @GenerateDataFunctions
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006\"\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$BlockQuote;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "children", "", "<init>", "(Ljava/util/List;)V", "", "([Lorg/jetbrains/jewel/markdown/MarkdownBlock;)V", "getChildren", "()Ljava/util/List;", "core"})
    @StabilityInferred(parameters=0)
    public static final class BlockQuote
    implements MarkdownBlock {
        @NotNull
        private final List<MarkdownBlock> children;
        public static final int $stable = 8;

        public BlockQuote(@NotNull List<? extends MarkdownBlock> children) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.children = children;
        }

        @NotNull
        public final List<MarkdownBlock> getChildren() {
            return this.children;
        }

        public BlockQuote(MarkdownBlock ... children) {
            Intrinsics.checkNotNullParameter((Object)children, (String)"children");
            this(ArraysKt.toList((Object[])children));
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockQuote)) {
                return false;
            }
            BlockQuote blockQuote = (BlockQuote)other;
            return Intrinsics.areEqual(this.children, blockQuote.children);
        }

        public int hashCode() {
            return ((Object)this.children).hashCode();
        }

        @NotNull
        public String toString() {
            return "BlockQuote(children=" + this.children + ")";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0006\u0007R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "content", "", "getContent", "()Ljava/lang/String;", "IndentedCodeBlock", "FencedCodeBlock", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock$FencedCodeBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock$IndentedCodeBlock;", "core"})
    public static interface CodeBlock
    extends MarkdownBlock {
        @NotNull
        public String getContent();

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @GenerateDataFunctions
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\n\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock$FencedCodeBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock;", "content", "", "mimeType", "Lorg/jetbrains/jewel/foundation/code/MimeType;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getContent", "()Ljava/lang/String;", "getMimeType-VwCp3SY", "Ljava/lang/String;", "core"})
        @StabilityInferred(parameters=1)
        public static final class FencedCodeBlock
        implements CodeBlock {
            @NotNull
            private final String content;
            @Nullable
            private final String mimeType;
            public static final int $stable;

            private FencedCodeBlock(String content, String mimeType) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                this.content = content;
                this.mimeType = mimeType;
            }

            @Override
            @NotNull
            public String getContent() {
                return this.content;
            }

            @Nullable
            public final String getMimeType-VwCp3SY() {
                return this.mimeType;
            }

            public boolean equals(@Nullable Object other) {
                boolean bl;
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FencedCodeBlock)) {
                    return false;
                }
                FencedCodeBlock fencedCodeBlock = (FencedCodeBlock)other;
                if (!Intrinsics.areEqual((Object)this.content, (Object)fencedCodeBlock.content)) {
                    return false;
                }
                String string = this.mimeType;
                String string2 = fencedCodeBlock.mimeType;
                if (string == null) {
                    bl = string2 == null;
                } else {
                    String string3 = string2;
                    bl = string3 == null ? false : MimeType.equals-impl0((String)string, (String)string3);
                }
                return bl;
            }

            public int hashCode() {
                int result = this.content.hashCode();
                result = result * 31 + (this.mimeType == null ? 0 : MimeType.hashCode-impl((String)this.mimeType));
                return result;
            }

            @NotNull
            public String toString() {
                String string = this.mimeType;
                return "FencedCodeBlock(content=" + this.content + ", mimeType=" + (string == null ? "null" : MimeType.toString-impl((String)string)) + ")";
            }

            public /* synthetic */ FencedCodeBlock(String content, String mimeType, DefaultConstructorMarker $constructor_marker) {
                this(content, mimeType);
            }
        }

        @GenerateDataFunctions
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock$IndentedCodeBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock;", "content", "", "<init>", "(Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "core"})
        @StabilityInferred(parameters=1)
        public static final class IndentedCodeBlock
        implements CodeBlock {
            @NotNull
            private final String content;
            public static final int $stable;

            public IndentedCodeBlock(@NotNull String content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                this.content = content;
            }

            @Override
            @NotNull
            public String getContent() {
                return this.content;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IndentedCodeBlock)) {
                    return false;
                }
                IndentedCodeBlock indentedCodeBlock = (IndentedCodeBlock)other;
                return Intrinsics.areEqual((Object)this.content, (Object)indentedCodeBlock.content);
            }

            public int hashCode() {
                return this.content.hashCode();
            }

            @NotNull
            public String toString() {
                return "IndentedCodeBlock(content=" + this.content + ")";
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$CustomBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "core"})
    public static interface CustomBlock
    extends MarkdownBlock {
    }

    @GenerateDataFunctions
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB%\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\n\"\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u000bR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$Heading;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "Lorg/jetbrains/jewel/markdown/WithInlineMarkdown;", "inlineContent", "", "Lorg/jetbrains/jewel/markdown/InlineMarkdown;", "level", "", "<init>", "(Ljava/util/List;I)V", "", "(I[Lorg/jetbrains/jewel/markdown/InlineMarkdown;)V", "getInlineContent", "()Ljava/util/List;", "getLevel", "()I", "core"})
    @StabilityInferred(parameters=0)
    public static final class Heading
    implements MarkdownBlock,
    WithInlineMarkdown {
        @NotNull
        private final List<InlineMarkdown> inlineContent;
        private final int level;
        public static final int $stable = 8;

        public Heading(@NotNull List<? extends InlineMarkdown> inlineContent, int level) {
            Intrinsics.checkNotNullParameter(inlineContent, (String)"inlineContent");
            this.inlineContent = inlineContent;
            this.level = level;
        }

        @Override
        @NotNull
        public List<InlineMarkdown> getInlineContent() {
            return this.inlineContent;
        }

        public final int getLevel() {
            return this.level;
        }

        public Heading(int level, InlineMarkdown ... inlineContent) {
            Intrinsics.checkNotNullParameter((Object)inlineContent, (String)"inlineContent");
            this(ArraysKt.toList((Object[])inlineContent), level);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Heading)) {
                return false;
            }
            Heading heading = (Heading)other;
            if (!Intrinsics.areEqual(this.inlineContent, heading.inlineContent)) {
                return false;
            }
            return this.level == heading.level;
        }

        public int hashCode() {
            int result = ((Object)this.inlineContent).hashCode();
            result = result * 31 + this.level;
            return result;
        }

        @NotNull
        public String toString() {
            return "Heading(inlineContent=" + this.inlineContent + ", level=" + this.level + ")";
        }
    }

    @GenerateDataFunctions
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$HtmlBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "content", "", "<init>", "(Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "core"})
    @StabilityInferred(parameters=1)
    public static final class HtmlBlock
    implements MarkdownBlock {
        @NotNull
        private final String content;
        public static final int $stable;

        public HtmlBlock(@NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HtmlBlock)) {
                return false;
            }
            HtmlBlock htmlBlock = (HtmlBlock)other;
            return Intrinsics.areEqual((Object)this.content, (Object)htmlBlock.content);
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        @NotNull
        public String toString() {
            return "HtmlBlock(content=" + this.content + ")";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\n\u000bR\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "children", "", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListItem;", "getChildren", "()Ljava/util/List;", "isTight", "", "()Z", "OrderedList", "UnorderedList", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock$OrderedList;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock$UnorderedList;", "core"})
    public static interface ListBlock
    extends MarkdownBlock {
        @NotNull
        public List<ListItem> getChildren();

        public boolean isTight();

        @GenerateDataFunctions
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB5\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\r\"\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\u000eR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock$OrderedList;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock;", "children", "", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListItem;", "isTight", "", "startFrom", "", "delimiter", "", "<init>", "(Ljava/util/List;ZILjava/lang/String;)V", "", "(ZILjava/lang/String;[Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListItem;)V", "getChildren", "()Ljava/util/List;", "()Z", "getStartFrom", "()I", "getDelimiter", "()Ljava/lang/String;", "core"})
        @StabilityInferred(parameters=0)
        public static final class OrderedList
        implements ListBlock {
            @NotNull
            private final List<ListItem> children;
            private final boolean isTight;
            private final int startFrom;
            @NotNull
            private final String delimiter;
            public static final int $stable = 8;

            public OrderedList(@NotNull List<ListItem> children, boolean isTight, int startFrom, @NotNull String delimiter) {
                Intrinsics.checkNotNullParameter(children, (String)"children");
                Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
                this.children = children;
                this.isTight = isTight;
                this.startFrom = startFrom;
                this.delimiter = delimiter;
            }

            @Override
            @NotNull
            public List<ListItem> getChildren() {
                return this.children;
            }

            @Override
            public boolean isTight() {
                return this.isTight;
            }

            public final int getStartFrom() {
                return this.startFrom;
            }

            @NotNull
            public final String getDelimiter() {
                return this.delimiter;
            }

            public OrderedList(boolean isTight, int startFrom, @NotNull String delimiter, ListItem ... children) {
                Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
                Intrinsics.checkNotNullParameter((Object)children, (String)"children");
                this(ArraysKt.toList((Object[])children), isTight, startFrom, delimiter);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof OrderedList)) {
                    return false;
                }
                OrderedList orderedList = (OrderedList)other;
                if (!Intrinsics.areEqual(this.children, orderedList.children)) {
                    return false;
                }
                if (this.isTight != orderedList.isTight) {
                    return false;
                }
                if (this.startFrom != orderedList.startFrom) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.delimiter, (Object)orderedList.delimiter);
            }

            public int hashCode() {
                int result = ((Object)this.children).hashCode();
                result = result * 31 + Boolean.hashCode(this.isTight);
                result = result * 31 + this.startFrom;
                result = result * 31 + this.delimiter.hashCode();
                return result;
            }

            @NotNull
            public String toString() {
                return "OrderedList(children=" + this.children + ", isTight=" + this.isTight + ", startFrom=" + this.startFrom + ", delimiter=" + this.delimiter + ")";
            }
        }

        @GenerateDataFunctions
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB-\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000b\"\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\fR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock$UnorderedList;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock;", "children", "", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListItem;", "isTight", "", "marker", "", "<init>", "(Ljava/util/List;ZLjava/lang/String;)V", "", "(ZLjava/lang/String;[Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListItem;)V", "getChildren", "()Ljava/util/List;", "()Z", "getMarker", "()Ljava/lang/String;", "core"})
        @StabilityInferred(parameters=0)
        public static final class UnorderedList
        implements ListBlock {
            @NotNull
            private final List<ListItem> children;
            private final boolean isTight;
            @NotNull
            private final String marker;
            public static final int $stable = 8;

            public UnorderedList(@NotNull List<ListItem> children, boolean isTight, @NotNull String marker) {
                Intrinsics.checkNotNullParameter(children, (String)"children");
                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                this.children = children;
                this.isTight = isTight;
                this.marker = marker;
            }

            @Override
            @NotNull
            public List<ListItem> getChildren() {
                return this.children;
            }

            @Override
            public boolean isTight() {
                return this.isTight;
            }

            @NotNull
            public final String getMarker() {
                return this.marker;
            }

            public UnorderedList(boolean isTight, @NotNull String marker, ListItem ... children) {
                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                Intrinsics.checkNotNullParameter((Object)children, (String)"children");
                this(ArraysKt.toList((Object[])children), isTight, marker);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnorderedList)) {
                    return false;
                }
                UnorderedList unorderedList = (UnorderedList)other;
                if (!Intrinsics.areEqual(this.children, unorderedList.children)) {
                    return false;
                }
                if (this.isTight != unorderedList.isTight) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.marker, (Object)unorderedList.marker);
            }

            public int hashCode() {
                int result = ((Object)this.children).hashCode();
                result = result * 31 + Boolean.hashCode(this.isTight);
                result = result * 31 + this.marker.hashCode();
                return result;
            }

            @NotNull
            public String toString() {
                return "UnorderedList(children=" + this.children + ", isTight=" + this.isTight + ", marker=" + this.marker + ")";
            }
        }
    }

    @GenerateDataFunctions
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006\"\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListItem;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "children", "", "<init>", "(Ljava/util/List;)V", "", "([Lorg/jetbrains/jewel/markdown/MarkdownBlock;)V", "getChildren", "()Ljava/util/List;", "core"})
    @StabilityInferred(parameters=0)
    public static final class ListItem
    implements MarkdownBlock {
        @NotNull
        private final List<MarkdownBlock> children;
        public static final int $stable = 8;

        public ListItem(@NotNull List<? extends MarkdownBlock> children) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.children = children;
        }

        @NotNull
        public final List<MarkdownBlock> getChildren() {
            return this.children;
        }

        public ListItem(MarkdownBlock ... children) {
            Intrinsics.checkNotNullParameter((Object)children, (String)"children");
            this(ArraysKt.toList((Object[])children));
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ListItem)) {
                return false;
            }
            ListItem listItem = (ListItem)other;
            return Intrinsics.areEqual(this.children, listItem.children);
        }

        public int hashCode() {
            return ((Object)this.children).hashCode();
        }

        @NotNull
        public String toString() {
            return "ListItem(children=" + this.children + ")";
        }
    }

    @GenerateDataFunctions
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\b\"\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\tR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$Paragraph;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "Lorg/jetbrains/jewel/markdown/WithInlineMarkdown;", "inlineContent", "", "Lorg/jetbrains/jewel/markdown/InlineMarkdown;", "<init>", "(Ljava/util/List;)V", "", "([Lorg/jetbrains/jewel/markdown/InlineMarkdown;)V", "getInlineContent", "()Ljava/util/List;", "core"})
    @StabilityInferred(parameters=0)
    public static final class Paragraph
    implements MarkdownBlock,
    WithInlineMarkdown {
        @NotNull
        private final List<InlineMarkdown> inlineContent;
        public static final int $stable = 8;

        public Paragraph(@NotNull List<? extends InlineMarkdown> inlineContent) {
            Intrinsics.checkNotNullParameter(inlineContent, (String)"inlineContent");
            this.inlineContent = inlineContent;
        }

        @Override
        @NotNull
        public List<InlineMarkdown> getInlineContent() {
            return this.inlineContent;
        }

        public Paragraph(InlineMarkdown ... inlineContent) {
            Intrinsics.checkNotNullParameter((Object)inlineContent, (String)"inlineContent");
            this(ArraysKt.toList((Object[])inlineContent));
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Paragraph)) {
                return false;
            }
            Paragraph paragraph = (Paragraph)other;
            return Intrinsics.areEqual(this.inlineContent, paragraph.inlineContent);
        }

        public int hashCode() {
            return ((Object)this.inlineContent).hashCode();
        }

        @NotNull
        public String toString() {
            return "Paragraph(inlineContent=" + this.inlineContent + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/jetbrains/jewel/markdown/MarkdownBlock$ThematicBreak;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
    @StabilityInferred(parameters=1)
    public static final class ThematicBreak
    implements MarkdownBlock {
        @NotNull
        public static final ThematicBreak INSTANCE = new ThematicBreak();
        public static final int $stable;

        private ThematicBreak() {
        }

        @NotNull
        public String toString() {
            return "ThematicBreak";
        }

        public int hashCode() {
            return -980876;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThematicBreak)) {
                return false;
            }
            ThematicBreak cfr_ignored_0 = (ThematicBreak)other;
            return true;
        }
    }
}

