/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.processing;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.commonmark.node.Code;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Emphasis;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jewel.markdown.InlineMarkdown;
import org.jetbrains.jewel.markdown.WithInlineMarkdown;
import org.jetbrains.jewel.markdown.WithTextContent;
import org.jetbrains.jewel.markdown.extensions.MarkdownInlineProcessorExtension;
import org.jetbrains.jewel.markdown.extensions.MarkdownProcessorExtension;
import org.jetbrains.jewel.markdown.processing.MarkdownProcessor;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001H\u0001\u001a$\u0010\b\u001a\u0004\u0018\u00010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001H\u0001\u001a\u0012\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u00a8\u0006\u000b"}, d2={"readInlineContent", "", "Lorg/jetbrains/jewel/markdown/InlineMarkdown;", "Lorg/commonmark/node/Node;", "markdownProcessor", "Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor;", "extensions", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownProcessorExtension;", "toInlineMarkdownOrNull", "renderAsSimpleText", "", "core"})
@SourceDebugExtension(value={"SMAP\nProcessingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessingUtil.kt\norg/jetbrains/jewel/markdown/processing/ProcessingUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class ProcessingUtilKt {
    @VisibleForTesting
    @NotNull
    public static final List<InlineMarkdown> readInlineContent(@NotNull Node $this$readInlineContent, @NotNull MarkdownProcessor markdownProcessor, @NotNull List<? extends MarkdownProcessorExtension> extensions) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$readInlineContent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)markdownProcessor, (String)"markdownProcessor");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        List $this$readInlineContent_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Node current = $this$readInlineContent.getFirstChild(); current != null; current = current.getNext()) {
            InlineMarkdown inline = ProcessingUtilKt.toInlineMarkdownOrNull(current, markdownProcessor, extensions);
            if (inline == null) continue;
            $this$readInlineContent_u24lambda_u240.add(inline);
        }
        return CollectionsKt.build((List)list);
    }

    @VisibleForTesting
    @Nullable
    public static final InlineMarkdown toInlineMarkdownOrNull(@NotNull Node $this$toInlineMarkdownOrNull, @NotNull MarkdownProcessor markdownProcessor, @NotNull List<? extends MarkdownProcessorExtension> extensions) {
        InlineMarkdown inlineMarkdown;
        Intrinsics.checkNotNullParameter((Object)$this$toInlineMarkdownOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)markdownProcessor, (String)"markdownProcessor");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Node node = $this$toInlineMarkdownOrNull;
        if (node instanceof Text) {
            String string = ((Text)$this$toInlineMarkdownOrNull).getLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
            inlineMarkdown = new InlineMarkdown.Text(string);
        } else if (node instanceof Link) {
            String string = ((Link)$this$toInlineMarkdownOrNull).getDestination();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDestination(...)");
            inlineMarkdown = new InlineMarkdown.Link(string, ((Link)$this$toInlineMarkdownOrNull).getTitle(), ProcessingUtilKt.readInlineContent($this$toInlineMarkdownOrNull, markdownProcessor, extensions));
        } else if (node instanceof Emphasis) {
            String string = ((Emphasis)$this$toInlineMarkdownOrNull).getOpeningDelimiter();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOpeningDelimiter(...)");
            inlineMarkdown = new InlineMarkdown.Emphasis(string, ProcessingUtilKt.readInlineContent($this$toInlineMarkdownOrNull, markdownProcessor, extensions));
        } else if (node instanceof StrongEmphasis) {
            String string = ((StrongEmphasis)$this$toInlineMarkdownOrNull).getOpeningDelimiter();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOpeningDelimiter(...)");
            inlineMarkdown = new InlineMarkdown.StrongEmphasis(string, ProcessingUtilKt.readInlineContent($this$toInlineMarkdownOrNull, markdownProcessor, extensions));
        } else if (node instanceof Code) {
            String string = ((Code)$this$toInlineMarkdownOrNull).getLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
            inlineMarkdown = new InlineMarkdown.Code(string);
        } else if (node instanceof HtmlInline) {
            String string = ((HtmlInline)$this$toInlineMarkdownOrNull).getLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
            inlineMarkdown = new InlineMarkdown.HtmlInline(string);
        } else if (node instanceof Image) {
            List<InlineMarkdown> inlineContent = ProcessingUtilKt.readInlineContent($this$toInlineMarkdownOrNull, markdownProcessor, extensions);
            String string = ((Image)$this$toInlineMarkdownOrNull).getDestination();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDestination(...)");
            inlineMarkdown = new InlineMarkdown.Image(string, ((Object)StringsKt.trim((CharSequence)ProcessingUtilKt.renderAsSimpleText(inlineContent))).toString(), ((Image)$this$toInlineMarkdownOrNull).getTitle(), inlineContent);
        } else if (node instanceof HardLineBreak) {
            inlineMarkdown = InlineMarkdown.HardLineBreak.INSTANCE;
        } else if (node instanceof SoftLineBreak) {
            inlineMarkdown = InlineMarkdown.SoftLineBreak.INSTANCE;
        } else if (node instanceof CustomNode) {
            MarkdownInlineProcessorExtension markdownInlineProcessorExtension;
            Object v7;
            block21: {
                Iterable iterable = extensions;
                for (Object t : iterable) {
                    MarkdownProcessorExtension it = (MarkdownProcessorExtension)t;
                    boolean bl = false;
                    MarkdownInlineProcessorExtension markdownInlineProcessorExtension2 = it.getInlineProcessorExtension();
                    boolean bl2 = markdownInlineProcessorExtension2 != null ? markdownInlineProcessorExtension2.canProcess((CustomNode)$this$toInlineMarkdownOrNull) : false;
                    if (!bl2) continue;
                    v7 = t;
                    break block21;
                }
                v7 = null;
            }
            MarkdownProcessorExtension markdownProcessorExtension = v7;
            inlineMarkdown = markdownProcessorExtension != null && (markdownInlineProcessorExtension = markdownProcessorExtension.getInlineProcessorExtension()) != null ? markdownInlineProcessorExtension.processInlineMarkdown((CustomNode)$this$toInlineMarkdownOrNull, markdownProcessor) : null;
        } else {
            throw new IllegalStateException(("Unexpected block " + $this$toInlineMarkdownOrNull).toString());
        }
        return inlineMarkdown;
    }

    @NotNull
    public static final String renderAsSimpleText(@NotNull List<? extends InlineMarkdown> $this$renderAsSimpleText) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$renderAsSimpleText, (String)"<this>");
        StringBuilder $this$renderAsSimpleText_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (InlineMarkdown inlineMarkdown : $this$renderAsSimpleText) {
            StringBuilder stringBuilder2;
            InlineMarkdown inlineMarkdown2 = inlineMarkdown;
            if (inlineMarkdown2 instanceof WithInlineMarkdown) {
                stringBuilder2 = $this$renderAsSimpleText_u24lambda_u242.append(ProcessingUtilKt.renderAsSimpleText(((WithInlineMarkdown)((Object)inlineMarkdown)).getInlineContent()));
                continue;
            }
            if (inlineMarkdown2 instanceof WithTextContent) {
                stringBuilder2 = $this$renderAsSimpleText_u24lambda_u242.append(((WithTextContent)((Object)inlineMarkdown)).getContent());
                continue;
            }
            if (inlineMarkdown2 instanceof InlineMarkdown.CustomNode) {
                String textContent = ((InlineMarkdown.CustomNode)inlineMarkdown).contentOrNull();
                if (textContent != null) {
                    $this$renderAsSimpleText_u24lambda_u242.append(' ');
                    $this$renderAsSimpleText_u24lambda_u242.append(textContent);
                }
                stringBuilder2 = Unit.INSTANCE;
                continue;
            }
            stringBuilder2 = inlineMarkdown2 instanceof InlineMarkdown.HardLineBreak ? $this$renderAsSimpleText_u24lambda_u242.append('\n') : (inlineMarkdown2 instanceof InlineMarkdown.SoftLineBreak ? $this$renderAsSimpleText_u24lambda_u242.append(' ') : Unit.INSTANCE);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

