/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.rendering;

import androidx.compose.foundation.text.InlineTextContentKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.text.LinkInteractionListener;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextLinkStyles;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.foundation.ExperimentalJewelApi;
import org.jetbrains.jewel.markdown.InlineMarkdown;
import org.jetbrains.jewel.markdown.extensions.MarkdownInlineRendererExtension;
import org.jetbrains.jewel.markdown.extensions.MarkdownRendererExtension;
import org.jetbrains.jewel.markdown.rendering.InlineMarkdownRenderer;
import org.jetbrains.jewel.markdown.rendering.InlinesStyling;

@ExperimentalJewelApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J<\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011H\u0016JB\u0010\u0014\u001a\u00020\u0013*\u00020\u00152\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011H\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JK\u0010\u0018\u001a\u00020\u0013\"\b\b\u0000\u0010\u0019*\u00020\u000b*\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u0002H\u00192\u001d\u0010\u001c\u001a\u0019\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\u00130\u001d\u00a2\u0006\u0002\b\u001eH\u0082\b\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/jewel/markdown/rendering/DefaultInlineMarkdownRenderer;", "Lorg/jetbrains/jewel/markdown/rendering/InlineMarkdownRenderer;", "rendererExtensions", "", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownRendererExtension;", "<init>", "(Ljava/util/List;)V", "renderAsAnnotatedString", "Landroidx/compose/ui/text/AnnotatedString;", "inlineMarkdown", "", "Lorg/jetbrains/jewel/markdown/InlineMarkdown;", "styling", "Lorg/jetbrains/jewel/markdown/rendering/InlinesStyling;", "enabled", "", "onUrlClicked", "Lkotlin/Function1;", "", "", "appendInlineMarkdownFrom", "Landroidx/compose/ui/text/AnnotatedString$Builder;", "withEnabled", "Landroidx/compose/ui/text/SpanStyle;", "withStyles", "T", "spanStyle", "node", "action", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Landroidx/compose/ui/text/AnnotatedString$Builder;Landroidx/compose/ui/text/SpanStyle;Lorg/jetbrains/jewel/markdown/InlineMarkdown;Lkotlin/jvm/functions/Function2;)V", "Companion", "core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDefaultInlineMarkdownRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultInlineMarkdownRenderer.kt\norg/jetbrains/jewel/markdown/rendering/DefaultInlineMarkdownRenderer\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n116#1,6:129\n116#1,6:135\n116#1,6:141\n116#1,6:147\n1241#2:128\n1#3:153\n*S KotlinDebug\n*F\n+ 1 DefaultInlineMarkdownRenderer.kt\norg/jetbrains/jewel/markdown/rendering/DefaultInlineMarkdownRenderer\n*L\n37#1:129,6\n43#1:135,6\n67#1:141,6\n75#1:147,6\n22#1:128\n*E\n"})
public class DefaultInlineMarkdownRenderer
implements InlineMarkdownRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<MarkdownRendererExtension> rendererExtensions;
    public static final int $stable = 8;
    @NotNull
    public static final String INLINE_IMAGE = "inline_image";

    public DefaultInlineMarkdownRenderer(@NotNull List<? extends MarkdownRendererExtension> rendererExtensions) {
        Intrinsics.checkNotNullParameter(rendererExtensions, (String)"rendererExtensions");
        this.rendererExtensions = rendererExtensions;
    }

    @Override
    @NotNull
    public AnnotatedString renderAsAnnotatedString(@NotNull Iterable<? extends InlineMarkdown> inlineMarkdown, @NotNull InlinesStyling styling, boolean enabled, @Nullable Function1<? super String, Unit> onUrlClicked) {
        AnnotatedString.Builder builder;
        Intrinsics.checkNotNullParameter(inlineMarkdown, (String)"inlineMarkdown");
        Intrinsics.checkNotNullParameter((Object)styling, (String)"styling");
        boolean $i$f$buildAnnotatedString = false;
        AnnotatedString.Builder $this$renderAsAnnotatedString_u24lambda_u240 = builder = new AnnotatedString.Builder(0, 1, null);
        boolean bl = false;
        this.appendInlineMarkdownFrom($this$renderAsAnnotatedString_u24lambda_u240, inlineMarkdown, styling, enabled, onUrlClicked);
        return builder.toAnnotatedString();
    }

    /*
     * WARNING - void declaration
     */
    private final void appendInlineMarkdownFrom(AnnotatedString.Builder $this$appendInlineMarkdownFrom, Iterable<? extends InlineMarkdown> inlineMarkdown, InlinesStyling styling, boolean enabled, Function1<? super String, Unit> onUrlClicked) {
        for (InlineMarkdown inlineMarkdown2 : inlineMarkdown) {
            String destination;
            boolean bl;
            Object $this$withStyles$iv;
            InlineMarkdown node$iv;
            Object object;
            Object object2;
            InlineMarkdown inlineMarkdown22 = inlineMarkdown2;
            if (inlineMarkdown22 instanceof InlineMarkdown.Text) {
                $this$appendInlineMarkdownFrom.append(((InlineMarkdown.Text)inlineMarkdown2).getContent());
                object2 = Unit.INSTANCE;
                continue;
            }
            if (inlineMarkdown22 instanceof InlineMarkdown.Emphasis) {
                void it;
                void spanStyle$iv;
                DefaultInlineMarkdownRenderer defaultInlineMarkdownRenderer = this;
                object = $this$appendInlineMarkdownFrom;
                SpanStyle spanStyle = this.withEnabled(styling.getEmphasis(), enabled);
                node$iv = inlineMarkdown2;
                boolean $i$f$withStyles = false;
                int popTo$iv = $this$withStyles$iv.pushStyle((SpanStyle)spanStyle$iv);
                InlineMarkdown.Emphasis emphasis = (InlineMarkdown.Emphasis)node$iv;
                AnnotatedString.Builder $this$appendInlineMarkdownFrom_u24lambda_u241 = $this$withStyles$iv;
                bl = false;
                DefaultInlineMarkdownRenderer.appendInlineMarkdownFrom$default(this, $this$appendInlineMarkdownFrom_u24lambda_u241, it.getInlineContent(), styling, enabled, null, 8, null);
                $this$withStyles$iv.pop(popTo$iv);
                object2 = Unit.INSTANCE;
                continue;
            }
            if (inlineMarkdown22 instanceof InlineMarkdown.StrongEmphasis) {
                DefaultInlineMarkdownRenderer this_$iv = this;
                $this$withStyles$iv = $this$appendInlineMarkdownFrom;
                SpanStyle spanStyle$iv = this.withEnabled(styling.getStrongEmphasis(), enabled);
                node$iv = inlineMarkdown2;
                boolean $i$f$withStyles = false;
                int popTo$iv = $this$withStyles$iv.pushStyle(spanStyle$iv);
                InlineMarkdown.StrongEmphasis it = (InlineMarkdown.StrongEmphasis)node$iv;
                AnnotatedString.Builder $this$appendInlineMarkdownFrom_u24lambda_u242 = $this$withStyles$iv;
                bl = false;
                DefaultInlineMarkdownRenderer.appendInlineMarkdownFrom$default(this, $this$appendInlineMarkdownFrom_u24lambda_u242, it.getInlineContent(), styling, enabled, null, 8, null);
                $this$withStyles$iv.pop(popTo$iv);
                object2 = Unit.INSTANCE;
                continue;
            }
            if (inlineMarkdown22 instanceof InlineMarkdown.Link) {
                int n;
                if (enabled) {
                    destination = ((InlineMarkdown.Link)inlineMarkdown2).getDestination();
                    node$iv = arg_0 -> DefaultInlineMarkdownRenderer.appendInlineMarkdownFrom$lambda$3(onUrlClicked, destination, arg_0);
                    TextLinkStyles $i$f$withStyles = styling.getTextLinkStyles();
                    LinkAnnotation.Clickable link = new LinkAnnotation.Clickable(destination, $i$f$withStyles, (LinkInteractionListener)node$iv);
                    n = $this$appendInlineMarkdownFrom.pushLink((LinkAnnotation)link);
                } else {
                    n = $this$appendInlineMarkdownFrom.pushStyle(styling.getLinkDisabled());
                }
                int index = n;
                DefaultInlineMarkdownRenderer.appendInlineMarkdownFrom$default(this, $this$appendInlineMarkdownFrom, ((InlineMarkdown.Link)inlineMarkdown2).getInlineContent(), styling, enabled, null, 8, null);
                $this$appendInlineMarkdownFrom.pop(index);
                object2 = Unit.INSTANCE;
                continue;
            }
            if (inlineMarkdown22 instanceof InlineMarkdown.Code) {
                void spanStyle$iv;
                DefaultInlineMarkdownRenderer index = this;
                destination = $this$appendInlineMarkdownFrom;
                SpanStyle link = this.withEnabled(styling.getInlineCode(), enabled);
                node$iv = inlineMarkdown2;
                boolean $i$f$withStyles = false;
                int popTo$iv = $this$withStyles$iv.pushStyle((SpanStyle)spanStyle$iv);
                InlineMarkdown.Code it = (InlineMarkdown.Code)node$iv;
                AnnotatedString.Builder $this$appendInlineMarkdownFrom_u24lambda_u244 = $this$withStyles$iv;
                bl = false;
                $this$appendInlineMarkdownFrom_u24lambda_u244.append(it.getContent());
                $this$withStyles$iv.pop(popTo$iv);
                object2 = Unit.INSTANCE;
                continue;
            }
            if (inlineMarkdown22 instanceof InlineMarkdown.HardLineBreak) {
                Appendable appendable = ((Appendable)$this$appendInlineMarkdownFrom).append('\n');
                object2 = appendable;
                Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                continue;
            }
            if (inlineMarkdown22 instanceof InlineMarkdown.SoftLineBreak) {
                $this$appendInlineMarkdownFrom.append(" ");
                object2 = Unit.INSTANCE;
                continue;
            }
            if (inlineMarkdown22 instanceof InlineMarkdown.HtmlInline) {
                if (styling.getRenderInlineHtml()) {
                    DefaultInlineMarkdownRenderer this_$iv = this;
                    $this$withStyles$iv = $this$appendInlineMarkdownFrom;
                    SpanStyle spanStyle$iv = this.withEnabled(styling.getInlineHtml(), enabled);
                    node$iv = inlineMarkdown2;
                    boolean $i$f$withStyles = false;
                    int popTo$iv = $this$withStyles$iv.pushStyle(spanStyle$iv);
                    InlineMarkdown.HtmlInline it = (InlineMarkdown.HtmlInline)node$iv;
                    Object $this$appendInlineMarkdownFrom_u24lambda_u245 = $this$withStyles$iv;
                    bl = false;
                    $this$appendInlineMarkdownFrom_u24lambda_u245.append(((Object)StringsKt.trim((CharSequence)it.getContent())).toString());
                    $this$withStyles$iv.pop(popTo$iv);
                }
                object2 = Unit.INSTANCE;
                continue;
            }
            if (inlineMarkdown22 instanceof InlineMarkdown.Image) {
                void $this$appendInlineMarkdownFrom_u24lambda_u246;
                StringBuilder stringBuilder = new StringBuilder();
                $this$withStyles$iv = stringBuilder;
                String string = INLINE_IMAGE;
                AnnotatedString.Builder builder = $this$appendInlineMarkdownFrom;
                boolean bl2 = false;
                StringBuilder stringBuilder2 = $this$appendInlineMarkdownFrom_u24lambda_u246.append(((InlineMarkdown.Image)inlineMarkdown2).getSource());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                $this$appendInlineMarkdownFrom_u24lambda_u246.append(((InlineMarkdown.Image)inlineMarkdown2).getAlt());
                CharSequence charSequence = ((InlineMarkdown.Image)inlineMarkdown2).getTitle();
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    Intrinsics.checkNotNullExpressionValue((Object)$this$appendInlineMarkdownFrom_u24lambda_u246.append('\n'), (String)"append(...)");
                    $this$appendInlineMarkdownFrom_u24lambda_u246.append(((InlineMarkdown.Image)inlineMarkdown2).getTitle());
                }
                Unit unit = Unit.INSTANCE;
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                InlineTextContentKt.appendInlineContent((AnnotatedString.Builder)builder, (String)string, (String)string2);
                object2 = Unit.INSTANCE;
                continue;
            }
            if (inlineMarkdown22 instanceof InlineMarkdown.CustomNode) {
                Object v7;
                block17: {
                    Iterable iterable = this.rendererExtensions;
                    for (Object t : iterable) {
                        MarkdownRendererExtension it = (MarkdownRendererExtension)t;
                        boolean bl3 = false;
                        MarkdownInlineRendererExtension markdownInlineRendererExtension = it.getInlineRenderer();
                        boolean bl4 = markdownInlineRendererExtension != null ? markdownInlineRendererExtension.canRender((InlineMarkdown.CustomNode)inlineMarkdown2) : false;
                        if (!bl4) continue;
                        v7 = t;
                        break block17;
                    }
                    v7 = null;
                }
                MarkdownRendererExtension markdownRendererExtension = v7;
                if (markdownRendererExtension != null && (object = markdownRendererExtension.getInlineRenderer()) != null) {
                    object.render((InlineMarkdown.CustomNode)inlineMarkdown2, this, enabled);
                    object2 = Unit.INSTANCE;
                    continue;
                }
                object2 = null;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    static /* synthetic */ void appendInlineMarkdownFrom$default(DefaultInlineMarkdownRenderer defaultInlineMarkdownRenderer, AnnotatedString.Builder builder, Iterable iterable, InlinesStyling inlinesStyling, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: appendInlineMarkdownFrom");
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        defaultInlineMarkdownRenderer.appendInlineMarkdownFrom(builder, iterable, inlinesStyling, bl, (Function1<? super String, Unit>)function1);
    }

    private final SpanStyle withEnabled(SpanStyle $this$withEnabled, boolean enabled) {
        return enabled ? $this$withEnabled : SpanStyle.copy-GSF8kmg$default((SpanStyle)$this$withEnabled, (long)Color.Companion.getUnspecified-0d7_KjU(), (long)0L, null, null, null, null, null, (long)0L, null, null, null, (long)0L, null, null, null, null, (int)65534, null);
    }

    private final <T extends InlineMarkdown> void withStyles(AnnotatedString.Builder $this$withStyles, SpanStyle spanStyle, T node, Function2<? super AnnotatedString.Builder, ? super T, Unit> action) {
        boolean $i$f$withStyles = false;
        int popTo = $this$withStyles.pushStyle(spanStyle);
        action.invoke((Object)$this$withStyles, node);
        $this$withStyles.pop(popTo);
    }

    private static final void appendInlineMarkdownFrom$lambda$3(Function1 $onUrlClicked, String $destination, LinkAnnotation linkAnnotation) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)linkAnnotation, (String)"<unused var>");
            Function1 function1 = $onUrlClicked;
            if (function1 == null) break block0;
            function1.invoke((Object)$destination);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/jewel/markdown/rendering/DefaultInlineMarkdownRenderer$Companion;", "", "<init>", "()V", "INLINE_IMAGE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

