/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.Bridge;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.environment.Logger;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLogWrapper;
import com.android.tools.idea.layoutlib.LayoutlibBundle;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.utils.ComputerArchUtilsKt;
import com.android.utils.CpuArchitecture;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class LayoutLibraryLoader {
    protected static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.LayoutLibraryLoader");
    private static final Map<IAndroidTarget, SoftReference<LayoutLibrary>> ourLibraryCache = new WeakHashMap<IAndroidTarget, SoftReference<LayoutLibrary>>();

    private LayoutLibraryLoader() {
    }

    private static LayoutLibrary loadImpl(IAndroidTarget target, Map<String, Map<String, Integer>> enumMap) throws RenderingException {
        Path icuDataPath;
        Path fontFolderPath = target.getPath(12);
        if (!Files.exists(fontFolderPath, new LinkOption[0]) || !Files.isDirectory(fontFolderPath, new LinkOption[0])) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", fontFolderPath), new Throwable[0]);
        }
        String platformFolderPath = target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
        File platformFolder = new File(platformFolderPath);
        if (!platformFolder.isDirectory()) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", platformFolderPath), new Throwable[0]);
        }
        File buildPropFile = new File(platformFolder, "build.prop");
        Properties buildProp = new Properties();
        try (FileInputStream buildPropStream = new FileInputStream(buildPropFile);){
            buildProp.load(buildPropStream);
        }
        catch (IOException e) {
            throw new RenderingException(LayoutlibBundle.message("android.file.not.exist.error", buildPropFile.getPath()), new Throwable[0]);
        }
        HashMap<String, String> buildPropMap = new HashMap<String, String>(buildProp.size());
        for (String key : buildProp.stringPropertyNames()) {
            buildPropMap.put(key, buildProp.getProperty(key));
        }
        LayoutLogWrapper layoutLog = new LayoutLogWrapper(LOG);
        Path dataPath = target.getPath(7);
        Path keyboardPath = dataPath.resolve("keyboards/Generic.kcm");
        Path hyphenPath = dataPath.resolve("hyphen-data/");
        try (Stream<Path> icuFiles = Files.list(dataPath.resolve("icu"));){
            icuDataPath = icuFiles.filter(path -> path.toString().endsWith(".dat")).findFirst().orElseThrow();
        }
        catch (Exception e) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", dataPath), new Throwable[0]);
        }
        LayoutLibrary library = LayoutLibraryLoader.getLayoutLibraryProvider().map(LayoutLibraryProvider::getLibrary).orElse(null);
        if (library == null || !library.init(buildPropMap, fontFolderPath.toFile(), LayoutLibraryLoader.getNativeLibraryPath(dataPath), LayoutLibraryLoader.pathToString(icuDataPath), LayoutLibraryLoader.pathToString(hyphenPath), new String[]{LayoutLibraryLoader.pathToString(keyboardPath)}, enumMap, layoutLog)) {
            throw new RenderingException(LayoutlibBundle.message("layoutlib.init.failed", new Object[0]), new Throwable[0]);
        }
        return library;
    }

    private static String pathToString(Path path) {
        return path.toString().replace('\\', '/');
    }

    private static String getNativeLibraryPath(Path dataPath) {
        return LayoutLibraryLoader.pathToString(dataPath) + "/" + LayoutLibraryLoader.getPlatformName() + "/lib64/";
    }

    private static String getPlatformName() {
        return switch (SdkConstants.currentPlatform()) {
            case 2 -> "win";
            case 3 -> {
                if (ComputerArchUtilsKt.getJvmArchitecture() == CpuArchitecture.ARM) {
                    yield "mac-arm";
                }
                yield "mac";
            }
            case 1 -> "linux";
            default -> "";
        };
    }

    public static synchronized LayoutLibrary load(IAndroidTarget target, Map<String, Map<String, Integer>> enumMap, Supplier<Boolean> hasExternalCrash) throws RenderingException {
        LayoutLibrary library;
        if (Bridge.hasNativeCrash()) {
            throw new RenderingException("Rendering disabled following a crash", new Throwable[0]);
        }
        SoftReference<LayoutLibrary> libraryRef = ourLibraryCache.get(target);
        LayoutLibrary layoutLibrary = library = libraryRef != null ? libraryRef.get() : null;
        if (library == null || library.isDisposed()) {
            if (hasExternalCrash.get().booleanValue()) {
                Bridge.setNativeCrash((boolean)true);
                throw new RenderingException("Rendering disabled following a crash", new Throwable[0]);
            }
            library = LayoutLibraryLoader.loadImpl(target, enumMap);
            ourLibraryCache.put(target, new SoftReference<LayoutLibrary>(library));
        }
        return library;
    }

    public static Optional<LayoutLibraryProvider> getLayoutLibraryProvider() {
        return ServiceLoader.load(LayoutLibraryProvider.class, LayoutLibraryProvider.class.getClassLoader()).findFirst();
    }

    public static interface LayoutLibraryProvider {
        public LayoutLibrary getLibrary();

        public Class<?> getFrameworkRClass();
    }
}

