/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AnnotateQuickFixKt;
import com.android.tools.idea.lint.common.LintIdeFixPerformer;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Location;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.SyntheticElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/lint/common/AnnotateQuickFix;", "Lcom/intellij/modcommand/ModCommandAction;", "project", "Lcom/intellij/openapi/project/Project;", "displayName", "", "familyName", "annotationSource", "replace", "", "range", "Lcom/android/tools/lint/detector/api/Location;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/android/tools/lint/detector/api/Location;)V", "rangePointer", "Lcom/intellij/psi/SmartPsiFileRange;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "findPsiTarget", "Lcom/intellij/psi/PsiElement;", "applyFixFun", "", "element", "intellij.lint"})
public final class AnnotateQuickFix
implements ModCommandAction {
    @Nullable
    private final String displayName;
    @Nullable
    private final String familyName;
    @NotNull
    private final String annotationSource;
    private final boolean replace;
    @Nullable
    private final SmartPsiFileRange rangePointer;

    public AnnotateQuickFix(@NotNull Project project, @Nullable String displayName, @Nullable String familyName, @NotNull String annotationSource, boolean replace, @Nullable Location range) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)annotationSource, (String)"annotationSource");
        this.displayName = displayName;
        this.familyName = familyName;
        this.annotationSource = annotationSource;
        this.replace = replace;
        this.rangePointer = LintIdeFixPerformer.Companion.getRangePointer(project, range);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.familyName;
        if (string == null) {
            string = "Annotate";
        }
        return string;
    }

    @Nullable
    public Presentation getPresentation(@NotNull ActionContext context) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.findPsiTarget(context) != null) {
            String string = this.displayName;
            if (string == null) {
                string = this.getFamilyName();
            }
            presentation = Presentation.of((String)string);
        } else {
            presentation = null;
        }
        return presentation;
    }

    @NotNull
    public ModCommand perform(@NotNull ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement psiElement = this.findPsiTarget(context);
        if (psiElement == null) {
            ModCommand modCommand = ModCommand.nop();
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
            return modCommand;
        }
        PsiElement element = psiElement;
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)element, (arg_0, arg_1) -> AnnotateQuickFix.perform$lambda$0(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
        return modCommand;
    }

    @Nullable
    public final PsiElement findPsiTarget(@NotNull ActionContext context) {
        Language language;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SmartPsiFileRange smartPsiFileRange = this.rangePointer;
        PsiFile rangeFile = smartPsiFileRange != null && (smartPsiFileRange = (PsiFile)smartPsiFileRange.getElement()) != null ? smartPsiFileRange.getContainingFile() : null;
        PsiElement psiElement = context.findLeaf();
        Intrinsics.checkNotNull((Object)psiElement);
        PsiElement element = psiElement;
        if (rangeFile != null && (Intrinsics.areEqual((Object)rangeFile.getContainingFile(), (Object)context.file()) || !Intrinsics.areEqual((Object)context.file().getOriginalFile(), (Object)rangeFile.getContainingFile()))) {
            Segment range;
            SmartPsiFileRange smartPsiFileRange2 = this.rangePointer;
            Segment segment = range = smartPsiFileRange2 != null ? smartPsiFileRange2.getRange() : null;
            Intrinsics.checkNotNull((Object)segment);
            PsiElement newStartElement = rangeFile.findElementAt(segment.getStartOffset());
            if (newStartElement != null) {
                element = newStartElement;
            }
        }
        return Intrinsics.areEqual((Object)(language = element.getLanguage()), (Object)JavaLanguage.INSTANCE) ? (PsiElement)AnnotateQuickFixKt.findJavaAnnotationTarget(element) : (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) ? AnnotateQuickFixKt.access$findKotlinAnnotationTarget(element) : null);
    }

    public final void applyFixFun(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Language language = element.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            PsiModifierListOwner owner = (PsiModifierListOwner)element;
            Project project = ((PsiModifierListOwner)element).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getElementFactory(...)");
            PsiElementFactory factory = psiElementFactory;
            PsiAnnotation psiAnnotation = factory.createAnnotationFromText(this.annotationSource, element);
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"createAnnotationFromText(...)");
            PsiAnnotation newAnnotation = psiAnnotation;
            String string = newAnnotation.getQualifiedName();
            if (string == null) {
                return;
            }
            String annotationName = string;
            String[] stringArray = new String[]{annotationName};
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])stringArray);
            if (annotation != null && !(annotation instanceof SyntheticElement) && this.replace) {
                annotation.replace((PsiElement)newAnnotation);
            } else {
                PsiNameValuePair[] psiNameValuePairArray = newAnnotation.getParameterList().getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)psiNameValuePairArray, (String)"getAttributes(...)");
                PsiNameValuePair[] attributes = psiNameValuePairArray;
                new AddAnnotationFix(annotationName, (PsiModifierListOwner)element, attributes, new String[0]).invoke(project2, null, ((PsiModifierListOwner)element).getContainingFile());
            }
        } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            KtAnnotationEntry ktAnnotationEntry;
            if (!(element instanceof KtModifierListOwner)) {
                return;
            }
            Project project = ((KtModifierListOwner)element).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, true);
            KtAnnotationEntry annotationEntry = psiFactory.createAnnotationEntry(this.annotationSource);
            String fqName = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)StringsKt.removePrefix((String)this.annotationSource, (CharSequence)"@"), (char)':', null, (int)2, null), (char)'(', null, (int)2, null);
            ClassId classId = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)ClassContext.Companion.getInternalName(fqName), (boolean)false, (int)2, null);
            KtAnnotationEntry existing = AnnotationModificationUtilsKt.findAnnotation$default((KtAnnotated)((KtAnnotated)element), (ClassId)classId, null, (boolean)false, (int)6, null);
            if (existing != null && !(existing instanceof SyntheticElement) && this.replace) {
                PsiElement psiElement = existing.replace((PsiElement)annotationEntry);
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
                ktAnnotationEntry = (KtAnnotationEntry)psiElement;
            } else {
                KtAnnotationEntry ktAnnotationEntry2 = ((KtModifierListOwner)element).addAnnotationEntry(annotationEntry);
                Intrinsics.checkNotNull((Object)ktAnnotationEntry2);
                ktAnnotationEntry = ktAnnotationEntry2;
            }
            KtAnnotationEntry addedAnnotation = ktAnnotationEntry;
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)addedAnnotation);
        }
    }

    private static final void perform$lambda$0(AnnotateQuickFix this$0, PsiElement e, ModPsiUpdater modPsiUpdater) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)modPsiUpdater, (String)"<unused var>");
        this$0.applyFixFun(e);
    }
}

