/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeIssueRegistry;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFixProvider;
import com.android.tools.idea.lint.common.LintIdeRequest;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintInspectionDescriptionLinkHandler;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.lint.common.ModCommandLintQuickFix;
import com.android.tools.idea.lint.common.SuppressLintIntentionAction;
import com.android.tools.lint.checks.DeprecatedSinceApiDetector;
import com.android.tools.lint.checks.DeprecationDetector;
import com.android.tools.lint.checks.DiscouragedDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.WrongIdDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Sets;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.DaemonTooltipsUtil;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.CustomEditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlStringUtil;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.gradle.config.GradleFileType;
import org.toml.lang.psi.TomlFileType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/lint/common/LintExternalAnnotator;", "Lcom/intellij/lang/annotation/ExternalAnnotator;", "Lcom/android/tools/idea/lint/common/LintEditorResult;", "<init>", "()V", "collectInformation", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasErrors", "", "isRelevant", "module", "Lcom/intellij/openapi/module/Module;", "doAnnotate", "lintResult", "apply", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "Companion", "MyDisableInspectionFix", "MyFixingIntention", "MyEditInspectionToolsSettingsAction", "intellij.lint"})
@SourceDebugExtension(value={"SMAP\nLintExternalAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintExternalAnnotator.kt\ncom/android/tools/idea/lint/common/LintExternalAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,524:1\n1#2:525\n*E\n"})
public final class LintExternalAnnotator
extends ExternalAnnotator<LintEditorResult, LintEditorResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean INCLUDE_IDEA_SUPPRESS_ACTIONS = false;
    @NotNull
    private static final Logger LOG;

    @Nullable
    public LintEditorResult collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.collectInformation(file);
    }

    @Nullable
    public LintEditorResult collectInformation(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (module == null) {
            return null;
        }
        Module module2 = module;
        return this.collectInformation(file, module2);
    }

    private final boolean isRelevant(PsiFile file, Module module) {
        return LintIdeSupport.Companion.get().canAnnotate(file, module);
    }

    private final LintEditorResult collectInformation(PsiFile file, Module module) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        if (!this.isRelevant(file, module)) {
            return null;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Set<Issue> issues = Companion.getIssuesFromInspections(project, (PsiElement)file);
        String string = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new LintEditorResult(module, vFile, string, issues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public LintEditorResult doAnnotate(@Nullable LintEditorResult lintResult) {
        if (lintResult == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        LintIdeClient client = LintIdeSupport.Companion.get().createEditorClient(lintResult);
        try {
            EnumSet scope = null;
            VirtualFile mainFile = lintResult.getMainFile();
            FileType fileType = mainFile.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
            FileType fileType2 = fileType;
            String string = mainFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name = string;
            if (fileType2 == XmlFileType.INSTANCE) {
                if (Intrinsics.areEqual((Object)name, (Object)"AndroidManifest.xml")) {
                    scope = Scope.MANIFEST_SCOPE;
                } else {
                    if (!StringsKt.endsWith$default((String)name, (String)".xml", (boolean)false, (int)2, null)) {
                        LintEditorResult lintEditorResult = lintResult;
                        return lintEditorResult;
                    }
                    scope = Scope.RESOURCE_FILE_SCOPE;
                }
            } else if (fileType2 == JavaFileType.INSTANCE || fileType2 == KotlinFileType.INSTANCE) {
                scope = Scope.JAVA_FILE_SCOPE;
                if (StringsKt.endsWith$default((String)name, (String)".kts", (boolean)false, (int)2, null)) {
                    scope = EnumSet.of((Enum)Scope.GRADLE_FILE, (Enum)Scope.JAVA_FILE);
                }
            } else if (StringsKt.endsWith$default((String)name, (String)"gradle.dcl", (boolean)false, (int)2, null)) {
                scope = EnumSet.of((Enum)Scope.GRADLE_FILE, (Enum)Scope.JAVA_FILE);
            } else if (Intrinsics.areEqual((Object)name, (Object)"proguard.cfg") || Intrinsics.areEqual((Object)name, (Object)"proguard-project.txt") || Intrinsics.areEqual((Object)name, (Object)"proguard-android.txt")) {
                scope = EnumSet.of((Enum)Scope.PROGUARD_FILE);
            } else if (GradleFileType.isGradleFile((VirtualFile)mainFile)) {
                scope = Scope.GRADLE_SCOPE;
            } else if (fileType2 == PropertiesFileType.INSTANCE) {
                scope = Scope.PROPERTY_SCOPE;
            } else if (fileType2 == TomlFileType.INSTANCE) {
                scope = Scope.TOML_SCOPE;
            } else {
                if (_Assertions.ENABLED) {
                    boolean $i$a$-assert-LintExternalAnnotator$doAnnotate$22 = false;
                    FileType $i$a$-assert-LintExternalAnnotator$doAnnotate$22 = fileType2;
                    throw new AssertionError($i$a$-assert-LintExternalAnnotator$doAnnotate$22);
                }
                LintEditorResult lintEditorResult = lintResult;
                return lintEditorResult;
            }
            Project project = lintResult.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            if (project2.isDisposed()) {
                LintEditorResult $i$a$-assert-LintExternalAnnotator$doAnnotate$22 = lintResult;
                return $i$a$-assert-LintExternalAnnotator$doAnnotate$22;
            }
            if (DumbService.Companion.isDumb(project2)) {
                LintEditorResult $i$a$-assert-LintExternalAnnotator$doAnnotate$22 = lintResult;
                return $i$a$-assert-LintExternalAnnotator$doAnnotate$22;
            }
            List files = CollectionsKt.listOf((Object)mainFile);
            LintRequest request = new LintIdeRequest(client, project2, files, CollectionsKt.listOf((Object)lintResult.getModule()), true);
            request.setScope(scope);
            LintDriver lint = client.createDriver(request);
            lint.analyze();
            lint.setAnalysisStartTime(startTime);
            LintIdeSupport lintIdeSupport = LintIdeSupport.Companion.get();
            Intrinsics.checkNotNull((Object)lint);
            lintIdeSupport.logSession(lint, lintResult);
            return lintResult;
        }
        finally {
            Disposer.dispose((Disposable)client);
        }
    }

    public void apply(@NotNull PsiFile file, @Nullable LintEditorResult lintResult, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (lintResult == null || lintResult.isDirty()) {
            return;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (DumbService.Companion.isDumb(project2)) {
            return;
        }
        LintIdeQuickFixProvider[] fixProviders = (LintIdeQuickFixProvider[])LintIdeQuickFixProvider.EP_NAME.getExtensions();
        LintIdeSupport ideSupport = LintIdeSupport.Companion.get();
        for (LintProblemData problemData : lintResult.getProblems()) {
            String id;
            HighlightDisplayKey key;
            String tooltip;
            String rawMessage;
            ProblemHighlightType problemHighlightType;
            HighlightDisplayLevel configuredLevel;
            Pair<AndroidLintInspectionBase, HighlightDisplayLevel> pair;
            Issue issue;
            TextRange range;
            Intrinsics.checkNotNullExpressionValue((Object)problemData.getIncident(), (String)"getIncident(...)");
            Intrinsics.checkNotNullExpressionValue((Object)problemData.getIssue(), (String)"getIssue(...)");
            Intrinsics.checkNotNullExpressionValue((Object)problemData.getMessage(), (String)"getMessage(...)");
            Intrinsics.checkNotNullExpressionValue((Object)problemData.getTextRange(), (String)"getTextRange(...)");
            LintFix quickfixData = problemData.getQuickfixData();
            if (range.getStartOffset() == range.getEndOffset() || Companion.getHighlightLevelAndInspection(project2, issue, (PsiElement)file) == null) continue;
            AndroidLintInspectionBase inspection = (AndroidLintInspectionBase)((Object)pair.component1());
            HighlightDisplayLevel displayLevel = (HighlightDisplayLevel)pair.component2();
            if (HighlightDisplayKey.find((String)inspection.getShortName()) == null) continue;
            PsiElement startElement = file.findElementAt(range.getStartOffset());
            PsiElement endElement = file.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || inspection.isSuppressedFor(startElement)) continue;
            Severity configuredSeverity = problemData.getConfiguredSeverity();
            if (configuredSeverity != null && (configuredLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(configuredSeverity)) != null) {
                displayLevel = configuredLevel;
            }
            HighlightSeverity severity = displayLevel.getSeverity();
            if (issue == DeprecationDetector.ISSUE || issue == GradleDetector.DEPRECATED || issue == GradleDetector.DEPRECATED_CONFIGURATION || issue == DeprecatedSinceApiDetector.ISSUE || issue == DiscouragedDetector.ISSUE) {
                problemHighlightType = ProblemHighlightType.LIKE_DEPRECATED;
            } else if (issue == WrongIdDetector.UNKNOWN_ID || issue == WrongIdDetector.UNKNOWN_ID_LAYOUT) {
                problemHighlightType = ProblemHighlightType.ERROR;
            } else if (severity == HighlightSeverity.ERROR) {
                problemHighlightType = ProblemHighlightType.GENERIC_ERROR;
            } else {
                ProblemHighlightType problemHighlightType2 = HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)severity);
                Intrinsics.checkNotNull((Object)problemHighlightType2);
                problemHighlightType = problemHighlightType2;
            }
            ProblemHighlightType type = problemHighlightType;
            String message = rawMessage.length() <= 1000 ? rawMessage : StringsKt.take((String)rawMessage, (int)1000) + "... [truncated]";
            String descriptionRef = "<a href=\"#lint/" + issue.getId() + "\"></a>";
            String moreLink = " <a href=\"#lint/\">Toggle info " + DaemonTooltipsUtil.getShortcutText() + "</a>";
            String messageHtml = TextFormat.RAW.convertTo(message, TextFormat.HTML);
            messageHtml = LintInspectionDescriptionLinkHandler.Companion.replaceLinksInHtml(messageHtml, issue.getId());
            Intrinsics.checkNotNullExpressionValue((Object)XmlStringUtil.wrapInHtml((CharSequence)(descriptionRef + messageHtml + moreLink)), (String)"wrapInHtml(...)");
            AnnotationBuilder annotationBuilder = holder.newAnnotation(severity, message).highlightType(type).range(range).tooltip(tooltip);
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"tooltip(...)");
            AnnotationBuilder builder = annotationBuilder;
            try {
                Incident incident;
                Object[] fixes = inspection.getAllFixes(startElement, endElement, incident, message, quickfixData, fixProviders, issue);
                Iterator iterator = ArrayIteratorKt.iterator((Object[])fixes);
                while (iterator.hasNext()) {
                    LintIdeQuickFix fix;
                    Object e = iterator.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    LintIdeQuickFix lintIdeQuickFix = fix = (LintIdeQuickFix)e;
                    if (lintIdeQuickFix instanceof DefaultLintQuickFix) {
                        if (!((DefaultLintQuickFix)fix).isApplicable(startElement, endElement, AndroidQuickfixContexts.EditorContext.TYPE)) continue;
                        SmartPsiFileRange smartPsiFileRange = ((DefaultLintQuickFix)fix).getRange();
                        if (smartPsiFileRange == null) {
                            SmartPsiFileRange smartPsiFileRange2 = SmartPointerManager.getInstance((Project)project2).createSmartPsiFileRangePointer(file, range);
                            smartPsiFileRange = smartPsiFileRange2;
                            Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange2, (String)"createSmartPsiFileRangePointer(...)");
                        }
                        SmartPsiFileRange smartRange = smartPsiFileRange;
                        builder = builder.withFix((IntentionAction)new MyFixingIntention((DefaultLintQuickFix)fix, smartRange, issue));
                        continue;
                    }
                    if (!(lintIdeQuickFix instanceof ModCommandLintQuickFix)) continue;
                    builder = builder.newFix(((ModCommandLintQuickFix)fix).asIntention(issue, project2)).key(key).registerFix();
                }
            }
            catch (Exception ex) {
                LOG.error("Exception thrown while creating quick-fixes for issue id " + issue.getId(), (Throwable)ex);
            }
            Iterator ex = ArrayIteratorKt.iterator((Object[])inspection.getIntentions(startElement, endElement));
            while (ex.hasNext()) {
                Object e = ex.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                IntentionAction intention = (IntentionAction)e;
                builder = builder.withFix(intention);
            }
            if (ideSupport.canRequestFeedback()) {
                builder = builder.withFix(ideSupport.requestFeedbackIntentionAction(issue));
            }
            Intrinsics.checkNotNullExpressionValue((Object)key.getID(), (String)"getID(...)");
            builder = builder.withFix((CommonIntentionAction)new SuppressLintIntentionAction(id, startElement, issue));
            builder.create();
        }
    }

    static {
        Logger logger = Logger.getInstance(LintExternalAnnotator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        LintClient.Companion.setClientName("studio");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ,\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/lint/common/LintExternalAnnotator$Companion;", "", "<init>", "()V", "INCLUDE_IDEA_SUPPRESS_ACTIONS", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getIssuesFromInspections", "", "Lcom/android/tools/lint/detector/api/Issue;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/psi/PsiElement;", "getHighlightLevelAndInspection", "Lkotlin/Pair;", "Lcom/android/tools/idea/lint/common/AndroidLintInspectionBase;", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "issue", "intellij.lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Issue> getIssuesFromInspections(@NotNull Project project, @Nullable PsiElement context) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            IssueRegistry fullRegistry = LintIdeIssueRegistry.get();
            List issueList = fullRegistry.getIssues();
            HashSet result = Sets.newHashSetWithExpectedSize((int)(issueList.size() + 10));
            for (Issue issue : issueList) {
                HighlightDisplayKey key;
                String inspectionShortName;
                if (AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue) == null || HighlightDisplayKey.find((String)inspectionShortName) == null) continue;
                InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
                InspectionProfile profile = (InspectionProfile)inspectionProfileImpl;
                boolean enabled = context != null ? profile.isToolEnabled(key, context) : profile.isToolEnabled(key);
                if (!enabled) continue;
                if (!issue.isEnabledByDefault()) {
                    issue.setEnabledByDefault(true);
                }
                result.add(issue);
            }
            Intrinsics.checkNotNull((Object)result);
            return result;
        }

        @Nullable
        public final Pair<AndroidLintInspectionBase, HighlightDisplayLevel> getHighlightLevelAndInspection(@NotNull Project project, @NotNull Issue issue, @NotNull PsiElement context) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String string = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue);
            if (string == null) {
                return null;
            }
            String inspectionShortName = string;
            HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.find((String)inspectionShortName);
            if (highlightDisplayKey == null) {
                return null;
            }
            HighlightDisplayKey key = highlightDisplayKey;
            InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getCurrentProfile();
            Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
            InspectionProfile profile = (InspectionProfile)inspectionProfileImpl;
            if (!profile.isToolEnabled(key, context) && issue.isEnabledByDefault()) {
                return null;
            }
            AndroidLintInspectionBase androidLintInspectionBase = (AndroidLintInspectionBase)profile.getUnwrappedTool(inspectionShortName, context);
            if (androidLintInspectionBase == null) {
                return null;
            }
            AndroidLintInspectionBase inspection = androidLintInspectionBase;
            HighlightDisplayLevel highlightDisplayLevel = profile.getErrorLevel(key, context);
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"getErrorLevel(...)");
            HighlightDisplayLevel errorLevel = highlightDisplayLevel;
            return new Pair((Object)inspection, (Object)errorLevel);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J!\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\b\u0010\u0016\u001a\u00020\rH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/lint/common/LintExternalAnnotator$MyDisableInspectionFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "key", "Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;", "<init>", "(Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;)V", "myDisableInspectionToolAction", "Lcom/intellij/codeInspection/ex/DisableInspectionToolAction;", "getText", "", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "startInWriteAction", "getElementToMakeWritable", "Lcom/intellij/psi/PsiElement;", "getIcon", "Ljavax/swing/Icon;", "flags", "", "intellij.lint"})
    private static final class MyDisableInspectionFix
    implements IntentionAction,
    Iconable {
        @NotNull
        private final DisableInspectionToolAction myDisableInspectionToolAction;

        public MyDisableInspectionFix(@NotNull HighlightDisplayKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.myDisableInspectionToolAction = new DisableInspectionToolAction(key);
        }

        @NotNull
        public String getText() {
            return "Disable inspection";
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return true;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.myDisableInspectionToolAction.invoke(project, editor, file);
        }

        public boolean startInWriteAction() {
            return this.myDisableInspectionToolAction.startInWriteAction();
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.myDisableInspectionToolAction.getElementToMakeWritable(file);
        }

        @NotNull
        public Icon getIcon(@Iconable.IconFlags int flags) {
            Icon icon = this.myDisableInspectionToolAction.getIcon(flags);
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
            return icon;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/lint/common/LintExternalAnnotator$MyEditInspectionToolsSettingsAction;", "Lcom/intellij/codeInspection/ex/CustomEditInspectionToolsSettingsAction;", "key", "Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;", "inspection", "Lcom/android/tools/idea/lint/common/AndroidLintInspectionBase;", "<init>", "(Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;Lcom/android/tools/idea/lint/common/AndroidLintInspectionBase;)V", "intellij.lint"})
    private static final class MyEditInspectionToolsSettingsAction
    extends CustomEditInspectionToolsSettingsAction {
        public MyEditInspectionToolsSettingsAction(@NotNull HighlightDisplayKey key, @NotNull AndroidLintInspectionBase inspection) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)inspection), (String)"inspection");
            super(key, () -> MyEditInspectionToolsSettingsAction._init_$lambda$0(inspection));
        }

        private static final String _init_$lambda$0(AndroidLintInspectionBase $inspection) {
            return "Edit '" + $inspection.getDisplayName() + "' inspection settings";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nB)\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\t\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/lint/common/LintExternalAnnotator$MyFixingIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "myQuickFix", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "myRange", "Lcom/intellij/psi/SmartPsiFileRange;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "<init>", "(Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;Lcom/intellij/psi/SmartPsiFileRange;Lcom/android/tools/lint/detector/api/Issue;)V", "quickFix", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;)V", "getText", "", "getFamilyName", "isAvailable", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "invoke", "", "startInWriteAction", "toString", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "intellij.lint"})
    public static final class MyFixingIntention
    implements IntentionAction,
    HighPriorityAction {
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final DefaultLintQuickFix myQuickFix;
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final SmartPsiFileRange myRange;
        @FileModifier.SafeFieldForPreview
        @Nullable
        private final Issue issue;

        public MyFixingIntention(@NotNull DefaultLintQuickFix myQuickFix, @NotNull SmartPsiFileRange myRange, @Nullable Issue issue) {
            Intrinsics.checkNotNullParameter((Object)myQuickFix, (String)"myQuickFix");
            Intrinsics.checkNotNullParameter((Object)myRange, (String)"myRange");
            this.myQuickFix = myQuickFix;
            this.myRange = myRange;
            this.issue = issue;
        }

        public /* synthetic */ MyFixingIntention(DefaultLintQuickFix defaultLintQuickFix, SmartPsiFileRange smartPsiFileRange, Issue issue, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                issue = null;
            }
            this(defaultLintQuickFix, smartPsiFileRange, issue);
        }

        public MyFixingIntention(@NotNull DefaultLintQuickFix quickFix, @NotNull Project project, @NotNull PsiFile file, @NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)quickFix, (String)"quickFix");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer(file, range);
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
            this(quickFix, smartPsiFileRange, null, 4, null);
        }

        @NotNull
        public String getText() {
            String string = this.myQuickFix.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myQuickFix.getFamilyName();
            if (string == null) {
                string = LintBundle.Companion.message("android.lint.quickfixes.family", new Object[0]);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return true;
        }

        public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (file == null) {
                return;
            }
            if (editor == null) {
                return;
            }
            AndroidQuickfixContexts.Context context = null;
            PsiFile targetFile = null;
            if (file.isPhysical()) {
                PsiFile psiFile = this.myRange.getContainingFile();
                if (psiFile == null) {
                    return;
                }
                targetFile = psiFile;
                context = AndroidQuickfixContexts.EditorContext.getInstance(editor, file);
            } else {
                PsiFile psiFile = this.myRange.getContainingFile();
                if (!Intrinsics.areEqual((Object)file.getName(), (Object)(psiFile != null ? psiFile.getName() : null))) {
                    return;
                }
                targetFile = file;
                context = new AndroidQuickfixContexts.EditorPreviewContext(editor, targetFile);
            }
            Segment segment = this.myRange.getRange();
            if (segment == null) {
                return;
            }
            Segment textRange = segment;
            PsiElement psiElement = targetFile.findElementAt(textRange.getStartOffset());
            if (psiElement == null) {
                return;
            }
            PsiElement start = psiElement;
            PsiElement psiElement2 = targetFile.findElementAt(textRange.getEndOffset() - 1);
            if (psiElement2 == null) {
                return;
            }
            PsiElement end = psiElement2;
            if (this.issue != null && !IntentionPreviewUtils.isPreviewElement((PsiElement)((PsiElement)file))) {
                LintIdeSupport.Companion.get().logQuickFixInvocation(project, this.issue, this.getText());
            }
            this.myQuickFix.apply(start, end, context);
        }

        public boolean startInWriteAction() {
            return this.myQuickFix.startInWriteAction();
        }

        @NotNull
        public String toString() {
            return this.getText();
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = this.myQuickFix.getPriority();
            Intrinsics.checkNotNullExpressionValue((Object)priority, (String)"getPriority(...)");
            return priority;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            IntentionPreviewInfo intentionPreviewInfo = this.myQuickFix.generatePreview(project, editor, file);
            if (intentionPreviewInfo == null) {
                IntentionPreviewInfo intentionPreviewInfo2 = super.generatePreview(project, editor, file);
                intentionPreviewInfo = intentionPreviewInfo2;
                Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo2, (String)"generatePreview(...)");
            }
            return intentionPreviewInfo;
        }
    }
}

