/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeUtilsKt;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;

public class LintIdeGradleVisitor
extends GradleVisitor {
    private static List<String> getClosureNames(GrClosableBlock closure) {
        GrReferenceExpression invokedExpression;
        GrMethodCall parent;
        ArrayList<String> result = new ArrayList<String>(2);
        if (closure.getParent() instanceof GrMethodCall && (parent = (GrMethodCall)closure.getParent()).getInvokedExpression() instanceof GrReferenceExpression && (invokedExpression = (GrReferenceExpression)parent.getInvokedExpression()).getReferenceName() != null) {
            result.add(invokedExpression.getReferenceName());
            if (invokedExpression.isQualified()) {
                GrReferenceExpression qualifierReferenceExpression;
                GrExpression qualifierExpression = invokedExpression.getQualifierExpression();
                if (qualifierExpression instanceof GrReferenceExpression && (qualifierReferenceExpression = (GrReferenceExpression)qualifierExpression).getReferenceName() != null) {
                    result.add(qualifierReferenceExpression.getReferenceName());
                }
            } else {
                GrReferenceExpression parent2InvokedExpression;
                GrMethodCall parent2;
                GrClosableBlock parentClosableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)closure, GrClosableBlock.class, (boolean)true);
                if (parentClosableBlock != null && parentClosableBlock.getParent() instanceof GrMethodCall && (parent2 = (GrMethodCall)parentClosableBlock.getParent()).getInvokedExpression() instanceof GrReferenceExpression && (parent2InvokedExpression = (GrReferenceExpression)parent2.getInvokedExpression()).getReferenceName() != null) {
                    result.add(parent2InvokedExpression.getReferenceName());
                }
            }
        }
        return result;
    }

    @NotNull
    private static List<String> getReferenceExpressionNames(GrReferenceExpression referenceExpression) {
        ArrayList<String> result = new ArrayList<String>(3);
        LintIdeGradleVisitor.getReferenceExpressionNames(referenceExpression, result);
        return result;
    }

    @Nullable
    private static List<String> getReferenceExpressionNamesOrNull(GrReferenceExpression referenceExpression) {
        ArrayList<String> result = new ArrayList<String>(3);
        if (LintIdeGradleVisitor.getReferenceExpressionNames(referenceExpression, result)) {
            return result;
        }
        return null;
    }

    private static boolean getReferenceExpressionNames(GrReferenceExpression referenceExpression, List<String> result) {
        String name = referenceExpression.getReferenceName();
        while (name != null) {
            String pluginName;
            GrCallExpression call;
            GrExpression[] arguments;
            PsiElement maybeCall;
            PsiElement deepestFirst;
            result.add(name);
            if (!referenceExpression.isQualified()) {
                return true;
            }
            GrExpression qualifierExpression = referenceExpression.getQualifierExpression();
            if (qualifierExpression instanceof GrReferenceExpression) {
                referenceExpression = (GrReferenceExpression)qualifierExpression;
                name = referenceExpression.getReferenceName();
                continue;
            }
            if (!(qualifierExpression instanceof GrCallExpression) || !(deepestFirst = PsiTreeUtil.getDeepestFirst((PsiElement)qualifierExpression)).textMatches((CharSequence)"id") || !((maybeCall = deepestFirst.getParent().getParent()) instanceof GrCallExpression) || (arguments = (call = (GrCallExpression)maybeCall).getExpressionArguments()).length != 1 || (pluginName = GradleContext.Companion.getStringLiteralValue(arguments[0].getText(), (Object)arguments[0])) == null) break;
            result.add(pluginName);
            return true;
        }
        return false;
    }

    private static void extractMethodCallArguments(GrMethodCall methodCall, List<String> unnamed, Map<String, String> named) {
        GrArgumentList argumentList = methodCall.getArgumentList();
        for (GroovyPsiElement groovyPsiElement : argumentList.getAllArguments()) {
            if (groovyPsiElement instanceof GrNamedArgument) {
                Object value;
                GrNamedArgument namedArgument = (GrNamedArgument)groovyPsiElement;
                GrExpression expression = namedArgument.getExpression();
                if (!(expression instanceof GrLiteral) || (value = ((GrLiteral)expression).getValue()) == null) continue;
                named.put(namedArgument.getLabelName(), value.toString());
                continue;
            }
            if (!(groovyPsiElement instanceof GrExpression)) continue;
            unnamed.add(groovyPsiElement.getText());
        }
    }

    public void visitBuildScript(final @NotNull GradleContext context, final @NotNull List<? extends GradleScanner> detectors) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile = LintIdeUtilsKt.getPsiFile((Context)context);
                if (!(psiFile instanceof GroovyFile)) {
                    return;
                }
                GroovyFile groovyFile = (GroovyFile)psiFile;
                groovyFile.accept((GroovyElementVisitor)new GroovyRecursiveElementVisitor(){

                    @Nullable
                    private GrClosableBlock getParentClosure(PsiElement element) {
                        return (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)element, GrClosableBlock.class, (boolean)true);
                    }

                    public void visitVariable(@NotNull GrVariable variable) {
                        String name = variable.getName();
                        GrExpression initial = variable.getInitializerGroovy();
                        PsiIdentifier identifier = variable.getNameIdentifier();
                        if (initial != null && identifier != null) {
                            List<String> names;
                            int size;
                            String parentName = "";
                            String parentParentName = null;
                            GrClosableBlock closure = this.getParentClosure((PsiElement)variable);
                            if (closure != null && (size = (names = LintIdeGradleVisitor.getClosureNames(closure)).size()) >= 1) {
                                parentName = names.get(0);
                                if (size >= 2) {
                                    parentParentName = names.get(1);
                                }
                            }
                            String value = initial.getText();
                            for (GradleScanner detector : detectors) {
                                detector.checkDslPropertyAssignment(context, name, value, parentName, parentParentName, (Object)identifier, (Object)initial, (Object)variable);
                            }
                        }
                        super.visitVariable(variable);
                    }

                    public void visitMethodCall(@NotNull GrMethodCall call) {
                        GroovyMethodCallReference reference = call.getExplicitCallReference();
                        if (reference != null) {
                            GrClosableBlock closure;
                            String methodName = reference.getMethodName();
                            String qualifier = null;
                            PsiElement firstChild = call.getFirstChild();
                            if (firstChild instanceof GrReferenceExpression) {
                                String s = ((GrReferenceExpression)firstChild).getQualifiedReferenceName();
                                if (s != null) {
                                    int index = s.lastIndexOf(46);
                                    if (index != -1) {
                                        qualifier = s.substring(0, index);
                                    }
                                } else {
                                    super.visitMethodCall(call);
                                    return;
                                }
                            }
                            String parent = null;
                            String parentParent = null;
                            if (qualifier != null) {
                                int index = qualifier.lastIndexOf(46);
                                if (index != -1) {
                                    parent = qualifier.substring(index + 1);
                                    parentParent = qualifier.substring(0, index);
                                    if ((index = parentParent.lastIndexOf(46)) != -1) {
                                        parentParent = parentParent.substring(index + 1);
                                    }
                                } else {
                                    parent = qualifier;
                                }
                            }
                            if (parentParent == null && (closure = this.getParentClosure((PsiElement)call)) != null) {
                                List<String> names = LintIdeGradleVisitor.getClosureNames(closure);
                                int size = names.size();
                                if (parent != null) {
                                    if (size >= 1) {
                                        parentParent = names.get(0);
                                    }
                                } else if (size >= 1) {
                                    parent = names.get(0);
                                    if (size >= 2) {
                                        parentParent = names.get(1);
                                    }
                                }
                            }
                            HashMap namedArguments = Maps.newHashMap();
                            ArrayList<String> unnamedArguments = new ArrayList<String>();
                            LintIdeGradleVisitor.extractMethodCallArguments(call, unnamedArguments, namedArguments);
                            PsiElement child = call.getLastChild();
                            if (child instanceof GrClosableBlock) {
                                unnamedArguments.add(child.getText());
                            }
                            for (GradleScanner detector : detectors) {
                                detector.checkMethodCall(context, methodName, parent, parentParent, (Map)namedArguments, unnamedArguments, (Object)call);
                            }
                        }
                        super.visitMethodCall(call);
                    }

                    private void handleApplicationOrMethodCallInClosure(List<String> closureNames, PsiElement element) {
                        String parentParentName;
                        String value;
                        GrExpression valueCookie;
                        GrReferenceExpression propertyRef;
                        if (element instanceof GrApplicationStatement) {
                            call = (GrApplicationStatement)element;
                            propertyExpression = call.getInvokedExpression();
                            if (!(propertyExpression instanceof GrReferenceExpression)) {
                                return;
                            }
                            propertyRef = (GrReferenceExpression)propertyExpression;
                            argumentList = call.getArgumentList();
                            if (argumentList == null) {
                                return;
                            }
                            valueCookie = argumentList;
                            value = argumentList.getText();
                        } else if (element instanceof GrMethodCallExpression) {
                            call = (GrMethodCallExpression)element;
                            propertyExpression = call.getInvokedExpression();
                            if (!(propertyExpression instanceof GrReferenceExpression)) {
                                return;
                            }
                            propertyRef = (GrReferenceExpression)propertyExpression;
                            argumentList = call.getArgumentList().getExpressionArguments();
                            if (((GrExpression[])argumentList).length != 1) {
                                return;
                            }
                            valueCookie = argumentList[0];
                            value = argumentList[0].getText();
                        } else {
                            return;
                        }
                        List<String> names = LintIdeGradleVisitor.getReferenceExpressionNamesOrNull(propertyRef);
                        if (names == null || propertyRef.getQualifierExpression() instanceof GrCallExpression) {
                            this.handleApplicationOrMethodCallInClosure(closureNames, (PsiElement)propertyRef.getQualifierExpression());
                        }
                        if (names == null) {
                            return;
                        }
                        names.addAll(closureNames);
                        String property = names.get(0);
                        String parentName = names.size() > 1 ? names.get(1) : null;
                        String string = parentParentName = names.size() > 2 ? names.get(2) : null;
                        if (property != null && parentName != null) {
                            for (GradleScanner detector : detectors) {
                                detector.checkDslPropertyAssignment(context, property, value, parentName, parentParentName, (Object)propertyRef, (Object)valueCookie, (Object)element);
                            }
                        }
                    }

                    public void visitClosure(@NotNull GrClosableBlock closure) {
                        List<String> closureNames = LintIdeGradleVisitor.getClosureNames(closure);
                        if (!closureNames.isEmpty()) {
                            for (PsiElement element : closure.getChildren()) {
                                GrExpression rValue;
                                String parentParentName;
                                GrAssignmentExpression assignment;
                                GrExpression lValue;
                                if (element instanceof GrApplicationStatement || element instanceof GrMethodCallExpression) {
                                    this.handleApplicationOrMethodCallInClosure(closureNames, element);
                                    continue;
                                }
                                if (!(element instanceof GrAssignmentExpression) || !((lValue = (assignment = (GrAssignmentExpression)element).getLValue()) instanceof GrReferenceExpression)) continue;
                                GrReferenceExpression propertyRef = (GrReferenceExpression)lValue;
                                List<String> names = LintIdeGradleVisitor.getReferenceExpressionNames(propertyRef);
                                names.addAll(closureNames);
                                String property = names.get(0);
                                String parentName = names.size() > 1 ? names.get(1) : null;
                                String string = parentParentName = names.size() > 2 ? names.get(2) : null;
                                if (property == null || parentName == null || (rValue = assignment.getRValue()) == null) continue;
                                String value = rValue.getText();
                                for (GradleScanner detector : detectors) {
                                    detector.checkDslPropertyAssignment(context, property, value, parentName, parentParentName, (Object)lValue, (Object)rValue, (Object)assignment);
                                }
                                if (parentName.equals("ext") || !property.equals("minSdkVersion") && !property.equals("targetSdkVersion")) continue;
                                int lValueEnd = lValue.getTextRange().getEndOffset();
                                int rValueStart = rValue.getTextRange().getStartOffset();
                                assert (lValueEnd <= rValueStart);
                                DefaultPosition startPosition = new DefaultPosition(-1, -1, lValueEnd);
                                DefaultPosition endPosition = new DefaultPosition(-1, -1, rValueStart);
                                Location location = Location.create((File)context.file, (Position)startPosition, (Position)endPosition);
                                String message = String.format("Do not use assignment with the %1$s property (remove the '=')", property);
                                context.report(GradleDetector.IDE_SUPPORT, location, message, null);
                            }
                        }
                        super.visitClosure(closure);
                    }

                    public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
                        GrExpression invokedExpression;
                        GrClosableBlock block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)applicationStatement, GrClosableBlock.class, (boolean)true);
                        ArrayList parentNames = block != null ? LintIdeGradleVisitor.getClosureNames(block) : new ArrayList(0);
                        HashMap namedArguments = Maps.newHashMap();
                        ArrayList<String> unnamedArguments = new ArrayList<String>();
                        LintIdeGradleVisitor.extractMethodCallArguments((GrMethodCall)applicationStatement, unnamedArguments, namedArguments);
                        if (parentNames.isEmpty() && unnamedArguments.size() == 1 && namedArguments.isEmpty() && (invokedExpression = applicationStatement.getInvokedExpression()) instanceof GrReferenceExpression) {
                            String parentParentName;
                            GrReferenceExpression referenceExpression = (GrReferenceExpression)invokedExpression;
                            List<String> names = LintIdeGradleVisitor.getReferenceExpressionNames(referenceExpression);
                            String name = !names.isEmpty() ? names.get(0) : null;
                            String parentName = names.size() > 1 ? names.get(1) : "";
                            String string = parentParentName = names.size() > 2 ? names.get(2) : null;
                            if (name != null) {
                                String value = (String)unnamedArguments.get(0);
                                GrCommandArgumentList argumentList = applicationStatement.getArgumentList();
                                for (GradleScanner detector : detectors) {
                                    detector.checkDslPropertyAssignment(context, name, value, parentName, parentParentName, (Object)invokedExpression, (Object)argumentList, (Object)applicationStatement);
                                }
                            }
                        }
                        super.visitApplicationStatement(applicationStatement);
                    }

                    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
                        GrExpression lvalue;
                        GrClosableBlock block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)expression, GrClosableBlock.class, (boolean)true);
                        if (block == null && (lvalue = expression.getLValue()) instanceof GrReferenceExpression) {
                            GrReferenceExpression lvalueRef = (GrReferenceExpression)lvalue;
                            List<String> names = LintIdeGradleVisitor.getReferenceExpressionNames(lvalueRef);
                            String name = !names.isEmpty() ? names.get(0) : null;
                            String parentName = names.size() > 1 ? names.get(1) : "";
                            String parentParentName = names.size() > 2 ? names.get(2) : null;
                            GrExpression rvalue = expression.getRValue();
                            if (name != null && rvalue != null) {
                                String value = rvalue.getText();
                                for (GradleScanner detector : detectors) {
                                    detector.checkDslPropertyAssignment(context, name, value, parentName, parentParentName, (Object)lvalue, (Object)rvalue, (Object)expression);
                                }
                            }
                        }
                        super.visitAssignmentExpression(expression);
                    }
                });
            }
        });
    }

    public int getStartOffset(@NotNull GradleContext context, @NotNull Object cookie) {
        int startOffset = super.getStartOffset(context, cookie);
        if (startOffset != -1) {
            return startOffset;
        }
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        return textRange.getStartOffset();
    }

    @NotNull
    public Location createLocation(@NotNull GradleContext context, @NotNull Object cookie) {
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        int start = textRange.getStartOffset();
        int end = textRange.getEndOffset();
        return Location.create((File)context.file, (Position)new DefaultPosition(-1, -1, start), (Position)new DefaultPosition(-1, -1, end)).withSource((Object)element);
    }
}

