/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.lint.client.api.LintFixPerformer;
import com.android.utils.PositionXmlParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/lint/common/LintIdeReadOnlyFileProvider;", "Lcom/android/tools/lint/client/api/LintFixPerformer$FileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getFileContents", "", "file", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEditFile;", "getXmlDocument", "Lorg/w3c/dom/Document;", "createBinaryFile", "", "fileData", "contents", "", "deleteFile", "intellij.lint"})
@SourceDebugExtension(value={"SMAP\nLintIdeFixPerformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintIdeFixPerformer.kt\ncom/android/tools/idea/lint/common/LintIdeReadOnlyFileProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,597:1\n14#2:598\n*S KotlinDebug\n*F\n+ 1 LintIdeFixPerformer.kt\ncom/android/tools/idea/lint/common/LintIdeReadOnlyFileProvider\n*L\n311#1:598\n*E\n"})
public class LintIdeReadOnlyFileProvider
implements LintFixPerformer.FileProvider {
    @NotNull
    private final Project project;

    public LintIdeReadOnlyFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @RequiresReadLock
    @NotNull
    public String getFileContents(@NotNull LintFixPerformer.PendingEditFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = PhysicalFileSystemUtilsKt.toPsiFile((File)file.getFile(), (Project)this.project);
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public Document getXmlDocument(@NotNull LintFixPerformer.PendingEditFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            return PositionXmlParser.parse((String)this.getFileContents(file));
        }
        catch (Exception e) {
            Exception exception = e;
            if (!(exception instanceof ParserConfigurationException || exception instanceof SAXException || exception instanceof IOException)) {
                throw e;
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LintIdeClient.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Ignoring " + file + ": Failed to parse XML: " + e, (Throwable)e);
            return null;
        }
    }

    public void createBinaryFile(@NotNull LintFixPerformer.PendingEditFile fileData, @NotNull byte[] contents) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        throw new UnsupportedOperationException();
    }

    public void deleteFile(@NotNull LintFixPerformer.PendingEditFile fileData) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        throw new UnsupportedOperationException();
    }
}

