/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.lint.common.LintBatchResult;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeIssueRegistry;
import com.android.tools.idea.lint.common.LintIdeProject;
import com.android.tools.idea.lint.common.LintIdeSupportKt;
import com.android.tools.idea.lint.common.LintIgnoredResult;
import com.android.tools.idea.lint.common.LintResult;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Project;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.gradle.config.GradleFileTypeKt;
import org.toml.lang.psi.TomlFileType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 L2\u00020\u0001:\u0001LB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001e\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J?\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\b\u001a\u00020\t2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u001f2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0$\"\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010%J.\u0010&\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0'2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\"2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010(\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\t2\u0006\u0010)\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\t2\u0006\u0010)\u001a\u00020.H\u0016J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u00101\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u00104\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u00105\u001a\u0002032\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u0016H\u0016J\u001a\u00107\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u0018H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010=\u001a\u00020>H\u0016J\u0018\u0010A\u001a\u0002032\u0006\u0010B\u001a\u00020C2\u0006\u0010)\u001a\u00020.H\u0016J\"\u0010A\u001a\u0002032\u0006\u0010B\u001a\u00020C2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010)\u001a\u00020,H\u0016J \u0010D\u001a\u0002032\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020>2\u0006\u0010E\u001a\u00020\u0011H\u0016J \u0010F\u001a\u0002032\u0006\u0010G\u001a\u00020\u00112\u0006\u0010=\u001a\u00020>2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010H\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020I2\u0006\u0010J\u001a\u00020\u00112\b\u0010K\u001a\u0004\u0018\u00010\u0011H\u0016\u00a8\u0006M"}, d2={"Lcom/android/tools/idea/lint/common/LintIdeSupport;", "", "<init>", "()V", "getIssueRegistry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "getBaselineFile", "Ljava/io/File;", "client", "Lcom/android/tools/idea/lint/common/LintIdeClient;", "module", "Lcom/intellij/openapi/module/Module;", "getPlatforms", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Platform;", "getSeverityOverrides", "", "", "", "askForAttributeValue", "attributeName", "context", "Lcom/intellij/psi/PsiElement;", "canAnnotate", "", "file", "Lcom/intellij/psi/PsiFile;", "canAnalyze", "project", "Lcom/intellij/openapi/project/Project;", "createProject", "", "Lcom/android/tools/lint/detector/api/Project;", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "modules", "", "(Lcom/android/tools/idea/lint/common/LintIdeClient;Ljava/util/List;[Lcom/intellij/openapi/module/Module;)Ljava/util/List;", "createProjectForSingleFile", "Lcom/intellij/openapi/util/Pair;", "createClient", "lintResult", "Lcom/android/tools/idea/lint/common/LintResult;", "createBatchClient", "Lcom/android/tools/idea/lint/common/LintBatchResult;", "createEditorClient", "Lcom/android/tools/idea/lint/common/LintEditorResult;", "recommendedAgpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "shouldRecommendUpdateAgpToLatest", "updateAgpToLatest", "", "shouldOfferUpgradeAssistantForDeprecatedConfigurations", "updateDeprecatedConfigurations", "element", "resolveDynamicDependency", "dependency", "Lcom/android/ide/common/gradle/Dependency;", "canRequestFeedback", "requestFeedbackFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "requestFeedbackIntentionAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "logSession", "lint", "Lcom/android/tools/lint/client/api/LintDriver;", "logQuickFixInvocation", "fixDescription", "logTooltipLink", "url", "ensureNamespaceImported", "Lcom/intellij/psi/xml/XmlFile;", "namespaceUri", "suggestedPrefix", "Companion", "intellij.lint"})
public abstract class LintIdeSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public LintIdeSupport() {
        LintClient.Companion.setClientName("studio");
    }

    @NotNull
    public IssueRegistry getIssueRegistry() {
        return (IssueRegistry)new LintIdeIssueRegistry();
    }

    @Nullable
    public File getBaselineFile(@NotNull LintIdeClient client, @NotNull Module module) {
        File file;
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        File file2 = LintIdeSupportKt.getModuleDir(module);
        if (file2 == null) {
            return null;
        }
        File dir = file2;
        Configuration configuration = client.getConfiguration(dir);
        if (configuration != null && (file = configuration.getBaselineFile()) != null) {
            File baseline = file;
            boolean bl = false;
            return baseline;
        }
        File lintBaseline = new File(dir, "lint_baseline.xml");
        if (lintBaseline.exists()) {
            return lintBaseline;
        }
        File baseline = new File(dir, "baseline.xml");
        if (baseline.exists()) {
            return baseline;
        }
        return null;
    }

    @NotNull
    public EnumSet<Platform> getPlatforms() {
        return Platform.JDK_SET;
    }

    @Nullable
    public Map<String, Integer> getSeverityOverrides(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return null;
    }

    @Nullable
    public String askForAttributeValue(@NotNull String attributeName, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return null;
    }

    public boolean canAnnotate(@NotNull PsiFile file, @NotNull Module module) {
        FileType fileType;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                FileType fileType2 = file.getFileType();
                Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
                fileType = fileType2;
                if (fileType == JavaFileType.INSTANCE || fileType == KotlinFileType.INSTANCE || fileType == PropertiesFileType.INSTANCE || fileType == TomlFileType.INSTANCE) break block5;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)"gradle.dcl", (boolean)false, (int)2, null)) break block6;
            }
            return true;
        }
        if (fileType == XmlFileType.INSTANCE) {
            return true;
        }
        if (fileType == FileTypes.PLAIN_TEXT) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name = string;
            return Intrinsics.areEqual((Object)name, (Object)"proguard-project.txt") || Intrinsics.areEqual((Object)name, (Object)"proguard-android.txt") || Intrinsics.areEqual((Object)name, (Object)"proguard.cfg");
        }
        return GradleFileTypeKt.isGradleFile((PsiFile)file);
    }

    public boolean canAnalyze(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @NotNull
    public List<Project> createProject(@NotNull LintIdeClient client, @Nullable List<? extends VirtualFile> files, Module ... modules) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        List<Project> list = LintIdeProject.create(client, files, Arrays.copyOf(modules, modules.length));
        Intrinsics.checkNotNullExpressionValue(list, (String)"create(...)");
        return list;
    }

    @NotNull
    public Pair<Project, Project> createProjectForSingleFile(@NotNull LintIdeClient client, @Nullable VirtualFile file, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Pair<Project, Project> pair = LintIdeProject.createForSingleFile(client, file, module);
        Intrinsics.checkNotNullExpressionValue(pair, (String)"createForSingleFile(...)");
        return pair;
    }

    @NotNull
    public LintIdeClient createClient(@NotNull com.intellij.openapi.project.Project project, @NotNull LintResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new LintIdeClient(project, lintResult);
    }

    public static /* synthetic */ LintIdeClient createClient$default(LintIdeSupport lintIdeSupport, com.intellij.openapi.project.Project project, LintResult lintResult, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createClient");
        }
        if ((n & 2) != 0) {
            lintResult = new LintIgnoredResult();
        }
        return lintIdeSupport.createClient(project, lintResult);
    }

    @NotNull
    public LintIdeClient createBatchClient(@NotNull LintBatchResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new LintIdeClient(lintResult.getProject(), lintResult);
    }

    @NotNull
    public LintIdeClient createEditorClient(@NotNull LintEditorResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new LintIdeClient(lintResult.getModule().getProject(), lintResult);
    }

    @Nullable
    public AgpVersion recommendedAgpVersion(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    public boolean shouldRecommendUpdateAgpToLatest(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    public void updateAgpToLatest(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public boolean shouldOfferUpgradeAssistantForDeprecatedConfigurations(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    public void updateDeprecatedConfigurations(@NotNull com.intellij.openapi.project.Project project, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    @Nullable
    public String resolveDynamicDependency(@NotNull com.intellij.openapi.project.Project project, @NotNull Dependency dependency) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        return null;
    }

    public boolean canRequestFeedback() {
        return false;
    }

    @NotNull
    public LocalQuickFix requestFeedbackFix(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        throw new IllegalStateException("Not supported".toString());
    }

    @NotNull
    public IntentionAction requestFeedbackIntentionAction(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        throw new IllegalStateException("Not supported".toString());
    }

    public void logSession(@NotNull LintDriver lint, @NotNull LintEditorResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lint, (String)"lint");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
    }

    public void logSession(@NotNull LintDriver lint, @Nullable Module module, @NotNull LintBatchResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lint, (String)"lint");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
    }

    public void logQuickFixInvocation(@NotNull com.intellij.openapi.project.Project project, @NotNull Issue issue, @NotNull String fixDescription) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)fixDescription, (String)"fixDescription");
    }

    public void logTooltipLink(@NotNull String url, @NotNull Issue issue, @NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public String ensureNamespaceImported(@NotNull XmlFile file, @NotNull String namespaceUri, @Nullable String suggestedPrefix) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)namespaceUri, (String)"namespaceUri");
        return "";
    }

    @JvmStatic
    @NotNull
    public static final LintIdeSupport get() {
        return Companion.get();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/lint/common/LintIdeSupport$Companion;", "", "<init>", "()V", "get", "Lcom/android/tools/idea/lint/common/LintIdeSupport;", "intellij.lint"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LintIdeSupport get() {
            LintIdeSupport lintIdeSupport = (LintIdeSupport)ApplicationManager.getApplication().getService(LintIdeSupport.class);
            if (lintIdeSupport == null) {
                lintIdeSupport = new LintIdeSupport(){};
            }
            return lintIdeSupport;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

