/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeRequest;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaVariableSymbol;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u001a \u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0011"}, d2={"getPsiFile", "Lcom/intellij/psi/PsiFile;", "Lcom/android/tools/lint/detector/api/Context;", "hasBackingField", "", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getPsiFileSafely", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getAndRemoveMapFix", "Lcom/android/tools/lint/detector/api/LintFix$DataMap;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "Lkotlin/Pair;", "Lcom/android/tools/lint/detector/api/LintFix;", "fix", "intellij.lint"})
@SourceDebugExtension(value={"SMAP\nLintIdeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintIdeUtils.kt\ncom/android/tools/idea/lint/common/LintIdeUtilsKt\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n28#2,2:106\n36#3,13:108\n1782#4,4:121\n626#4,12:125\n774#4:137\n865#4,2:138\n*S KotlinDebug\n*F\n+ 1 LintIdeUtils.kt\ncom/android/tools/idea/lint/common/LintIdeUtilsKt\n*L\n47#1:106,2\n47#1:108,13\n86#1:121,4\n88#1:125,12\n93#1:137\n93#1:138,2\n*E\n"})
public final class LintIdeUtilsKt {
    @Nullable
    public static final PsiFile getPsiFile(@NotNull Context $this$getPsiFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getPsiFile, (String)"<this>");
        LintRequest request = $this$getPsiFile.getDriver().getRequest();
        Intrinsics.checkNotNull((Object)request, (String)"null cannot be cast to non-null type com.android.tools.idea.lint.common.LintIdeRequest");
        Project project = ((LintIdeRequest)request).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (project2.isDisposed()) {
            return null;
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)$this$getPsiFile.file, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return LintIdeUtilsKt.getPsiFileSafely(file, project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean hasBackingField(@NotNull KtProperty $this$hasBackingField) {
        Intrinsics.checkNotNullParameter((Object)$this$hasBackingField, (String)"<this>");
        boolean $i$f$analyze = false;
        Project project = ((KtElement)$this$hasBackingField).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)$this$hasBackingField);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)$this$hasBackingField);
        try {
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                KaPropertySymbol kaPropertySymbol;
                block9: {
                    boolean bl = false;
                    KaSession $this$hasBackingField_u24lambda_u240 = analysisSession$iv$iv;
                    boolean bl2 = false;
                    KaVariableSymbol kaVariableSymbol = $this$hasBackingField_u24lambda_u240.getSymbol($this$hasBackingField);
                    if ((kaVariableSymbol instanceof KaPropertySymbol ? (KaPropertySymbol)kaVariableSymbol : null) != null) break block9;
                    boolean bl3 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl22 : MonitorExitStatement: MONITOREXIT : var6_6
                    boolean bl4 = bl3;
                    return bl4;
                }
                KaPropertySymbol propertySymbol = kaPropertySymbol;
                boolean bl = propertySymbol.getHasBackingField();
                // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl28 : MonitorExitStatement: MONITOREXIT : var6_6
                boolean bl5 = bl;
                return bl5;
            }
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)$this$hasBackingField);
        }
    }

    @Nullable
    public static final PsiFile getPsiFileSafely(@NotNull VirtualFile $this$getPsiFileSafely, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getPsiFileSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (PsiFile)ApplicationManager.getApplication().runReadAction(() -> LintIdeUtilsKt.getPsiFileSafely$lambda$1(project, $this$getPsiFileSafely));
    }

    @Nullable
    public static final LintFix.DataMap getAndRemoveMapFix(@NotNull Incident incident) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Pair<LintFix, LintFix.DataMap> pair = LintIdeUtilsKt.getAndRemoveMapFix(incident.getFix());
        LintFix updatedFix = (LintFix)pair.component1();
        LintFix.DataMap dataMap = (LintFix.DataMap)pair.component2();
        incident.setFix(updatedFix);
        return dataMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<LintFix, LintFix.DataMap> getAndRemoveMapFix(@Nullable LintFix fix) {
        Pair pair;
        LintFix lintFix = fix;
        if (lintFix == null) {
            pair = TuplesKt.to(null, null);
        } else if (lintFix instanceof LintFix.LintFixGroup) {
            int numMaps;
            Iterable $this$count$iv = ((LintFix.LintFixGroup)fix).getFixes();
            boolean $i$f$count2 = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v1 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    LintFix it = (LintFix)element$iv;
                    boolean bl = false;
                    if (!(it instanceof LintFix.DataMap) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v1 = numMaps = count$iv;
            }
            if (numMaps == 1) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                LintFix it;
                Iterable $this$single$iv = ((LintFix.LintFixGroup)fix).getFixes();
                boolean $i$f$single22 = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    it = (LintFix)element$iv;
                    boolean bl = false;
                    if (!(it instanceof LintFix.DataMap)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Object v2 = single$iv;
                Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type com.android.tools.lint.detector.api.LintFix.DataMap");
                LintFix.DataMap dataMap = v2;
                Iterable $i$f$count2 = ((LintFix.LintFixGroup)fix).getFixes();
                LintFix.GroupType groupType = ((LintFix.LintFixGroup)fix).getType();
                String string = ((LintFix.LintFixGroup)fix).getFamilyName();
                String string2 = ((LintFix.LintFixGroup)fix).getDisplayName();
                boolean $i$f$filter = false;
                void $i$f$single22 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (LintFix)element$iv$iv;
                    boolean bl = false;
                    if (!(!(it instanceof LintFix.DataMap))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                boolean bl = ((LintFix.LintFixGroup)fix).independent;
                boolean bl2 = ((LintFix.LintFixGroup)fix).robot;
                List list2 = list;
                LintFix.GroupType groupType2 = groupType;
                String string3 = string;
                String string4 = string2;
                pair = TuplesKt.to((Object)new LintFix.LintFixGroup(string4, string3, groupType2, list2, bl2, bl), (Object)dataMap);
            } else {
                pair = TuplesKt.to((Object)fix, null);
            }
        } else {
            pair = lintFix instanceof LintFix.DataMap ? TuplesKt.to(null, (Object)fix) : TuplesKt.to((Object)fix, null);
        }
        return pair;
    }

    private static final PsiFile getPsiFileSafely$lambda$1(Project $project, VirtualFile $this_getPsiFileSafely) {
        return $project.isDisposed() ? null : ($this_getPsiFileSafely.isValid() ? PsiManager.getInstance((Project)$project).findFile($this_getPsiFileSafely) : null);
    }
}

