/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.gradle.dcl.lang.psi.DeclarativeFileType;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.SuppressLintQuickFix;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.gradle.config.GradleFileType;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.toml.lang.psi.TomlFileType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\b\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/lint/common/SuppressLintIntentionAction;", "Lcom/intellij/modcommand/ModCommandAction;", "id", "", "element", "Lcom/intellij/psi/PsiElement;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/android/tools/lint/detector/api/Issue;)V", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/intellij/psi/PsiElement;)V", "label", "getFamilyName", "perform", "Lcom/intellij/modcommand/ModCommand;", "context", "Lcom/intellij/modcommand/ActionContext;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "intellij.lint"})
public final class SuppressLintIntentionAction
implements ModCommandAction {
    @NotNull
    private final String id;
    @Nullable
    private final Issue issue;
    @NotNull
    private final String label;

    public SuppressLintIntentionAction(@NotNull String id, @NotNull PsiElement element, @Nullable Issue issue) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.id = id;
        this.issue = issue;
        this.label = SuppressLintQuickFix.Companion.displayName(element, this.id);
    }

    public /* synthetic */ SuppressLintIntentionAction(String string, PsiElement psiElement, Issue issue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            issue = null;
        }
        this(string, psiElement, issue);
    }

    public SuppressLintIntentionAction(@NotNull Issue issue, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this(issue.getId(), element, null, 4, null);
    }

    @NotNull
    public String getFamilyName() {
        return "Suppress";
    }

    @NotNull
    public ModCommand perform(@NotNull ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiFile psiFile = context.file();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file(...)");
        PsiFile file = psiFile;
        PsiElement psiElement = file.findElementAt(context.offset());
        if (psiElement == null) {
            psiElement = (PsiElement)file;
        }
        PsiElement target = psiElement;
        ModCommand result = new SuppressLintQuickFix(this.id, target).applyFix(target, context);
        if (this.issue != null && !IntentionPreviewUtils.isIntentionPreviewActive()) {
            LintIdeSupport lintIdeSupport = LintIdeSupport.Companion.get();
            Project project = context.project();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
            lintIdeSupport.logQuickFixInvocation(project, this.issue, this.label);
        }
        return result;
    }

    @Nullable
    public Presentation getPresentation(@NotNull ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FileType fileType = context.file().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType type = fileType;
        return type == JavaFileType.INSTANCE || type == XmlFileType.INSTANCE || type == GroovyFileType.GROOVY_FILE_TYPE || type == GradleFileType.INSTANCE || type == KotlinFileType.INSTANCE || context.file() instanceof PsiBinaryFile || type == TomlFileType.INSTANCE || type == DeclarativeFileType.Companion.getINSTANCE() ? Presentation.of((String)this.label).withIcon(AllIcons.Actions.Cancel) : null;
    }
}

