/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.chunkio;

import com.android.tools.chunkio.ChunkException;
import com.android.tools.chunkio.ChunkUtils;
import com.android.tools.chunkio.RangedInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.WeakHashMap;

public final class ChunkIO {
    private static final WeakHashMap<Class<?>, Method> sReaders = new WeakHashMap();

    private ChunkIO() {
    }

    public static <T> T read(InputStream in, Class<T> type) throws ChunkException {
        Method method = sReaders.get(type);
        if (method == null) {
            ArrayList<String> names = new ArrayList<String>();
            for (Class<Object> c = type; c != null; c = c.getEnclosingClass()) {
                names.add(c.getSimpleName());
            }
            Collections.reverse(names);
            String className = type.getPackage().getName() + '.' + ChunkUtils.join(names, "_") + "__ChunkIO";
            try {
                Class<?> reader = Class.forName(className);
                method = reader.getDeclaredMethod("read", RangedInputStream.class, LinkedList.class);
                method.setAccessible(true);
                sReaders.put(type, method);
            }
            catch (ClassNotFoundException e) {
                throw new ChunkException("Could not find the decoder for type " + type, e);
            }
            catch (NoSuchMethodException e) {
                throw new ChunkException("Could not find the read() method for type " + type, e);
            }
        }
        try {
            return (T)method.invoke(null, new RangedInputStream(in), new LinkedList());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ChunkException("Could not invoke the read() method for type " + type, e);
        }
    }
}

