/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.fonts;

import com.android.ide.common.fonts.FontType;
import com.android.ide.common.fonts.MutableFontDetail;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QueryResolverLegacy {
    private static final String NAME_PARAMETER = "name";
    private static final String WIDTH_PARAMETER = "width";
    private static final String WEIGHT_PARAMETER = "weight";
    private static final String ITALIC_PARAMETER = "italic";
    private static final String BEST_EFFORT_PARAMETER = "besteffort";

    public static List<MutableFontDetail> getSpecsForQuery(String query) {
        List queries = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)query);
        ArrayList<MutableFontDetail> specs = new ArrayList<MutableFontDetail>();
        for (String q : queries) {
            specs.add(QueryResolverLegacy.getSpecForQuery(q));
        }
        return specs;
    }

    private static MutableFontDetail getSpecForQuery(String query) {
        if (!query.contains("=")) {
            return new MutableFontDetail(query, FontType.SINGLE, 0.0f, true);
        }
        Map parameters = Splitter.on((char)'&').withKeyValueSeparator(Splitter.on((char)'=').trimResults()).split((CharSequence)query);
        String name = (String)parameters.get(NAME_PARAMETER);
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("'name' parameter is required.");
        }
        String widthString = (String)parameters.get(WIDTH_PARAMETER);
        String weightString = (String)parameters.get(WEIGHT_PARAMETER);
        String italicString = (String)parameters.get(ITALIC_PARAMETER);
        String bestEffortString = (String)parameters.get(BEST_EFFORT_PARAMETER);
        try {
            float width = widthString == null ? 100.0f : Float.parseFloat(widthString);
            int weight = weightString == null ? 400 : Integer.parseInt(weightString);
            float italic = italicString == null ? 0.0f : Float.parseFloat(italicString);
            boolean bestEffort = bestEffortString == null ? false : Boolean.parseBoolean(bestEffortString);
            return new MutableFontDetail(name, weight, width, italic, !bestEffort);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid numerical parameter", nfe);
        }
    }
}

