/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.NameDetails;
import com.android.sdklib.SdkVersionInfo;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u0007\u001a\u001e\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u001a\u001e\u0010\b\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u001a\u001e\u0010\n\u001a\u00020\u0007*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u001a1\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000f\u001a1\u0010\u0010\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0011\u001a1\u0010\u0012\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000f\u001a1\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0014"}, d2={"getFullApiName", "", "Lcom/android/sdklib/AndroidVersion;", "includeReleaseName", "", "includeCodeName", "getApiNameAndDetails", "Lcom/android/sdklib/NameDetails;", "getFullReleaseName", "includeApiLevel", "getReleaseNameAndDetails", "computeFullApiName", "apiLevel", "", "extensionLevel", "(ILjava/lang/Integer;ZZ)Ljava/lang/String;", "computeApiNameAndDetails", "(ILjava/lang/Integer;ZZ)Lcom/android/sdklib/NameDetails;", "computeFullReleaseName", "computeReleaseNameAndDetails", "android.sdktools.sdklib"})
@JvmName(name="AndroidVersionUtils")
public final class AndroidVersionUtils {
    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName, boolean includeReleaseName, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullApiName, (String)"<this>");
        if ($this$getFullApiName.getCodename() != null) {
            return "API " + $this$getFullApiName.getCodename() + " Preview";
        }
        return AndroidVersionUtils.computeFullApiName($this$getFullApiName.getApiLevel(), $this$getFullApiName.isBaseExtension() ? null : $this$getFullApiName.getExtensionLevel(), includeReleaseName, includeCodeName);
    }

    public static /* synthetic */ String getFullApiName$default(AndroidVersion androidVersion, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.getFullApiName(androidVersion, bl, bl2);
    }

    @NotNull
    public static final NameDetails getApiNameAndDetails(@NotNull AndroidVersion $this$getApiNameAndDetails, boolean includeReleaseName, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getApiNameAndDetails, (String)"<this>");
        if ($this$getApiNameAndDetails.getCodename() != null) {
            return new NameDetails("API " + $this$getApiNameAndDetails.getCodename() + " Preview", null);
        }
        return AndroidVersionUtils.computeApiNameAndDetails($this$getApiNameAndDetails.getApiLevel(), $this$getApiNameAndDetails.isBaseExtension() ? null : $this$getApiNameAndDetails.getExtensionLevel(), includeReleaseName, includeCodeName);
    }

    public static /* synthetic */ NameDetails getApiNameAndDetails$default(AndroidVersion androidVersion, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.getApiNameAndDetails(androidVersion, bl, bl2);
    }

    @NotNull
    public static final String getFullReleaseName(@NotNull AndroidVersion $this$getFullReleaseName, boolean includeApiLevel, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullReleaseName, (String)"<this>");
        if ($this$getFullReleaseName.getCodename() != null) {
            return "Android " + $this$getFullReleaseName.getCodename() + " Preview";
        }
        return AndroidVersionUtils.computeFullReleaseName($this$getFullReleaseName.getApiLevel(), $this$getFullReleaseName.isBaseExtension() ? null : $this$getFullReleaseName.getExtensionLevel(), includeApiLevel, includeCodeName);
    }

    public static /* synthetic */ String getFullReleaseName$default(AndroidVersion androidVersion, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.getFullReleaseName(androidVersion, bl, bl2);
    }

    @NotNull
    public static final NameDetails getReleaseNameAndDetails(@NotNull AndroidVersion $this$getReleaseNameAndDetails, boolean includeApiLevel, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getReleaseNameAndDetails, (String)"<this>");
        if ($this$getReleaseNameAndDetails.getCodename() != null) {
            return new NameDetails("Android " + $this$getReleaseNameAndDetails.getCodename() + " Preview", null);
        }
        return AndroidVersionUtils.computeReleaseNameAndDetails($this$getReleaseNameAndDetails.getApiLevel(), $this$getReleaseNameAndDetails.isBaseExtension() ? null : $this$getReleaseNameAndDetails.getExtensionLevel(), includeApiLevel, includeCodeName);
    }

    public static /* synthetic */ NameDetails getReleaseNameAndDetails$default(AndroidVersion androidVersion, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.getReleaseNameAndDetails(androidVersion, bl, bl2);
    }

    @NotNull
    public static final String computeFullApiName(int apiLevel, @Nullable Integer extensionLevel, boolean includeReleaseName, boolean includeCodeName) {
        NameDetails nameDetails = AndroidVersionUtils.computeApiNameAndDetails(apiLevel, extensionLevel, includeReleaseName, includeCodeName);
        if (nameDetails.getDetails() != null) {
            return nameDetails.getName() + " (" + nameDetails.getDetails() + ')';
        }
        return nameDetails.getName();
    }

    public static /* synthetic */ String computeFullApiName$default(int n, Integer n2, boolean bl, boolean bl2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.computeFullApiName(n, n2, bl, bl2);
    }

    @NotNull
    public static final NameDetails computeApiNameAndDetails(int apiLevel, @Nullable Integer extensionLevel, boolean includeReleaseName, boolean includeCodeName) {
        String codeName;
        String string;
        StringBuilder name = new StringBuilder("API " + apiLevel);
        if (extensionLevel != null) {
            name.append(" ext. " + extensionLevel);
        }
        boolean useCodeName = false;
        useCodeName = includeCodeName;
        if (includeReleaseName) {
            String codeName2;
            String string2;
            String relName = SdkVersionInfo.getReleaseVersionString(apiLevel);
            if (relName == null) {
                String string3 = SdkVersionInfo.getCodeName(apiLevel);
                if (string3 != null) {
                    String string4;
                    String it = string4 = string3;
                    boolean bl = false;
                    useCodeName = false;
                    string2 = string4;
                } else {
                    string2 = null;
                }
            } else {
                string2 = codeName2 = null;
            }
            if ((string = relName) == null) {
                string = codeName2;
            }
        } else {
            string = null;
        }
        String releaseName = string;
        String string5 = codeName = useCodeName ? SdkVersionInfo.getCodeName(apiLevel) : null;
        if (codeName == null && releaseName == null) {
            String string6 = name.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
            return new NameDetails(string6, null);
        }
        StringBuilder details = new StringBuilder();
        if (codeName != null) {
            details.append('\"' + codeName + '\"');
            if (releaseName != null) {
                details.append("; ");
            }
        }
        if (releaseName != null) {
            details.append("Android " + releaseName);
        }
        String string7 = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
        return new NameDetails(string7, details.toString());
    }

    public static /* synthetic */ NameDetails computeApiNameAndDetails$default(int n, Integer n2, boolean bl, boolean bl2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.computeApiNameAndDetails(n, n2, bl, bl2);
    }

    @NotNull
    public static final String computeFullReleaseName(int apiLevel, @Nullable Integer extensionLevel, boolean includeApiLevel, boolean includeCodeName) {
        NameDetails nameDetails = AndroidVersionUtils.computeReleaseNameAndDetails(apiLevel, extensionLevel, includeApiLevel, includeCodeName);
        if (nameDetails.getDetails() != null) {
            return nameDetails.getName() + " (" + nameDetails.getDetails() + ')';
        }
        return nameDetails.getName();
    }

    public static /* synthetic */ String computeFullReleaseName$default(int n, Integer n2, boolean bl, boolean bl2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.computeFullReleaseName(n, n2, bl, bl2);
    }

    @NotNull
    public static final NameDetails computeReleaseNameAndDetails(int apiLevel, @Nullable Integer extensionLevel, boolean includeApiLevel, boolean includeCodeName) {
        String resolvedCodeName;
        StringBuilder name = new StringBuilder();
        String releaseName = SdkVersionInfo.getReleaseVersionString(apiLevel);
        if (releaseName == null) {
            String knownCodeName = SdkVersionInfo.getCodeName(apiLevel);
            if (knownCodeName != null) {
                name.append("Android " + knownCodeName);
                if (includeApiLevel) {
                    name.append(" (API \"" + apiLevel + '\"');
                    if (extensionLevel != null) {
                        name.append(" ext. " + extensionLevel);
                    }
                    name.append(")");
                }
            } else {
                name.append("Android API " + apiLevel);
                if (includeApiLevel && extensionLevel != null) {
                    name.append(" ext. " + extensionLevel);
                }
            }
            String string = name.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new NameDetails(string, null);
        }
        name.append("Android " + releaseName);
        String string = resolvedCodeName = includeCodeName ? SdkVersionInfo.getCodeName(apiLevel) : null;
        if (resolvedCodeName == null && !includeApiLevel) {
            String string2 = name.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return new NameDetails(string2, null);
        }
        StringBuilder details = new StringBuilder();
        if (resolvedCodeName != null) {
            details.append('\"' + resolvedCodeName + '\"');
            if (includeApiLevel) {
                details.append("; ");
            }
        }
        if (includeApiLevel) {
            details.append("API " + apiLevel);
            if (extensionLevel != null) {
                details.append(" ext. " + extensionLevel);
            }
        }
        String string3 = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return new NameDetails(string3, details.toString());
    }

    public static /* synthetic */ NameDetails computeReleaseNameAndDetails$default(int n, Integer n2, boolean bl, boolean bl2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.computeReleaseNameAndDetails(n, n2, bl, bl2);
    }

    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName, boolean includeReleaseName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullApiName, (String)"<this>");
        return AndroidVersionUtils.getFullApiName$default($this$getFullApiName, includeReleaseName, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullApiName, (String)"<this>");
        return AndroidVersionUtils.getFullApiName$default($this$getFullApiName, false, false, 3, null);
    }
}

