/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool;

import com.android.annotations.concurrency.Slow;
import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.Channel;
import com.android.repository.api.Checksum;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.Downloader;
import com.android.repository.api.License;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.Repository;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.RemotePackageImpl;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.legacy.LegacyDownloader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class OfflineRepoCreator {
    private final OfflineRepoConfig mConfig;

    public OfflineRepoCreator(OfflineRepoConfig config) {
        this.mConfig = config;
    }

    @Slow
    public void run() throws IOException {
        Path tempDir = FileOpUtils.getNewTempDir((String)"OfflineRepoCreator", (FileSystem)FileSystems.getDefault());
        AndroidSdkHandler handler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, tempDir);
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        RepoManager mgr = handler.getSdkManager((ProgressIndicator)progress);
        SettingsController settings = new SettingsController(){

            public boolean getForceHttp() {
                return false;
            }

            public void setForceHttp(boolean force) {
            }

            public Channel getChannel() {
                return null;
            }
        };
        mgr.loadSynchronously(0L, (ProgressIndicator)progress, (Downloader)new LegacyDownloader(settings), settings);
        Map remotes = mgr.getPackages().getRemotePackages();
        ArrayList<RemotePackageImpl> toWrite = new ArrayList<RemotePackageImpl>();
        for (String path : this.mConfig.mPackages) {
            RemotePackageImpl remote = (RemotePackageImpl)remotes.get(path);
            if (remote == null) continue;
            toWrite.add(remote);
            URL url = InstallerUtil.resolveCompleteArchiveUrl((RemotePackage)remote, (ProgressIndicator)progress);
            Path dest = this.mConfig.mDest.resolve(remote.getArchive().getComplete().getUrl());
            if (OfflineRepoCreator.checkExisting(remote, dest)) continue;
            System.out.println("downloading " + url + " to " + dest);
            Files.copy(url.openStream(), dest, StandardCopyOption.REPLACE_EXISTING);
        }
        if (!toWrite.isEmpty()) {
            this.writeRepoXml(toWrite, mgr, (ProgressIndicator)progress);
        }
    }

    private static boolean checkExisting(RemotePackageImpl remote, Path dest) throws IOException {
        if (Files.exists(dest, new LinkOption[0])) {
            try {
                Checksum existingChecksum = remote.getArchive().getComplete().getTypedChecksum();
                MessageDigest digest = MessageDigest.getInstance(existingChecksum.getType());
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(dest, new OpenOption[0]));){
                    int n;
                    byte[] buf = new byte[4096];
                    while ((n = ((InputStream)in).read(buf)) >= 0) {
                        digest.update(buf, 0, n);
                    }
                }
                if (DatatypeConverter.printHexBinary((byte[])digest.digest()).equals(existingChecksum.getValue().toUpperCase())) {
                    System.out.println(dest + " is up to date");
                    return true;
                }
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return false;
    }

    private void writeRepoXml(List<RemotePackageImpl> toWrite, RepoManager mgr, ProgressIndicator progress) throws IOException {
        if (toWrite.isEmpty()) {
            return;
        }
        CommonFactory factory = toWrite.get(0).createFactory();
        Repository repo = factory.createRepositoryType();
        HashSet<String> seenLicenses = new HashSet<String>();
        for (RemotePackageImpl remote : toWrite) {
            License l = remote.getLicense();
            if (l != null && !seenLicenses.contains(l.getId())) {
                repo.addLicense(l);
                seenLicenses.add(l.getId());
            }
            remote.setChannel(null);
            repo.getRemotePackage().add(remote);
        }
        Path outFile = this.mConfig.mDest.resolve("offline-repo.xml");
        System.out.println("Writing repo xml to " + outFile);
        InstallerUtil.writeRepoXml((RepoManager)mgr, (Repository)repo, (Path)outFile, (CommonFactory)factory, (ProgressIndicator)progress);
    }

    public static void main(String[] args) throws IOException {
        OfflineRepoConfig config = OfflineRepoConfig.parse(args);
        if (config == null) {
            System.exit(1);
        }
        OfflineRepoCreator creator = new OfflineRepoCreator(config);
        creator.run();
    }

    private static class OfflineRepoConfig {
        private Path mDest;
        private final List<String> mPackages = new ArrayList<String>();
        private static final String DEST = "--dest";
        private static final String PKG_LIST = "--package_file";

        private OfflineRepoConfig() {
        }

        public static OfflineRepoConfig parse(String[] args) {
            OfflineRepoConfig result = new OfflineRepoConfig();
            try {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals(DEST)) {
                        result.mDest = Paths.get(args[++i], new String[0]);
                        continue;
                    }
                    if (args[i].equals(PKG_LIST)) {
                        result.mPackages.addAll(Files.readAllLines(Paths.get(args[++i], new String[0])));
                        continue;
                    }
                    result.mPackages.add(args[i]);
                }
                if (result.mDest == null || result.mPackages.isEmpty()) {
                    OfflineRepoConfig.printUsage();
                    return null;
                }
                return result;
            }
            catch (Exception e) {
                OfflineRepoConfig.printUsage();
                System.err.println();
                e.printStackTrace();
                return null;
            }
        }

        private static void printUsage() {
            System.err.println("Usage: java com.android.sdklib.tool.OfflineRepoCreator \\");
            System.err.println("  --dest <path> [--package_file <filename>] <packages>...");
            System.err.println();
            System.err.println("<package> is a sdk-style path (e.g. \"build-tools;23.0.0\" or \"platforms;android-23\")");
            System.err.println("<filename> is a file that contains one <package> per line");
            System.err.println();
            System.err.println("* If the env var REPO_OS_OVERRIDE is set to \"windows\",\n  \"macosx\", or \"linux\", packages will be created for that OS");
        }
    }
}

