/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis.reflection.util;

import com.google.common.collect.ImmutableBiMap;

public class ReflectionUtils {
    private static ImmutableBiMap<String, String> primitiveMap = ImmutableBiMap.builder().put((Object)"boolean", (Object)"Z").put((Object)"int", (Object)"I").put((Object)"long", (Object)"J").put((Object)"double", (Object)"D").put((Object)"void", (Object)"V").put((Object)"float", (Object)"F").put((Object)"char", (Object)"C").put((Object)"short", (Object)"S").put((Object)"byte", (Object)"B").build();

    public static String javaToDexName(String javaName) {
        if (javaName.charAt(0) == '[') {
            return javaName.replace('.', '/');
        }
        if (primitiveMap.containsKey((Object)javaName)) {
            return (String)primitiveMap.get((Object)javaName);
        }
        return 'L' + javaName.replace('.', '/') + ';';
    }

    public static String dexToJavaName(String dexName) {
        if (dexName.charAt(0) == '[') {
            return dexName.replace('/', '.');
        }
        if (primitiveMap.inverse().containsKey((Object)dexName)) {
            return (String)primitiveMap.inverse().get((Object)dexName);
        }
        return dexName.replace('/', '.').substring(1, dexName.length() - 1);
    }
}

