/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked;

import com.android.tools.smali.dexlib2.base.BaseTryBlock;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedCatchAllExceptionHandler;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedExceptionHandler;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedTypedExceptionHandler;
import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.util.VariableSizeList;
import java.util.List;
import javax.annotation.Nonnull;

public class DexBackedTryBlock
extends BaseTryBlock<DexBackedExceptionHandler> {
    @Nonnull
    public final DexBackedDexFile dexFile;
    private final int tryItemOffset;
    private final int handlersStartOffset;

    public DexBackedTryBlock(@Nonnull DexBackedDexFile dexFile, int tryItemOffset, int handlersStartOffset) {
        this.dexFile = dexFile;
        this.tryItemOffset = tryItemOffset;
        this.handlersStartOffset = handlersStartOffset;
    }

    @Override
    public int getStartCodeAddress() {
        return this.dexFile.getDataBuffer().readSmallUint(this.tryItemOffset + 0);
    }

    @Override
    public int getCodeUnitCount() {
        return this.dexFile.getDataBuffer().readUshort(this.tryItemOffset + 4);
    }

    @Override
    @Nonnull
    public List<? extends DexBackedExceptionHandler> getExceptionHandlers() {
        DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(this.handlersStartOffset + this.dexFile.getDataBuffer().readUshort(this.tryItemOffset + 6));
        int encodedSize = reader.readSleb128();
        if (encodedSize > 0) {
            return new VariableSizeList<DexBackedTypedExceptionHandler>(this.dexFile.getDataBuffer(), reader.getOffset(), encodedSize){

                @Override
                @Nonnull
                protected DexBackedTypedExceptionHandler readNextItem(@Nonnull DexReader reader, int index) {
                    return new DexBackedTypedExceptionHandler(DexBackedTryBlock.this.dexFile, reader);
                }
            };
        }
        final int sizeWithCatchAll = -1 * encodedSize + 1;
        return new VariableSizeList<DexBackedExceptionHandler>(this.dexFile.getDataBuffer(), reader.getOffset(), sizeWithCatchAll){

            @Override
            @Nonnull
            protected DexBackedExceptionHandler readNextItem(@Nonnull DexReader dexReader, int index) {
                if (index == sizeWithCatchAll - 1) {
                    return new DexBackedCatchAllExceptionHandler(dexReader);
                }
                return new DexBackedTypedExceptionHandler(DexBackedTryBlock.this.dexFile, dexReader);
            }
        };
    }
}

