/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto.handshake;

import androidx.tracing.perfetto.handshake.PerfettoSdkHandshakeException;
import androidx.tracing.perfetto.handshake.PerfettoSdkSideloader;
import androidx.tracing.perfetto.handshake.protocol.Response;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\"Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012-\u0010\u0004\u001a)\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t0\u0005\u0012%\u0010\n\u001a!\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00030\u0005j\u0002`\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u0012\u0010\u0015\u001a\u00020\u000f2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0016\u0010\u001a\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001cH\u0002J-\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00032\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010!R-\u0010\n\u001a!\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00030\u0005j\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u0004\u001a)\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake;", "", "targetPackage", "", "parseJsonMap", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "jsonString", "", "executeShellCommand", "command", "Landroidx/tracing/perfetto/handshake/ShellCommandExecutor;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "disableTracingColdStart", "Landroidx/tracing/perfetto/handshake/protocol/Response;", "enableTracingColdStart", "persistent", "", "librarySource", "Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake$LibrarySource;", "enableTracingImmediate", "killAppProcess", "", "parseResponse", "rawResponse", "safeExecute", "block", "Lkotlin/Function0;", "sendTracingBroadcast", "action", "libPath", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;Ljava/lang/Boolean;)Landroidx/tracing/perfetto/handshake/protocol/Response;", "LibrarySource", "tracing-perfetto-handshake"})
@SourceDebugExtension(value={"SMAP\nPerfettoSdkHandshake.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoSdkHandshake.kt\nandroidx/tracing/perfetto/handshake/PerfettoSdkHandshake\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,291:1\n288#2,2:292\n288#2,2:294\n*S KotlinDebug\n*F\n+ 1 PerfettoSdkHandshake.kt\nandroidx/tracing/perfetto/handshake/PerfettoSdkHandshake\n*L\n169#1:292,2\n189#1:294,2\n*E\n"})
public final class PerfettoSdkHandshake {
    @NotNull
    private final String targetPackage;
    @NotNull
    private final Function1<String, Map<String, String>> parseJsonMap;
    @NotNull
    private final Function1<String, String> executeShellCommand;

    public PerfettoSdkHandshake(@NotNull String targetPackage, @NotNull Function1<? super String, ? extends Map<String, String>> parseJsonMap, @NotNull Function1<? super String, String> executeShellCommand) {
        Intrinsics.checkNotNullParameter((Object)targetPackage, (String)"targetPackage");
        Intrinsics.checkNotNullParameter(parseJsonMap, (String)"parseJsonMap");
        Intrinsics.checkNotNullParameter(executeShellCommand, (String)"executeShellCommand");
        this.targetPackage = targetPackage;
        this.parseJsonMap = parseJsonMap;
        this.executeShellCommand = executeShellCommand;
    }

    @NotNull
    public final Response enableTracingImmediate(@Nullable LibrarySource librarySource) {
        return this.safeExecute((Function0<Response>)((Function0)new Function0<Response>(librarySource, this){
            final /* synthetic */ LibrarySource $librarySource;
            final /* synthetic */ PerfettoSdkHandshake this$0;
            {
                this.$librarySource = $librarySource;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @NotNull
            public final Response invoke() {
                File file;
                LibrarySource librarySource = this.$librarySource;
                if (librarySource != null) {
                    LibrarySource librarySource2 = librarySource;
                    PerfettoSdkHandshake perfettoSdkHandshake = this.this$0;
                    LibrarySource $this$invoke_u24lambda_u240 = librarySource2;
                    boolean bl = false;
                    if (!($this$invoke_u24lambda_u240 instanceof LibrarySource.ZipLibrarySource)) throw new NoWhenBranchMatchedException();
                    file = new PerfettoSdkSideloader(PerfettoSdkHandshake.access$getTargetPackage$p(perfettoSdkHandshake)).sideloadFromZipFile(((LibrarySource.ZipLibrarySource)$this$invoke_u24lambda_u240).getLibraryZip$tracing_perfetto_handshake(), ((LibrarySource.ZipLibrarySource)$this$invoke_u24lambda_u240).getTempDirectory$tracing_perfetto_handshake(), (Function1<? super String, String>)PerfettoSdkHandshake.access$getExecuteShellCommand$p(perfettoSdkHandshake), ((LibrarySource.ZipLibrarySource)$this$invoke_u24lambda_u240).getMoveLibFileFromTmpDirToAppDir$tracing_perfetto_handshake());
                } else {
                    file = null;
                }
                File libPath = file;
                return PerfettoSdkHandshake.sendTracingBroadcast$default(this.this$0, "androidx.tracing.perfetto.action.ENABLE_TRACING", libPath, null, 4, null);
            }
        }));
    }

    public static /* synthetic */ Response enableTracingImmediate$default(PerfettoSdkHandshake perfettoSdkHandshake, LibrarySource librarySource, int n, Object object) {
        if ((n & 1) != 0) {
            librarySource = null;
        }
        return perfettoSdkHandshake.enableTracingImmediate(librarySource);
    }

    @JvmOverloads
    @NotNull
    public final Response enableTracingColdStart(boolean persistent, @Nullable LibrarySource librarySource) {
        return this.safeExecute((Function0<Response>)((Function0)new Function0<Response>(librarySource, this, persistent){
            final /* synthetic */ LibrarySource $librarySource;
            final /* synthetic */ PerfettoSdkHandshake this$0;
            final /* synthetic */ boolean $persistent;
            {
                this.$librarySource = $librarySource;
                this.this$0 = $receiver;
                this.$persistent = $persistent;
                super(0);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @NotNull
            public final Response invoke() {
                File file;
                LibrarySource librarySource = this.$librarySource;
                if (librarySource != null) {
                    LibrarySource librarySource2 = librarySource;
                    PerfettoSdkHandshake perfettoSdkHandshake = this.this$0;
                    LibrarySource $this$invoke_u24lambda_u240 = librarySource2;
                    boolean bl = false;
                    if (!($this$invoke_u24lambda_u240 instanceof LibrarySource.ZipLibrarySource)) throw new NoWhenBranchMatchedException();
                    file = new PerfettoSdkSideloader(PerfettoSdkHandshake.access$getTargetPackage$p(perfettoSdkHandshake)).sideloadFromZipFile(((LibrarySource.ZipLibrarySource)$this$invoke_u24lambda_u240).getLibraryZip$tracing_perfetto_handshake(), ((LibrarySource.ZipLibrarySource)$this$invoke_u24lambda_u240).getTempDirectory$tracing_perfetto_handshake(), (Function1<? super String, String>)PerfettoSdkHandshake.access$getExecuteShellCommand$p(perfettoSdkHandshake), ((LibrarySource.ZipLibrarySource)$this$invoke_u24lambda_u240).getMoveLibFileFromTmpDirToAppDir$tracing_perfetto_handshake());
                } else {
                    file = null;
                }
                File libPath = file;
                PerfettoSdkHandshake.access$killAppProcess(this.this$0);
                Response response = PerfettoSdkHandshake.access$sendTracingBroadcast(this.this$0, "androidx.tracing.perfetto.action.ENABLE_TRACING_COLD_START", libPath, this.$persistent);
                PerfettoSdkHandshake.access$killAppProcess(this.this$0);
                return response;
            }
        }));
    }

    public static /* synthetic */ Response enableTracingColdStart$default(PerfettoSdkHandshake perfettoSdkHandshake, boolean bl, LibrarySource librarySource, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            librarySource = null;
        }
        return perfettoSdkHandshake.enableTracingColdStart(bl, librarySource);
    }

    @NotNull
    public final Response disableTracingColdStart() {
        return this.safeExecute((Function0<Response>)((Function0)new Function0<Response>(this){
            final /* synthetic */ PerfettoSdkHandshake this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                Response response = PerfettoSdkHandshake.sendTracingBroadcast$default(this.this$0, "androidx.tracing.perfetto.action.DISABLE_TRACING_COLD_START", null, null, 6, null);
                PerfettoSdkHandshake perfettoSdkHandshake = this.this$0;
                Response it = response;
                boolean bl = false;
                PerfettoSdkHandshake.access$killAppProcess(perfettoSdkHandshake);
                return response;
            }
        }));
    }

    private final Response sendTracingBroadcast(String action, File libPath, Boolean persistent) {
        Response response;
        StringBuilder commandBuilder = new StringBuilder("am broadcast -a " + action);
        if (persistent != null) {
            commandBuilder.append(" --es persistent " + persistent);
        }
        if (libPath != null) {
            commandBuilder.append(" --es path " + libPath);
        }
        commandBuilder.append(' ' + this.targetPackage + "/androidx.tracing.perfetto.TracingReceiver");
        String string = commandBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandBuilder.toString()");
        String rawResponse = (String)this.executeShellCommand.invoke((Object)string);
        try {
            response = this.parseResponse(rawResponse);
        }
        catch (Exception e) {
            throw new PerfettoSdkHandshakeException("Exception occurred while trying to parse a response. Error: " + e.getMessage() + ". Raw response: " + rawResponse + '.');
        }
        return response;
    }

    static /* synthetic */ Response sendTracingBroadcast$default(PerfettoSdkHandshake perfettoSdkHandshake, String string, File file, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        return perfettoSdkHandshake.sendTracingBroadcast(string, file, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final Response parseResponse(String rawResponse) {
        String string;
        Object v4;
        Object object;
        String $this$firstOrNull$iv;
        Integer broadcastResponseCode;
        Object object2;
        block10: {
            Object v0;
            Object element$iv;
            block9: {
                void $this$firstOrNull$iv2;
                Object object3 = rawResponse;
                Regex regex = new Regex("\r?\n");
                int n = 0;
                object3 = regex.split((CharSequence)object3, n);
                boolean $i$f$firstOrNull = false;
                object2 = $this$firstOrNull$iv2.iterator();
                while (object2.hasNext()) {
                    element$iv = object2.next();
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"Broadcast completed: result=", (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            String string2 = v0;
            if (string2 == null) {
                throw new PerfettoSdkHandshakeException("Cannot parse: " + rawResponse);
            }
            String line = string2;
            if (Intrinsics.areEqual((Object)line, (Object)"Broadcast completed: result=0")) {
                return new Response(0, null, null);
            }
            MatchResult matchResult = new Regex("Broadcast completed: (result=.*?)(, data=\".*?\")?(, extras: .*)?").matchEntire((CharSequence)line);
            if (matchResult == null) {
                throw new PerfettoSdkHandshakeException("Cannot parse: " + rawResponse);
            }
            MatchResult matchResult2 = matchResult;
            MatchGroup $i$f$firstOrNull = matchResult2.getGroups().get(1);
            broadcastResponseCode = $i$f$firstOrNull != null && (object2 = $i$f$firstOrNull.getValue()) != null && (element$iv = StringsKt.substringAfter$default((String)object2, (String)"result=", null, (int)2, null)) != null ? StringsKt.toIntOrNull(element$iv) : null;
            element$iv = (Iterable)matchResult2.getGroups();
            boolean $i$f$firstOrNull2 = false;
            object = $this$firstOrNull$iv.iterator();
            while (object.hasNext()) {
                Object element$iv2 = object.next();
                MatchGroup it = (MatchGroup)element$iv2;
                boolean bl = false;
                Object object4 = it;
                if (!(object4 != null && (object4 = object4.getValue()) != null ? StringsKt.startsWith$default((String)object4, (String)", data=", (boolean)false, (int)2, null) : false)) continue;
                v4 = element$iv2;
                break block10;
            }
            v4 = null;
        }
        object2 = v4;
        if (object2 == null || ($this$firstOrNull$iv = object2.getValue()) == null || (string = StringsKt.substringAfter$default((String)$this$firstOrNull$iv, (String)", data=\"", null, (int)2, null)) == null || (object = StringsKt.dropLast((String)string, (int)1)) == null) {
            throw new PerfettoSdkHandshakeException("Cannot parse: " + rawResponse + ". Unable to detect 'data=' section.");
        }
        Object dataString = object;
        Map dataMap = (Map)this.parseJsonMap.invoke(dataString);
        String string3 = (String)dataMap.get("exitCode");
        if (string3 == null) {
            throw new PerfettoSdkHandshakeException("Response missing exitCode value");
        }
        String string4 = (String)dataMap.get("requiredVersion");
        if (string4 == null) {
            throw new PerfettoSdkHandshakeException("Response missing requiredVersion value");
        }
        Response response = new Response(Integer.parseInt(string3), string4, (String)dataMap.get("message"));
        Integer n = broadcastResponseCode;
        int n2 = response.getResultCode();
        if (n == null || n != n2) {
            throw new PerfettoSdkHandshakeException("Cannot parse: " + rawResponse + ". Result code not matching broadcast result code.");
        }
        return response;
    }

    private final Response safeExecute(Function0<Response> block) {
        Response response;
        try {
            response = (Response)block.invoke();
        }
        catch (Exception exception) {
            response = new Response(99, null, exception.getMessage());
        }
        return response;
    }

    private final void killAppProcess() {
        boolean isRootSession = StringsKt.contains$default((CharSequence)((CharSequence)this.executeShellCommand.invoke((Object)"id")), (CharSequence)"uid=0(root)", (boolean)false, (int)2, null);
        String result = isRootSession ? (String)this.executeShellCommand.invoke((Object)("killall " + this.targetPackage)) : (String)this.executeShellCommand.invoke((Object)("am force-stop " + this.targetPackage));
        if (!StringsKt.isBlank((CharSequence)result) && !StringsKt.contains$default((CharSequence)result, (CharSequence)"No such process", (boolean)false, (int)2, null)) {
            throw new PerfettoSdkHandshakeException("Issue while trying to kill app process: " + result);
        }
    }

    @JvmOverloads
    @NotNull
    public final Response enableTracingColdStart(boolean persistent) {
        return PerfettoSdkHandshake.enableTracingColdStart$default(this, persistent, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Response enableTracingColdStart() {
        return PerfettoSdkHandshake.enableTracingColdStart$default(this, false, null, 3, null);
    }

    public static final /* synthetic */ String access$getTargetPackage$p(PerfettoSdkHandshake $this) {
        return $this.targetPackage;
    }

    public static final /* synthetic */ Function1 access$getExecuteShellCommand$p(PerfettoSdkHandshake $this) {
        return $this.executeShellCommand;
    }

    public static final /* synthetic */ void access$killAppProcess(PerfettoSdkHandshake $this) {
        $this.killAppProcess();
    }

    public static final /* synthetic */ Response access$sendTracingBroadcast(PerfettoSdkHandshake $this, String action, File libPath, Boolean persistent) {
        return $this.sendTracingBroadcast(action, libPath, persistent);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0001\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake$LibrarySource;", "", "()V", "Companion", "ZipLibrarySource", "Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake$LibrarySource$ZipLibrarySource;", "tracing-perfetto-handshake"})
    public static abstract class LibrarySource {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private LibrarySource() {
        }

        @JvmStatic
        @NotNull
        public static final LibrarySource aarLibrarySource(@NotNull File aarFile, @NotNull File tempDirectory, @NotNull Function2<? super File, ? super File, Unit> moveLibFileFromTmpDirToAppDir) {
            return Companion.aarLibrarySource(aarFile, tempDirectory, moveLibFileFromTmpDirToAppDir);
        }

        @JvmStatic
        @NotNull
        public static final LibrarySource apkLibrarySource(@NotNull File apkFile, @NotNull File tempDirectory, @NotNull Function2<? super File, ? super File, Unit> moveLibFileFromTmpDirToAppDir) {
            return Companion.apkLibrarySource(apkFile, tempDirectory, moveLibFileFromTmpDirToAppDir);
        }

        public /* synthetic */ LibrarySource(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062:\u0010\b\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\u0002`\u000fH\u0007JT\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062:\u0010\b\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\u0002`\u000fH\u0007\u00a8\u0006\u0012"}, d2={"Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake$LibrarySource$Companion;", "", "()V", "aarLibrarySource", "Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake$LibrarySource;", "aarFile", "Ljava/io/File;", "tempDirectory", "moveLibFileFromTmpDirToAppDir", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "srcFile", "dstFile", "", "Landroidx/tracing/perfetto/handshake/FileMover;", "apkLibrarySource", "apkFile", "tracing-perfetto-handshake"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final LibrarySource aarLibrarySource(@NotNull File aarFile, @NotNull File tempDirectory, @NotNull Function2<? super File, ? super File, Unit> moveLibFileFromTmpDirToAppDir) {
                Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
                Intrinsics.checkNotNullParameter((Object)tempDirectory, (String)"tempDirectory");
                Intrinsics.checkNotNullParameter(moveLibFileFromTmpDirToAppDir, (String)"moveLibFileFromTmpDirToAppDir");
                return new ZipLibrarySource(aarFile, tempDirectory, moveLibFileFromTmpDirToAppDir);
            }

            @JvmStatic
            @NotNull
            public final LibrarySource apkLibrarySource(@NotNull File apkFile, @NotNull File tempDirectory, @NotNull Function2<? super File, ? super File, Unit> moveLibFileFromTmpDirToAppDir) {
                Intrinsics.checkNotNullParameter((Object)apkFile, (String)"apkFile");
                Intrinsics.checkNotNullParameter((Object)tempDirectory, (String)"tempDirectory");
                Intrinsics.checkNotNullParameter(moveLibFileFromTmpDirToAppDir, (String)"moveLibFileFromTmpDirToAppDir");
                return new ZipLibrarySource(apkFile, tempDirectory, moveLibFileFromTmpDirToAppDir);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012:\u0010\u0005\u001a6\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006j\u0002`\f\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fRH\u0010\u0005\u001a6\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006j\u0002`\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0013"}, d2={"Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake$LibrarySource$ZipLibrarySource;", "Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake$LibrarySource;", "libraryZip", "Ljava/io/File;", "tempDirectory", "moveLibFileFromTmpDirToAppDir", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "srcFile", "dstFile", "", "Landroidx/tracing/perfetto/handshake/FileMover;", "(Ljava/io/File;Ljava/io/File;Lkotlin/jvm/functions/Function2;)V", "getLibraryZip$tracing_perfetto_handshake", "()Ljava/io/File;", "getMoveLibFileFromTmpDirToAppDir$tracing_perfetto_handshake", "()Lkotlin/jvm/functions/Function2;", "getTempDirectory$tracing_perfetto_handshake", "tracing-perfetto-handshake"})
        public static final class ZipLibrarySource
        extends LibrarySource {
            @NotNull
            private final File libraryZip;
            @NotNull
            private final File tempDirectory;
            @NotNull
            private final Function2<File, File, Unit> moveLibFileFromTmpDirToAppDir;

            public ZipLibrarySource(@NotNull File libraryZip, @NotNull File tempDirectory, @NotNull Function2<? super File, ? super File, Unit> moveLibFileFromTmpDirToAppDir) {
                Intrinsics.checkNotNullParameter((Object)libraryZip, (String)"libraryZip");
                Intrinsics.checkNotNullParameter((Object)tempDirectory, (String)"tempDirectory");
                Intrinsics.checkNotNullParameter(moveLibFileFromTmpDirToAppDir, (String)"moveLibFileFromTmpDirToAppDir");
                super(null);
                this.libraryZip = libraryZip;
                this.tempDirectory = tempDirectory;
                this.moveLibFileFromTmpDirToAppDir = moveLibFileFromTmpDirToAppDir;
            }

            @NotNull
            public final File getLibraryZip$tracing_perfetto_handshake() {
                return this.libraryZip;
            }

            @NotNull
            public final File getTempDirectory$tracing_perfetto_handshake() {
                return this.tempDirectory;
            }

            @NotNull
            public final Function2<File, File, Unit> getMoveLibFileFromTmpDirToAppDir$tracing_perfetto_handshake() {
                return this.moveLibFileFromTmpDirToAppDir;
            }
        }
    }
}

