/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.focus.FocusTargetNode;
import androidx.compose.ui.focus.FocusTraversalKt;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.LayoutNode;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/focus/FocusableChildrenComparator;", "Ljava/util/Comparator;", "Landroidx/compose/ui/focus/FocusTargetNode;", "Lkotlin/Comparator;", "()V", "compare", "", "focusTarget1", "focusTarget2", "pathFromRoot", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/ui/node/LayoutNode;", "layoutNode", "ui"})
@SourceDebugExtension(value={"SMAP\nOneDimensionalFocusSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OneDimensionalFocusSearch.kt\nandroidx/compose/ui/focus/FocusableChildrenComparator\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n*L\n1#1,263:1\n48#2:264\n523#2:265\n523#2:266\n1208#3:267\n1187#3,2:268\n*S KotlinDebug\n*F\n+ 1 OneDimensionalFocusSearch.kt\nandroidx/compose/ui/focus/FocusableChildrenComparator\n*L\n242#1:264\n246#1:265\n247#1:266\n254#1:267\n254#1:268,2\n*E\n"})
final class FocusableChildrenComparator
implements Comparator<FocusTargetNode> {
    @NotNull
    public static final FocusableChildrenComparator INSTANCE = new FocusableChildrenComparator();

    private FocusableChildrenComparator() {
    }

    @Override
    public int compare(@NotNull FocusTargetNode focusTarget1, @NotNull FocusTargetNode focusTarget2) {
        LayoutNode layoutNode2;
        Intrinsics.checkNotNullParameter((Object)focusTarget1, (String)"focusTarget1");
        Intrinsics.checkNotNullParameter((Object)focusTarget2, (String)"focusTarget2");
        if (!FocusTraversalKt.isEligibleForFocusSearch(focusTarget1) || !FocusTraversalKt.isEligibleForFocusSearch(focusTarget2)) {
            if (FocusTraversalKt.isEligibleForFocusSearch(focusTarget1)) {
                return -1;
            }
            if (FocusTraversalKt.isEligibleForFocusSearch(focusTarget2)) {
                return 1;
            }
            return 0;
        }
        LayoutNode layoutNode1 = DelegatableNodeKt.requireLayoutNode(focusTarget1);
        if (Intrinsics.areEqual((Object)layoutNode1, (Object)(layoutNode2 = DelegatableNodeKt.requireLayoutNode(focusTarget2)))) {
            return 0;
        }
        MutableVector<LayoutNode> pathFromRoot1 = this.pathFromRoot(layoutNode1);
        MutableVector<LayoutNode> pathFromRoot2 = this.pathFromRoot(layoutNode2);
        int depth = 0;
        MutableVector<LayoutNode> this_$iv22 = pathFromRoot1;
        boolean $i$f$getLastIndex = false;
        int this_$iv22 = this_$iv22.getSize() - 1;
        MutableVector<LayoutNode> this_$iv32 = pathFromRoot2;
        boolean $i$f$getLastIndex2 = false;
        int this_$iv32 = this_$iv32.getSize() - 1;
        int n = Math.min(this_$iv22, this_$iv32);
        if (depth <= n) {
            while (true) {
                MutableVector<LayoutNode> this_$iv = pathFromRoot1;
                boolean $i$f$get = false;
                Object object = this_$iv.getContent()[depth];
                this_$iv = pathFromRoot2;
                $i$f$get = false;
                if (!Intrinsics.areEqual((Object)object, (Object)this_$iv.getContent()[depth])) {
                    this_$iv = pathFromRoot1;
                    $i$f$get = false;
                    int n2 = ((LayoutNode)this_$iv.getContent()[depth]).getPlaceOrder$ui();
                    this_$iv = pathFromRoot2;
                    $i$f$get = false;
                    return Intrinsics.compare((int)n2, (int)((LayoutNode)this_$iv.getContent()[depth]).getPlaceOrder$ui());
                }
                if (depth == n) break;
                ++depth;
            }
        }
        throw new IllegalStateException("Could not find a common ancestor between the two FocusModifiers.".toString());
    }

    private final MutableVector<LayoutNode> pathFromRoot(LayoutNode layoutNode2) {
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        MutableVector path = new MutableVector((Object[])new LayoutNode[capacity$iv$iv], 0);
        for (LayoutNode current = layoutNode2; current != null; current = current.getParent$ui()) {
            path.add(0, (Object)current);
        }
        return path;
    }
}

