/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp;

import com.android.tools.utp.TaskOutputProcessorKt;
import com.android.tools.utp.TaskOutputProcessorListener;
import com.android.tools.utp.plugins.result.listener.gradle.proto.GradleAndroidTestResultListenerProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/utp/TaskOutputProcessor;", "", "listeners", "", "", "Lcom/android/tools/utp/TaskOutputProcessorListener;", "<init>", "(Ljava/util/Map;)V", "getListeners", "()Ljava/util/Map;", "process", "stdout", "processLine", "", "line", "processEvent", "", "event", "Lcom/android/tools/utp/plugins/result/listener/gradle/proto/GradleAndroidTestResultListenerProto$TestResultEvent;", "processTestSuiteStarted", "processTestCaseStarted", "processTestCaseFinished", "processTestSuiteFinished", "Companion", "utp"})
public final class TaskOutputProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, TaskOutputProcessorListener> listeners;
    @NotNull
    public static final String ON_RESULT_OPENING_TAG = "<UTP_TEST_RESULT_ON_TEST_RESULT_EVENT>";
    @NotNull
    public static final String ON_RESULT_CLOSING_TAG = "</UTP_TEST_RESULT_ON_TEST_RESULT_EVENT>";

    public TaskOutputProcessor(@NotNull Map<String, ? extends TaskOutputProcessorListener> listeners) {
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        this.listeners = listeners;
    }

    @NotNull
    public final Map<String, TaskOutputProcessorListener> getListeners() {
        return this.listeners;
    }

    @NotNull
    public final String process(@NotNull String stdout) {
        Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.filterNot((Sequence)StringsKt.lineSequence((CharSequence)stdout), (Function1)((Function1)new Function1<String, Boolean>((Object)this){

            public final Boolean invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return TaskOutputProcessor.access$processLine((TaskOutputProcessor)this.receiver, p0);
            }
        })), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final boolean processLine(String line) {
        boolean bl;
        String trimmedLine = ((Object)StringsKt.trim((CharSequence)line)).toString();
        if (StringsKt.startsWith$default((String)trimmedLine, (String)ON_RESULT_OPENING_TAG, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)line, (String)ON_RESULT_CLOSING_TAG, (boolean)false, (int)2, null)) {
            String base64EncodedProto = StringsKt.removeSurrounding((String)trimmedLine, (CharSequence)ON_RESULT_OPENING_TAG, (CharSequence)ON_RESULT_CLOSING_TAG);
            GradleAndroidTestResultListenerProto.TestResultEvent eventProto = TaskOutputProcessorKt.access$decodeBase64EncodedProto(base64EncodedProto);
            this.processEvent(eventProto);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void processEvent(GradleAndroidTestResultListenerProto.TestResultEvent event) {
        GradleAndroidTestResultListenerProto.TestResultEvent.StateCase stateCase = event.getStateCase();
        switch (stateCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[stateCase.ordinal()]) {
            case 1: {
                this.processTestSuiteStarted(event);
                break;
            }
            case 2: {
                this.processTestCaseStarted(event);
                break;
            }
            case 3: {
                this.processTestCaseFinished(event);
                break;
            }
            case 4: {
                this.processTestSuiteFinished(event);
            }
        }
    }

    private final void processTestSuiteStarted(GradleAndroidTestResultListenerProto.TestResultEvent event) {
        block0: {
            GradleAndroidTestResultListenerProto.TestResultEvent.TestSuiteStarted testSuiteStarted = event.getTestSuiteStarted();
            TestSuiteResultProto.TestSuiteMetaData testSuite = (TestSuiteResultProto.TestSuiteMetaData)testSuiteStarted.getTestSuiteMetadata().unpack(TestSuiteResultProto.TestSuiteMetaData.class);
            TaskOutputProcessorListener taskOutputProcessorListener = this.listeners.get(event.getDeviceId());
            if (taskOutputProcessorListener == null) break block0;
            Intrinsics.checkNotNull((Object)testSuite);
            taskOutputProcessorListener.onTestSuiteStarted(testSuite);
        }
    }

    private final void processTestCaseStarted(GradleAndroidTestResultListenerProto.TestResultEvent event) {
        block0: {
            GradleAndroidTestResultListenerProto.TestResultEvent.TestCaseStarted testCaseStarted = event.getTestCaseStarted();
            TestCaseProto.TestCase testCase = (TestCaseProto.TestCase)testCaseStarted.getTestCase().unpack(TestCaseProto.TestCase.class);
            TaskOutputProcessorListener taskOutputProcessorListener = this.listeners.get(event.getDeviceId());
            if (taskOutputProcessorListener == null) break block0;
            Intrinsics.checkNotNull((Object)testCase);
            taskOutputProcessorListener.onTestCaseStarted(testCase);
        }
    }

    private final void processTestCaseFinished(GradleAndroidTestResultListenerProto.TestResultEvent event) {
        block0: {
            GradleAndroidTestResultListenerProto.TestResultEvent.TestCaseFinished testCaseFinished = event.getTestCaseFinished();
            TestResultProto.TestResult testCaseResult = (TestResultProto.TestResult)testCaseFinished.getTestCaseResult().unpack(TestResultProto.TestResult.class);
            TaskOutputProcessorListener taskOutputProcessorListener = this.listeners.get(event.getDeviceId());
            if (taskOutputProcessorListener == null) break block0;
            Intrinsics.checkNotNull((Object)testCaseResult);
            taskOutputProcessorListener.onTestCaseFinished(testCaseResult);
        }
    }

    private final void processTestSuiteFinished(GradleAndroidTestResultListenerProto.TestResultEvent event) {
        block0: {
            GradleAndroidTestResultListenerProto.TestResultEvent.TestSuiteFinished testSuiteFinished = event.getTestSuiteFinished();
            TestSuiteResultProto.TestSuiteResult testSuiteResult = (TestSuiteResultProto.TestSuiteResult)testSuiteFinished.getTestSuiteResult().unpack(TestSuiteResultProto.TestSuiteResult.class);
            TaskOutputProcessorListener taskOutputProcessorListener = this.listeners.get(event.getDeviceId());
            if (taskOutputProcessorListener == null) break block0;
            Intrinsics.checkNotNull((Object)testSuiteResult);
            taskOutputProcessorListener.onTestSuiteFinished(testSuiteResult);
        }
    }

    public static final /* synthetic */ boolean access$processLine(TaskOutputProcessor $this, String line) {
        return $this.processLine(line);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/utp/TaskOutputProcessor$Companion;", "", "<init>", "()V", "ON_RESULT_OPENING_TAG", "", "ON_RESULT_CLOSING_TAG", "utp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.values().length];
            try {
                nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_SUITE_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_CASE_STARTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_CASE_FINISHED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_SUITE_FINISHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

