/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profiler;

import com.android.tools.profiler.asm.ClassVisitor;
import com.android.tools.profiler.asm.MethodVisitor;
import com.android.tools.profiler.asm.Opcodes;

final class HttpURLAdapter
extends ClassVisitor
implements Opcodes {
    static final String URL_CLASS = "java/net/URL";
    static final String WRAPPER_CLASS = "com/android/tools/profiler/support/network/httpurl/HttpURLWrapper";

    HttpURLAdapter(ClassVisitor classVisitor) {
        super(458752, classVisitor);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return mv != null ? new MethodAdapter(mv) : null;
    }

    private static final class MethodAdapter
    extends MethodVisitor
    implements Opcodes {
        public MethodAdapter(MethodVisitor mv) {
            super(458752, mv);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode != 182 || !owner.equals(HttpURLAdapter.URL_CLASS)) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                return;
            }
            assert (!itf);
            if (name.equals("openConnection") && desc.equals("()Ljava/net/URLConnection;")) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                this.invoke("wrapURLConnection", "(Ljava/net/URLConnection;)Ljava/net/URLConnection;");
            } else if (name.equals("openConnection") && desc.equals("(Ljava/net/Proxy;)Ljava/net/URLConnection;")) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                this.invoke("wrapURLConnection", "(Ljava/net/URLConnection;)Ljava/net/URLConnection;");
            } else if (name.equals("openStream") && desc.equals("()Ljava/io/InputStream;")) {
                this.invoke("wrapOpenStream", "(Ljava/net/URL;)Ljava/io/InputStream;");
            } else if (name.equals("getContent") && desc.equals("()Ljava/lang/Object;")) {
                this.invoke("wrapGetContent", "(Ljava/net/URL;)Ljava/lang/Object;");
            } else if (name.equals("getContent") && desc.equals("([Ljava/lang/Class;)Ljava/lang/Object;")) {
                this.invoke("wrapGetContent", "(Ljava/net/URL;[Ljava/lang/Class;)Ljava/lang/Object;");
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }

        private void invoke(String method, String desc) {
            super.visitMethodInsn(184, HttpURLAdapter.WRAPPER_CLASS, method, desc, false);
        }
    }
}

