/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.instrumentation.threading.agent;

import com.android.tools.instrumentation.threading.agent.AnnotationMappings;
import com.android.tools.instrumentation.threading.agent.CheckerMethodRef;
import com.android.tools.instrumentation.threading.org.objectweb.asm.AnnotationVisitor;
import com.android.tools.instrumentation.threading.org.objectweb.asm.MethodVisitor;
import com.android.tools.instrumentation.threading.org.objectweb.asm.Type;
import com.android.tools.instrumentation.threading.org.objectweb.asm.commons.AdviceAdapter;
import com.android.tools.instrumentation.threading.org.objectweb.asm.commons.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public class InstrumentMethodVisitor
extends AdviceAdapter {
    private static final Logger LOGGER = Logger.getLogger(InstrumentMethodVisitor.class.getName());
    private final AnnotationMappings annotationMappings;
    private final String className;
    private final String methodName;
    private final String classThreadingAnnotation;
    private List<String> threadingAnnotations;

    public InstrumentMethodVisitor(MethodVisitor methodVisitor, AnnotationMappings annotationMappings, String classThreadingAnnotation, String className, int access, String name, String desc) {
        super(458752, methodVisitor, access, name, desc);
        this.annotationMappings = annotationMappings;
        this.classThreadingAnnotation = classThreadingAnnotation;
        this.className = className;
        this.methodName = name;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.annotationMappings.isThreadingAnnotation(desc)) {
            if (this.threadingAnnotations == null) {
                this.threadingAnnotations = new ArrayList<String>(1);
            }
            this.threadingAnnotations.add(desc);
        }
        return super.visitAnnotation(desc, visible);
    }

    @Override
    protected void onMethodEnter() {
        super.onMethodEnter();
        if (this.threadingAnnotations == null && this.classThreadingAnnotation == null) {
            return;
        }
        if ((this.methodAccess & 0x1000) != 0 || this.methodName.contains("$lambda$")) {
            if (this.threadingAnnotations != null && (this.methodAccess & 0x40) == 0) {
                LOGGER.warning("Threading annotation found on a generated method which is not a bridge method. " + this.className + "#" + this.methodName);
            }
            return;
        }
        List<String> effectiveThreadingAnnotations = this.threadingAnnotations != null ? this.threadingAnnotations : Collections.singletonList(this.classThreadingAnnotation);
        for (String effectiveThreadingAnnotation : effectiveThreadingAnnotations) {
            LOGGER.fine(String.format("Processed a threading annotation '%s' on %s#%s", effectiveThreadingAnnotation, this.className, this.methodName));
            Optional<CheckerMethodRef> checkerMethodRef = this.annotationMappings.getCheckerMethodForThreadingAnnotation(effectiveThreadingAnnotation);
            checkerMethodRef.ifPresent(cmr -> this.generateStaticCall(cmr.getClassName(), cmr.getMethodName()));
        }
    }

    private void generateStaticCall(String className, String methodName) {
        try {
            Type staticClassType = Type.getType(Class.forName(className));
            Method staticClassMethod = Method.getMethod(String.format("void %s()", methodName));
            this.invokeStatic(staticClassType, staticClassMethod);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning("Threading agent: unable to instrument an annotated method. Class " + className + " not found");
        }
    }
}

