/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowablePairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.psi.OCExternalResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ClangExternalResolver
implements OCExternalResolver {
    private static final Logger LOG = Logger.getInstance((String)ClangExternalResolver.class.getName());
    private static final Key<CachedValue<Map<Integer, List<OCExternalResolver.Resolved>>>> TEST_CLANG_RESOLVE_CACHE = Key.create((String)"TEST_CLANG_RESOLVE_CACHE");
    private static final long CLANG_RESPONSE_TIMEOUT_MS = ApplicationManager.getApplication().isUnitTestMode() ? 30000L : Long.MAX_VALUE;

    private static List<OCExternalResolver.Resolved> doResolve(@NotNull PsiFile file, int offset, @NotNull ThrowablePairConsumer<ClangLanguageService, Ref<List<ClangSym>>, Exception> resolveFn) {
        List<OCExternalResolver.Resolved> result;
        ClangLocalWorkspace workspace;
        CachedValueProvider provider;
        CachedValuesManager manager;
        ClangLanguageService service;
        if (file == null) {
            ClangExternalResolver.$$$reportNull$$$0(0);
        }
        if (resolveFn == null) {
            ClangExternalResolver.$$$reportNull$$$0(1);
        }
        if ((service = ClangLanguageServiceProvider.getIfStarted((Project)file.getProject())) == null) {
            return Collections.emptyList();
        }
        if (!ClangUtils.isNavigationViaClangd((Project)file.getProject())) {
            return Collections.emptyList();
        }
        Project project = file.getProject();
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        Map cache = null;
        if (ApplicationManager.getApplication().isUnitTestMode() && (cache = (Map)(manager = CachedValuesManager.getManager((Project)project)).getCachedValue((UserDataHolder)file, TEST_CLANG_RESOLVE_CACHE, provider = () -> new CachedValueProvider.Result(new ConcurrentHashMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false)).containsKey(offset)) {
            return (List)cache.get(offset);
        }
        SimpleOpenRequestId openRequestId = null;
        if (ClangdBridge.CLANG_CAN_OPEN_FILE.get((UserDataHolder)project) != null && !((Boolean)(workspace = service.getContext().getLocalWorkspace()).apply(virtualFile.getUrl(), wf -> wf.isOpened())).booleanValue()) {
            openRequestId = new SimpleOpenRequestId(ExternalResolveUtils.class, "Opened [" + virtualFile.getPath() + "]");
            service.notifyDocumentOpened(virtualFile, (OpenRequestId)openRequestId);
        }
        Ref clangSymsRef = Ref.create();
        try {
            Ref exWrapper = Ref.create();
            ConcurrencyUtil.runUnderThreadName((String)(virtualFile.getName() + ":" + offset), () -> {
                try {
                    resolveFn.consume((Object)service, (Object)clangSymsRef);
                }
                catch (Exception ex) {
                    exWrapper.set((Object)ex);
                }
            });
            if (exWrapper.get() != null) {
                throw (Exception)exWrapper.get();
            }
        }
        catch (TimeoutException ex) {
            LOG.warn(ClangExternalResolver.toMessageWithOffset(ex, file, offset));
        }
        catch (ExecutionException ex) {
            ClangUtils.logServerException((Logger)LOG, (String)ClangExternalResolver.toMessageWithOffset(ex, file, offset), (ExecutionException)ex);
        }
        catch (Exception ex) {
            if (ex instanceof ControlFlowException) {
                ExceptionUtil.rethrow((Throwable)ex);
            }
            LOG.error(ClangExternalResolver.toMessageWithOffset(ex, file, offset), (Throwable)ex);
        }
        List clangSyms = (List)clangSymsRef.get();
        if (openRequestId != null && ClangdBridge.CLANG_DONT_CLOSE_FILE.get((UserDataHolder)project) == null) {
            service.notifyDocumentClosed(virtualFile, (OpenRequestId)openRequestId);
        }
        List<Object> list = result = !ContainerUtil.isEmpty((Collection)clangSyms) ? clangSyms.stream().filter(sym -> !sym.isMacro()).map(sym -> new OCExternalResolver.Resolved(sym.startLoc.file, sym.name, sym.startLoc.position.getLine(), sym.startLoc.position.getColumn())).collect(Collectors.toList()) : Collections.emptyList();
        if (cache != null) {
            cache.put(offset, result);
        }
        return result;
    }

    public void ensureUpToDate(@NotNull PsiFile file) {
        Project project;
        ClangLanguageService service;
        if (file == null) {
            ClangExternalResolver.$$$reportNull$$$0(2);
        }
        if ((service = ClangLanguageServiceProvider.getIfStarted((Project)(project = file.getProject()))) == null) {
            return;
        }
        if (!ClangUtils.isNavigationViaClangd((Project)project)) {
            return;
        }
        if (!ClangdSettings.getInstance((Project)project).getKeepObsoleteAst()) {
            return;
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        service.runWithParsed(virtualFile, response -> {
            if (response == null) {
                return;
            }
            try {
                ClangUtils.waitForClangFuture((Future)response.getDiagnostics());
            }
            catch (ExecutionException ex) {
                ClangUtils.logServerException((Logger)LOG, (String)ex.getMessage(), (ExecutionException)ex);
            }
        });
    }

    @NotNull
    public List<OCExternalResolver.Resolved> resolve(@NotNull PsiFile file, int offset) {
        if (file == null) {
            ClangExternalResolver.$$$reportNull$$$0(3);
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        List<OCExternalResolver.Resolved> list = ClangExternalResolver.doResolve(file, offset, (ThrowablePairConsumer<ClangLanguageService, Ref<List<ClangSym>>, Exception>)((ThrowablePairConsumer)(service, ref) -> service.gotoDefinition(virtualFile, offset, res -> ref.set((Object)((List)res.waitForResult(CLANG_RESPONSE_TIMEOUT_MS))))));
        if (list == null) {
            ClangExternalResolver.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<OCExternalResolver.Resolved> resolveType(@NotNull PsiFile file, int offset) {
        if (file == null) {
            ClangExternalResolver.$$$reportNull$$$0(5);
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        List<OCExternalResolver.Resolved> list = ClangExternalResolver.doResolve(file, offset, (ThrowablePairConsumer<ClangLanguageService, Ref<List<ClangSym>>, Exception>)((ThrowablePairConsumer)(service, ref) -> service.gotoTypeDeclaration(virtualFile, offset, res -> ref.set((Object)((List)res.waitForResult(CLANG_RESPONSE_TIMEOUT_MS))))));
        if (list == null) {
            ClangExternalResolver.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static String toMessageWithOffset(@NotNull Throwable original, @NotNull PsiFile file, int offset) {
        String string;
        if (original == null) {
            ClangExternalResolver.$$$reportNull$$$0(7);
        }
        if (file == null) {
            ClangExternalResolver.$$$reportNull$$$0(8);
        }
        try {
            string = "When resolving " + file.getName() + ":" + offset + " happened [" + original.getMessage() + "]";
        }
        catch (Throwable thr) {
            String string2 = original.getMessage();
            if (string2 == null) {
                ClangExternalResolver.$$$reportNull$$$0(10);
            }
            return string2;
        }
        if (string == null) {
            ClangExternalResolver.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveFn";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangExternalResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangExternalResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toMessageWithOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpToDate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toMessageWithOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 9, 10 -> new IllegalStateException(string);
        };
    }
}

