/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.ImmutableCharSequence;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.completion.ClangPostfixTemplateFlags;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdCompleteFileAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ClangdCompleteFileAction.$$$reportNull$$$0(0);
        }
        DataContext context = e.getDataContext();
        Project project = e.getProject();
        if (project != null) {
            VirtualFile vf = (VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE);
            AtomicInteger documentTextLength = new AtomicInteger(0);
            if (vf != null) {
                Lexer lexer = (Lexer)ReadAction.compute(() -> {
                    Document document = FileDocumentManager.getInstance().getDocument(vf);
                    if (document == null) {
                        return null;
                    }
                    documentTextLength.set(document.getTextLength());
                    SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)OCLanguage.getInstance(), (Project)project, (VirtualFile)vf);
                    Lexer result = syntaxHighlighter.getHighlightingLexer();
                    result.start(ImmutableCharSequence.asImmutable((CharSequence)document.getCharsSequence()), 0, document.getTextLength());
                    return result;
                });
                try {
                    if (documentTextLength.get() > 0) {
                        IElementType tok = lexer.getTokenType();
                        while (tok != null) {
                            if (tok == OCTokenTypes.IDENTIFIER) {
                                ClangdCompleteFileAction.codeCompleteAt(project, vf, lexer.getTokenStart());
                            }
                            lexer.advance();
                            tok = lexer.getTokenType();
                        }
                    }
                }
                catch (ExecutionException ex) {
                    CidrLogService.LOG.error((Throwable)ex);
                }
            }
        }
    }

    protected static void codeCompleteAt(@NotNull Project project, @NotNull VirtualFile file, int offset) throws ExecutionException {
        ClangLanguageService service;
        if (project == null) {
            ClangdCompleteFileAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            ClangdCompleteFileAction.$$$reportNull$$$0(2);
        }
        if ((service = ClangLanguageServiceProvider.getOrStart((Project)project)) == null) {
            ClangUtils.LOG.warn("Failed to getOrStart() ClangLanguageService");
            return;
        }
        int enabledPostfixTemplates = 0;
        for (ClangPostfixTemplateFlags flag : ClangPostfixTemplateFlags.values()) {
            enabledPostfixTemplates = (int)((long)enabledPostfixTemplates | flag.getValue());
        }
        Pair postfixTemplates = new Pair((Object)enabledPostfixTemplates, new ArrayList());
        @Nullable LineColumn lineColumn = (LineColumn)ReadAction.compute(() -> {
            ClangFileFacade helper = service.getClangIdeFacade().getFileFacade(file);
            return helper != null ? helper.getLineColumn(offset) : null;
        });
        int line = lineColumn != null ? lineColumn.line : 0;
        int column = lineColumn != null ? lineColumn.column : 0;
        CidrLogService.LOG.warn("Completing at " + file.getPath() + ":" + line + ":" + column + " (offset = " + offset + ")");
        service.complete(file, line, column, "", CompletionTriggerKind.Invoked, CLionCompletionKind.Default.getValue(), postfixTemplates, result -> result.waitForResult());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdCompleteFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "codeCompleteAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

