/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.format;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.DocumentUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColRange;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColReplace;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatChangeSettingsProvider;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatLog;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClangDaemonFormatProvider
implements ClangFormatChangeSettingsProvider {
    @NonNls
    private static final String ourErrorPreamble = "Problem with access to ClangFormat configuration: ";
    @NonNls
    private static final String ourClangFormatConfigureSourcePrefix = "# ClangFormatConfigureSource: ";
    @NonNls
    public static final String CF_CANCEL_FORMATTING_PREFIX = "// CIDR_CLANG_FORMAT_CANCEL";
    private static boolean ourDebugRangesForFormat = false;
    @NonNls
    private static final String PARSE_START = "Error reading";
    @NonNls
    private static final String WRONG_CFG_START = "Configuration file(s) do(es) not support";
    private static final Pattern CLANG_FORMAT_CONFIGURE_SOURCE = Pattern.compile("^#\\s*ClangFormatConfigureSource:\\s*'([^']*)'\\s*\n.*");

    @Override
    @Nullable
    public Consumer<CodeStyleSettings> getDisablingFunction(@NotNull Project project) {
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(0);
        }
        return settings -> {
            ClangFormatSettings clangFormatSettings = (ClangFormatSettings)settings.getCustomSettings(ClangFormatSettings.class);
            clangFormatSettings.ENABLED = false;
            ClangFormatChangeSettingsProvider.syncCurrentClangFormatSettings(project, settings, true);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    @NonNls
    public String findClangFormatContent(@NotNull Project project, @NotNull VirtualFile vfCodeFile) {
        ClangLanguageService service;
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(1);
        }
        if (vfCodeFile == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(2);
        }
        if ((service = ClangLanguageServiceProvider.getOrStart((Project)project)) != null) {
            String clangFormatContent;
            block13: {
                String string2;
                String cfPath = PathUtil.getParentPath((String)vfCodeFile.getPath()) + "/" + PathUtil.getFileName((String)vfCodeFile.getPath()) + "_clang_format";
                LightVirtualFile fakeCFFile = new LightVirtualFile(cfPath, vfCodeFile.getFileType(), ""){

                    @NotNull
                    public String getPath() {
                        String string = this.getName();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/clang/format/ClangDaemonFormatProvider$1", "getPath"));
                    }
                };
                SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(this.getClass(), cfPath);
                service.notifyDocumentOpened((VirtualFile)fakeCFFile, (OpenRequestId)openRequestId);
                CompletableFuture future = service.requestClangFormatConfiguration((VirtualFile)fakeCFFile);
                try {
                    clangFormatContent = (String)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)future, (String)".clang-format content");
                    if (clangFormatContent != null && !clangFormatContent.isEmpty()) break block13;
                    string2 = CFC_NO_CONTEXT_FUTURE;
                }
                catch (ExecutionException e) {
                    String clangFormatFileWithErrorURL;
                    OpenFileDescriptor fileDescriptor;
                    CidrLogService.logOnce((Level)Level.WARNING, (String)e.getMessage(), (Throwable)e);
                    @NotNull Throwable cause = e.getCause() != null ? e.getCause() : e;
                    @NotNull String message = cause.getMessage() != null ? cause.getMessage() : cause.getClass().toString();
                    ProcessedMessage pe = ClangDaemonFormatProvider.processMessage(StringUtil.notNullize((String)message, (String)e.toString()));
                    if (!pe.getClangFormatURLs().isEmpty() && (fileDescriptor = ClangDaemonFormatProvider.createOpenFileDescriptor(project, clangFormatFileWithErrorURL = pe.getClangFormatURLs().get(0))) != null) {
                        String string5 = ClangDaemonFormatProvider.getCFSourceCommentLine(fileDescriptor.getFile()) + ClangFormatFileUtils.getErrorStyleFor(message);
                        String string = string5;
                        if (string != null) return string;
                        ClangDaemonFormatProvider.$$$reportNull$$$0(5);
                        return string;
                    }
                    if (!pe.getFilteredMessage().isEmpty()) {
                        String string7 = ClangFormatFileUtils.getErrorStyleFor(ourErrorPreamble + message);
                        String string = string7;
                        if (string != null) return string;
                        ClangDaemonFormatProvider.$$$reportNull$$$0(6);
                        return string;
                    }
                }
                service.notifyDocumentClosed((VirtualFile)fakeCFFile, (OpenRequestId)openRequestId);
                String string = string2;
                if (string != null) return string;
                ClangDaemonFormatProvider.$$$reportNull$$$0(3);
                return string;
            }
            String string4 = clangFormatContent;
            String string = string4;
            if (string != null) return string;
            ClangDaemonFormatProvider.$$$reportNull$$$0(4);
            return string;
        }
        String string = CFC_WRONG_CONTEXT_FUTURE_RESPOND;
        if (string != null) return string;
        ClangDaemonFormatProvider.$$$reportNull$$$0(7);
        return string;
    }

    public static boolean isClangdCommunicationError(@NotNull String optionsOrErrorAsYAML) {
        if (optionsOrErrorAsYAML == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(8);
        }
        return CFC_NO_CONTEXT_FUTURE.equals(optionsOrErrorAsYAML) || CFC_WRONG_CONTEXT_FUTURE_RESPOND.equals(optionsOrErrorAsYAML);
    }

    @NotNull
    @NonNls
    public static String getCFSourceCommentLine(@NotNull VirtualFile cfvFile) {
        if (cfvFile == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(9);
        }
        String string = "# ClangFormatConfigureSource: 'clang-format-file://" + cfvFile.getCanonicalPath() + "'\n";
        if (string == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public boolean isApplicable(@NotNull Project project, @NotNull FileType fileType) {
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(11);
        }
        if (fileType == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(12);
        }
        return OCLanguageUtilsBase.isSupported((FileType)fileType);
    }

    @Override
    public boolean isActive(@NotNull Project project, @NotNull FileType fileType) {
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(13);
        }
        if (fileType == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(14);
        }
        return this.isApplicable(project, fileType) && ClangUtils.isClangdOn((Project)project);
    }

    @Nullable
    private static String styleForFormatting(@Nullable String style, @NotNull Project project) {
        String errorParsingMessageFromStyle;
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(15);
        }
        if ((errorParsingMessageFromStyle = ClangDaemonFormatProvider.getErrorParsingMessageFromStyle(style)) != null) {
            ClangDaemonFormatProvider.reportClangFormatError(errorParsingMessageFromStyle, project, MessageType.ERROR);
            return null;
        }
        return ClangDaemonFormatProvider.makeStyleLanguageAgnostic(style);
    }

    @NotNull
    private static String styleToKeepLineBreaks(@NotNull String style) {
        int index;
        if (style == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(16);
        }
        if ((index = ((String)style).indexOf("ColumnLimit:")) >= 0) {
            int lineEnd = ((String)style).indexOf("\n", index);
            style = ((String)style).substring(0, index) + "ColumnLimit: 0" + (lineEnd == -1 ? "" : ((String)style).substring(lineEnd));
        } else {
            style = (String)style + "ColumnLimit: 0\n";
        }
        Object object = style = (String)style + "KeepLineBreaksForNonEmptyLines: true\n";
        if (object == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(17);
        }
        return object;
    }

    @NotNull
    private static String styleWithoutSorting(@NotNull String style) {
        int lineEnd;
        int index;
        if (style == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(18);
        }
        if ((index = ((String)style).indexOf("SortIncludes:")) >= 0) {
            lineEnd = ((String)style).indexOf("\n", index);
            style = ((String)style).substring(0, index) + "SortIncludes: Never" + (lineEnd == -1 ? "" : ((String)style).substring(lineEnd));
        } else {
            style = (String)style + "SortIncludes: Never\n";
        }
        index = ((String)style).indexOf("SortUsingDeclarations:");
        if (index >= 0) {
            lineEnd = ((String)style).indexOf("\n", index);
            style = ((String)style).substring(0, index) + "SortUsingDeclarations: Never" + (lineEnd == -1 ? "" : ((String)style).substring(lineEnd));
        } else {
            style = (String)style + "SortUsingDeclarations: Never\n";
        }
        Object object = style;
        if (object == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(19);
        }
        return object;
    }

    private static void handleFormatException(@NotNull Exception e, @NotNull Project project) {
        if (e == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(20);
        }
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(21);
        }
        ClangFormatLog.LOG.error((Throwable)e);
    }

    private static boolean isInsideLiveTemplate(@NotNull Project project, @NotNull Document document) {
        Editor[] editors;
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(22);
        }
        if (document == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(23);
        }
        if ((editors = EditorFactory.getInstance().getEditors(document, project)).length == 0) {
            return false;
        }
        Template currentTemplate = TemplateManager.getInstance((Project)project).getActiveTemplate(editors[0]);
        return currentTemplate != null;
    }

    @Override
    @Nullable(value="return null if cannot guaranty the consistency of Psi and document before or after formatting procedure")
    public @Nullable(value="return null if cannot guaranty the consistency of Psi and document before or after formatting procedure") TextRange format(@NotNull PsiFile source, @NotNull TextRange range, @Nullable String style, boolean canChangeWhiteSpacesOnly, boolean keepLineBreaks, boolean enableBulkUpdate, int cursorOffset) {
        if (source == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(24);
        }
        if (range == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(25);
        }
        Project project = source.getProject();
        VirtualFile virtualFile = source.getViewProvider().getVirtualFile();
        @Nullable Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        ClangFormatLog.LOG.assertTrue(document != null);
        String origText = document.getText();
        if (ourDebugRangesForFormat) {
            ClangDaemonFormatProvider.outDebugString("Format range: " + source.getName() + ClangDaemonFormatProvider.selectedRangeInContext(origText, range));
        }
        if ((style = ClangDaemonFormatProvider.styleForFormatting(style, project)) == null) {
            return range;
        }
        if (keepLineBreaks) {
            style = ClangDaemonFormatProvider.styleToKeepLineBreaks(style);
        }
        if (canChangeWhiteSpacesOnly && (range.getStartOffset() != 0 || range.getEndOffset() != source.getTextLength()) || ClangDaemonFormatProvider.isInsideLiveTemplate(project, document)) {
            style = ClangDaemonFormatProvider.styleWithoutSorting(style);
        }
        try {
            List replaces;
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)project);
            if (service == null) {
                return range;
            }
            try {
                replaces = (List)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)service.formatRange(virtualFile, range, style, cursorOffset), (long)12000L, (String)"formatRange");
            }
            catch (TimeoutException ex) {
                ClangFormatLog.LOG.warn(ex.getMessage() + "\nNative stacktrace:\n" + service.getNativeStacktrace());
                replaces = (List)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)service.formatRange(virtualFile, range, style, cursorOffset), (String)"formatRange");
            }
            if (replaces == null || replaces.isEmpty()) {
                ClangDaemonFormatProvider.generateCancelFormatForTestFile(origText);
                return source.getTextRange();
            }
            if (!ApplicationManager.getApplication().isDispatchThread() && ClangDaemonFormatProvider.getCachedViewProvider(project, document) == null) {
                return null;
            }
            return this.processFormatPatch(range, canChangeWhiteSpacesOnly, project, document, origText, replaces, enableBulkUpdate);
        }
        catch (ProcessCanceledException cancel) {
            throw cancel;
        }
        catch (Exception e) {
            ClangDaemonFormatProvider.handleFormatException(e, project);
            return range;
        }
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Document document) {
        VirtualFile virtualFile;
        if (document == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(26);
        }
        if ((virtualFile = FileDocumentManager.getInstance().getFile(document)) == null || !virtualFile.isValid()) {
            return null;
        }
        return virtualFile;
    }

    @Nullable
    private static FileViewProvider getCachedViewProvider(Project project, @NotNull Document document) {
        VirtualFile virtualFile;
        if (document == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(27);
        }
        if ((virtualFile = ClangDaemonFormatProvider.getVirtualFile(document)) == null) {
            return null;
        }
        return PsiManagerEx.getInstanceEx((Project)project).getFileManager().findCachedViewProvider(virtualFile);
    }

    protected TextRange processFormatPatch(@NotNull TextRange range, boolean canChangeWhiteSpacesOnly, @NotNull Project project, @NotNull Document document, @NotNull String origText, @NotNull List<ClangLineColReplace> replaces, boolean enableBulkUpdate) {
        boolean forceBulkUpdate;
        boolean indentOnly;
        if (range == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(28);
        }
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(29);
        }
        if (document == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(30);
        }
        if (origText == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(31);
        }
        if (replaces == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(32);
        }
        Ref start = Ref.create((Object)Integer.MAX_VALUE);
        Ref end = Ref.create((Object)Integer.MIN_VALUE);
        Ref delta = Ref.create((Object)0);
        boolean bl = indentOnly = OCLanguageUtilsBase.INDENTATION_ONLY_HINT.get((UserDataHolder)document) == Boolean.TRUE;
        if (ourDebugRangesForFormat && indentOnly) {
            ClangDaemonFormatProvider.outDebugString("Indent Only!");
        }
        Runnable runnable = () -> replaces.stream().sorted(Comparator.comparingInt(o -> -o.getRange().getStart().getOffset(document))).map(replace -> {
            ClangLineColRange replaceRange = replace.getRange();
            TextRange mappedRange = TextRange.create((int)replaceRange.getStart().getOffset(document), (int)replaceRange.getEnd().getOffset(document));
            if (ourDebugRangesForFormat) {
                ClangDaemonFormatProvider.outDebugString("map" + ClangDaemonFormatProvider.selectedRangeInContext(origText, mappedRange) + " to >>>" + replace.getReplace() + "<<<");
            }
            return Pair.create((Object)replace.getReplace().replace("\r\n", "\n"), (Object)mappedRange);
        }).toList().forEach(replaceRange -> {
            if (!(!range.intersects((TextRange)replaceRange.second) || range.getEndOffset() != origText.length() && ((TextRange)replaceRange.second).getStartOffset() == range.getEndOffset() || canChangeWhiteSpacesOnly && !StringUtil.isEmptyOrSpaces((String)((String)replaceRange.first)))) {
                String replaceText = (String)replaceRange.first;
                int startOffset = ((TextRange)replaceRange.second).getStartOffset();
                int endOffset = ((TextRange)replaceRange.second).getEndOffset();
                if (indentOnly) {
                    char ch;
                    int startLine;
                    CharSequence text = document.getCharsSequence();
                    for (startLine = endOffset - 1; startLine >= 0 && (ch = text.charAt(startLine)) != '\n'; --startLine) {
                        if ("\r\t ".indexOf(ch) >= 0) continue;
                        if (ourDebugRangesForFormat) {
                            ClangDaemonFormatProvider.outDebugString("Skip:" + ClangDaemonFormatProvider.selectedRangeInContext(origText, (TextRange)replaceRange.second) + "\n to >>>" + replaceText + "<<<");
                        }
                        return;
                    }
                    int lastNL = replaceText.lastIndexOf(10);
                    if (lastNL >= 0) {
                        startOffset = startLine;
                        replaceText = replaceText.substring(lastNL);
                    }
                }
                start.set((Object)Math.min((Integer)start.get(), startOffset));
                end.set((Object)Math.max((Integer)end.get(), endOffset));
                int oldLength = endOffset - startOffset;
                int newLength = replaceText.length();
                int diff = newLength - oldLength;
                delta.set((Object)((Integer)delta.get() + diff));
                if (ourDebugRangesForFormat) {
                    ClangDaemonFormatProvider.outDebugString("Replace:" + ClangDaemonFormatProvider.selectedRangeInContext(origText, (TextRange)replaceRange.second) + "\n to >>>" + replaceText + "<<<");
                }
                document.replaceString(startOffset, endOffset, (CharSequence)replaceText);
            }
        });
        boolean bl2 = forceBulkUpdate = !document.isInBulkUpdate() && enableBulkUpdate;
        if (forceBulkUpdate) {
            DocumentUtil.executeInBulk((Document)document, (Runnable)runnable);
        } else {
            runnable.run();
        }
        ClangDaemonFormatProvider.generateCancelFormatForTestFile(origText);
        if ((Integer)start.get() != Integer.MAX_VALUE && (Integer)start.get() != Integer.MIN_VALUE) {
            TextRange diffRangeInModifiedDoc = TextRange.create((int)((Integer)start.get()), (int)((Integer)end.get() + (Integer)delta.get()));
            return ClangDaemonFormatProvider.psiAndDocumentAreSynchronized(PsiDocumentManager.getInstance((Project)project), document) ? TextRange.create((int)Integer.min(range.getStartOffset(), diffRangeInModifiedDoc.getStartOffset()), (int)Integer.max(range.getEndOffset() + (Integer)delta.get(), diffRangeInModifiedDoc.getEndOffset())) : null;
        }
        return range;
    }

    private static void generateCancelFormatForTestFile(@NotNull String origText) {
        ProgressIndicator formatProgress;
        if (origText == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(33);
        }
        if (origText.startsWith(CF_CANCEL_FORMATTING_PREFIX) && (formatProgress = ProgressManager.getInstance().getProgressIndicator()) != null) {
            formatProgress.cancel();
        }
    }

    @NotNull
    private static String indentationFromList(@NotNull Document document, @NotNull List<ClangLineColReplace> replaces, int lineStartOffset) {
        if (document == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(34);
        }
        if (replaces == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(35);
        }
        for (ClangLineColReplace replace : Lists.reverse(replaces)) {
            int offsetStart = replace.getRange().getStart().getOffset(document);
            int offsetEnd = replace.getRange().getEnd().getOffset(document);
            if (lineStartOffset <= offsetStart || lineStartOffset > offsetEnd) continue;
            String replaceString = replace.getReplace();
            int firstSpace = replaceString.lastIndexOf(10) + 1;
            String string = replaceString.substring(firstSpace, CharArrayUtil.shiftForward((CharSequence)replaceString, (int)firstSpace, (String)" \t"));
            if (string == null) {
                ClangDaemonFormatProvider.$$$reportNull$$$0(36);
            }
            return string;
        }
        return "";
    }

    @Override
    public String indent(@NotNull PsiFile source, int lineStartOffset, @Nullable String style) {
        if (source == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(37);
        }
        Project project = source.getProject();
        VirtualFile virtualFile = source.getViewProvider().getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        ClangFormatLog.LOG.assertTrue(document != null);
        style = ClangDaemonFormatProvider.styleForFormatting(style, project);
        if (style == null) {
            return null;
        }
        String indentString = null;
        try {
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)project);
            if (service == null) {
                return null;
            }
            CompletableFuture future = service.indentLine(virtualFile, lineStartOffset, style);
            List replaces = (List)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)future, (String)"indentLine");
            if (replaces == null || replaces.isEmpty()) {
                return null;
            }
            indentString = ClangDaemonFormatProvider.indentationFromList(document, replaces, lineStartOffset);
        }
        catch (ProcessCanceledException cancel) {
            throw cancel;
        }
        catch (Exception e) {
            ClangDaemonFormatProvider.handleFormatException(e, project);
        }
        return indentString;
    }

    @Contract(value="null -> null")
    private static String makeStyleLanguageAgnostic(@Nullable String style) {
        if (style == null) {
            return null;
        }
        String[] lines = StringUtil.splitByLinesKeepSeparators((String)style);
        if (Arrays.stream(lines).filter(line -> line.startsWith("---")).count() > 1L) {
            return style;
        }
        return Arrays.stream(lines).filter(line -> !line.startsWith("---") && !line.startsWith("...") && !line.startsWith("Language:")).collect(Collectors.joining());
    }

    @Contract(value="null -> null")
    public static String getErrorParsingMessageFromStyle(@Nullable String style) {
        if (style == null) {
            return null;
        }
        String[] lines = StringUtil.splitByLines((String)style);
        if (lines.length == 1) {
            return ClangFormatFileUtils.getErrorMessageFromYAMLine(lines[0]);
        }
        if ((lines.length == 2 || lines.length == 3) && lines[0].startsWith(ourClangFormatConfigureSourcePrefix)) {
            return ClangFormatFileUtils.getErrorMessageFromYAMLine(lines[1] + (String)(lines.length == 2 ? "" : " - " + lines[2]));
        }
        return null;
    }

    private static boolean psiAndDocumentAreSynchronized(@NotNull PsiDocumentManager psiDocumentManager, @NotNull Document document) {
        if (psiDocumentManager == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(38);
        }
        if (document == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(39);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed() && OCLanguageUtilsBase.INSIDE_TYPING_ACTION_HINT.get((UserDataHolder)document) != Boolean.TRUE) {
            psiDocumentManager.commitDocument(document);
            return true;
        }
        return psiDocumentManager.isCommitted(document);
    }

    private static void outDebugString(@NotNull @NonNls String message) {
        if (message == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(40);
        }
        assert (ourDebugRangesForFormat);
        System.out.println("=============================== " + message);
    }

    @NotNull
    private static String selectedRangeInContext(@NotNull @NonNls String text, @NotNull TextRange range) {
        if (text == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(41);
        }
        if (range == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(42);
        }
        String string = "\n'" + text.substring(0, range.getStartOffset()) + ">>>" + range.substring(text) + "<<<" + text.substring(range.getEndOffset()) + "'";
        if (string == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(43);
        }
        return string;
    }

    public static void reportClangFormatError(@NotNull String message, final @NotNull Project project, MessageType messageType) {
        Application application;
        if (message == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(44);
        }
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(45);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        if (application.isInternal() || application.isHeadlessEnvironment()) {
            ClangFormatLog.LOG.warn("ClangFormat error:" + message);
            if (application.isHeadlessEnvironment()) {
                return;
            }
        }
        if (ClangDaemonFormatProvider.isClangdCommunicationError(message)) {
            ClangFormatLog.LOG.warn(message);
            return;
        }
        ProcessedMessage pe = ClangDaemonFormatProvider.processMessage(message);
        UIUtil.invokeLaterIfNeeded(() -> {
            BalloonLayout layout;
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(pe.getFilteredMessage(), messageType, new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    OpenFileDescriptor descriptor;
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (descriptor = ClangDaemonFormatProvider.createOpenFileDescriptor(project, e.getDescription())) != null) {
                        new OpenFileHyperlinkInfo(descriptor).navigate(project);
                    }
                }
            }).setFadeoutTime(0L).setShowCallout(false).setAnimationCycle(0).setHideOnClickOutside(true).setHideOnKeyOutside(true).setHideOnLinkClick(true).setCloseButtonEnabled(true).createBalloon();
            Disposer.register((Disposable)project, (Disposable)balloon);
            Frame window = WindowManager.getInstance().getFrame(project);
            if (window == null) {
                window = JOptionPane.getRootFrame();
            }
            if (window instanceof IdeFrame && (layout = ((IdeFrame)window).getBalloonLayout()) != null) {
                balloon.show((PositionTracker)new PositionTracker<Balloon>((Component)((IdeFrame)window).getComponent()){

                    public RelativePoint recalculateLocation(@NotNull Balloon object) {
                        if (object == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        Component c = this.getComponent();
                        int y = c.getHeight() - 45;
                        return new RelativePoint(c, new Point(c.getWidth() - 150, y));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/cidr/lang/daemon/clang/format/ClangDaemonFormatProvider$3", "recalculateLocation"));
                    }
                }, Balloon.Position.above);
            }
        });
    }

    @Contract(value="_, null -> null")
    public static OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project, @Nullable String url) {
        VirtualFile vtClangFormat;
        if (project == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(46);
        }
        if (url == null) {
            return null;
        }
        int pos = url.lastIndexOf(58);
        int col = 0;
        int line = 0;
        if (pos > 1) {
            String num1 = url.substring(pos + 1);
            if ((pos = (url = url.substring(0, pos)).lastIndexOf(58)) > 1) {
                String num2 = url.substring(pos + 1);
                url = url.substring(0, pos);
                line = ClangDaemonFormatProvider._int(num2);
                col = ClangDaemonFormatProvider._int(num1);
            } else {
                line = ClangDaemonFormatProvider._int(num1);
            }
        }
        if ((vtClangFormat = VfsUtil.findFile((Path)Paths.get(url, new String[0]), (boolean)false)) != null) {
            return new OpenFileDescriptor(project, vtClangFormat, line - 1, col);
        }
        return null;
    }

    @NotNull
    public static ProcessedMessage processMessage(@NotNull String message) {
        int pos;
        if (message == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(47);
        }
        if (message.startsWith(PARSE_START)) {
            int pos2 = message.indexOf(": ");
            String messageEnd = message.substring(pos2);
            String fileName = message.substring(PARSE_START.length(), pos2).trim();
            ProcessedMessage processedMessage = ProcessedMessage.createProcessedMessage(Collections.singletonList(fileName), new HtmlBuilder().append(PARSE_START).append(" ").appendLink(fileName, fileName).append(messageEnd).wrapWithHtmlBody().toString());
            if (processedMessage == null) {
                ClangDaemonFormatProvider.$$$reportNull$$$0(48);
            }
            return processedMessage;
        }
        if (message.startsWith(WRONG_CFG_START) && (pos = message.indexOf(":")) > 0) {
            StringBuffer sb = new StringBuffer(message.substring(0, pos + 1));
            List paths = StringUtil.split((String)message.substring(pos + 1), (String)",");
            boolean[] first = new boolean[]{true};
            SmartList clangFormatURLs = new SmartList();
            paths.forEach(arg_0 -> ClangDaemonFormatProvider.lambda$processMessage$8((List)clangFormatURLs, first, sb, arg_0));
            ProcessedMessage processedMessage = ProcessedMessage.createProcessedMessage((List<String>)clangFormatURLs, new HtmlBuilder().append(sb.toString()).wrapWithHtmlBody().toString());
            if (processedMessage == null) {
                ClangDaemonFormatProvider.$$$reportNull$$$0(49);
            }
            return processedMessage;
        }
        ProcessedMessage processedMessage = ProcessedMessage.createProcessedMessage(ContainerUtil.emptyList(), message);
        if (processedMessage == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(50);
        }
        return processedMessage;
    }

    private static int _int(String num2) {
        try {
            return Integer.parseInt(num2);
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    @Override
    @Nullable
    public VirtualFile extractClangFormatFile(@NotNull String clangFormatExtendedContext) {
        String formatSource;
        if (clangFormatExtendedContext == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(51);
        }
        return (formatSource = ClangDaemonFormatProvider.extractClangFormatSource(clangFormatExtendedContext)) == null ? null : ClangFormatFileUtils.getClangFormatFile(formatSource, false);
    }

    @Nullable
    public static String extractClangFormatSource(@NotNull String clangFormatExtendedContext) {
        Matcher matcher;
        if (clangFormatExtendedContext == null) {
            ClangDaemonFormatProvider.$$$reportNull$$$0(52);
        }
        return (matcher = CLANG_FORMAT_CONFIGURE_SOURCE.matcher(clangFormatExtendedContext)).find() ? matcher.group(1) : null;
    }

    private static /* synthetic */ void lambda$processMessage$8(List clangFormatURLs, boolean[] first, StringBuffer sb, String fileName) {
        String trim = fileName.trim();
        clangFormatURLs.add(trim);
        if (first[0]) {
            first[0] = false;
            sb.append(" ");
        } else {
            sb.append(", ");
        }
        sb.append(HtmlChunk.link((String)trim, (String)trim));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 10, 17, 19, 36, 43, 48, 49, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfCodeFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 17: 
            case 19: 
            case 36: 
            case 43: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/format/ClangDaemonFormatProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsOrErrorAsYAML";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfvFile";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 23: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 25: 
            case 28: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origText";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaces";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDocumentManager";
                break;
            }
            case 40: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangFormatExtendedContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/format/ClangDaemonFormatProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findClangFormatContent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCFSourceCommentLine";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "styleToKeepLineBreaks";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "styleWithoutSorting";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "indentationFromList";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedRangeInContext";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "processMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDisablingFunction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClangFormatContent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 17: 
            case 19: 
            case 36: 
            case 43: 
            case 48: 
            case 49: 
            case 50: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isClangdCommunicationError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCFSourceCommentLine";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "styleForFormatting";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "styleToKeepLineBreaks";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "styleWithoutSorting";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "handleFormatException";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInsideLiveTemplate";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCachedViewProvider";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processFormatPatch";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "generateCancelFormatForTestFile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "indentationFromList";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "indent";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "psiAndDocumentAreSynchronized";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "outDebugString";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "selectedRangeInContext";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "reportClangFormatError";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createOpenFileDescriptor";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processMessage";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "extractClangFormatFile";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "extractClangFormatSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 10, 17, 19, 36, 43, 48, 49, 50 -> new IllegalStateException(string);
        };
    }

    public static final class ProcessedMessage {
        private final List<String> myClangFormatURLs;
        private final @NlsContexts.PopupContent String myFilteredMessage;

        private ProcessedMessage(@NotNull List<String> clangFormatURLs, @NotNull @NlsContexts.PopupContent String message) {
            if (clangFormatURLs == null) {
                ProcessedMessage.$$$reportNull$$$0(0);
            }
            if (message == null) {
                ProcessedMessage.$$$reportNull$$$0(1);
            }
            this.myClangFormatURLs = clangFormatURLs;
            this.myFilteredMessage = message;
        }

        public List<String> getClangFormatURLs() {
            return this.myClangFormatURLs;
        }

        @NlsContexts.PopupContent
        public String getFilteredMessage() {
            return this.myFilteredMessage;
        }

        @NotNull
        @Contract(value="_, _ -> new")
        public static ProcessedMessage createProcessedMessage(@NotNull List<String> clangFormatURLs, @NotNull @NlsContexts.PopupContent String message) {
            if (clangFormatURLs == null) {
                ProcessedMessage.$$$reportNull$$$0(2);
            }
            if (message == null) {
                ProcessedMessage.$$$reportNull$$$0(3);
            }
            return new ProcessedMessage(clangFormatURLs, message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clangFormatURLs";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/format/ClangDaemonFormatProvider$ProcessedMessage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createProcessedMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

