/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat.settings;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangDaemonFormatProvider;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatLog;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangDaemonFormatClassicProvider
extends ClangDaemonFormatProvider {
    @Override
    public boolean applyCollectedSettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile codeFile, @NotNull Map<String, Object> formattingOptionValue) {
        if (settings == null) {
            ClangDaemonFormatClassicProvider.$$$reportNull$$$0(0);
        }
        if (codeFile == null) {
            ClangDaemonFormatClassicProvider.$$$reportNull$$$0(1);
        }
        if (formattingOptionValue == null) {
            ClangDaemonFormatClassicProvider.$$$reportNull$$$0(2);
        }
        boolean isModified = false;
        CommonCodeStyleSettings.IndentOptions indentOptions = ClangFormatFileUtils.getOverriddenIndentOptions(settings);
        OCCodeStyleSettings oc = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        CommonCodeStyleSettings common = settings.getCommonSettings(codeFile.getLanguage());
        isModified |= common.IF_BRACE_FORCE != 0 || common.DOWHILE_BRACE_FORCE != 0 || common.WHILE_BRACE_FORCE != 0 || common.FOR_BRACE_FORCE != 0;
        common.FOR_BRACE_FORCE = 0;
        common.WHILE_BRACE_FORCE = 0;
        common.DOWHILE_BRACE_FORCE = 0;
        common.IF_BRACE_FORCE = 0;
        oc.BLOCK_BRACE_PLACEMENT = 1;
        isModified |= oc.BLOCK_BRACE_PLACEMENT != 1;
        boolean customBraceStyle = true;
        for (Map.Entry<String, Object> entry : formattingOptionValue.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            try {
                if ("AfterClass".equals(key)) {
                    int CLASS_BRACE_STYLE = ClangDaemonFormatClassicProvider.getBraceStyle(ClangDaemonFormatClassicProvider._boolean(value), false);
                    isModified |= CLASS_BRACE_STYLE != common.CLASS_BRACE_STYLE;
                    common.CLASS_BRACE_STYLE = CLASS_BRACE_STYLE;
                    continue;
                }
                if ("AfterFunction".equals(key)) {
                    int FUNCTION_BRACE_PLACEMENT = ClangDaemonFormatClassicProvider.getBraceStyle(ClangDaemonFormatClassicProvider._boolean(value), false);
                    isModified |= FUNCTION_BRACE_PLACEMENT != oc.FUNCTION_BRACE_PLACEMENT;
                    oc.FUNCTION_BRACE_PLACEMENT = FUNCTION_BRACE_PLACEMENT;
                    continue;
                }
                if ("AfterControlStatement".equals(key)) {
                    int BRACE_STYLE = ClangDaemonFormatClassicProvider.getBraceStyle(ClangDaemonFormatClassicProvider._boolean(value), ClangDaemonFormatClassicProvider._boolean(formattingOptionValue.get("IndentBraces")));
                    isModified |= BRACE_STYLE != common.BRACE_STYLE;
                    common.BRACE_STYLE = BRACE_STYLE;
                    continue;
                }
                if ("AfterNamespace".equals(key)) {
                    int NAMESPACE_BRACE_PLACEMENT = ClangDaemonFormatClassicProvider.getBraceStyle(ClangDaemonFormatClassicProvider._boolean(value), false);
                    isModified |= NAMESPACE_BRACE_PLACEMENT != oc.NAMESPACE_BRACE_PLACEMENT;
                    oc.NAMESPACE_BRACE_PLACEMENT = NAMESPACE_BRACE_PLACEMENT;
                    continue;
                }
                if ("BeforeElse".equals(key)) {
                    boolean vBeforeElse = ClangDaemonFormatClassicProvider._boolean(value);
                    isModified |= vBeforeElse != common.ELSE_ON_NEW_LINE;
                    common.ELSE_ON_NEW_LINE = vBeforeElse;
                    continue;
                }
                if ("BeforeCatch".equals(key)) {
                    boolean vBeforeCatch = ClangDaemonFormatClassicProvider._boolean(value);
                    isModified |= vBeforeCatch != common.CATCH_ON_NEW_LINE;
                    common.CATCH_ON_NEW_LINE = vBeforeCatch;
                    continue;
                }
                if ("ColumnLimit".equals(key)) {
                    int vColumnLimit = ClangDaemonFormatClassicProvider._int(value);
                    boolean vKeepLineBreaks = false;
                    if (vColumnLimit == 0) {
                        vColumnLimit = 1000;
                        vKeepLineBreaks = true;
                    }
                    isModified |= vColumnLimit != common.RIGHT_MARGIN || vKeepLineBreaks != common.KEEP_LINE_BREAKS;
                    common.RIGHT_MARGIN = vColumnLimit;
                    common.KEEP_LINE_BREAKS = vKeepLineBreaks;
                    continue;
                }
                if ("MaxEmptyLinesToKeep".equals(key)) {
                    int vMaxEmptyLinesToKeep = ClangDaemonFormatClassicProvider._int(value);
                    isModified |= vMaxEmptyLinesToKeep != common.KEEP_BLANK_LINES_IN_CODE;
                    common.KEEP_BLANK_LINES_IN_CODE = vMaxEmptyLinesToKeep;
                    continue;
                }
                if ("IndentWidth".equals(key)) {
                    int vIndentWidth = ClangDaemonFormatClassicProvider._int(value);
                    isModified |= vIndentWidth != indentOptions.INDENT_SIZE || vIndentWidth != oc.INDENT_CLASS_MEMBERS || vIndentWidth != oc.INDENT_C_STRUCT_MEMBERS || vIndentWidth != oc.INDENT_INTERFACE_MEMBERS || vIndentWidth != oc.INDENT_IMPLEMENTATION_MEMBERS || oc.INDENT_PREPROCESSOR_DIRECTIVE != 0 || oc.INDENT_DIRECTIVE_AS_CODE || !oc.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK;
                    oc.INDENT_INTERFACE_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS = vIndentWidth;
                    oc.INDENT_C_STRUCT_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    oc.INDENT_CLASS_MEMBERS = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    indentOptions.INDENT_SIZE = oc.INDENT_IMPLEMENTATION_MEMBERS;
                    oc.INDENT_INTERFACE_MEMBERS_EXCEPT_IVARS_BLOCK = true;
                    oc.INDENT_DIRECTIVE_AS_CODE = false;
                    oc.INDENT_PREPROCESSOR_DIRECTIVE = 0;
                    continue;
                }
                if ("ObjCBlockIndentWidth".equals(key)) {
                    int vObjCBlockIndentWidth = ClangDaemonFormatClassicProvider._int(value);
                    isModified |= vObjCBlockIndentWidth != oc.INDENT_INSIDE_CODE_BLOCK;
                    oc.INDENT_INSIDE_CODE_BLOCK = vObjCBlockIndentWidth;
                    continue;
                }
                if ("ContinuationIndentWidth".equals(key)) {
                    int vContinuationIndentWidth = ClangDaemonFormatClassicProvider._int(value);
                    isModified |= vContinuationIndentWidth != indentOptions.CONTINUATION_INDENT_SIZE;
                    indentOptions.CONTINUATION_INDENT_SIZE = vContinuationIndentWidth;
                    continue;
                }
                if ("TabWidth".equals(key)) {
                    int vTabWidth = ClangDaemonFormatClassicProvider._int(value);
                    isModified |= vTabWidth != indentOptions.TAB_SIZE;
                    indentOptions.TAB_SIZE = vTabWidth;
                    continue;
                }
                if ("UseTab".equals(key)) {
                    Boolean vUseTab = null;
                    vUseTab = "Never".equals(value) || "false".equals(value) ? Boolean.FALSE : Boolean.TRUE;
                    if (vUseTab == null) continue;
                    isModified |= !vUseTab.equals(indentOptions.USE_TAB_CHARACTER);
                    indentOptions.USE_TAB_CHARACTER = vUseTab;
                    continue;
                }
                if ("AccessModifierOffset".equals(key)) {
                    int vAccessModifierOffset = ClangDaemonFormatClassicProvider._int(value) + ClangDaemonFormatClassicProvider._int(formattingOptionValue.get("IndentWidth"));
                    isModified |= vAccessModifierOffset != oc.INDENT_VISIBILITY_KEYWORDS;
                    oc.INDENT_VISIBILITY_KEYWORDS = vAccessModifierOffset;
                    continue;
                }
                if ("IndentCaseLabels".equals(key)) {
                    boolean vIndentCaseLabels = ClangDaemonFormatClassicProvider._boolean(value);
                    isModified |= vIndentCaseLabels != common.INDENT_CASE_FROM_SWITCH;
                    common.INDENT_CASE_FROM_SWITCH = vIndentCaseLabels;
                    continue;
                }
                if (!"NamespaceIndentation".equals(key)) continue;
                String vNamespaceIndentation = ClangDaemonFormatClassicProvider._str(value);
                int INDENT_NAMESPACE_MEMBERS = oc.INDENT_NAMESPACE_MEMBERS;
                if ("None".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = 0;
                } else if ("Inner".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = 0;
                } else if ("All".equals(vNamespaceIndentation)) {
                    INDENT_NAMESPACE_MEMBERS = ClangDaemonFormatClassicProvider._int(formattingOptionValue.get("IndentWidth"));
                }
                isModified |= INDENT_NAMESPACE_MEMBERS != oc.INDENT_NAMESPACE_MEMBERS;
                oc.INDENT_NAMESPACE_MEMBERS = INDENT_NAMESPACE_MEMBERS;
            }
            catch (UnsupportedOperationException t) {
                ClangFormatLog.LOG.info("No option:" + key);
            }
            catch (Throwable t) {
                ClangFormatLog.LOG.warn(key + " option caused an exception: " + t.getMessage());
            }
        }
        return isModified;
    }

    @Override
    public void syncClangFormatSettings(@NotNull Project project, @NotNull CodeStyleSettings settings, boolean changeFromWidget) {
        if (project == null) {
            ClangDaemonFormatClassicProvider.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            ClangDaemonFormatClassicProvider.$$$reportNull$$$0(4);
        }
    }

    @Override
    @NotNull
    public String convertCodeStyleToClangFormat(@Nullable Project project, @NotNull CodeStyleSettings style) {
        if (style == null) {
            ClangDaemonFormatClassicProvider.$$$reportNull$$$0(5);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# Generated from CLion C/C++ Code Style settings\n");
        stringBuilder.append("BasedOnStyle: LLVM\n");
        CommonCodeStyleSettings commonSettings = style.getCommonSettings((Language)OCLanguage.getInstance());
        CommonCodeStyleSettings.IndentOptions indentSettings = commonSettings.getIndentOptions();
        if (indentSettings == null) {
            indentSettings = style.getIndentOptions();
        }
        OCCodeStyleSettings cppCodeStyleSettings = (OCCodeStyleSettings)style.getCustomSettings(OCCodeStyleSettings.class);
        stringBuilder.append("AccessModifierOffset: ").append(cppCodeStyleSettings.INDENT_VISIBILITY_KEYWORDS - indentSettings.INDENT_SIZE).append('\n');
        stringBuilder.append("AlignAfterOpenBracket: ").append(commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE ? "AlwaysBreak" : (commonSettings.ALIGN_MULTILINE_PARAMETERS ? "Align" : "DontAlign")).append('\n');
        stringBuilder.append("AlignConsecutiveAssignments: ").append(commonSettings.ALIGN_GROUP_FIELD_DECLARATIONS ? "Consecutive" : "None").append('\n');
        stringBuilder.append("AlignOperands: ").append(commonSettings.ALIGN_MULTILINE_BINARY_OPERATION ? "Align" : "DontAlign").append('\n');
        stringBuilder.append("AllowAllArgumentsOnNextLine: ").append(commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE).append('\n');
        stringBuilder.append("AllowAllConstructorInitializersOnNextLine: ").append(cppCodeStyleSettings.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON == 1).append('\n');
        stringBuilder.append("AllowAllParametersOfDeclarationOnNextLine: ").append(commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE).append('\n');
        stringBuilder.append("AllowShortBlocksOnASingleLine: ").append(commonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE ? "Always" : (commonSettings.KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE ? "Empty" : "Never")).append('\n');
        stringBuilder.append("AllowShortCaseLabelsOnASingleLine: ").append(cppCodeStyleSettings.KEEP_CASE_EXPRESSIONS_IN_ONE_LINE).append('\n');
        stringBuilder.append("AllowShortFunctionsOnASingleLine: ").append(commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE ? "All" : "None").append('\n');
        stringBuilder.append("AllowShortIfStatementsOnASingleLine: ").append(commonSettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE ? "Always" : "Never").append('\n');
        stringBuilder.append("AllowShortLambdasOnASingleLine: ").append(commonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE ? "All" : "None").append('\n');
        stringBuilder.append("AllowShortLoopsOnASingleLine: ").append(commonSettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE).append('\n');
        stringBuilder.append("AlwaysBreakAfterReturnType: ").append(cppCodeStyleSettings.FUNCTION_TOP_AFTER_RETURN_TYPE_WRAP == 2 ? (cppCodeStyleSettings.FUNCTION_NON_TOP_AFTER_RETURN_TYPE_WRAP == 2 ? "All" : "TopLevel") : "None").append('\n');
        stringBuilder.append("AlwaysBreakTemplateDeclarations: ").append(cppCodeStyleSettings.TEMPLATE_DECLARATION_FUNCTION_WRAP == 2 ? "Yes" : (cppCodeStyleSettings.TEMPLATE_DECLARATION_FUNCTION_WRAP == 1 ? "MultiLine" : "No")).append('\n');
        stringBuilder.append("BreakBeforeBraces: Custom\n");
        stringBuilder.append("BraceWrapping:\n");
        stringBuilder.append("  AfterCaseLabel: false\n");
        stringBuilder.append("  AfterClass: ").append(commonSettings.CLASS_BRACE_STYLE != 1).append('\n');
        stringBuilder.append("  AfterControlStatement: ").append(commonSettings.BRACE_STYLE == 5 ? "MultiLine" : (commonSettings.BRACE_STYLE != 1 ? "Always" : "Never")).append('\n');
        stringBuilder.append("  AfterEnum: ").append(commonSettings.CLASS_BRACE_STYLE != 1).append('\n');
        stringBuilder.append("  AfterFunction: ").append(cppCodeStyleSettings.FUNCTION_BRACE_PLACEMENT != 1).append('\n');
        stringBuilder.append("  AfterNamespace: ").append(cppCodeStyleSettings.NAMESPACE_BRACE_PLACEMENT != 1).append('\n');
        stringBuilder.append("  AfterUnion: ").append(commonSettings.CLASS_BRACE_STYLE != 1).append('\n');
        stringBuilder.append("  BeforeCatch: ").append(commonSettings.CATCH_ON_NEW_LINE).append('\n');
        stringBuilder.append("  BeforeElse: ").append(commonSettings.ELSE_ON_NEW_LINE).append('\n');
        stringBuilder.append("  IndentBraces: ").append(commonSettings.BRACE_STYLE == 3).append('\n');
        stringBuilder.append("  SplitEmptyFunction: ").append(!commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE).append('\n');
        stringBuilder.append("  SplitEmptyRecord: ").append(!commonSettings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE).append('\n');
        stringBuilder.append("BreakBeforeBinaryOperators: ").append(commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? (commonSettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE ? "All" : "NonAssignment") : "None").append('\n');
        stringBuilder.append("BreakBeforeTernaryOperators: ").append(commonSettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE).append('\n');
        stringBuilder.append("BreakConstructorInitializers: ").append(cppCodeStyleSettings.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON == 1 ? "AfterColon" : (cppCodeStyleSettings.CLASS_CONSTRUCTOR_INIT_LIST_COMMA_ON_NEXT_LINE ? "BeforeComma" : "BeforeColon")).append('\n');
        stringBuilder.append("BreakInheritanceList: ").append(cppCodeStyleSettings.SUPERCLASS_LIST_AFTER_COLON == 1 ? "AfterColon" : (cppCodeStyleSettings.SUPERCLASS_LIST_COMMA_ON_NEXT_LINE ? "BeforeComma" : "BeforeColon")).append('\n');
        stringBuilder.append("ColumnLimit: ").append(commonSettings.KEEP_LINE_BREAKS ? 0 : (commonSettings.RIGHT_MARGIN > 0 ? commonSettings.RIGHT_MARGIN : 120)).append('\n');
        stringBuilder.append("CompactNamespaces: ").append(cppCodeStyleSettings.KEEP_NESTED_NAMESPACES_IN_ONE_LINE).append('\n');
        stringBuilder.append("ContinuationIndentWidth: ").append(indentSettings.CONTINUATION_INDENT_SIZE).append('\n');
        stringBuilder.append("IndentCaseLabels: ").append(commonSettings.INDENT_CASE_FROM_SWITCH).append('\n');
        stringBuilder.append("IndentPPDirectives: ").append(cppCodeStyleSettings.INDENT_PREPROCESSOR_DIRECTIVE > 0 ? "BeforeHash" : "None").append('\n');
        stringBuilder.append("IndentWidth: ").append(indentSettings.INDENT_SIZE).append('\n');
        stringBuilder.append("KeepEmptyLinesAtTheStartOfBlocks: ").append(commonSettings.KEEP_BLANK_LINES_IN_CODE > 0).append('\n');
        stringBuilder.append("MaxEmptyLinesToKeep: ").append(commonSettings.KEEP_BLANK_LINES_IN_CODE).append('\n');
        stringBuilder.append("NamespaceIndentation: ").append(cppCodeStyleSettings.INDENT_NAMESPACE_MEMBERS > 0 ? "All" : "None").append('\n');
        stringBuilder.append("ObjCSpaceAfterProperty: ").append(cppCodeStyleSettings.SPACE_BEFORE_PROPERTY_ATTRIBUTES_PARENTHESES).append('\n');
        stringBuilder.append("ObjCSpaceBeforeProtocolList: ").append(cppCodeStyleSettings.SPACE_BEFORE_PROTOCOLS_BRACKETS).append('\n');
        stringBuilder.append("PointerAlignment: ").append(cppCodeStyleSettings.SPACE_BEFORE_POINTER_IN_DECLARATION ? (cppCodeStyleSettings.SPACE_AFTER_POINTER_IN_DECLARATION ? "Middle" : "Right") : "Left").append('\n');
        stringBuilder.append("ReflowComments: ").append(commonSettings.WRAP_COMMENTS).append('\n');
        stringBuilder.append("SpaceAfterCStyleCast: ").append(commonSettings.SPACE_AFTER_TYPE_CAST).append('\n');
        stringBuilder.append("SpaceAfterLogicalNot: ").append(commonSettings.SPACE_AROUND_UNARY_OPERATOR).append('\n');
        stringBuilder.append("SpaceAfterTemplateKeyword: ").append(cppCodeStyleSettings.SPACE_BEFORE_TEMPLATE_DECLARATION_LT).append('\n');
        stringBuilder.append("SpaceBeforeAssignmentOperators: ").append(commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS).append('\n');
        stringBuilder.append("SpaceBeforeCpp11BracedList: ").append(cppCodeStyleSettings.SPACE_BEFORE_INIT_LIST).append('\n');
        stringBuilder.append("SpaceBeforeCtorInitializerColon: ").append(cppCodeStyleSettings.SPACE_BEFORE_INIT_LIST_COLON).append('\n');
        stringBuilder.append("SpaceBeforeInheritanceColon: ").append(cppCodeStyleSettings.SPACE_BEFORE_SUPERCLASS_COLON).append('\n');
        boolean spaceBeforeControlStatementParen = commonSettings.SPACE_BEFORE_IF_PARENTHESES || commonSettings.SPACE_BEFORE_FOR_PARENTHESES || commonSettings.SPACE_BEFORE_WHILE_PARENTHESES || commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES || commonSettings.SPACE_BEFORE_CATCH_PARENTHESES;
        stringBuilder.append("SpaceBeforeParens: ").append(spaceBeforeControlStatementParen ? (commonSettings.SPACE_BEFORE_METHOD_PARENTHESES ? "Always" : "ControlStatements") : "Never").append('\n');
        stringBuilder.append("SpaceBeforeRangeBasedForLoopColon: ").append(cppCodeStyleSettings.SPACE_BEFORE_COLON_IN_FOREACH).append('\n');
        stringBuilder.append("SpaceInEmptyParentheses: ").append(commonSettings.SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES).append('\n');
        stringBuilder.append("SpacesBeforeTrailingComments: ").append(commonSettings.LINE_COMMENT_ADD_SPACE ? 1 : 0).append('\n');
        stringBuilder.append("SpacesInAngles: ").append(cppCodeStyleSettings.SPACE_WITHIN_TEMPLATE_DECLARATION_LTGT).append('\n');
        stringBuilder.append("SpacesInCStyleCastParentheses: ").append(commonSettings.SPACE_WITHIN_CAST_PARENTHESES).append('\n');
        stringBuilder.append("SpacesInContainerLiterals: ").append(cppCodeStyleSettings.SPACE_BEFORE_DICTIONARY_LITERAL_COLON).append('\n');
        stringBuilder.append("SpacesInParentheses: ").append(commonSettings.SPACE_WITHIN_PARENTHESES).append('\n');
        stringBuilder.append("SpacesInSquareBrackets: ").append(commonSettings.SPACE_WITHIN_BRACKETS).append('\n');
        stringBuilder.append("TabWidth: ").append(indentSettings.TAB_SIZE).append('\n');
        stringBuilder.append("UseTab: ").append(indentSettings.USE_TAB_CHARACTER ? (indentSettings.SMART_TABS ? "ForIndentation" : "ForContinuationAndIndentation") : "Never").append('\n');
        String string = stringBuilder.toString();
        if (string == null) {
            ClangDaemonFormatClassicProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Contract(pure=true)
    private static int getBraceStyle(boolean wrapAfter, boolean indentBrace) {
        return !wrapAfter ? 1 : (indentBrace ? 4 : 2);
    }

    private static String _str(@Nullable Object value) {
        if (value == null) {
            throw new UnsupportedOperationException();
        }
        return value.toString();
    }

    private static int _int(@Nullable Object value) {
        if (value == null) {
            throw new UnsupportedOperationException();
        }
        return Integer.parseInt((String)value);
    }

    private static boolean _boolean(@Nullable Object value) {
        if (value == null) {
            throw new UnsupportedOperationException();
        }
        return Boolean.parseBoolean((String)value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingOptionValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/clangFormat/settings/ClangDaemonFormatClassicProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/clangFormat/settings/ClangDaemonFormatClassicProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertCodeStyleToClangFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyCollectedSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "syncClangFormatSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertCodeStyleToClangFormat";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

