/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat.settings;

import com.intellij.application.options.GeneralCodeStyleOptionsProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.clangFormat.messages.ClangFormatBundle;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangFormatConfigurable
extends CodeStyleSettingsProvider
implements GeneralCodeStyleOptionsProvider {
    private JBCheckBox myClangFormatEnabled;
    private JTextPane myNotificationWithClangdEnableRef;
    private Disposable myUILifeTimeDisposable;
    private Project myProject;

    @Nullable
    public JComponent createComponent() {
        this.myClangFormatEnabled = new JBCheckBox(ClangFormatBundle.message("cf.config.enable", new Object[0]));
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 2));
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        result.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ClangFormatBundle.message("cf.config.title", new Object[0]), (boolean)false));
        panel.add((Component)this.myClangFormatEnabled);
        this.myNotificationWithClangdEnableRef = new JTextPane();
        this.myNotificationWithClangdEnableRef.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
        panel.add(this.myNotificationWithClangdEnableRef);
        panel.setAlignmentY(0.0f);
        result.add(panel);
        this.myProject = ProjectUtil.guessCurrentProject(null);
        this.setupClangdUISync();
        return result;
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ClangFormatConfigurable.$$$reportNull$$$0(0);
        }
        return this.myClangFormatEnabled.isSelected() != ((ClangFormatSettings)settings.getCustomSettings(ClangFormatSettings.class)).ENABLED;
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ClangFormatConfigurable.$$$reportNull$$$0(1);
        }
        ((ClangFormatSettings)settings.getCustomSettings(ClangFormatSettings.class)).ENABLED = this.myClangFormatEnabled.isSelected();
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ClangFormatConfigurable.$$$reportNull$$$0(2);
        }
        this.myClangFormatEnabled.setSelected(((ClangFormatSettings)settings.getCustomSettings(ClangFormatSettings.class)).ENABLED);
    }

    public void setupClangdUISync() {
        Messages.configureMessagePaneUi((JTextPane)this.myNotificationWithClangdEnableRef, (String)ClangFormatBundle.message("cf.config.override.standard", new Object[0]), (UIUtil.FontSize)UIUtil.FontSize.SMALL);
        this.myUILifeTimeDisposable = Disposer.newDisposable((String)"ClangFormatConfigurableUI");
        Disposer.register((Disposable)this.myProject, (Disposable)this.myUILifeTimeDisposable);
        this.myProject.getMessageBus().connect(this.myUILifeTimeDisposable).subscribe(ClangdSettingsListener.TOPIC_UI, (Object)new ClangdSettingsListener(){

            public void onClangdOnChanged(boolean clangdOnInUI) {
                if (!clangdOnInUI) {
                    ClangFormatConfigurable.this.myClangFormatEnabled.setSelected(false);
                }
            }
        });
        this.myClangFormatEnabled.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean clangFormatEnabled = ClangFormatConfigurable.this.myClangFormatEnabled.isSelected();
                if (clangFormatEnabled) {
                    ((ClangdSettingsListener)ClangFormatConfigurable.this.myProject.getMessageBus().syncPublisher(ClangdSettingsListener.TOPIC_UI)).onClangdOnChanged(true);
                }
            }
        });
    }

    public void disposeUIResources() {
        this.myClangFormatEnabled = null;
        this.myProject = null;
        if (this.myUILifeTimeDisposable != null) {
            Disposer.dispose((Disposable)this.myUILifeTimeDisposable);
            this.myUILifeTimeDisposable = null;
        }
    }

    public boolean isModified() {
        return false;
    }

    public void apply() {
    }

    public boolean hasSettingsPage() {
        return false;
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ClangFormatConfigurable.$$$reportNull$$$0(3);
        }
        return new ClangFormatSettings(settings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "settings";
        objectArray2[1] = "com/jetbrains/clangFormat/settings/ClangFormatConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

