/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.devkit.threadingModelHelper;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.devkit.threadingModelHelper.TMHAssertionGenerator;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

class TMHAssertionGenerator2
implements TMHAssertionGenerator {
    private static final String THREAD_ASSERTIONS_CLASS_NAME = "com/intellij/util/concurrency/ThreadingAssertions";
    private static final String GENERATE_ASSERTION_PARAMETER = "generateAssertion";
    private final String myThreadAssertionsClassName;
    private final Type myAnnotationClass;
    private final String myAssertionMethodName;
    private static final Set<? extends TMHAssertionGenerator> GENERATORS = TMHAssertionGenerator2.generators("com/intellij/util/concurrency/ThreadingAssertions", "com/intellij/util/concurrency/annotations");

    TMHAssertionGenerator2(String threadAssertionsClassName, Type annotationClass, String assertionMethodName) {
        this.myThreadAssertionsClassName = threadAssertionsClassName;
        this.myAnnotationClass = annotationClass;
        this.myAssertionMethodName = assertionMethodName;
    }

    @Override
    public boolean isMyAnnotation(String annotationDescriptor) {
        return this.myAnnotationClass.getDescriptor().equals(annotationDescriptor);
    }

    @Override
    public AnnotationVisitor getAnnotationChecker(int api, Runnable onShouldGenerateAssertion) {
        return new AnnotationChecker(api, onShouldGenerateAssertion);
    }

    @Override
    public void generateAssertion(MethodVisitor writer, int methodStartLineNumber) {
        if (methodStartLineNumber != -1) {
            Label generatedCodeStart = new Label();
            writer.visitLabel(generatedCodeStart);
            writer.visitLineNumber(methodStartLineNumber, generatedCodeStart);
        }
        writer.visitMethodInsn(184, this.myThreadAssertionsClassName, this.myAssertionMethodName, "()V", false);
    }

    @NotNull
    static Set<? extends TMHAssertionGenerator> generators() {
        Set<? extends TMHAssertionGenerator> set = GENERATORS;
        if (set == null) {
            TMHAssertionGenerator2.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    static Set<? extends TMHAssertionGenerator> generators(@NotNull String threadAssertionsClassName, @NotNull String packageString) {
        if (threadAssertionsClassName == null) {
            TMHAssertionGenerator2.$$$reportNull$$$0(1);
        }
        if (packageString == null) {
            TMHAssertionGenerator2.$$$reportNull$$$0(2);
        }
        Set<TMHAssertionGenerator> set = Set.of(TMHAssertionGenerator2.generator(threadAssertionsClassName, packageString + "/RequiresEdt", "assertEventDispatchThread"), TMHAssertionGenerator2.generator(threadAssertionsClassName, packageString + "/RequiresBackgroundThread", "assertBackgroundThread"), TMHAssertionGenerator2.generator(threadAssertionsClassName, packageString + "/RequiresReadLock", "softAssertReadAccess"), TMHAssertionGenerator2.generator(threadAssertionsClassName, packageString + "/RequiresReadLockAbsence", "assertNoReadAccess"), TMHAssertionGenerator2.generator(threadAssertionsClassName, packageString + "/RequiresWriteLock", "assertWriteAccess"));
        if (set == null) {
            TMHAssertionGenerator2.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    private static TMHAssertionGenerator generator(@NotNull String threadAssertionsClassName, @NotNull String annotationClassName, @NotNull String assertionMethodName) {
        if (threadAssertionsClassName == null) {
            TMHAssertionGenerator2.$$$reportNull$$$0(4);
        }
        if (annotationClassName == null) {
            TMHAssertionGenerator2.$$$reportNull$$$0(5);
        }
        if (assertionMethodName == null) {
            TMHAssertionGenerator2.$$$reportNull$$$0(6);
        }
        return new TMHAssertionGenerator2(threadAssertionsClassName, Type.getType((String)("L" + annotationClassName + ";")), assertionMethodName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/devkit/threadingModelHelper/TMHAssertionGenerator2";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadAssertionsClassName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageString";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClassName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertionMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "generators";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/devkit/threadingModelHelper/TMHAssertionGenerator2";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generators";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AnnotationChecker
    extends AnnotationVisitor {
        private boolean myShouldGenerateAssertion = true;
        private final Runnable myOnShouldGenerateAssertion;

        private AnnotationChecker(int api, Runnable onShouldGenerateAssertion) {
            super(api);
            this.myOnShouldGenerateAssertion = onShouldGenerateAssertion;
        }

        public void visit(String annotationParameterName, Object value) {
            if (TMHAssertionGenerator2.GENERATE_ASSERTION_PARAMETER.equals(annotationParameterName) && Boolean.FALSE.equals(value)) {
                this.myShouldGenerateAssertion = false;
            }
        }

        public void visitEnd() {
            if (this.myShouldGenerateAssertion) {
                this.myOnShouldGenerateAssertion.run();
            }
        }
    }
}

