/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.devkit.threadingModelHelper;

import com.intellij.compiler.instrumentation.FailSafeMethodVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.devkit.threadingModelHelper.TMHAssertionGenerator;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public final class TMHInstrumenter {
    static boolean instrument(ClassReader classReader, ClassVisitor classWriter, Set<? extends TMHAssertionGenerator> generators, boolean generateLineNumbers) {
        AnnotatedMethodsCollector collector = new AnnotatedMethodsCollector(generators);
        int options = 4;
        if (!generateLineNumbers) {
            options |= 3;
        }
        classReader.accept((ClassVisitor)collector, options);
        if (collector.annotatedMethods.isEmpty()) {
            return false;
        }
        Instrumenter instrumenter = new Instrumenter(classWriter, collector.annotatedMethods);
        classReader.accept((ClassVisitor)instrumenter, 0);
        return true;
    }

    private static class AnnotatedMethodsCollector
    extends ClassVisitor {
        final Set<? extends TMHAssertionGenerator> assertionGenerators;
        final Map<MethodKey, InstrumentationInfo> annotatedMethods = new HashMap<MethodKey, InstrumentationInfo>();

        AnnotatedMethodsCollector(Set<? extends TMHAssertionGenerator> assertionGenerators) {
            super(589824);
            this.assertionGenerators = assertionGenerators;
        }

        public MethodVisitor visitMethod(int access, final String name, final String methodDescriptor, String signature, String[] exceptions) {
            return new MethodVisitor(589824){
                private final MethodKey methodKey;
                private boolean annotated;
                private boolean firstLineNumberVisited;
                {
                    super(arg0);
                    this.methodKey = new MethodKey(name, methodDescriptor);
                    this.annotated = false;
                    this.firstLineNumberVisited = false;
                }

                public AnnotationVisitor visitAnnotation(String annotationDescriptor, boolean visible) {
                    for (TMHAssertionGenerator tMHAssertionGenerator : assertionGenerators) {
                        if (!tMHAssertionGenerator.isMyAnnotation(annotationDescriptor)) continue;
                        return tMHAssertionGenerator.getAnnotationChecker(589824, () -> {
                            annotatedMethods.put(this.methodKey, new InstrumentationInfo(assertionGenerator));
                            this.annotated = true;
                        });
                    }
                    return super.visitAnnotation(annotationDescriptor, visible);
                }

                public void visitLineNumber(int line, Label start) {
                    super.visitLineNumber(line, start);
                    if (this.annotated && !this.firstLineNumberVisited) {
                        annotatedMethods.get((Object)this.methodKey).methodStartLineNumber = line;
                        this.firstLineNumberVisited = true;
                    }
                }
            };
        }
    }

    private static class Instrumenter
    extends ClassVisitor {
        private final Map<MethodKey, InstrumentationInfo> myAnnotatedMethods;

        Instrumenter(ClassVisitor writer, Map<MethodKey, InstrumentationInfo> annotatedMethods) {
            super(589824, writer);
            this.myAnnotatedMethods = annotatedMethods;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            final InstrumentationInfo instrumentationInfo = this.myAnnotatedMethods.get(new MethodKey(name, descriptor));
            if (instrumentationInfo == null) {
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
            return new FailSafeMethodVisitor(589824, super.visitMethod(access, name, descriptor, signature, exceptions)){

                public void visitCode() {
                    instrumentationInfo.assertionGenerator.generateAssertion(this.mv, instrumentationInfo.methodStartLineNumber);
                    super.visitCode();
                }
            };
        }
    }

    private static class InstrumentationInfo {
        final TMHAssertionGenerator assertionGenerator;
        int methodStartLineNumber = -1;

        private InstrumentationInfo(TMHAssertionGenerator generator) {
            this.assertionGenerator = generator;
        }
    }

    private static class MethodKey {
        final String name;
        final String descriptor;

        private MethodKey(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.descriptor.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MethodKey && ((MethodKey)obj).name.equals(this.name) && ((MethodKey)obj).descriptor.equals(this.descriptor);
        }
    }
}

