/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.runtimeModuleRepository.jps.build;

import com.intellij.devkit.runtimeModuleRepository.jps.build.RuntimeModuleRepositoryTarget;
import com.intellij.devkit.runtimeModuleRepository.jps.build.RuntimeModuleRepositoryValidator;
import com.intellij.devkit.runtimeModuleRepository.jps.impl.DevkitRuntimeModuleRepositoryJpsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.serialization.RuntimeModuleRepositorySerialization;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 82\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00018B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J4\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0019\u0010\u000f\u001a\u00020\u0007*\u00020\u000e2\u000b\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\u00020\u00072\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u001f2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00110(H\u0002J*\u0010)\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u001f2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00110(H\u0002Jl\u0010*\u001a\u00020\u00072\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110,2\u0006\u0010&\u001a\u00020\u001f2\u0016\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\u00110.j\b\u0012\u0004\u0012\u00020\u0011`/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f012\f\u00102\u001a\b\u0012\u0004\u0012\u000203012\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00110(H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000203H\u0002J\b\u00107\u001a\u00020\u0011H\u0016R\u0018\u0010\u001d\u001a\u00020\u001e*\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010 R\u0018\u0010!\u001a\u00020\u001e*\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0018\u0010#\u001a\u00020\u001e*\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010 \u00a8\u00069"}, d2={"Lcom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryBuilder;", "Lorg/jetbrains/jps/incremental/TargetBuilder;", "Lorg/jetbrains/jps/builders/BuildRootDescriptor;", "Lcom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryTarget;", "<init>", "()V", "build", "", "target", "holder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "outputConsumer", "Lorg/jetbrains/jps/builders/BuildOutputConsumer;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "reportError", "message", "", "Lorg/jetbrains/annotations/Nls;", "createDescriptors", "", "Lcom/intellij/platform/runtime/repository/serialization/RawRuntimeModuleDescriptor;", "project", "Lorg/jetbrains/jps/model/JpsProject;", "relativizer", "Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;", "generateDescriptorsForModules", "descriptors", "", "isTestOnly", "", "Lorg/jetbrains/jps/model/module/JpsModule;", "(Lorg/jetbrains/jps/model/module/JpsModule;)Z", "hasTestSources", "getHasTestSources", "hasProductionSources", "getHasProductionSources", "createProductionPartDescriptor", "module", "runtimeModuleNameGenerator", "Lkotlin/Function2;", "createTestPartDescriptor", "addTestDependency", "result", "", "processedDummyTestDependencies", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "addedTransitiveModuleDependencies", "", "addedTransitiveLibraryDependencies", "Lorg/jetbrains/jps/model/library/JpsLibrary;", "getLibraryId", "Lcom/intellij/platform/runtime/repository/RuntimeModuleId;", "library", "getPresentableName", "Companion", "intellij.devkit.runtimeModuleRepository.jps"})
@SourceDebugExtension(value={"SMAP\nRuntimeModuleRepositoryBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeModuleRepositoryBuilder.kt\ncom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryBuilder\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,271:1\n17#2,6:272\n17#2,6:278\n1557#3:284\n1628#3,3:285\n1628#3,3:288\n1755#3,3:291\n1755#3,3:294\n14#4:297\n*S KotlinDebug\n*F\n+ 1 RuntimeModuleRepositoryBuilder.kt\ncom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryBuilder\n*L\n65#1:272,6\n78#1:278,6\n106#1:284\n106#1:285,3\n115#1:288,3\n165#1:291,3\n168#1:294,3\n46#1:297\n*E\n"})
public final class RuntimeModuleRepositoryBuilder
extends TargetBuilder<BuildRootDescriptor, RuntimeModuleRepositoryTarget> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean GENERATE_DESCRIPTORS_FOR_TEST_MODULES = true;
    @NotNull
    private static final Logger LOG;

    public RuntimeModuleRepositoryBuilder() {
        super((Collection)CollectionsKt.listOf((Object)((Object)RuntimeModuleRepositoryTarget.Companion)));
    }

    public void build(@NotNull RuntimeModuleRepositoryTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, RuntimeModuleRepositoryTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)outputConsumer, (String)"outputConsumer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!holder.hasDirtyFiles() && !holder.hasRemovedFiles()) {
            LOG.debug("Runtime module repository is up to date");
            return;
        }
        JpsProject project = target.getProject();
        List<RawRuntimeModuleDescriptor> descriptors = null;
        context.processMessage((BuildMessage)new ProgressMessage(DevkitRuntimeModuleRepositoryJpsBundle.INSTANCE.message("progress.message.generating.intellij.modules.repository", new Object[0]), new BuildTargetChunk(SetsKt.setOf((Object)((Object)target)))));
        boolean $i$f$measureTimeMillis = false;
        long start$iv22 = System.currentTimeMillis();
        boolean bl = false;
        PathRelativizerService pathRelativizerService = context.getProjectDescriptor().dataManager.getRelativizer();
        Intrinsics.checkNotNullExpressionValue((Object)pathRelativizerService, (String)"getRelativizer(...)");
        descriptors = this.createDescriptors(project, pathRelativizerService);
        long timeToCreateDescriptors = System.currentTimeMillis() - start$iv22;
        LOG.info(descriptors.size() + " descriptors are created in " + timeToCreateDescriptors + "ms");
        RuntimeModuleRepositoryValidator.INSTANCE.validate(descriptors, (Function1<? super String, Unit>)((Function1)arg_0 -> RuntimeModuleRepositoryBuilder.build$lambda$1(this, context, arg_0)));
        JpsJavaProjectExtension jpsJavaProjectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(project);
        String outputUrl = jpsJavaProjectExtension != null ? jpsJavaProjectExtension.getOutputUrl() : null;
        CharSequence start$iv22 = outputUrl;
        if (start$iv22 == null || start$iv22.length() == 0) {
            this.reportError(context, DevkitRuntimeModuleRepositoryJpsBundle.INSTANCE.message("error.message.project.compiler.output.directory.is.not.specified", new Object[0]));
            return;
        }
        String[] stringArray = new String[]{"module-descriptors.jar"};
        Path outputPath = Path.of(JpsPathUtil.urlToOsPath((String)outputUrl), stringArray);
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv = System.currentTimeMillis();
        boolean bl2 = false;
        try {
            RuntimeModuleRepositorySerialization.saveToJar((Collection)descriptors, null, (Path)outputPath, (int)2);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            this.reportError(context, DevkitRuntimeModuleRepositoryJpsBundle.INSTANCE.message("error.message.failed.to.save.jar.file.0", objectArray));
        }
        long timeToSaveDescriptors = System.currentTimeMillis() - start$iv;
        File file = RuntimeModuleRepositoryTarget.Companion.getModulesXmlFile(project);
        if (file == null) {
            throw new IllegalStateException("Project was not loaded from .idea".toString());
        }
        File modulesXml = file;
        outputConsumer.registerOutputFile(outputPath.toFile(), (Collection)CollectionsKt.listOf((Object)modulesXml.getAbsolutePath()));
        LOG.info(descriptors.size() + " descriptors are saved in " + timeToSaveDescriptors + "ms");
    }

    private final void reportError(CompileContext $this$reportError, String message) {
        $this$reportError.processMessage((BuildMessage)new CompilerMessage("intellij-runtime-repository", BuildMessage.Kind.ERROR, message));
    }

    /*
     * WARNING - void declaration
     */
    private final List<RawRuntimeModuleDescriptor> createDescriptors(JpsProject project, PathRelativizerService relativizer) {
        ArrayList<RawRuntimeModuleDescriptor> descriptors = new ArrayList<RawRuntimeModuleDescriptor>();
        this.generateDescriptorsForModules((List<RawRuntimeModuleDescriptor>)descriptors, project);
        LinkedHashSet libraries = new LinkedHashSet();
        for (JpsModule module : project.getModules()) {
            Intrinsics.checkNotNull((Object)module);
            libraries.addAll(Companion.enumerateRuntimeDependencies$intellij_devkit_runtimeModuleRepository_jps(module).getLibraries());
        }
        Iterator iterator = libraries.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            JpsLibrary library = (JpsLibrary)e;
            RuntimeModuleId moduleId = this.getLibraryId(library);
            List files = library.getFiles(JpsOrderRootType.COMPILED);
            String string = moduleId.getStringId();
            Intrinsics.checkNotNull((Object)files);
            Iterable iterable = files;
            String string2 = string;
            ArrayList<RawRuntimeModuleDescriptor> arrayList = descriptors;
            boolean $i$f$map = false;
            void var11_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(relativizer.toRelative(it.getAbsolutePath()));
            }
            collection = (List)destination$iv$iv;
            arrayList.add(RawRuntimeModuleDescriptor.create((String)string2, (List)collection, (List)CollectionsKt.emptyList()));
        }
        return descriptors;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateDescriptorsForModules(List<RawRuntimeModuleDescriptor> descriptors, JpsProject project) {
        void $this$mapTo$iv;
        HashSet<String> productionModulesWithTestRoots = new HashSet<String>();
        HashSet<String> testModulesWithProductionRoots = new HashSet<String>();
        List list = project.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getModules(...)");
        Iterator iterator = list;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            JpsModule jpsModule = (JpsModule)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        HashSet allModuleNames = (HashSet)destination$iv;
        for (JpsModule module : project.getModules()) {
            String string = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)string, (String)".tests", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)module);
                if (this.getHasProductionSources(module)) {
                    testModulesWithProductionRoots.add(module.getName());
                }
            }
            if (!allModuleNames.contains(module.getName() + ".tests")) continue;
            Intrinsics.checkNotNull((Object)module);
            if (!this.getHasTestSources(module)) continue;
            productionModulesWithTestRoots.add(module.getName());
        }
        for (JpsModule module : project.getModules()) {
            Intrinsics.checkNotNull((Object)module);
            if (!this.isTestOnly(module)) {
                descriptors.add(this.createProductionPartDescriptor(module, (Function2<? super JpsModule, ? super Boolean, String>)((Function2)new Function2<JpsModule, Boolean, String>(productionModulesWithTestRoots, testModulesWithProductionRoots){
                    final /* synthetic */ HashSet<String> $productionModulesWithTestRoots;
                    final /* synthetic */ HashSet<String> $testModulesWithProductionRoots;
                    {
                        this.$productionModulesWithTestRoots = $productionModulesWithTestRoots;
                        this.$testModulesWithProductionRoots = $testModulesWithProductionRoots;
                        super(2, Intrinsics.Kotlin.class, "getRuntimeModuleName", "generateDescriptorsForModules$getRuntimeModuleName(Ljava/util/HashSet;Ljava/util/HashSet;Lorg/jetbrains/jps/model/module/JpsModule;Z)Ljava/lang/String;", 0);
                    }

                    public final String invoke(JpsModule p0, boolean p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return RuntimeModuleRepositoryBuilder.access$generateDescriptorsForModules$getRuntimeModuleName(this.$productionModulesWithTestRoots, this.$testModulesWithProductionRoots, p0, p1);
                    }
                })));
            }
            if (!this.getHasTestSources(module)) continue;
            descriptors.add(this.createTestPartDescriptor(module, (Function2<? super JpsModule, ? super Boolean, String>)((Function2)new Function2<JpsModule, Boolean, String>(productionModulesWithTestRoots, testModulesWithProductionRoots){
                final /* synthetic */ HashSet<String> $productionModulesWithTestRoots;
                final /* synthetic */ HashSet<String> $testModulesWithProductionRoots;
                {
                    this.$productionModulesWithTestRoots = $productionModulesWithTestRoots;
                    this.$testModulesWithProductionRoots = $testModulesWithProductionRoots;
                    super(2, Intrinsics.Kotlin.class, "getRuntimeModuleName", "generateDescriptorsForModules$getRuntimeModuleName(Ljava/util/HashSet;Ljava/util/HashSet;Lorg/jetbrains/jps/model/module/JpsModule;Z)Ljava/lang/String;", 0);
                }

                public final String invoke(JpsModule p0, boolean p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return RuntimeModuleRepositoryBuilder.access$generateDescriptorsForModules$getRuntimeModuleName(this.$productionModulesWithTestRoots, this.$testModulesWithProductionRoots, p0, p1);
                }
            })));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTestOnly(JpsModule $this$isTestOnly) {
        String string = $this$isTestOnly.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".tests", (boolean)false, (int)2, null)) return true;
        String string2 = $this$isTestOnly.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string2, (String)"all-tests", (boolean)false, (int)2, null)) return true;
        String string3 = $this$isTestOnly.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string3, (String)".test", (boolean)false, (int)2, null)) return true;
        String string4 = $this$isTestOnly.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string4, (String)".tests.main", (boolean)false, (int)2, null)) return true;
        String string5 = $this$isTestOnly.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
        if (StringsKt.contains$default((CharSequence)string5, (CharSequence)".tests.", (boolean)false, (int)2, null)) return true;
        String string6 = $this$isTestOnly.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string6, (String)"Tests", (boolean)false, (int)2, null)) return true;
        Object[] objectArray = new String[]{"kotlin.jvm-debugger.test.k2", "intellij.devkit.testFramework", "intellij.jupyter.testFramework", "kotlin-ultimate.spring-tests", "intellij.goland.tools", "intellij.kotlin.testsWithAndroidPlugin", "fleet"};
        if (!SetsKt.setOf((Object[])objectArray).contains($this$isTestOnly.getName())) return false;
        return true;
    }

    private final boolean getHasTestSources(JpsModule $this$hasTestSources) {
        boolean bl;
        block3: {
            List list = $this$hasTestSources.getSourceRoots();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JpsModuleSourceRoot it = (JpsModuleSourceRoot)element$iv;
                    boolean bl2 = false;
                    Set set = JavaModuleSourceRootTypes.TESTS;
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"TESTS");
                    if (!CollectionsKt.contains((Iterable)set, (Object)it.getRootType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean getHasProductionSources(JpsModule $this$hasProductionSources) {
        boolean bl;
        block3: {
            List list = $this$hasProductionSources.getSourceRoots();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JpsModuleSourceRoot it = (JpsModuleSourceRoot)element$iv;
                    boolean bl2 = false;
                    Set set = JavaModuleSourceRootTypes.PRODUCTION;
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"PRODUCTION");
                    if (!CollectionsKt.contains((Iterable)set, (Object)it.getRootType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final RawRuntimeModuleDescriptor createProductionPartDescriptor(JpsModule module, Function2<? super JpsModule, ? super Boolean, String> runtimeModuleNameGenerator) {
        LinkedHashSet dependencies = new LinkedHashSet();
        Companion.enumerateRuntimeDependencies$intellij_devkit_runtimeModuleRepository_jps(module).productionOnly().processModuleAndLibraries(arg_0 -> RuntimeModuleRepositoryBuilder.createProductionPartDescriptor$lambda$8(arg_0 -> RuntimeModuleRepositoryBuilder.createProductionPartDescriptor$lambda$7(dependencies, runtimeModuleNameGenerator, arg_0), arg_0), arg_0 -> RuntimeModuleRepositoryBuilder.createProductionPartDescriptor$lambda$10(arg_0 -> RuntimeModuleRepositoryBuilder.createProductionPartDescriptor$lambda$9(dependencies, this, arg_0), arg_0));
        List resourcePaths = this.getHasProductionSources(module) ? CollectionsKt.listOf((Object)("production/" + module.getName())) : CollectionsKt.emptyList();
        RawRuntimeModuleDescriptor rawRuntimeModuleDescriptor = RawRuntimeModuleDescriptor.create((String)((String)runtimeModuleNameGenerator.invoke((Object)module, (Object)false)), (List)resourcePaths, (List)CollectionsKt.toList((Iterable)dependencies));
        Intrinsics.checkNotNullExpressionValue((Object)rawRuntimeModuleDescriptor, (String)"create(...)");
        return rawRuntimeModuleDescriptor;
    }

    private final RawRuntimeModuleDescriptor createTestPartDescriptor(JpsModule module, Function2<? super JpsModule, ? super Boolean, String> runtimeModuleNameGenerator) {
        HashSet<JpsModule> addedTransitiveModuleDependencies = new HashSet<JpsModule>();
        HashSet<JpsLibrary> addedTransitiveLibraryDependencies = new HashSet<JpsLibrary>();
        JpsJavaExtensionService.dependencies((JpsModule)module).runtimeOnly().processModules(arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$lambda$18(arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$lambda$17(this, module, addedTransitiveModuleDependencies, addedTransitiveLibraryDependencies, arg_0), arg_0));
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = JpsJavaExtensionService.dependencies((JpsModule)module).withoutSdk().runtimeOnly().productionOnly();
        Intrinsics.checkNotNullExpressionValue((Object)jpsJavaDependenciesEnumerator, (String)"productionOnly(...)");
        RuntimeModuleRepositoryBuilder.createTestPartDescriptor$collectTransitiveDependencies(jpsJavaDependenciesEnumerator, addedTransitiveModuleDependencies, addedTransitiveLibraryDependencies);
        addedTransitiveModuleDependencies.remove(module);
        LinkedHashSet<Object> dependencies = new LinkedHashSet<Object>();
        HashSet processedDummyTestDependencies = new HashSet();
        if (this.getHasProductionSources(module)) {
            dependencies.add(runtimeModuleNameGenerator.invoke((Object)module, (Object)false));
        }
        Companion.enumerateRuntimeDependencies$intellij_devkit_runtimeModuleRepository_jps(module).processModuleAndLibraries(arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$lambda$20(arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$lambda$19(this, dependencies, runtimeModuleNameGenerator, processedDummyTestDependencies, addedTransitiveModuleDependencies, addedTransitiveLibraryDependencies, arg_0), arg_0), arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$lambda$22(arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$lambda$21(dependencies, this, arg_0), arg_0));
        List resourcePaths = this.getHasTestSources(module) ? CollectionsKt.listOf((Object)("test/" + module.getName())) : CollectionsKt.emptyList();
        RawRuntimeModuleDescriptor rawRuntimeModuleDescriptor = RawRuntimeModuleDescriptor.create((String)((String)runtimeModuleNameGenerator.invoke((Object)module, (Object)true)), (List)resourcePaths, (List)CollectionsKt.toList((Iterable)dependencies));
        Intrinsics.checkNotNullExpressionValue((Object)rawRuntimeModuleDescriptor, (String)"create(...)");
        return rawRuntimeModuleDescriptor;
    }

    private final void addTestDependency(Collection<String> result, JpsModule module, HashSet<String> processedDummyTestDependencies, Set<JpsModule> addedTransitiveModuleDependencies, Set<JpsLibrary> addedTransitiveLibraryDependencies, Function2<? super JpsModule, ? super Boolean, String> runtimeModuleNameGenerator) {
        if (this.getHasTestSources(module)) {
            result.add((String)runtimeModuleNameGenerator.invoke((Object)module, (Object)true));
            return;
        }
        if (!processedDummyTestDependencies.add(module.getName())) {
            return;
        }
        Companion.enumerateRuntimeDependencies$intellij_devkit_runtimeModuleRepository_jps(module).processModuleAndLibraries(arg_0 -> RuntimeModuleRepositoryBuilder.addTestDependency$lambda$24(arg_0 -> RuntimeModuleRepositoryBuilder.addTestDependency$lambda$23(this, result, processedDummyTestDependencies, addedTransitiveModuleDependencies, addedTransitiveLibraryDependencies, runtimeModuleNameGenerator, arg_0), arg_0), arg_0 -> RuntimeModuleRepositoryBuilder.addTestDependency$lambda$26(arg_0 -> RuntimeModuleRepositoryBuilder.addTestDependency$lambda$25(addedTransitiveLibraryDependencies, result, this, arg_0), arg_0));
    }

    private final RuntimeModuleId getLibraryId(JpsLibrary library) {
        String string = library.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        Intrinsics.checkNotNull((Object)library, (String)"null cannot be cast to non-null type org.jetbrains.jps.model.ex.JpsElementBase<*>");
        JpsElementBase element = ((JpsElementBase)library).getParent().getParent();
        if (element instanceof JpsModule) {
            List files = library.getFiles(JpsOrderRootType.COMPILED);
            if (StringsKt.startsWith$default((String)name, (String)"#", (boolean)false, (int)2, null) && files.size() == 1) {
                name = ((File)files.get(0)).getName();
            }
            RuntimeModuleId runtimeModuleId = RuntimeModuleId.moduleLibrary((String)((JpsModule)element).getName(), (String)name);
            Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId, (String)"moduleLibrary(...)");
            return runtimeModuleId;
        }
        RuntimeModuleId runtimeModuleId = RuntimeModuleId.projectLibrary((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)runtimeModuleId, (String)"projectLibrary(...)");
        return runtimeModuleId;
    }

    @NotNull
    public String getPresentableName() {
        return DevkitRuntimeModuleRepositoryJpsBundle.INSTANCE.message("builder.name.intellij.runtime.module.descriptors", new Object[0]);
    }

    private static final Unit build$lambda$1(RuntimeModuleRepositoryBuilder this$0, CompileContext $context, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reportError($context, it);
        return Unit.INSTANCE;
    }

    private static final String generateDescriptorsForModules$getRuntimeModuleName(HashSet<String> productionModulesWithTestRoots, HashSet<String> testModulesWithProductionRoots, JpsModule module, boolean tests) {
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String moduleName = string;
        if (tests) {
            if (productionModulesWithTestRoots.contains(moduleName)) {
                return moduleName + ".tests2";
            }
            if (!StringsKt.endsWith$default((String)moduleName, (String)".tests", (boolean)false, (int)2, null)) {
                return moduleName + ".tests";
            }
        } else if (testModulesWithProductionRoots.contains(moduleName)) {
            return moduleName + "2";
        }
        return moduleName;
    }

    private static final Unit createProductionPartDescriptor$lambda$7(LinkedHashSet $dependencies, Function2 $runtimeModuleNameGenerator, JpsModule it) {
        Intrinsics.checkNotNull((Object)it);
        $dependencies.add($runtimeModuleNameGenerator.invoke((Object)it, (Object)false));
        return Unit.INSTANCE;
    }

    private static final void createProductionPartDescriptor$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createProductionPartDescriptor$lambda$9(LinkedHashSet $dependencies, RuntimeModuleRepositoryBuilder this$0, JpsLibrary it) {
        Intrinsics.checkNotNull((Object)it);
        $dependencies.add(this$0.getLibraryId(it).getStringId());
        return Unit.INSTANCE;
    }

    private static final void createProductionPartDescriptor$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean createTestPartDescriptor$collectTransitiveDependencies$lambda$11(HashSet $addedTransitiveModuleDependencies, JpsDependencyElement dependency) {
        JpsModuleDependency jpsModuleDependency = dependency instanceof JpsModuleDependency ? (JpsModuleDependency)dependency : null;
        return !CollectionsKt.contains((Iterable)$addedTransitiveModuleDependencies, (Object)(jpsModuleDependency != null ? jpsModuleDependency.getModule() : null));
    }

    private static final boolean createTestPartDescriptor$collectTransitiveDependencies$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit createTestPartDescriptor$collectTransitiveDependencies$lambda$13(HashSet $addedTransitiveModuleDependencies, JpsModule it) {
        $addedTransitiveModuleDependencies.add(it);
        return Unit.INSTANCE;
    }

    private static final void createTestPartDescriptor$collectTransitiveDependencies$lambda$14(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createTestPartDescriptor$collectTransitiveDependencies$lambda$15(HashSet $addedTransitiveLibraryDependencies, JpsLibrary it) {
        $addedTransitiveLibraryDependencies.add(it);
        return Unit.INSTANCE;
    }

    private static final void createTestPartDescriptor$collectTransitiveDependencies$lambda$16(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void createTestPartDescriptor$collectTransitiveDependencies(JpsJavaDependenciesEnumerator $this$createTestPartDescriptor_u24collectTransitiveDependencies, HashSet<JpsModule> addedTransitiveModuleDependencies, HashSet<JpsLibrary> addedTransitiveLibraryDependencies) {
        $this$createTestPartDescriptor_u24collectTransitiveDependencies.recursively().satisfying(arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$collectTransitiveDependencies$lambda$12(arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$collectTransitiveDependencies$lambda$11(addedTransitiveModuleDependencies, arg_0), arg_0)).processModuleAndLibraries(arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$collectTransitiveDependencies$lambda$14(arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$collectTransitiveDependencies$lambda$13(addedTransitiveModuleDependencies, arg_0), arg_0), arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$collectTransitiveDependencies$lambda$16(arg_0 -> RuntimeModuleRepositoryBuilder.createTestPartDescriptor$collectTransitiveDependencies$lambda$15(addedTransitiveLibraryDependencies, arg_0), arg_0));
    }

    private static final Unit createTestPartDescriptor$lambda$17(RuntimeModuleRepositoryBuilder this$0, JpsModule $module, HashSet $addedTransitiveModuleDependencies, HashSet $addedTransitiveLibraryDependencies, JpsModule directDependency) {
        Intrinsics.checkNotNull((Object)directDependency);
        if (this$0.getHasTestSources(directDependency)) {
            JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = JpsJavaExtensionService.dependencies((JpsModule)$module).withoutSdk().runtimeOnly();
            Intrinsics.checkNotNullExpressionValue((Object)jpsJavaDependenciesEnumerator, (String)"runtimeOnly(...)");
            RuntimeModuleRepositoryBuilder.createTestPartDescriptor$collectTransitiveDependencies(jpsJavaDependenciesEnumerator, $addedTransitiveModuleDependencies, $addedTransitiveLibraryDependencies);
        }
        return Unit.INSTANCE;
    }

    private static final void createTestPartDescriptor$lambda$18(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createTestPartDescriptor$lambda$19(RuntimeModuleRepositoryBuilder this$0, LinkedHashSet $dependencies, Function2 $runtimeModuleNameGenerator, HashSet $processedDummyTestDependencies, HashSet $addedTransitiveModuleDependencies, HashSet $addedTransitiveLibraryDependencies, JpsModule dependency) {
        Intrinsics.checkNotNull((Object)dependency);
        if (this$0.getHasProductionSources(dependency)) {
            $dependencies.add($runtimeModuleNameGenerator.invoke((Object)dependency, (Object)false));
        }
        this$0.addTestDependency($dependencies, dependency, $processedDummyTestDependencies, $addedTransitiveModuleDependencies, $addedTransitiveLibraryDependencies, (Function2<? super JpsModule, ? super Boolean, String>)$runtimeModuleNameGenerator);
        return Unit.INSTANCE;
    }

    private static final void createTestPartDescriptor$lambda$20(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createTestPartDescriptor$lambda$21(LinkedHashSet $dependencies, RuntimeModuleRepositoryBuilder this$0, JpsLibrary it) {
        Intrinsics.checkNotNull((Object)it);
        $dependencies.add(this$0.getLibraryId(it).getStringId());
        return Unit.INSTANCE;
    }

    private static final void createTestPartDescriptor$lambda$22(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit addTestDependency$lambda$23(RuntimeModuleRepositoryBuilder this$0, Collection $result, HashSet $processedDummyTestDependencies, Set $addedTransitiveModuleDependencies, Set $addedTransitiveLibraryDependencies, Function2 $runtimeModuleNameGenerator, JpsModule it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.addTestDependency($result, it, $processedDummyTestDependencies, $addedTransitiveModuleDependencies, $addedTransitiveLibraryDependencies, (Function2<? super JpsModule, ? super Boolean, String>)$runtimeModuleNameGenerator);
        return Unit.INSTANCE;
    }

    private static final void addTestDependency$lambda$24(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit addTestDependency$lambda$25(Set $addedTransitiveLibraryDependencies, Collection $result, RuntimeModuleRepositoryBuilder this$0, JpsLibrary it) {
        Intrinsics.checkNotNull((Object)it);
        if ($addedTransitiveLibraryDependencies.add(it)) {
            String string = this$0.getLibraryId(it).getStringId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringId(...)");
            $result.add(string);
        }
        return Unit.INSTANCE;
    }

    private static final void addTestDependency$lambda$26(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$generateDescriptorsForModules$getRuntimeModuleName(HashSet productionModulesWithTestRoots, HashSet testModulesWithProductionRoots, JpsModule module, boolean tests) {
        return RuntimeModuleRepositoryBuilder.generateDescriptorsForModules$getRuntimeModuleName(productionModulesWithTestRoots, testModulesWithProductionRoots, module, tests);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RuntimeModuleRepositoryBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/devkit/runtimeModuleRepository/jps/build/RuntimeModuleRepositoryBuilder$Companion;", "", "<init>", "()V", "GENERATE_DESCRIPTORS_FOR_TEST_MODULES", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "enumerateRuntimeDependencies", "Lorg/jetbrains/jps/model/java/JpsJavaDependenciesEnumerator;", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "enumerateRuntimeDependencies$intellij_devkit_runtimeModuleRepository_jps", "intellij.devkit.runtimeModuleRepository.jps"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JpsJavaDependenciesEnumerator enumerateRuntimeDependencies$intellij_devkit_runtimeModuleRepository_jps(@NotNull JpsModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = JpsJavaExtensionService.dependencies((JpsModule)module).withoutSdk().withoutModuleSourceEntries().runtimeOnly();
            Intrinsics.checkNotNullExpressionValue((Object)jpsJavaDependenciesEnumerator, (String)"runtimeOnly(...)");
            return jpsJavaDependenciesEnumerator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

