/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.workspaceModel;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.devkit.workspaceModel.DevKitWorkspaceModelBundle;
import com.intellij.devkit.workspaceModel.WorkspaceModelGenerator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\r\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\nH\u0016J)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/devkit/workspaceModel/GenerateWorkspaceModelFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "psiElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getText", "", "Lorg/jetbrains/annotations/Nls;", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "startInWriteAction", "", "intellij.devkit.workspaceModel"})
final class GenerateWorkspaceModelFix
extends LocalQuickFixOnPsiElement {
    public GenerateWorkspaceModelFix(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        super(psiElement);
    }

    @NotNull
    public String getText() {
        return DevKitWorkspaceModelBundle.INSTANCE.message("inspection.workspace.msg.generate.implementation", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        Module module = projectFileIndex2.getModuleForFile(file.getVirtualFile());
        WorkspaceModelGenerator workspaceModelGenerator = WorkspaceModelGenerator.Companion.getInstance(project);
        Module module2 = module;
        Intrinsics.checkNotNull((Object)module2);
        workspaceModelGenerator.generate(module2);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

