/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.workspaceModel;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.devkit.workspaceModel.DevKitWorkspaceModelBundle;
import com.intellij.devkit.workspaceModel.GenerateWorkspaceModelFix;
import com.intellij.devkit.workspaceModel.WorkspaceKtClassExtentionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.workspaceModel.codegen.engine.CodeGeneratorKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/devkit/workspaceModel/WorkspaceImplGenerationInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.devkit.workspaceModel"})
public final class WorkspaceImplGenerationInspection
extends LocalInspectionTool {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitClass(KtClass klass) {
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                String superTypeFqn = WorkspaceKtClassExtentionsKt.getWorkspaceModelSuperType(klass);
                if (superTypeFqn == null) {
                    return;
                }
                ProblemHighlightType highlightType = null;
                String descriptionTemplate = null;
                if (Intrinsics.areEqual((Object)superTypeFqn, (Object)Reflection.getOrCreateKotlinClass(WorkspaceEntity.class).getQualifiedName())) {
                    if (!klass.isInterface()) {
                        return;
                    }
                    if (CollectionsKt.contains((Iterable)CodeGeneratorKt.getSKIPPED_TYPES(), (Object)klass.getName())) {
                        return;
                    }
                    if (WorkspaceKtClassExtentionsKt.isAbstractEntity(klass)) {
                        return;
                    }
                    if (Intrinsics.areEqual((Object)klass.getName(), (Object)"Builder")) {
                        return;
                    }
                    String string = klass.getName() + "Impl";
                    Project project = klass.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)klass.getProject());
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
                    Collection foundImplClasses = KotlinClassShortNameIndex.Helper.get(string, project, globalSearchScope);
                    if (foundImplClasses.isEmpty()) {
                        descriptionTemplate = DevKitWorkspaceModelBundle.INSTANCE.message("inspection.workspace.msg.absent.implementation", new Object[0]);
                        highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    } else {
                        descriptionTemplate = DevKitWorkspaceModelBundle.INSTANCE.message("inspection.workspace.msg.regenerate.implementation", new Object[0]);
                        highlightType = ProblemHighlightType.INFORMATION;
                    }
                } else {
                    descriptionTemplate = DevKitWorkspaceModelBundle.INSTANCE.message("inspection.workspace.msg.collect.class.metadata", new Object[0]);
                    highlightType = ProblemHighlightType.INFORMATION;
                }
                PsiElement psiElement = klass.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                PsiElement psiElement2 = klass.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement2);
                localQuickFixArray[0] = new GenerateWorkspaceModelFix(psiElement2);
                this.$holder.registerProblem(psiElement, descriptionTemplate, highlightType, localQuickFixArray);
            }
        };
    }
}

