/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateTemplateInPackageAction;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.actions.NewMessageBundleActionKt;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\f\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0014J#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0014J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/devkit/actions/NewMessageBundleAction;", "Lcom/intellij/ide/actions/CreateElementActionBase;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "invokeDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/psi/PsiDirectory;", "elementsConsumer", "Ljava/util/function/Consumer;", "", "Lcom/intellij/psi/PsiElement;", "create", "newName", "", "(Ljava/lang/String;Lcom/intellij/psi/PsiDirectory;)[Lcom/intellij/psi/PsiElement;", "getOrCreateResourcesRoot", "module", "Lcom/intellij/openapi/module/Module;", "isAvailable", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "startInWriteAction", "getErrorTitle", "getActionName", "intellij.devkit.core"})
public final class NewMessageBundleAction
extends CreateElementActionBase {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected void invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull Consumer<? super PsiElement[]> elementsConsumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(elementsConsumer, (String)"elementsConsumer");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)directory));
        if (module == null) {
            return;
        }
        Module module2 = module;
        String string = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".impl", (boolean)false, (int)2, null)) {
            ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
            String string2 = module2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (moduleManager.findModuleByName(StringsKt.removeSuffix((String)string2, (CharSequence)".impl")) != null) {
                Messages.showErrorDialog((Project)project, (String)DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.do.not.put.bundle.to.impl.module", new Object[0]), (String)this.getErrorTitle());
                return;
            }
        }
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        String defaultName = NewMessageBundleActionKt.generateDefaultBundleName(module2);
        String result = Messages.showInputDialog((Project)project, (String)DevKitBundle.message("action.DevKit.NewMessageBundle.label.bundle.name", new Object[0]), (String)DevKitBundle.message("action.DevKit.NewMessageBundle.title.create.new.message.bundle", new Object[0]), null, (String)defaultName, (InputValidator)((InputValidator)validator));
        if (result != null) {
            PsiElement[] psiElementArray = validator.getCreatedElements();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getCreatedElements(...)");
            elementsConsumer.accept((PsiElement[])psiElementArray);
        }
    }

    @NotNull
    protected PsiElement[] create(@NotNull String newName, @NotNull PsiDirectory directory) {
        PsiDirectory resourcesRoot;
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        PsiClass bundleClass = DevkitActionsUtil.createSingleClass(newName, "MessageBundle.java", directory);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)directory));
        if (module == null) {
            return new PsiElement[0];
        }
        Module module2 = module;
        XmlFile pluginXml = PluginModuleType.getPluginXml(module2);
        if (pluginXml != null) {
            DescriptorUtil.patchPluginXml((arg_0, arg_1) -> NewMessageBundleAction.create$lambda$0(module2, newName, arg_0, arg_1), bundleClass, pluginXml);
        }
        if ((resourcesRoot = this.getOrCreateResourcesRoot(module2)) == null) {
            PsiElement[] psiElementArray = new PsiElement[]{bundleClass};
            return psiElementArray;
        }
        Object object = ActionsKt.runWriteAction(() -> NewMessageBundleAction.create$lambda$1(resourcesRoot, newName));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction(...)");
        PsiFile propertiesFile = (PsiFile)object;
        PsiElement[] psiElementArray = new PsiElement[]{bundleClass, propertiesFile};
        return psiElementArray;
    }

    private final PsiDirectory getOrCreateResourcesRoot(Module module) {
        List list = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((List)list);
        if (virtualFile == null && (virtualFile = NewMessageBundleAction.getOrCreateResourcesRoot$createResourcesRoot(module, this)) == null) {
            return null;
        }
        VirtualFile resourcesRoot = virtualFile;
        return PsiManager.getInstance((Project)module.getProject()).findDirectory(resourcesRoot);
    }

    protected boolean isAvailable(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        if (!IntelliJProjectUtil.isIntelliJPlatformProject((Project)((Project)dataContext.getData(CommonDataKeys.PROJECT)))) {
            return false;
        }
        return CreateTemplateInPackageAction.isAvailable((DataContext)dataContext, (Set)JavaModuleSourceRootTypes.SOURCES, NewMessageBundleAction::isAvailable$lambda$5);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected String getErrorTitle() {
        String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.title.cannot.create.new.message.bundle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Object[] objectArray = new Object[]{newName};
        String string = DevKitBundle.message("action.DevKit.NewMessageBundle.action.name.create.new.message.bundle", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final void create$lambda$0(Module $module, String $newName, XmlFile xmlFile, PsiClass psiClass) {
        DomFileElement fileElement = DomManager.getDomManager((Project)$module.getProject()).getFileElement(xmlFile, IdeaPlugin.class);
        if (fileElement != null) {
            GenericDomValue<String> genericDomValue = ((IdeaPlugin)fileElement.getRootElement()).getResourceBundle();
            Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"getResourceBundle(...)");
            GenericDomValue<String> resourceBundle = genericDomValue;
            if (!resourceBundle.exists()) {
                resourceBundle.setValue((Object)("messages." + $newName));
            }
        }
    }

    private static final PsiFile create$lambda$1(PsiDirectory $resourcesRoot, String $newName) {
        String messagesDirName = "messages";
        PsiDirectory psiDirectory = $resourcesRoot.findSubdirectory(messagesDirName);
        if (psiDirectory == null) {
            PsiDirectory psiDirectory2 = $resourcesRoot.createSubdirectory(messagesDirName);
            psiDirectory = psiDirectory2;
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectory2, (String)"createSubdirectory(...)");
        }
        PsiDirectory messagesDir = psiDirectory;
        return messagesDir.createFile($newName + ".properties");
    }

    private static final Void getOrCreateResourcesRoot$reportError(Module $module, @Nls String message) {
        Object[] objectArray = new Object[]{message};
        Notification notification = new Notification("DevKit Errors", DevKitBundle.message("action.DevKit.NewMessageBundle.notification.title.cannot.create.resources.root.for.properties.file", new Object[0]), DevKitBundle.message("action.DevKit.NewMessageBundle.notification.content.cannot.create.resources.root.for.properties.file", objectArray), NotificationType.ERROR);
        Notifications.Bus.notify((Notification)notification, (Project)$module.getProject());
        return null;
    }

    private static final Unit getOrCreateResourcesRoot$createResourcesRoot$lambda$4$lambda$2(VirtualFile $resourcesDir, ModifiableRootModel it) {
        ContentEntry[] contentEntryArray = it.getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
        ((ContentEntry)ArraysKt.single((Object[])contentEntryArray)).addSourceFolder($resourcesDir, (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        return Unit.INSTANCE;
    }

    private static final void getOrCreateResourcesRoot$createResourcesRoot$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final VirtualFile getOrCreateResourcesRoot$createResourcesRoot$lambda$4(VirtualFile $contentRoot, NewMessageBundleAction this$0, String $resourcesDirName, Module $module) {
        VirtualFile virtualFile = $contentRoot.createChildDirectory((Object)this$0, $resourcesDirName);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createChildDirectory(...)");
        VirtualFile resourcesDir = virtualFile;
        ModuleRootModificationUtil.updateModel((Module)$module, arg_0 -> NewMessageBundleAction.getOrCreateResourcesRoot$createResourcesRoot$lambda$4$lambda$3(arg_0 -> NewMessageBundleAction.getOrCreateResourcesRoot$createResourcesRoot$lambda$4$lambda$2(resourcesDir, arg_0), arg_0));
        return resourcesDir;
    }

    private static final VirtualFile getOrCreateResourcesRoot$createResourcesRoot(Module $module, NewMessageBundleAction this$0) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)$module).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        VirtualFile virtualFile = (VirtualFile)ArraysKt.singleOrNull((Object[])virtualFileArray);
        if (virtualFile == null) {
            Object[] objectArray = new Object[]{$module.getName()};
            String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.multiple.content.roots.for.module", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return (VirtualFile)NewMessageBundleAction.getOrCreateResourcesRoot$reportError($module, string);
        }
        VirtualFile contentRoot = virtualFile;
        String resourcesDirName = "resources";
        if (contentRoot.findChild(resourcesDirName) != null) {
            Object[] objectArray = new Object[]{resourcesDirName, contentRoot.getPath()};
            String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.folder.already.exists", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return (VirtualFile)NewMessageBundleAction.getOrCreateResourcesRoot$reportError($module, string);
        }
        if (ProjectFileIndex.getInstance((Project)$module.getProject()).isInSource(contentRoot)) {
            Object[] objectArray = new Object[]{contentRoot.getPath()};
            String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.under.sources.root", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return (VirtualFile)NewMessageBundleAction.getOrCreateResourcesRoot$reportError($module, string);
        }
        return (VirtualFile)ActionsKt.runWriteAction(() -> NewMessageBundleAction.getOrCreateResourcesRoot$createResourcesRoot$lambda$4(contentRoot, this$0, resourcesDirName, $module));
    }

    private static final boolean isAvailable$lambda$5(PsiDirectory it) {
        return JavaCreateTemplateInPackageAction.doCheckPackageExists((PsiDirectory)it);
    }
}

