/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleHighlightingMarkupAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleHighlightingMarkupAction.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabled(editor != null && file != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToggleHighlightingMarkupAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleHighlightingMarkupAction.$$$reportNull$$$0(2);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || file == null) {
            return;
        }
        Project project = file.getProject();
        CommandProcessorEx commandProcessor = (CommandProcessorEx)CommandProcessor.getInstance();
        CommandToken commandToken = commandProcessor.startCommand(project, e.getPresentation().getText(), (Object)e.getPresentation().getText(), UndoConfirmationPolicy.DEFAULT);
        try {
            WriteAction.run(() -> {
                TextRange range = editor.getSelectionModel().hasSelection() ? EditorUtil.getSelectionInAnyMode((Editor)editor) : TextRange.create((int)0, (int)editor.getDocument().getTextLength());
                ToggleHighlightingMarkupAction.perform(project, editor.getDocument(), range);
            });
        }
        finally {
            commandProcessor.finishCommand(commandToken, null);
        }
    }

    private static void perform(Project project, Document document, TextRange selection) {
        CharSequence sequence = document.getCharsSequence();
        StringBuilder sb = new StringBuilder();
        Pattern pattern = Pattern.compile("<(/?(?:error|warning|EOLError|EOLWarning|info|weak_warning))((?:\\s|=|\\w+|\"(?:[^\"]|\\\\\")*?\")*?)>(.*?)");
        Matcher matcher = pattern.matcher(sequence);
        if (matcher.find(selection.getStartOffset())) {
            boolean compactMode = false;
            int pos = 0;
            while (matcher.start(0) < selection.getEndOffset()) {
                String tag = matcher.group(1);
                if (!tag.startsWith("/")) {
                    boolean hasDescription;
                    boolean bl = hasDescription = matcher.start(2) < matcher.end(2);
                    if (hasDescription) {
                        if (!compactMode) {
                            pos = 0;
                            sb.setLength(0);
                            compactMode = true;
                        }
                        sb.append(sequence, pos, matcher.start(2));
                        pos = matcher.end(2);
                    } else if (!compactMode) {
                        sb.append(sequence, pos, matcher.start());
                        pos = matcher.end();
                    }
                } else if (!compactMode) {
                    sb.append(sequence, pos, matcher.start());
                    pos = matcher.end();
                }
                if (matcher.find(matcher.end())) continue;
            }
            sb.append(sequence, pos, sequence.length());
        } else {
            int[] offset = new int[]{0};
            ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
            DaemonCodeAnalyzerEx.processHighlights((Document)document, (Project)project, (HighlightSeverity)HighlightSeverity.WARNING, (int)0, (int)sequence.length(), info -> {
                if (info.getSeverity() != HighlightSeverity.WARNING && info.getSeverity() != HighlightSeverity.ERROR) {
                    return true;
                }
                if (info.getStartOffset() >= selection.getEndOffset()) {
                    return false;
                }
                if (info.getEndOffset() > selection.getStartOffset()) {
                    offset[0] = ToggleHighlightingMarkupAction.appendInfo(info, sb, sequence, offset[0], infos);
                }
                return true;
            });
            offset[0] = ToggleHighlightingMarkupAction.appendInfo(null, sb, sequence, offset[0], infos);
            sb.append(sequence.subSequence(offset[0], sequence.length()));
        }
        document.setText((CharSequence)sb);
    }

    private static int appendInfo(@Nullable HighlightInfo info, StringBuilder sb, CharSequence sequence, int offset, ArrayList<HighlightInfo> infos) {
        if (info == null || !infos.isEmpty() && ToggleHighlightingMarkupAction.getMaxEnd(infos) < info.getStartOffset()) {
            if (infos.size() == 1) {
                HighlightInfo cur = infos.remove(0);
                sb.append(sequence.subSequence(offset, cur.getStartOffset()));
                ToggleHighlightingMarkupAction.appendTag(sb, cur, true);
                sb.append(sequence.subSequence(cur.getStartOffset(), cur.getEndOffset()));
                ToggleHighlightingMarkupAction.appendTag(sb, cur, false);
                offset = cur.getEndOffset();
            } else {
                LinkedList<HighlightInfo> stack = new LinkedList<HighlightInfo>();
                for (HighlightInfo cur : infos) {
                    offset = ToggleHighlightingMarkupAction.processStack(stack, sb, sequence, offset, cur.getStartOffset());
                    sb.append(sequence.subSequence(offset, cur.getStartOffset()));
                    offset = cur.getStartOffset();
                    ToggleHighlightingMarkupAction.appendTag(sb, cur, true);
                    stack.addLast(cur);
                }
                offset = ToggleHighlightingMarkupAction.processStack(stack, sb, sequence, offset, sequence.length());
                infos.clear();
            }
        }
        if (info != null) {
            boolean found = false;
            for (HighlightInfo cur : infos) {
                if (cur.getStartOffset() != info.getStartOffset() || cur.getEndOffset() != info.getEndOffset() || cur.getSeverity() != info.getSeverity()) continue;
                found = true;
                break;
            }
            if (!found) {
                infos.add(info);
            }
        }
        return offset;
    }

    private static int getMaxEnd(ArrayList<HighlightInfo> infos) {
        int max = -1;
        for (HighlightInfo info : infos) {
            int endOffset = info.getEndOffset();
            if (max >= endOffset) continue;
            max = endOffset;
        }
        return max;
    }

    private static int processStack(LinkedList<HighlightInfo> stack, StringBuilder sb, CharSequence sequence, int offset, int endOffset) {
        if (stack.isEmpty()) {
            return offset;
        }
        HighlightInfo cur = stack.peekLast();
        while (cur != null && cur.getEndOffset() <= endOffset) {
            stack.removeLast();
            if (offset <= cur.getEndOffset()) {
                sb.append(sequence.subSequence(offset, cur.getEndOffset()));
            }
            offset = cur.getEndOffset();
            ToggleHighlightingMarkupAction.appendTag(sb, cur, false);
            cur = stack.peekLast();
        }
        return offset;
    }

    private static void appendTag(@NonNls StringBuilder sb, HighlightInfo cur, boolean opening) {
        sb.append("<");
        if (!opening) {
            sb.append("/");
        }
        if (cur.isAfterEndOfLine()) {
            sb.append(cur.getSeverity() == HighlightSeverity.WARNING ? "EOLWarning" : "EOLError");
        } else {
            sb.append(cur.getSeverity() == HighlightSeverity.WARNING ? "warning" : "error");
        }
        if (opening) {
            sb.append(" descr=\"").append(cur.getDescription()).append("\"");
        }
        sb.append(">");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/actions/ToggleHighlightingMarkupAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/actions/ToggleHighlightingMarkupAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

