/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions.updateFromSources;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.updateSettings.impl.IdeRestartKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ProjectTaskManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Restarter;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesKt;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettings;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettingsKt;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettingsState;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a6\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000b\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001aF\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002\u001a \u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a#\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u001e\u001a1\u0010\u001f\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010!\u001a\u00020\u00152\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002\u00a2\u0006\u0002\u0010\"\u001a\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\u0015H\u0002\u001a\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00150(H\u0002\u001a.\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020\u00152\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0006\u0012\u0004\u0018\u00010\u00150.H\u0002\u001aF\u0010/\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u00100\u001a\u00020\n2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\r0$2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\r0$H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "updateFromSources", "", "project", "Lcom/intellij/openapi/project/Project;", "beforeRestart", "Lkotlin/Function0;", "restartAutomatically", "", "showError", "message", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "actions", "", "Lcom/intellij/notification/NotificationAction;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Lcom/intellij/notification/NotificationAction;)V", "checkIdeHome", "workIdeHome", "Ljava/nio/file/Path;", "runUpdateScript", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "deployDir", "builtDistDir", "startCopyingFiles", "builtDistPath", "generateUpdateCommand", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)[Ljava/lang/String;", "restartWithCommand", "command", "deployDirPath", "([Ljava/lang/String;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function0;)V", "readPluginsDir", "", "Lcom/intellij/ide/plugins/PluginNode;", "pluginsDirPath", "nonBundledPluginsPaths", "", "Lcom/intellij/openapi/extensions/PluginId;", "updateNonBundledPlugin", "newDescriptor", "pluginDir", "oldPluginPathProvider", "Lkotlin/Function1;", "createScriptJavaParameters", "buildEnabledPluginsOnly", "bundledPluginDirsToSkip", "nonBundledPluginDirsToInclude", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nUpdateFromSources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateFromSources.kt\norg/jetbrains/idea/devkit/actions/updateFromSources/UpdateFromSourcesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,382:1\n1#2:383\n3829#3:384\n4344#3,2:385\n1557#4:387\n1628#4,3:388\n774#4:391\n865#4,2:392\n1628#4,3:394\n1863#4,2:397\n662#5:399\n743#5,4:400\n*S KotlinDebug\n*F\n+ 1 UpdateFromSources.kt\norg/jetbrains/idea/devkit/actions/updateFromSources/UpdateFromSourcesKt\n*L\n83#1:384\n83#1:385,2\n84#1:387\n84#1:388,3\n85#1:391\n85#1:392,2\n86#1:394,3\n285#1:397,2\n318#1:399\n318#1:400,4\n*E\n"})
public final class UpdateFromSourcesKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public static final void updateFromSources(@NotNull Project project, @NotNull Function0<Unit> beforeRestart, boolean restartAutomatically) {
        boolean buildEnabledPluginsOnly;
        Object[] it;
        Object[] objectArray;
        UpdateFromSourcesSettingsState state;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(beforeRestart, (String)"beforeRestart");
                LOG.debug("Update from sources requested");
                state = UpdateFromSourcesSettings.Companion.getState();
                objectArray = project.getBasePath();
                if (objectArray == null) break block14;
                it = objectArray;
                boolean bl = false;
                Path path = Path.of((String)it, new String[0]);
                objectArray = path;
                if (path != null) break block15;
            }
            return;
        }
        Object[] devIdeaHome = objectArray;
        Path workIdeHome = Path.of(UpdateFromSourcesSettingsKt.getActualIdePath(state), new String[0]);
        if (!ApplicationManager.getApplication().isRestartCapable() && StringsKt.equals((String)UpdateFromSourcesSettingsKt.getActualIdePath(state), (String)PathManager.getHomePath(), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
            String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.ide.cannot.restart", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            UpdateFromSourcesKt.showError(project, string, new NotificationAction[0]);
            return;
        }
        Intrinsics.checkNotNull((Object)workIdeHome);
        String notIdeHomeMessage = UpdateFromSourcesKt.checkIdeHome(workIdeHome);
        if (notIdeHomeMessage != null) {
            it = new Object[]{workIdeHome, notIdeHomeMessage};
            String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.work.home.not.valid.ide.home", it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            UpdateFromSourcesKt.showError(project, string, new NotificationAction[0]);
            return;
        }
        if (PathManager.getConfigDir().startsWith(workIdeHome)) {
            it = new Object[]{workIdeHome, "idea.config.path"};
            String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.config.or.system.directory.under.home", it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            UpdateFromSourcesKt.showError(project, string, new NotificationAction[0]);
            return;
        }
        if (PathManager.getSystemDir().startsWith(workIdeHome)) {
            it = new Object[]{workIdeHome, "idea.system.path"};
            String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.config.or.system.directory.under.home", it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            UpdateFromSourcesKt.showError(project, string, new NotificationAction[0]);
            return;
        }
        List bundledPluginDirsToSkip = null;
        List nonBundledPluginDirsToInclude = null;
        boolean bl = buildEnabledPluginsOnly = !state.getBuildDisabledPlugins();
        if (buildEnabledPluginsOnly) {
            void $this$mapTo$iv;
            Path it2;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            LinkedHashSet pluginDirectoriesToSkip = new LinkedHashSet(state.getPluginDirectoriesForDisabledPlugins());
            pluginDirectoriesToSkip.removeAll(SequencesKt.toHashSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)PluginManagerCore.getLoadedPlugins()), UpdateFromSourcesKt::updateFromSources$lambda$1), UpdateFromSourcesKt::updateFromSources$lambda$2), UpdateFromSourcesKt::updateFromSources$lambda$3), UpdateFromSourcesKt::updateFromSources$lambda$4)));
            IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
            boolean $i$f$filter = false;
            void var13_14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (IdeaPluginDescriptor element$iv$iv : $this$filterTo$iv$iv) {
                void it3 = element$iv$iv;
                boolean bl2 = false;
                if (!(it3.isBundled() && !it3.isEnabled())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IdeaPluginDescriptor element$iv$iv;
                element$iv$iv = (IdeaPluginDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it2.getPluginPath());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                it2 = (Path)element$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it2);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(it2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it4;
                Path $i$f$filterTo2 = (Path)item$iv;
                collection = pluginDirectoriesToSkip;
                boolean bl5 = false;
                Intrinsics.checkNotNull((Object)it4);
                collection.add(PathsKt.getName((Path)it4));
            }
            List list = CollectionsKt.toMutableList((Collection)pluginDirectoriesToSkip);
            state.setPluginDirectoriesForDisabledPlugins(list);
            bundledPluginDirsToSkip = list;
            nonBundledPluginDirsToInclude = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])PluginManagerCore.getPlugins()), UpdateFromSourcesKt::updateFromSources$lambda$9), UpdateFromSourcesKt::updateFromSources$lambda$10), UpdateFromSourcesKt::updateFromSources$lambda$11), UpdateFromSourcesKt::updateFromSources$lambda$12));
        } else {
            bundledPluginDirsToSkip = CollectionsKt.emptyList();
            nonBundledPluginDirsToInclude = CollectionsKt.emptyList();
        }
        Path deployDir = devIdeaHome.resolve("out/deploy");
        Path builtDistDir = deployDir.resolve("dist");
        Intrinsics.checkNotNull((Object)deployDir);
        Intrinsics.checkNotNull((Object)builtDistDir);
        JavaParameters javaParameters = UpdateFromSourcesKt.createScriptJavaParameters(project, deployDir, builtDistDir, buildEnabledPluginsOnly, bundledPluginDirsToSkip, nonBundledPluginDirsToInclude);
        if (javaParameters == null) {
            return;
        }
        JavaParameters params = javaParameters;
        ProjectTaskManager taskManager = ProjectTaskManager.getInstance((Project)project);
        taskManager.run(taskManager.createModulesBuildTask(ModuleManager.Companion.getInstance(project).getModules(), true, true, true, false)).onSuccess(arg_0 -> UpdateFromSourcesKt.updateFromSources$lambda$14(arg_0 -> UpdateFromSourcesKt.updateFromSources$lambda$13(params, project, workIdeHome, deployDir, builtDistDir, restartAutomatically, beforeRestart, arg_0), arg_0));
    }

    private static final void showError(Project project, String message, NotificationAction ... actions) {
        new Notification("Update from Sources", DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.failed.title", new Object[0]), message, NotificationType.ERROR).addActions((Collection)ArraysKt.asList((Object[])actions)).notify(project);
    }

    private static final String checkIdeHome(Path workIdeHome) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(workIdeHome, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isDirectory(workIdeHome, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            return DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.work.home.not.valid.ide.home.not.directory", new Object[0]);
        }
        if (PathsKt.listDirectoryEntries$default((Path)workIdeHome, null, (int)1, null).isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[]{"bin", SystemInfo.isMac ? "Resources/build.txt" : "build.txt"};
        for (String name : CollectionsKt.listOf((Object[])objectArray)) {
            Object[] objectArray2;
            Intrinsics.checkNotNullExpressionValue((Object)workIdeHome.resolve(name), (String)"resolve(...)");
            LinkOption[] linkOptionArray3 = new LinkOption[0];
            if (!Files.notExists((Path)objectArray2, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) continue;
            objectArray2 = new Object[]{name};
            return DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.work.home.not.valid.ide.home.not.exists", objectArray2);
        }
        return null;
    }

    private static final void runUpdateScript(JavaParameters params, Project project, Path workIdeHome, Path deployDir, Path builtDistDir, boolean restartAutomatically, Function0<Unit> beforeRestart) {
        String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.title", new Object[0]);
        new Task.Backgroundable(project, builtDistDir, params, workIdeHome, restartAutomatically, deployDir, beforeRestart, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ Path $builtDistDir;
            final /* synthetic */ JavaParameters $params;
            final /* synthetic */ Path $workIdeHome;
            final /* synthetic */ boolean $restartAutomatically;
            final /* synthetic */ Path $deployDir;
            final /* synthetic */ Function0<Unit> $beforeRestart;
            {
                this.$project = $project;
                this.$builtDistDir = $builtDistDir;
                this.$params = $params;
                this.$workIdeHome = $workIdeHome;
                this.$restartAutomatically = $restartAutomatically;
                this.$deployDir = $deployDir;
                this.$beforeRestart = $beforeRestart;
                super($project, $super_call_param$1, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.progress.text", new Object[0]));
                Object[] objectArray = new Object[]{this.$builtDistDir};
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.progress.delete", objectArray));
                PathsKt.deleteRecursively((Path)this.$builtDistDir);
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.progress.start.script", new Object[0]));
                GeneralCommandLine generalCommandLine = this.$params.toCommandLine().withRedirectErrorStream(true);
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withRedirectErrorStream(...)");
                GeneralCommandLine commandLine = generalCommandLine;
                OSProcessHandler scriptHandler = new OSProcessHandler(commandLine);
                List<String> output = Collections.synchronizedList((List)new ArrayList<E>());
                scriptHandler.addProcessListener(new ProcessListener(output, indicator, this.$project, this.$builtDistDir, this.$workIdeHome, this.$restartAutomatically, this.$deployDir, this.$beforeRestart){
                    final /* synthetic */ List<String> $output;
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Path $builtDistDir;
                    final /* synthetic */ Path $workIdeHome;
                    final /* synthetic */ boolean $restartAutomatically;
                    final /* synthetic */ Path $deployDir;
                    final /* synthetic */ Function0<Unit> $beforeRestart;
                    {
                        this.$output = $output;
                        this.$indicator = $indicator;
                        this.$project = $project;
                        this.$builtDistDir = $builtDistDir;
                        this.$workIdeHome = $workIdeHome;
                        this.$restartAutomatically = $restartAutomatically;
                        this.$deployDir = $deployDir;
                        this.$beforeRestart = $beforeRestart;
                    }

                    public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                        this.$output.add(event.getText());
                        if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                            this.$indicator.setText2(event.getText());
                        }
                    }

                    public void processTerminated(ProcessEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (this.$indicator.isCanceled()) {
                            return;
                        }
                        if (event.getExitCode() != 0) {
                            Object[] objectArray = new Object[]{event.getExitCode()};
                            String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.failed.content", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            NotificationAction[] notificationActionArray = new NotificationAction[]{NotificationAction.createSimple((String)DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.action.view.output", new Object[0]), () -> runUpdateScript.run.1.processTerminated$lambda$0(this.$project, this.$output)), NotificationAction.createSimple((String)DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.action.view.debug.log", new Object[0]), () -> runUpdateScript.run.1.processTerminated$lambda$2(this.$deployDir, this.$project))};
                            UpdateFromSourcesKt.access$showError(this.$project, string, notificationActionArray);
                            return;
                        }
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!Files.isDirectory(this.$builtDistDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || PathsKt.listDirectoryEntries$default((Path)this.$builtDistDir, null, (int)1, null).isEmpty()) {
                            Object[] objectArray = new Object[]{this.$builtDistDir};
                            String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.empty.dir", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            UpdateFromSourcesKt.access$showError(this.$project, string, new NotificationAction[0]);
                            return;
                        }
                        if (!Intrinsics.areEqual((Object)this.$workIdeHome, (Object)Path.of(PathManager.getHomePath(), new String[0]))) {
                            UpdateFromSourcesKt.access$startCopyingFiles(this.$builtDistDir, this.$workIdeHome, this.$project);
                        } else {
                            String[] command = UpdateFromSourcesKt.access$generateUpdateCommand(this.$builtDistDir, this.$workIdeHome);
                            IdeRestartKt.restartOrNotify$default((Project)this.$project, (boolean)this.$restartAutomatically, null, () -> runUpdateScript.run.1.processTerminated$lambda$3(command, this.$deployDir, this.$beforeRestart), (int)4, null);
                        }
                    }

                    private static final void processTerminated$lambda$0(Project $project, List $output) {
                        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$project);
                        Intrinsics.checkNotNull((Object)$output);
                        fileEditorManager.openFile((VirtualFile)new LightVirtualFile("output.txt", (CharSequence)CollectionsKt.joinToString$default((Iterable)$output, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)), true);
                    }

                    private static final void processTerminated$lambda$2(Path $deployDir, Project $project) {
                        block0: {
                            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile($deployDir.resolve("log/debug.log"));
                            if (virtualFile == null) break block0;
                            VirtualFile logFile = virtualFile;
                            boolean bl = false;
                            logFile.refresh(true, false);
                            FileEditorManager.getInstance((Project)$project).openFile(logFile, true);
                        }
                    }

                    private static final Unit processTerminated$lambda$3(String[] $command, Path $deployDir, Function0 $beforeRestart) {
                        UpdateFromSourcesKt.access$restartWithCommand($command, $deployDir, $beforeRestart);
                        return Unit.INSTANCE;
                    }
                });
                scriptHandler.startNotify();
                while (!scriptHandler.isProcessTerminated()) {
                    scriptHandler.waitFor(300L);
                    indicator.checkCanceled();
                }
            }
        }.queue();
    }

    private static final void startCopyingFiles(Path builtDistPath, Path workIdeHome, Project project) {
        String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.title", new Object[0]);
        new Task.Backgroundable(project, workIdeHome, builtDistPath, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ Path $workIdeHome;
            final /* synthetic */ Path $builtDistPath;
            {
                this.$project = $project;
                this.$workIdeHome = $workIdeHome;
                this.$builtDistPath = $builtDistPath;
                super($project, $super_call_param$1, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(DevKitBundle.message("action.UpdateIdeFromSourcesAction.copy.progress.text", new Object[0]));
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.copy.delete.old.files.text", new Object[0]));
                PathsKt.deleteRecursively((Path)this.$workIdeHome);
                indicator.checkCanceled();
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.copy.copy.new.files.text", new Object[0]));
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(this.$workIdeHome, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                PathsKt.copyToRecursively$default((Path)this.$builtDistPath, (Path)this.$workIdeHome, null, (boolean)false, (boolean)false, (int)2, null);
                indicator.checkCanceled();
                Object[] objectArray = new Object[]{this.$workIdeHome};
                new Notification("Update from Sources", DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.title", new Object[0]), DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.content", objectArray), NotificationType.INFORMATION).notify(this.$project);
            }
        }.queue();
    }

    private static final String[] generateUpdateCommand(Path builtDistDir, Path workIdeHome) {
        if (SystemInfo.isWindows) {
            Path restartLogFile = PathManager.getLogDir().resolve("update-from-sources.log");
            Path updateScript = Files.createTempFile("update-from-sources", ".cmd", new FileAttribute[0]);
            String builtDistPath = ((Object)builtDistDir.toAbsolutePath()).toString();
            String workIdeHomePath = ((Object)workIdeHome.toAbsolutePath()).toString();
            Intrinsics.checkNotNull((Object)updateScript);
            PathsKt.writeText$default((Path)updateScript, (CharSequence)StringsKt.trimIndent((String)("\n        @echo off\n        SET count=20\n        SET time_to_wait=1\n        :DELETE_DIR\n        RMDIR /Q /S \"" + workIdeHomePath + "\"\n        IF EXIST \"" + workIdeHomePath + "\" (\n          IF %count% GEQ 0 (\n            ECHO \"" + workIdeHomePath + "\" still exists, wait %time_to_wait%s and try delete again\n            SET /A time_to_wait=%time_to_wait%+1\n            PING 127.0.0.1 -n %time_to_wait% >NUL\n            SET /A count=%count%-1\n            ECHO %count% attempts remain\n            GOTO DELETE_DIR\n          )\n          ECHO Failed to delete \"" + workIdeHomePath + "\", IDE wasn't updated. You may delete it manually and copy files from \"" + builtDistPath + "\" by hand  \n          GOTO CLEANUP_AND_EXIT \n        )\n        XCOPY \"" + builtDistPath + "\" \"" + workIdeHomePath + "\"\\ /Q /E /Y\n        :CLEANUP_AND_EXIT\n        START /b \"\" cmd /c DEL /Q /F \"" + updateScript.toAbsolutePath() + "\" & EXIT /b\n      ")), null, (OpenOption[])new OpenOption[0], (int)2, null);
            String[] stringArray = new String[]{"cmd", "/c", ((Object)updateScript.toAbsolutePath()).toString(), ">" + restartLogFile.toAbsolutePath(), "2>&1"};
            return stringArray;
        }
        String[] stringArray = new String[]{"/bin/sh", "-c", "rm -rf \"" + workIdeHome + "\"/* && cp -R \"" + builtDistDir + "\"/* \"" + workIdeHome + "\""};
        return stringArray;
    }

    private static final void restartWithCommand(String[] command, Path deployDirPath, Function0<Unit> beforeRestart) {
        Path pluginsDir = deployDirPath.resolve("artifacts/" + ApplicationInfo.getInstance().getBuild().getProductCode() + "-plugins");
        Lazy nonBundledPluginsPaths = LazyKt.lazy(UpdateFromSourcesKt::restartWithCommand$lambda$15);
        Intrinsics.checkNotNull((Object)pluginsDir);
        Iterable $this$forEach$iv = UpdateFromSourcesKt.readPluginsDir(pluginsDir);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginNode newPluginNode = (PluginNode)element$iv;
            boolean bl = false;
            UpdateFromSourcesKt.updateNonBundledPlugin(newPluginNode, pluginsDir, (Function1<? super PluginId, ? extends Path>)((Function1)arg_0 -> UpdateFromSourcesKt.restartWithCommand$lambda$17$lambda$16(nonBundledPluginsPaths, arg_0)));
        }
        Restarter.setCopyRestarterFiles();
        beforeRestart.invoke();
        ApplicationEx applicationEx = ApplicationManagerEx.getApplicationEx();
        Intrinsics.checkNotNull((Object)applicationEx, (String)"null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        ((ApplicationImpl)applicationEx).restart(7, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<PluginNode> readPluginsDir(Path pluginsDirPath) {
        Object object;
        Path pluginsXml = pluginsDirPath.resolve("plugins.xml");
        Intrinsics.checkNotNull((Object)pluginsXml);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(pluginsXml, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.warn("Cannot read non-bundled plugins from " + pluginsXml + ", they won't be updated");
            return CollectionsKt.emptyList();
        }
        try {
            List list;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(pluginsXml, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            object = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl = false;
                list = MarketplaceRequests.Companion.parsePluginList(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = list;
        }
        catch (Exception e) {
            LOG.error("Failed to parse " + pluginsXml, (Throwable)e);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<PluginId, Path> nonBundledPluginsPaths() {
        void var3_5;
        void var0;
        void $this$associateTo$iv$iv;
        Sequence $this$associate$iv = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)PluginManagerCore.getLoadedPlugins()), UpdateFromSourcesKt::nonBundledPluginsPaths$lambda$19);
        boolean $i$f$associate = false;
        Sequence sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getPluginId(), (Object)it.getPluginPath());
            map.put(pair.getFirst(), pair.getSecond());
        }
        void it = var0 = var3_5;
        boolean bl = false;
        LOG.debug("Existing custom plugins: " + (Map)it);
        return var0;
    }

    private static final void updateNonBundledPlugin(PluginNode newDescriptor, Path pluginDir, Function1<? super PluginId, ? extends Path> oldPluginPathProvider) {
        Path path;
        boolean bl;
        boolean bl2 = bl = !newDescriptor.isBundled();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PluginId pluginId = newDescriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        Path path2 = (Path)oldPluginPathProvider.invoke((Object)pluginId);
        if (path2 == null) {
            return;
        }
        Path oldPluginPath = path2;
        Path it = path = pluginDir.resolve(newDescriptor.getDownloadUrl());
        boolean bl3 = false;
        LOG.debug("Adding update command: " + oldPluginPath + " to " + it);
        Path newPluginPath = path;
        PluginInstaller.installAfterRestart((IdeaPluginDescriptor)((IdeaPluginDescriptor)newDescriptor), (Path)newPluginPath, (Path)oldPluginPath, (boolean)false);
    }

    private static final JavaParameters createScriptJavaParameters(Project project, Path deployDir, Path builtDistPath, boolean buildEnabledPluginsOnly, List<String> bundledPluginDirsToSkip, List<String> nonBundledPluginDirsToInclude) {
        Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (sdk == null) {
            String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.no.sdk", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            UpdateFromSourcesKt.showError(project, string, new NotificationAction[0]);
            return null;
        }
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
        boolean ultimate = moduleManager.findModuleByName("intellij.idea.ultimate.main") != null;
        JavaParameters params = new JavaParameters();
        params.setUseClasspathJar(true);
        params.setDefaultCharset(project);
        params.setJdk(sdk);
        params.setMainClass(ultimate ? "UltimateUpdateFromSourcesBuildTarget" : "OpenSourceCommunityUpdateFromSourcesBuildTarget");
        params.getProgramParametersList().add("--classpath");
        String buildScriptsModuleName = ultimate ? "intellij.idea.ultimate.build" : "intellij.idea.community.build";
        Module buildScriptsModule = moduleManager.findModuleByName(buildScriptsModuleName);
        if (buildScriptsModule == null) {
            Object[] objectArray = new Object[]{buildScriptsModuleName};
            String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.no.module", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            UpdateFromSourcesKt.showError(project, string, new NotificationAction[0]);
            return null;
        }
        List list = OrderEnumerator.orderEntries((Module)buildScriptsModule).recursively().withoutSdk().runtimeOnly().productionOnly().classes().getPathsList().getPathList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathList(...)");
        List classpath = list;
        params.getClassPath().addAll(classpath);
        params.getVMParametersList().add("-Dintellij.build.bundled.jre.prefix=jbrsdk_jcef-");
        if (buildEnabledPluginsOnly) {
            if (!((Collection)bundledPluginDirsToSkip).isEmpty()) {
                params.getVMParametersList().add("-Dintellij.build.bundled.plugin.dirs.to.skip=" + CollectionsKt.joinToString$default((Iterable)bundledPluginDirsToSkip, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            String nonBundled = !((Collection)nonBundledPluginDirsToInclude).isEmpty() ? CollectionsKt.joinToString$default((Iterable)nonBundledPluginDirsToInclude, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : "none";
            params.getVMParametersList().add("-Dintellij.build.non.bundled.plugin.dirs.to.include=" + nonBundled);
        }
        if (!buildEnabledPluginsOnly || !((Collection)nonBundledPluginDirsToInclude).isEmpty()) {
            params.getVMParametersList().add("-Dintellij.build.local.plugins.repository=true");
        }
        params.getVMParametersList().add("-Dintellij.build.output.root=" + deployDir);
        params.getVMParametersList().add("-DdistOutputRelativePath=" + deployDir.relativize(builtDistPath));
        return params;
    }

    private static final boolean updateFromSources$lambda$1(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isBundled();
    }

    private static final Path updateFromSources$lambda$2(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPluginPath();
    }

    private static final boolean updateFromSources$lambda$3(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final String updateFromSources$lambda$4(Path it) {
        Intrinsics.checkNotNull((Object)it);
        return PathsKt.getName((Path)it);
    }

    private static final boolean updateFromSources$lambda$9(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isBundled() && it.isEnabled();
    }

    private static final Path updateFromSources$lambda$10(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPluginPath();
    }

    private static final boolean updateFromSources$lambda$11(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final String updateFromSources$lambda$12(Path it) {
        Intrinsics.checkNotNull((Object)it);
        return PathsKt.getName((Path)it);
    }

    private static final Unit updateFromSources$lambda$13(JavaParameters $params, Project $project, Path $workIdeHome, Path $deployDir, Path $builtDistDir, boolean $restartAutomatically, Function0 $beforeRestart, ProjectTaskManager.Result it) {
        if (!it.isAborted() && !it.hasErrors()) {
            Intrinsics.checkNotNull((Object)$workIdeHome);
            Intrinsics.checkNotNull((Object)$deployDir);
            Intrinsics.checkNotNull((Object)$builtDistDir);
            UpdateFromSourcesKt.runUpdateScript($params, $project, $workIdeHome, $deployDir, $builtDistDir, $restartAutomatically, (Function0<Unit>)$beforeRestart);
        }
        return Unit.INSTANCE;
    }

    private static final void updateFromSources$lambda$14(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Map restartWithCommand$lambda$15() {
        return UpdateFromSourcesKt.nonBundledPluginsPaths();
    }

    private static final Path restartWithCommand$lambda$17$lambda$16(Lazy $nonBundledPluginsPaths, PluginId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Path)((Map)$nonBundledPluginsPaths.getValue()).get(it);
    }

    private static final boolean nonBundledPluginsPaths$lambda$19(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isBundled();
    }

    public static final /* synthetic */ void access$showError(Project project, String message, NotificationAction ... actions) {
        UpdateFromSourcesKt.showError(project, message, actions);
    }

    public static final /* synthetic */ void access$startCopyingFiles(Path builtDistPath, Path workIdeHome, Project project) {
        UpdateFromSourcesKt.startCopyingFiles(builtDistPath, workIdeHome, project);
    }

    public static final /* synthetic */ String[] access$generateUpdateCommand(Path builtDistDir, Path workIdeHome) {
        return UpdateFromSourcesKt.generateUpdateCommand(builtDistDir, workIdeHome);
    }

    public static final /* synthetic */ void access$restartWithCommand(String[] command, Path deployDirPath, Function0 beforeRestart) {
        UpdateFromSourcesKt.restartWithCommand(command, deployDirPath, (Function0<Unit>)beforeRestart);
    }

    static {
        Logger logger = Logger.getInstance((String)"org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesKt");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

