/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions.updateFromSources;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesDialog;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesKt;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettings;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettingsKt;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettingsState;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u0013\b\u0004\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/actions/updateFromSources/UpdateIdeFromSourcesActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "forceShowSettings", "", "<init>", "(Z)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Lorg/jetbrains/idea/devkit/actions/updateFromSources/UpdateIdeFromSourcesAction;", "Lorg/jetbrains/idea/devkit/actions/updateFromSources/UpdateIdeFromSourcesSettingsAction;", "intellij.devkit.core"})
public abstract class UpdateIdeFromSourcesActionBase
extends DumbAwareAction {
    private final boolean forceShowSettings;

    private UpdateIdeFromSourcesActionBase(boolean forceShowSettings) {
        this.forceShowSettings = forceShowSettings;
    }

    public /* synthetic */ UpdateIdeFromSourcesActionBase(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl, null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        UpdateFromSourcesSettingsState settings = UpdateFromSourcesSettings.Companion.getState();
        if (this.forceShowSettings || settings.getShowSettings()) {
            String oldWorkIdePath = UpdateFromSourcesSettingsKt.getActualIdePath(settings);
            boolean ok = new UpdateFromSourcesDialog(project2, this.forceShowSettings).showAndGet();
            if (!ok) {
                return;
            }
            UpdateFromSourcesSettingsState updatedState = settings;
            if (!Intrinsics.areEqual((Object)oldWorkIdePath, (Object)UpdateFromSourcesSettingsKt.getActualIdePath(updatedState))) {
                updatedState.getWorkIdePathsHistory().remove(oldWorkIdePath);
                updatedState.getWorkIdePathsHistory().remove(UpdateFromSourcesSettingsKt.getActualIdePath(updatedState));
                updatedState.getWorkIdePathsHistory().add(0, UpdateFromSourcesSettingsKt.getActualIdePath(updatedState));
                updatedState.getWorkIdePathsHistory().add(0, oldWorkIdePath);
            }
        }
        UpdateFromSourcesKt.updateFromSources(project2, (Function0<Unit>)((Function0)UpdateIdeFromSourcesActionBase::actionPerformed$lambda$0), settings.getRestartAutomatically());
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && IntelliJProjectUtil.isIntelliJPlatformProject((Project)project));
    }

    private static final Unit actionPerformed$lambda$0() {
        return Unit.INSTANCE;
    }

    public /* synthetic */ UpdateIdeFromSourcesActionBase(boolean forceShowSettings, DefaultConstructorMarker $constructor_marker) {
        this(forceShowSettings);
    }
}

