/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.commit;

import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.commit.DevKitGitBundle;
import org.jetbrains.idea.devkit.commit.IssueIDPrePushHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\r\u0010\u0013\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0014H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/devkit/commit/IntelliJPrePushHandler;", "Lorg/jetbrains/idea/devkit/commit/IssueIDPrePushHandler;", "<init>", "()V", "paths", "", "", "getPaths", "()Ljava/util/List;", "pathsToIgnore", "getPathsToIgnore", "commitMessageRegex", "Lkotlin/text/Regex;", "getCommitMessageRegex", "()Lkotlin/text/Regex;", "ignorePattern", "getIgnorePattern", "isAvailable", "", "getPresentableName", "Lorg/jetbrains/annotations/Nls;", "intellij.devkit.git"})
public final class IntelliJPrePushHandler
extends IssueIDPrePushHandler {
    @NotNull
    private final List<String> paths;
    @NotNull
    private final List<String> pathsToIgnore;
    @NotNull
    private final Regex commitMessageRegex;
    @NotNull
    private final Regex ignorePattern;

    public IntelliJPrePushHandler() {
        Object[] objectArray = new String[]{"community", "platform"};
        this.paths = CollectionsKt.listOf((Object[])objectArray);
        this.pathsToIgnore = CollectionsKt.listOf((Object)"plugins/kotlin/");
        this.commitMessageRegex = new Regex(".*[A-Z]+-\\d+.*", RegexOption.DOT_MATCHES_ALL);
        this.ignorePattern = new Regex("(tests|cleanup):.*");
    }

    @Override
    @NotNull
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    @NotNull
    public List<String> getPathsToIgnore() {
        return this.pathsToIgnore;
    }

    @Override
    @NotNull
    public Regex getCommitMessageRegex() {
        return this.commitMessageRegex;
    }

    @Override
    @NotNull
    public Regex getIgnorePattern() {
        return this.ignorePattern;
    }

    @Override
    public boolean isAvailable() {
        return Registry.Companion.is("intellij.commit.message.validation.enabled", true);
    }

    @NotNull
    public String getPresentableName() {
        String string = DevKitGitBundle.message("push.commit.handler.idea.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

