/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.util.PsiUtil;

final class ExtensionOrderKeywordCompletionContributor
extends CompletionContributor {
    private static final LookupElementBuilder KEYWORD_VARIANT_FIRST = LookupElementBuilder.create((String)"first");
    private static final LookupElementBuilder KEYWORD_VARIANT_LAST = LookupElementBuilder.create((String)"last");
    private static final LookupElementBuilder KEYWORD_VARIANT_BEFORE = LookupElementBuilder.create((String)"before ".trim()).withInsertHandler(AddSpaceInsertHandler.INSTANCE_WITH_AUTO_POPUP);
    private static final LookupElementBuilder KEYWORD_VARIANT_AFTER = LookupElementBuilder.create((String)"after ".trim()).withInsertHandler(AddSpaceInsertHandler.INSTANCE_WITH_AUTO_POPUP);

    ExtensionOrderKeywordCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)ExtensionOrderKeywordCompletionContributor.getCapture(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                String prefix;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!ExtensionOrderKeywordCompletionContributor.shouldProposeKeywordsAfterPrefix(prefix = ExtensionOrderKeywordCompletionContributor.getCompletionPrefix(parameters))) {
                    return;
                }
                if (ExtensionOrderKeywordCompletionContributor.shouldProposeFirstLastKeywordsAfterPrefix(prefix)) {
                    result.addElement((LookupElement)KEYWORD_VARIANT_FIRST);
                    result.addElement((LookupElement)KEYWORD_VARIANT_LAST);
                }
                result.addElement((LookupElement)KEYWORD_VARIANT_BEFORE);
                result.addElement((LookupElement)KEYWORD_VARIANT_AFTER);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/devkit/completion/ExtensionOrderKeywordCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static PsiElementPattern.Capture<PsiElement> getCapture() {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"order"}).inside((ElementPattern)XmlPatterns.xmlTag().with((PatternCondition)new PatternCondition<XmlTag>("extension tag"){

            public boolean accepts(@NotNull XmlTag tag, ProcessingContext context) {
                if (tag == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!PsiUtil.isPluginXmlPsiElement((PsiElement)tag)) {
                    return false;
                }
                DomManager domManager = DomManager.getDomManager((Project)tag.getProject());
                return domManager.getDomElement(tag) instanceof Extension;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/idea/devkit/completion/ExtensionOrderKeywordCompletionContributor$2", "accepts"));
            }
        })));
        if (capture == null) {
            ExtensionOrderKeywordCompletionContributor.$$$reportNull$$$0(0);
        }
        return capture;
    }

    @NotNull
    private static String getCompletionPrefix(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            ExtensionOrderKeywordCompletionContributor.$$$reportNull$$$0(1);
        }
        XmlElement position = (XmlElement)parameters.getPosition();
        int startOffset = position.getTextOffset();
        int endOffset = parameters.getOffset();
        Document document = parameters.getEditor().getDocument();
        String string = document.getText(new TextRange(startOffset, endOffset));
        if (string == null) {
            ExtensionOrderKeywordCompletionContributor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getPrefixLastPart(@NotNull String prefix) {
        String lastPart;
        if (prefix == null) {
            ExtensionOrderKeywordCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((lastPart = StringUtil.substringAfterLast((String)prefix, (String)String.valueOf(','))) == null) {
            lastPart = prefix;
        }
        String string = lastPart = StringUtil.trimLeading((String)lastPart);
        if (string == null) {
            ExtensionOrderKeywordCompletionContributor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static boolean shouldProposeKeywordsAfterPrefix(@NotNull String prefix) {
        if (prefix == null) {
            ExtensionOrderKeywordCompletionContributor.$$$reportNull$$$0(5);
        }
        return !ExtensionOrderKeywordCompletionContributor.getPrefixLastPart(prefix).contains(" ");
    }

    private static boolean shouldProposeFirstLastKeywordsAfterPrefix(@NotNull String prefix) {
        String[] parts;
        if (prefix == null) {
            ExtensionOrderKeywordCompletionContributor.$$$reportNull$$$0(6);
        }
        for (String part : parts = prefix.split(String.valueOf(','))) {
            if (!part.trim().equalsIgnoreCase("first") && !part.trim().equalsIgnoreCase("last")) continue;
            return false;
        }
        return true;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        String prefix;
        if (parameters == null) {
            ExtensionOrderKeywordCompletionContributor.$$$reportNull$$$0(7);
        }
        if (result == null) {
            ExtensionOrderKeywordCompletionContributor.$$$reportNull$$$0(8);
        }
        result = (prefix = result.getPrefixMatcher().getPrefix()).endsWith(String.valueOf(',')) ? result.withPrefixMatcher("") : result.withPrefixMatcher(ExtensionOrderKeywordCompletionContributor.getPrefixLastPart(prefix));
        super.fillCompletionVariants(parameters, result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/completion/ExtensionOrderKeywordCompletionContributor";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapture";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/completion/ExtensionOrderKeywordCompletionContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixLastPart";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionPrefix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixLastPart";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldProposeKeywordsAfterPrefix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldProposeFirstLastKeywordsAfterPrefix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

