/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.debugger;

import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.ExtraDebugNodesProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.debugger.DebugeeIdeStateRendererKt;
import org.jetbrains.idea.devkit.debugger.DevKitDebuggerBundle;
import org.jetbrains.idea.devkit.debugger.IdeState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/devkit/debugger/DebugeeIdeStateRenderer;", "Lcom/intellij/debugger/ui/tree/ExtraDebugNodesProvider;", "<init>", "()V", "addExtraNodes", "", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "children", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "intellij.devkit.debugger"})
public final class DebugeeIdeStateRenderer
implements ExtraDebugNodesProvider {
    public void addExtraNodes(@NotNull EvaluationContext evaluationContext, @NotNull XValueChildrenList children) {
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        Intrinsics.checkNotNullParameter((Object)children, (String)"children");
        if (!Registry.Companion.is("devkit.debugger.show.ide.state")) {
            return;
        }
        IdeState ideState = DebugeeIdeStateRendererKt.getIdeState(evaluationContext);
        if (ideState == null) {
            return;
        }
        IdeState ideState2 = ideState;
        if (ideState2.getReadAllowed() == null && ideState2.getWriteAllowed() == null) {
            return;
        }
        Pair pair = DebugeeIdeStateRendererKt.access$adjustLockStatus(TuplesKt.to((Object)ideState2.getReadAllowed(), (Object)ideState2.getWriteAllowed()), evaluationContext);
        Boolean isReadActionAllowed = (Boolean)pair.component1();
        Boolean isWriteActionAllowed = (Boolean)pair.component2();
        String string = DevKitDebuggerBundle.message("debugger.ide.state", new Object[0]);
        children.addTopValue(new XNamedValue(isReadActionAllowed, isWriteActionAllowed, evaluationContext, string){
            final /* synthetic */ Boolean $isReadActionAllowed;
            final /* synthetic */ Boolean $isWriteActionAllowed;
            final /* synthetic */ EvaluationContext $evaluationContext;
            {
                this.$isReadActionAllowed = $isReadActionAllowed;
                this.$isWriteActionAllowed = $isWriteActionAllowed;
                this.$evaluationContext = $evaluationContext;
                super($super_call_param$1);
            }

            public boolean canNavigateToSource() {
                return false;
            }

            public void computePresentation(XValueNode node, XValuePlace place) {
                String string;
                String readState;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                if (this.$isReadActionAllowed != null) {
                    Object[] objectArray = new Object[]{DebugeeIdeStateRenderer.access$addExtraNodes$icon(this.$isReadActionAllowed)};
                    v0 = DevKitDebuggerBundle.message("debugger.read.state", objectArray);
                } else {
                    v0 = readState = null;
                }
                if (this.$isWriteActionAllowed != null) {
                    Object[] objectArray = new Object[]{DebugeeIdeStateRenderer.access$addExtraNodes$icon(this.$isWriteActionAllowed)};
                    string = DevKitDebuggerBundle.message("debugger.write.state", objectArray);
                } else {
                    string = null;
                }
                String writeState = string;
                Object[] objectArray = new String[]{readState, writeState};
                String value = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                node.setPresentation(AllIcons.Nodes.EnterpriseProject, null, value, true);
            }

            public void computeChildren(XCompositeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.addChild(node, this.$isReadActionAllowed, true, !Intrinsics.areEqual((Object)this.$isWriteActionAllowed, (Object)true));
                this.addChild(node, this.$isWriteActionAllowed, false, true);
                node.addChildren(XValueChildrenList.EMPTY, true);
            }

            private final void addChild(XCompositeNode node, Boolean value, boolean isRead, boolean addLink) {
                if (value == null) {
                    return;
                }
                String nameKey = isRead ? "debugger.read.allowed" : "debugger.write.allowed";
                Icon icon = isRead ? AllIcons.Actions.ShowReadAccess : AllIcons.Actions.ShowWriteAccess;
                Intrinsics.checkNotNull((Object)icon);
                Icon icon2 = icon;
                node.addChildren(XValueChildrenList.singleton((String)DevKitDebuggerBundle.message(nameKey, new Object[0]), (XValue)new XValue(icon2, value, addLink, isRead, this.$evaluationContext){
                    final /* synthetic */ Icon $icon;
                    final /* synthetic */ Boolean $value;
                    final /* synthetic */ boolean $addLink;
                    final /* synthetic */ boolean $isRead;
                    final /* synthetic */ EvaluationContext $evaluationContext;
                    {
                        this.$icon = $icon;
                        this.$value = $value;
                        this.$addLink = $addLink;
                        this.$isRead = $isRead;
                        this.$evaluationContext = $evaluationContext;
                    }

                    public boolean canNavigateToSource() {
                        return false;
                    }

                    public void computePresentation(XValueNode node, XValuePlace place) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                        node.setPresentation(this.$icon, null, this.$value.toString(), false);
                        if (Intrinsics.areEqual((Object)this.$value, (Object)true) && this.$addLink) {
                            DebugeeIdeStateRendererKt.access$addLinkToLockAccess(this.$isRead, node, this.$evaluationContext);
                        }
                    }
                }), false);
            }
        });
    }

    private static final String addExtraNodes$icon(boolean isAvailable) {
        return isAvailable ? "\u2713" : "\u2717";
    }

    public static final /* synthetic */ String access$addExtraNodes$icon(boolean isAvailable) {
        return DebugeeIdeStateRenderer.addExtraNodes$icon(isAvailable);
    }
}

