/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.debugger;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.frame.XFramesView;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.debugger.DevKitDebuggerBundle;
import org.jetbrains.idea.devkit.debugger.IdeState;
import org.jetbrains.idea.devkit.debugger.UtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a4\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012*\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\"\u0010\u0014\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0001H\u0002\u001a\u0018\u0010 \u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0001H\u0002\u001a\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0001H\u0002\u001a \u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a&\u0010'\u001a\u00020\u00132\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00182\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+H\u0002\u001a\u001c\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u00162\n\u0010.\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002\u001a\"\u0010/\u001a\b\u0012\u0004\u0012\u00020)0\u0018*\b\u0012\u0004\u0012\u0002000\u00182\b\b\u0002\u00101\u001a\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"SUPPORT_CLASS_FQN", "", "GET_STATE_METHOD_NAME", "GET_STATE_METHOD_SIGNATURE", "READ_ACTION_ALLOWED_FIELD_NAME", "WRITE_ACTION_ALLOWED_FIELD_NAME", "THREADING_SUPPORT_FQN", "APPLICATION_IMPL_FQN", "COROUTINES_KT_FQN", "ACTIONS_KT_FQN", "cachedIdeState", "Ljava/util/WeakHashMap;", "Lcom/intellij/debugger/engine/SuspendContext;", "Lorg/jetbrains/idea/devkit/debugger/IdeState;", "getIdeState", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "adjustLockStatus", "Lkotlin/Pair;", "", "getReadWriteAccessStateBasedOnCurrentFrame", "findLockAccessIndex", "", "frames", "", "Lcom/intellij/debugger/engine/jdi/StackFrameProxy;", "isLockAccessMethod", "frame", "isRead", "isReadAccessCall", "className", "methodName", "isWriteAccessCall", "isApplicationReadAccess", "isApplicationWriteAccess", "addLinkToLockAccess", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "selectLockFrame", "javaFrames", "Lcom/intellij/debugger/engine/JavaStackFrame;", "framesList", "Lcom/intellij/xdebugger/impl/frame/XDebuggerFramesList;", "indexOrEndOfList", "index", "list", "flattenJavaFrames", "Lcom/intellij/xdebugger/frame/XStackFrame;", "toIndex", "intellij.devkit.debugger"})
@SourceDebugExtension(value={"SMAP\nDebugeeIdeStateRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugeeIdeStateRenderer.kt\norg/jetbrains/idea/devkit/debugger/DebugeeIdeStateRendererKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,274:1\n1#2:275\n295#3,2:276\n808#3,11:278\n295#3,2:289\n1368#3:291\n1454#3,2:292\n808#3,11:294\n1456#3,3:305\n1246#3,4:310\n477#4:308\n423#4:309\n*S KotlinDebug\n*F\n+ 1 DebugeeIdeStateRenderer.kt\norg/jetbrains/idea/devkit/debugger/DebugeeIdeStateRendererKt\n*L\n252#1:276,2\n256#1:278,11\n257#1:289,2\n267#1:291\n267#1:292,2\n270#1:294,11\n267#1:305,3\n46#1:310,4\n46#1:308\n46#1:309\n*E\n"})
public final class DebugeeIdeStateRendererKt {
    @NotNull
    private static final String SUPPORT_CLASS_FQN = "com.intellij.ide.debug.ApplicationStateDebugSupport";
    @NotNull
    private static final String GET_STATE_METHOD_NAME = "getApplicationState";
    @NotNull
    private static final String GET_STATE_METHOD_SIGNATURE = "()Lcom/intellij/ide/debug/ApplicationDebugState;";
    @NotNull
    private static final String READ_ACTION_ALLOWED_FIELD_NAME = "readActionAllowed";
    @NotNull
    private static final String WRITE_ACTION_ALLOWED_FIELD_NAME = "writeActionAllowed";
    @NotNull
    private static final String THREADING_SUPPORT_FQN = "com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport";
    @NotNull
    private static final String APPLICATION_IMPL_FQN = "com.intellij.openapi.application.impl.ApplicationImpl";
    @NotNull
    private static final String COROUTINES_KT_FQN = "com.intellij.openapi.application.CoroutinesKt";
    @NotNull
    private static final String ACTIONS_KT_FQN = "com.intellij.openapi.application.ActionsKt";
    @NotNull
    private static final WeakHashMap<SuspendContext, IdeState> cachedIdeState = new WeakHashMap();

    @Nullable
    public static final IdeState getIdeState(@NotNull EvaluationContext evaluationContext) {
        IdeState ideState;
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        try {
            ideState = cachedIdeState.computeIfAbsent(evaluationContext.getSuspendContext(), arg_0 -> DebugeeIdeStateRendererKt.getIdeState$lambda$3(arg_0 -> DebugeeIdeStateRendererKt.getIdeState$lambda$2(evaluationContext, arg_0), arg_0));
        }
        catch (Exception e) {
            DebuggerUtilsImpl.logError((Throwable)e);
            ideState = null;
        }
        return ideState;
    }

    private static final Pair<Boolean, Boolean> adjustLockStatus(Pair<Boolean, Boolean> $this$adjustLockStatus, EvaluationContext evaluationContext) {
        Boolean globalRead = (Boolean)$this$adjustLockStatus.getFirst();
        Boolean globalWrite = (Boolean)$this$adjustLockStatus.getSecond();
        if (!Intrinsics.areEqual((Object)globalRead, (Object)true) && !Intrinsics.areEqual((Object)globalWrite, (Object)true)) {
            return $this$adjustLockStatus;
        }
        Pair<Boolean, Boolean> pair = DebugeeIdeStateRendererKt.getReadWriteAccessStateBasedOnCurrentFrame(evaluationContext);
        if (pair == null) {
            return $this$adjustLockStatus;
        }
        Pair<Boolean, Boolean> stackBased = pair;
        Boolean readAllowed = (Boolean)stackBased.component1();
        Boolean writeAllowed = (Boolean)stackBased.component2();
        if (readAllowed != null && Intrinsics.areEqual((Object)globalRead, (Object)true)) {
            globalRead = readAllowed;
        }
        if (writeAllowed != null && Intrinsics.areEqual((Object)globalWrite, (Object)true)) {
            globalWrite = writeAllowed;
        }
        return TuplesKt.to((Object)globalRead, (Object)globalWrite);
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<Boolean, Boolean> getReadWriteAccessStateBasedOnCurrentFrame(EvaluationContext evaluationContext) {
        XStackFrame currentXFrame;
        SuspendContext suspendContext = evaluationContext.getSuspendContext();
        Intrinsics.checkNotNull((Object)suspendContext, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.SuspendContextImpl");
        XDebugSession xDebugSession = ((SuspendContextImpl)suspendContext).getDebugProcess().getSession().getXDebugSession();
        Object object = currentXFrame = xDebugSession != null ? xDebugSession.getCurrentStackFrame() : null;
        if (!(currentXFrame instanceof JavaStackFrame)) {
            return null;
        }
        StackFrameProxyImpl stackFrameProxyImpl = ((JavaStackFrame)currentXFrame).getStackFrameProxy();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"getStackFrameProxy(...)");
        StackFrameProxyImpl currentFrame = stackFrameProxyImpl;
        ThreadReferenceProxy threadReferenceProxy = evaluationContext.getSuspendContext().getThread();
        if (threadReferenceProxy == null) {
            return null;
        }
        ThreadReferenceProxy thread = threadReferenceProxy;
        int n = thread.frameCount();
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(thread.frame((int)it));
        }
        List frames = arrayList;
        int currentIndex = frames.indexOf(currentFrame);
        if (currentIndex < 0) {
            return null;
        }
        arrayList = DebugeeIdeStateRendererKt.findLockAccessIndex(frames);
        int readIndex = ((Number)arrayList.component1()).intValue();
        int writeIndex = ((Number)arrayList.component2()).intValue();
        return new Pair((Object)(readIndex == -1 ? null : Boolean.valueOf(currentIndex <= readIndex)), writeIndex == -1 ? null : Boolean.valueOf(currentIndex <= writeIndex));
    }

    private static final Pair<Integer, Integer> findLockAccessIndex(List<? extends StackFrameProxy> frames) {
        int readIndex = -1;
        int writeIndex = -1;
        int n = ((Collection)frames).size();
        for (int i = 0; i < n; ++i) {
            StackFrameProxy frame = frames.get(i);
            Location location = frame.location();
            String className = location.declaringType().name();
            String methodName = location.method().name();
            String signature = location.method().signature();
            if (readIndex == -1 && Intrinsics.areEqual((Object)className, (Object)THREADING_SUPPORT_FQN) && (Intrinsics.areEqual((Object)methodName, (Object)"runReadAction") && Intrinsics.areEqual((Object)signature, (Object)"(Ljava/lang/Class;Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;") || Intrinsics.areEqual((Object)methodName, (Object)"runWriteIntentReadAction") && Intrinsics.areEqual((Object)signature, (Object)"(Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;") || Intrinsics.areEqual((Object)methodName, (Object)"tryRunReadAction") && Intrinsics.areEqual((Object)signature, (Object)"(Ljava/lang/Runnable;)Z"))) {
                readIndex = i;
            }
            if (writeIndex == -1 && Intrinsics.areEqual((Object)className, (Object)THREADING_SUPPORT_FQN) && Intrinsics.areEqual((Object)methodName, (Object)"runWriteAction") && Intrinsics.areEqual((Object)signature, (Object)"(Ljava/lang/Class;Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;")) {
                writeIndex = i;
            }
            if (readIndex != -1 && writeIndex != -1) break;
        }
        return TuplesKt.to((Object)readIndex, (Object)writeIndex);
    }

    private static final boolean isLockAccessMethod(StackFrameProxy frame, boolean isRead) {
        boolean bl;
        Location location = frame.location();
        String className = location.declaringType().name();
        String methodName = location.method().name();
        if (isRead) {
            Intrinsics.checkNotNull((Object)className);
            Intrinsics.checkNotNull((Object)methodName);
            bl = DebugeeIdeStateRendererKt.isReadAccessCall(className, methodName);
        } else {
            Intrinsics.checkNotNull((Object)className);
            Intrinsics.checkNotNull((Object)methodName);
            bl = DebugeeIdeStateRendererKt.isWriteAccessCall(className, methodName);
        }
        return bl;
    }

    private static final boolean isReadAccessCall(String className, String methodName) {
        return Intrinsics.areEqual((Object)className, (Object)"com.intellij.openapi.application.impl.NonBlockingReadActionImpl") && Intrinsics.areEqual((Object)methodName, (Object)"executeSynchronously") || (Intrinsics.areEqual((Object)className, (Object)THREADING_SUPPORT_FQN) || Intrinsics.areEqual((Object)className, (Object)APPLICATION_IMPL_FQN)) && DebugeeIdeStateRendererKt.isApplicationReadAccess(methodName) || Intrinsics.areEqual((Object)className, (Object)ACTIONS_KT_FQN) && Intrinsics.areEqual((Object)methodName, (Object)"runReadAction") || Intrinsics.areEqual((Object)className, (Object)"com.intellij.openapi.application.ReadAction") && (Intrinsics.areEqual((Object)methodName, (Object)"run") || Intrinsics.areEqual((Object)methodName, (Object)"execute") || Intrinsics.areEqual((Object)methodName, (Object)"compute") || Intrinsics.areEqual((Object)methodName, (Object)"computeCancellable")) || Intrinsics.areEqual((Object)className, (Object)"com.intellij.openapi.application.WriteIntentReadAction") && (Intrinsics.areEqual((Object)methodName, (Object)"run") || Intrinsics.areEqual((Object)methodName, (Object)"compute")) || Intrinsics.areEqual((Object)className, (Object)COROUTINES_KT_FQN) && (Intrinsics.areEqual((Object)methodName, (Object)"readAction") || Intrinsics.areEqual((Object)methodName, (Object)"smartReadAction") || Intrinsics.areEqual((Object)methodName, (Object)"constrainedReadAction") || Intrinsics.areEqual((Object)methodName, (Object)"readActionUndispatched") || Intrinsics.areEqual((Object)methodName, (Object)"constrainedReadActionUndispatched") || Intrinsics.areEqual((Object)methodName, (Object)"readActionBlocking") || Intrinsics.areEqual((Object)methodName, (Object)"smartReadActionBlocking") || Intrinsics.areEqual((Object)methodName, (Object)"constrainedReadActionBlocking") || Intrinsics.areEqual((Object)methodName, (Object)"writeIntentReadAction"));
    }

    private static final boolean isWriteAccessCall(String className, String methodName) {
        return Intrinsics.areEqual((Object)className, (Object)ACTIONS_KT_FQN) && Intrinsics.areEqual((Object)methodName, (Object)"runWriteAction") || Intrinsics.areEqual((Object)className, (Object)"com.intellij.openapi.application.WriteAction") && (Intrinsics.areEqual((Object)methodName, (Object)"run") || Intrinsics.areEqual((Object)methodName, (Object)"execute") || Intrinsics.areEqual((Object)methodName, (Object)"compute") || Intrinsics.areEqual((Object)methodName, (Object)"runAndWait") || Intrinsics.areEqual((Object)methodName, (Object)"computeAndWait")) || Intrinsics.areEqual((Object)className, (Object)COROUTINES_KT_FQN) && (Intrinsics.areEqual((Object)methodName, (Object)"writeAction") || Intrinsics.areEqual((Object)methodName, (Object)"readAndWriteAction") || Intrinsics.areEqual((Object)methodName, (Object)"constrainedReadAndWriteAction")) || (Intrinsics.areEqual((Object)className, (Object)THREADING_SUPPORT_FQN) || Intrinsics.areEqual((Object)className, (Object)APPLICATION_IMPL_FQN)) && DebugeeIdeStateRendererKt.isApplicationWriteAccess(methodName);
    }

    private static final boolean isApplicationReadAccess(String methodName) {
        return Intrinsics.areEqual((Object)methodName, (Object)"runReadAction") || Intrinsics.areEqual((Object)methodName, (Object)"runWriteIntentReadAction") || Intrinsics.areEqual((Object)methodName, (Object)"tryRunReadAction") || Intrinsics.areEqual((Object)methodName, (Object)"runIntendedWriteActionOnCurrentThread");
    }

    private static final boolean isApplicationWriteAccess(String methodName) {
        return Intrinsics.areEqual((Object)methodName, (Object)"runWriteAction") || Intrinsics.areEqual((Object)methodName, (Object)"executeSuspendingWriteAction") || Intrinsics.areEqual((Object)methodName, (Object)"runWriteActionWithNonCancellableProgressInDispatchThread") || Intrinsics.areEqual((Object)methodName, (Object)"runWriteActionWithCancellableProgressInDispatchThread");
    }

    private static final void addLinkToLockAccess(boolean isRead, XValueNode node, EvaluationContext evaluationContext) {
        String string = DevKitDebuggerBundle.message("debugger.navigate.to.lock.access", new Object[0]);
        node.setFullValueEvaluator((XFullValueEvaluator)new JavaValue.JavaFullValueEvaluator(evaluationContext, isRead, string){
            final /* synthetic */ EvaluationContext $evaluationContext;
            final /* synthetic */ boolean $isRead;
            {
                this.$evaluationContext = $evaluationContext;
                this.$isRead = $isRead;
                Intrinsics.checkNotNull((Object)$evaluationContext, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.evaluation.EvaluationContextImpl");
                super($super_call_param$1, (EvaluationContextImpl)$evaluationContext);
            }

            public boolean isShowValuePopup() {
                return false;
            }

            public void evaluate(XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                this.navigateToStackFrame();
                callback.evaluated("");
            }

            /*
             * WARNING - void declaration
             */
            private final void navigateToStackFrame() {
                int n;
                List xFrames;
                XDebuggerFramesList framesList;
                block6: {
                    void $this$filterIsInstanceTo$iv$iv;
                    DebugProcess debugProcess = this.$evaluationContext.getDebugProcess();
                    DebugProcessImpl debugProcessImpl = debugProcess instanceof DebugProcessImpl ? (DebugProcessImpl)debugProcess : null;
                    if (debugProcessImpl == null) {
                        return;
                    }
                    DebugProcessImpl debugProcess2 = debugProcessImpl;
                    XDebugSession xDebugSession = debugProcess2.getSession().getXDebugSession();
                    XDebugSessionImpl xDebugSessionImpl = xDebugSession instanceof XDebugSessionImpl ? (XDebugSessionImpl)xDebugSession : null;
                    if (xDebugSessionImpl == null) {
                        return;
                    }
                    XDebugSessionImpl xDebugSession2 = xDebugSessionImpl;
                    XDebugSessionTab xDebugSessionTab = xDebugSession2.getSessionTab();
                    if (xDebugSessionTab == null || (xDebugSessionTab = xDebugSessionTab.getFramesView()) == null) {
                        return;
                    }
                    XDebugSessionTab framesView = xDebugSessionTab;
                    framesList = framesView.getFramesList();
                    List list = framesList.getModel().getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                    Iterable $this$filterIsInstance$iv = list;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof XStackFrame)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List $this$indexOfFirst$iv = xFrames = (List)destination$iv$iv;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (E item$iv : $this$indexOfFirst$iv) {
                        XStackFrame it = (XStackFrame)item$iv;
                        boolean bl = false;
                        if (it instanceof StackFrameItem.CapturedStackFrame) {
                            n = index$iv;
                            break block6;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int asyncFrameIndex = n;
                List syncXFrames = DebugeeIdeStateRendererKt.access$flattenJavaFrames(xFrames, DebugeeIdeStateRendererKt.access$indexOrEndOfList(asyncFrameIndex, xFrames));
                Intrinsics.checkNotNull((Object)framesList);
                DebugeeIdeStateRendererKt.access$selectLockFrame(syncXFrames, this.$isRead, framesList);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean selectLockFrame(List<? extends JavaStackFrame> javaFrames, boolean isRead, XDebuggerFramesList framesList) {
        Object v1;
        Object object;
        block9: {
            void $this$firstOrNull$iv;
            Iterable iterable = CollectionsKt.reversed((Iterable)CollectionsKt.withIndex((Iterable)javaFrames));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                object = (IndexedValue)element$iv;
                boolean bl = false;
                JavaStackFrame frame = (JavaStackFrame)object.component2();
                StackFrameProxyImpl stackFrameProxyImpl = frame.getStackFrameProxy();
                Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"getStackFrameProxy(...)");
                if (!DebugeeIdeStateRendererKt.isLockAccessMethod((StackFrameProxy)stackFrameProxyImpl, isRead)) continue;
                v1 = element$iv;
                break block9;
            }
            v1 = null;
        }
        IndexedValue indexedValue = v1;
        if (indexedValue == null) {
            return false;
        }
        int targetXFrameIndex = indexedValue.component1();
        if (targetXFrameIndex < 0) {
            return false;
        }
        JavaStackFrame targetXFrame = null;
        JavaStackFrame javaStackFrame = (JavaStackFrame)CollectionsKt.getOrNull(javaFrames, (int)(targetXFrameIndex + 1));
        if (javaStackFrame == null) {
            return false;
        }
        targetXFrame = javaStackFrame;
        if (!framesList.getModel().contains((Object)targetXFrame)) {
            Object v5;
            block10: {
                void $this$filterIsInstanceTo$iv$iv;
                List list = framesList.getModel().getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                Iterable $this$filterIsInstance$iv = list;
                boolean $i$f$filterIsInstance = false;
                object = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof XFramesView.HiddenStackFramesItem)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List collapsedFrames = (List)destination$iv$iv;
                Iterable $this$firstOrNull$iv = collapsedFrames;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    XFramesView.HiddenStackFramesItem it = (XFramesView.HiddenStackFramesItem)element$iv;
                    boolean bl = false;
                    if (!it.getHiddenFrames().contains(targetXFrame)) continue;
                    v5 = element$iv;
                    break block10;
                }
                v5 = null;
            }
            XFramesView.HiddenStackFramesItem hiddenStackFramesItem = v5;
            if (hiddenStackFramesItem == null) {
                return false;
            }
            targetXFrame = (XStackFrame)hiddenStackFramesItem;
            if (!framesList.getModel().contains((Object)targetXFrame)) {
                return false;
            }
        }
        framesList.selectFrame((XStackFrame)targetXFrame);
        return true;
    }

    private static final int indexOrEndOfList(int index, List<?> list) {
        return index < 0 ? list.size() : index;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<JavaStackFrame> flattenJavaFrames(List<? extends XStackFrame> $this$flattenJavaFrames, int toIndex) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$flattenJavaFrames.subList(0, toIndex);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            XStackFrame frame = (XStackFrame)element$iv$iv;
            boolean bl = false;
            XStackFrame xStackFrame = frame;
            if (xStackFrame instanceof JavaStackFrame) {
                list = CollectionsKt.listOf((Object)frame);
            } else if (xStackFrame instanceof XFramesView.HiddenStackFramesItem) {
                void $this$filterIsInstanceTo$iv$iv;
                List list2 = ((XFramesView.HiddenStackFramesItem)frame).getHiddenFrames();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getHiddenFrames(...)");
                Iterable $this$filterIsInstance$iv = list2;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv2 instanceof JavaStackFrame)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List flattenJavaFrames$default(List list, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = list.size();
        }
        return DebugeeIdeStateRendererKt.flattenJavaFrames(list, n);
    }

    private static final ObjectReference getIdeState$lambda$2$lambda$0(EvaluationContext $evaluationContext, ClassType $supportClass) {
        Value value = DebuggerUtilsImpl.invokeClassMethod((EvaluationContext)$evaluationContext, (ClassType)$supportClass, (String)GET_STATE_METHOD_NAME, (String)GET_STATE_METHOD_SIGNATURE);
        return value instanceof ObjectReference ? (ObjectReference)value : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final IdeState getIdeState$lambda$2(EvaluationContext $evaluationContext, SuspendContext it) {
        void $this$mapKeysTo$iv$iv;
        ReferenceType referenceType = UtilsKt.findClassOrNull($evaluationContext, SUPPORT_CLASS_FQN);
        ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
        if (classType == null) {
            return null;
        }
        ClassType supportClass = classType;
        ObjectReference objectReference = (ObjectReference)$evaluationContext.computeAndKeep(() -> DebugeeIdeStateRendererKt.getIdeState$lambda$2$lambda$0($evaluationContext, supportClass));
        if (objectReference == null) {
            return null;
        }
        ObjectReference state = objectReference;
        ReferenceType stateClass = state.referenceType();
        Map<Field, Value> map = state.getValues(stateClass.allFields());
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValues(...)");
        Map<Field, Value> $this$mapKeys$iv = map;
        boolean $i$f$mapKeys = false;
        Map<Field, Value> map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it2;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string = ((Field)it2.getKey()).name();
            Map map4 = map3;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map4.put(string, entry);
        }
        Map fieldValues = destination$iv$iv;
        map2 = fieldValues.get(READ_ACTION_ALLOWED_FIELD_NAME);
        BooleanValue booleanValue = map2 instanceof BooleanValue ? (BooleanValue)((Object)map2) : null;
        Boolean readField = booleanValue != null ? Boolean.valueOf(booleanValue.value()) : null;
        Object v = fieldValues.get(WRITE_ACTION_ALLOWED_FIELD_NAME);
        BooleanValue booleanValue2 = v instanceof BooleanValue ? (BooleanValue)v : null;
        Boolean writeField = booleanValue2 != null ? Boolean.valueOf(booleanValue2.value()) : null;
        return new IdeState(readField, writeField);
    }

    private static final IdeState getIdeState$lambda$3(Function1 $tmp0, Object p0) {
        return (IdeState)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Pair access$adjustLockStatus(Pair $receiver, EvaluationContext evaluationContext) {
        return DebugeeIdeStateRendererKt.adjustLockStatus((Pair<Boolean, Boolean>)$receiver, evaluationContext);
    }

    public static final /* synthetic */ void access$addLinkToLockAccess(boolean isRead, XValueNode node, EvaluationContext evaluationContext) {
        DebugeeIdeStateRendererKt.addLinkToLockAccess(isRead, node, evaluationContext);
    }

    public static final /* synthetic */ List access$flattenJavaFrames(List $receiver, int toIndex) {
        return DebugeeIdeStateRendererKt.flattenJavaFrames($receiver, toIndex);
    }

    public static final /* synthetic */ int access$indexOrEndOfList(int index, List list) {
        return DebugeeIdeStateRendererKt.indexOrEndOfList(index, list);
    }

    public static final /* synthetic */ boolean access$selectLockFrame(List javaFrames, boolean isRead, XDebuggerFramesList framesList) {
        return DebugeeIdeStateRendererKt.selectLockFrame(javaFrames, isRead, framesList);
    }
}

