/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.debugger;

import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.debugger.SessionThreadsData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u000b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/devkit/debugger/PauseListener;", "Lcom/intellij/debugger/impl/DebuggerManagerListener;", "<init>", "()V", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/debugger/impl/DebuggerSession;", "Lorg/jetbrains/idea/devkit/debugger/SessionThreadsData;", "sessionAttached", "", "session", "sessionDetached", "getSessionData", "intellij.devkit.debugger"})
final class PauseListener
implements DebuggerManagerListener {
    @NotNull
    public static final PauseListener INSTANCE = new PauseListener();
    @NotNull
    private static final ConcurrentHashMap<DebuggerSession, SessionThreadsData> sessions = new ConcurrentHashMap();

    private PauseListener() {
    }

    public void sessionAttached(@Nullable DebuggerSession session) {
        if (session == null) {
            return;
        }
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        ((Map)sessions).put(session, new SessionThreadsData(disposable2));
        session.getProcess().addDebugProcessListener(new DebugProcessListener(){

            public void paused(SuspendContext suspendContext) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                    SuspendContextImpl suspendContextImpl = suspendContext instanceof SuspendContextImpl ? (SuspendContextImpl)suspendContext : null;
                    if (suspendContextImpl == null) {
                        return;
                    }
                    SuspendContextImpl context = suspendContextImpl;
                    DebuggerSession debuggerSession = context.getDebugProcess().getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)debuggerSession, (String)"getSession(...)");
                    SessionThreadsData sessionThreadsData = PauseListener.INSTANCE.getSessionData(debuggerSession);
                    if (sessionThreadsData == null) break block1;
                    sessionThreadsData.resetNonCancellableSection(context);
                }
            }
        }, disposable2);
    }

    public void sessionDetached(@Nullable DebuggerSession session) {
        if (session == null) {
            return;
        }
        SessionThreadsData sessionThreadsData = sessions.remove(session);
        if (sessionThreadsData == null) {
            return;
        }
        SessionThreadsData sessionData = sessionThreadsData;
        Disposer.dispose((Disposable)sessionData.getDisposable());
    }

    @Nullable
    public final SessionThreadsData getSessionData(@NotNull DebuggerSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return sessions.get(session);
    }
}

